/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.busi.ContractItemQueryBusiService;
import com.tydic.contract.busi.ContractPushPlanBusiService;
import com.tydic.contract.busi.bo.ContractItemQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemQueryBusiRspBO;
import com.tydic.contract.busi.bo.ContractPushPlanBusiReqBo;
import com.tydic.contract.busi.bo.ContractPushPlanBusiRspBo;
import com.tydic.contract.busi.bo.PushPlanItem;
import com.tydic.contract.busi.bo.PushPlanReqBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.CContractInfoPushErpLogMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractScopeMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.CContractInfoPushErpPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractScope;
import com.tydic.contract.utils.HttpUtils;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQueryAbilityService;
import com.tydic.umc.general.ability.api.UmcMemDetailQueryAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityRspBO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractPushPlanBusiServiceImpl
implements ContractPushPlanBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractPushPlanBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private UmcEnterpriseOrgQueryAbilityService umcEnterpriseOrgQueryAbilityService;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @Autowired
    private ContractItemQueryBusiService contractItemQueryBusiService;
    @Value(value="${agr.plan.url:http://172.16.8.147:8070/plan/agreementController/addaAllAgreement}")
    private String planUrl;
    @Autowired
    private CContractInfoPushErpLogMapper cContractInfoPushErpLogMapper;
    @Autowired
    private ContractScopeMapper contractScopeMapper;
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @Override
    public ContractPushPlanBusiRspBo dealContractPushPlan(ContractPushPlanBusiReqBo reqBo) {
        CContractInfoPushErpPO cContractInfoPushErpPO;
        ContractPushPlanBusiRspBo rspBo = new ContractPushPlanBusiRspBo();
        if (CollectionUtils.isEmpty(reqBo.getContractIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(reqBo.getContractIds());
        if (CollectionUtils.isEmpty(contractInfoPOS)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5408\u540c\u4e0d\u5b58\u5728");
            return rspBo;
        }
        HashMap<Long, String> failDealPushInfo = new HashMap<Long, String>();
        HashMap<String, String> success = new HashMap<String, String>();
        HashMap<String, String> fail = new HashMap<String, String>();
        ArrayList purchaseType = Lists.newArrayList((Object[])new Integer[]{11, 12, 13, 20, 21});
        ArrayList JsType = Lists.newArrayList((Object[])new Integer[]{12});
        HashMap<Long, String> pushInParam = new HashMap<Long, String>();
        HashMap<Long, String> pushOutParam = new HashMap<Long, String>();
        HashMap<Long, String> needNot = new HashMap<Long, String>();
        for (ContractInfoPO contractInfoPO : contractInfoPOS) {
            String buyerErpOrgCode;
            boolean checkPushErpYc;
            String failInfo = "";
            if (!ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT.equals(contractInfoPO.getContractStatus()) && !ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER.equals(contractInfoPO.getContractStatus())) {
                failInfo = failInfo + "\u5408\u540c\u7684\u72b6\u6001\u4e0d\u4e3a\u5df2\u751f\u6548\u6216\u8005\u5df2\u5931\u6548;";
            }
            if (checkPushErpYc = this.checkPushErpYc(contractInfoPO)) {
                needNot.put(contractInfoPO.getContractId(), "\u5f53\u524d\u6846\u67b6\u534f\u8bae\u5bc4\u552e\u5408\u540c\u65e0\u9700\u63a8\u9001\u8ba1\u5212\u5e73\u53f0");
                continue;
            }
            PushPlanReqBO pushPlanReqBO = new PushPlanReqBO();
            pushPlanReqBO.setAgreementId(contractInfoPO.getContractId());
            pushPlanReqBO.setAgreementName(contractInfoPO.getContractName());
            if (purchaseType.contains(contractInfoPO.getContractType())) {
                pushPlanReqBO.setAgreementSrc((byte)2);
            } else {
                pushPlanReqBO.setAgreementSrc((byte)1);
            }
            if (JsType.contains(contractInfoPO.getContractType())) {
                pushPlanReqBO.setAgreementType((byte)1);
            } else {
                pushPlanReqBO.setAgreementType((byte)2);
            }
            pushPlanReqBO.setAgreementStatus((byte)contractInfoPO.getContractStatus().intValue());
            if (!(contractInfoPO.getContractSignDate() != null && contractInfoPO.getValidaType() != null && contractInfoPO.getValidaNum() != null || contractInfoPO.getContractValidTime() != null && contractInfoPO.getContractSignDate() != null)) {
                failInfo = failInfo + "\u5408\u540c\u751f\u6548\u65e5\u671f\u4e3a\u7a7a;";
            } else if (contractInfoPO.getContractValidTime() != null) {
                pushPlanReqBO.setEffDate(contractInfoPO.getContractSignDate());
                if (ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER.equals(contractInfoPO.getContractStatus())) {
                    pushPlanReqBO.setExpDate(contractInfoPO.getContractValidTime());
                } else {
                    pushPlanReqBO.setExpDate(contractInfoPO.getContractValidTime());
                }
            } else {
                Calendar c = Calendar.getInstance();
                c.setTime(contractInfoPO.getContractSignDate());
                pushPlanReqBO.setEffDate(contractInfoPO.getContractSignDate());
                if (ContractConstant.TermOfValidityType.MONTHS.equals(contractInfoPO.getValidaType())) {
                    c.add(2, contractInfoPO.getValidaNum());
                } else if (ContractConstant.TermOfValidityType.YEARS.equals(contractInfoPO.getValidaType())) {
                    c.add(1, contractInfoPO.getValidaNum());
                } else {
                    failInfo = failInfo + "\u5408\u540c\u751f\u6548\u65e5\u671f\u4e3a\u7a7a;";
                }
                pushPlanReqBO.setExpDate(c.getTime());
            }
            if (!StringUtils.isEmpty((Object)contractInfoPO.getBuyerNo()) && !StringUtils.isEmpty((Object)(buyerErpOrgCode = this.getErpOrgCode(contractInfoPO.getBuyerNo())))) {
                pushPlanReqBO.setOuList(Lists.newArrayList((Object[])new String[]{buyerErpOrgCode}));
            }
            ContractScope contractScope = new ContractScope();
            contractScope.setRelateId(contractInfoPO.getContractId());
            contractScope.setIsDelete(0);
            List<ContractScope> contractScopes = this.contractScopeMapper.queryAll(contractScope);
            if (!CollectionUtils.isEmpty(contractScopes)) {
                List<String> ouList = pushPlanReqBO.getOuList();
                List<String> collect = contractScopes.stream().map(ContractScope::getExtFiled1).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(ouList)) {
                    pushPlanReqBO.getOuList().addAll(collect);
                } else {
                    pushPlanReqBO.setOuList(collect);
                }
            }
            if (contractInfoPO.getAmountLimit() != null) {
                pushPlanReqBO.setAmountLimit(MoneyUtils.haoToYuan(contractInfoPO.getAmountLimit()));
            }
            if (contractInfoPO.getOrderAmount() != null) {
                pushPlanReqBO.setOrderAmount(MoneyUtils.haoToYuan(contractInfoPO.getOrderAmount()));
            }
            pushPlanReqBO.setIsDelete((byte)0);
            if (!StringUtils.isEmpty((Object)contractInfoPO.getTrackNo())) {
                pushPlanReqBO.setPlaAgreementCode(contractInfoPO.getTrackNo());
            } else if (!StringUtils.isEmpty((Object)contractInfoPO.getContractCode())) {
                pushPlanReqBO.setPlaAgreementCode(contractInfoPO.getContractCode());
            } else {
                failInfo = failInfo + "\u5408\u540c\u8ddf\u8e2a\u53f7\u548c\u5408\u540c\u7f16\u53f7\u90fd\u4e3a\u7a7a;";
            }
            pushPlanReqBO.setProducerCode(contractInfoPO.getCreateUserCode());
            pushPlanReqBO.setProducerId(this.getMemErp(contractInfoPO.getCreateUserId()));
            pushPlanReqBO.setProducerName(contractInfoPO.getCreateUserName());
            pushPlanReqBO.setRemark(contractInfoPO.getRemark());
            pushPlanReqBO.setScopeType((byte)0);
            pushPlanReqBO.setSignTime(contractInfoPO.getContractSignDate());
            pushPlanReqBO.setSupplierId(this.getMemErp(contractInfoPO.getCreateDeptId()));
            pushPlanReqBO.setSupplierName(contractInfoPO.getCreateDeptName());
            pushPlanReqBO.setUpdateLoginId(1L);
            pushPlanReqBO.setUpdateName(contractInfoPO.getUpdateUserName());
            pushPlanReqBO.setUpdateTime(contractInfoPO.getUpdateTime());
            String erpOrgCode = this.getOrgErpCode(contractInfoPO.getSupplierId());
            if (!StringUtils.isEmpty((Object)erpOrgCode)) {
                pushPlanReqBO.setVendorCode(erpOrgCode);
                pushPlanReqBO.setVendorId(erpOrgCode);
            } else {
                pushPlanReqBO.setVendorCode(contractInfoPO.getSupplierCode());
                pushPlanReqBO.setVendorId(contractInfoPO.getSupplierCode());
            }
            pushPlanReqBO.setVendorName(contractInfoPO.getSupplierName());
            ArrayList<PushPlanItem> childEntityList = new ArrayList<PushPlanItem>();
            ContractItemQueryBusiReqBO contractItemQueryBusiReqBO = new ContractItemQueryBusiReqBO();
            contractItemQueryBusiReqBO.setContractId(contractInfoPO.getContractId());
            contractItemQueryBusiReqBO.setPageNo(0);
            contractItemQueryBusiReqBO.setPageSize(0);
            ContractItemQueryBusiRspBO contractItemQueryBusiRspBO = this.contractItemQueryBusiService.contractItemQuery(contractItemQueryBusiReqBO);
            if (!"0000".equals(contractItemQueryBusiRspBO.getRespCode())) {
                failInfo = failInfo + "\u5408\u540c\u660e\u7ec6\u5217\u8868\u83b7\u53d6\u5931\u8d25;";
            } else {
                for (ContractItemAbilityBO row : contractItemQueryBusiRspBO.getRows()) {
                    PushPlanItem sh = new PushPlanItem();
                    sh.setAgreementId(contractInfoPO.getContractId());
                    sh.setAgreementSkuId(row.getItemId());
                    sh.setCreateLoginId(pushPlanReqBO.getProducerId());
                    sh.setCreateName(pushPlanReqBO.getProducerName());
                    sh.setCreateTime(pushPlanReqBO.getEffDate());
                    sh.setEffDate(pushPlanReqBO.getEffDate());
                    sh.setExpDate(pushPlanReqBO.getExpDate());
                    sh.setMaterialCode(row.getMaterialCode());
                    sh.setMaterialId(row.getMaterialId() + "");
                    sh.setMaterialName(row.getMaterialName());
                    sh.setRemark(row.getRemark());
                    sh.setIsDelete((byte)0);
                    if (row.getSaleStatus() != null && row.getSaleStatus() == 3) {
                        sh.setExpDate(new Date());
                    }
                    try {
                        sh.setSalePrice(row.getUnitPriceExcludingTax().stripTrailingZeros());
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    sh.setTaxRate(row.getRate());
                    sh.setUpdateLoginId(1L);
                    sh.setUpdateName(pushPlanReqBO.getUpdateName());
                    sh.setUpdateTime(pushPlanReqBO.getUpdateTime());
                    childEntityList.add(sh);
                }
                pushPlanReqBO.setChildEntityList(childEntityList);
            }
            if (!StringUtils.isEmpty((Object)failInfo)) {
                failDealPushInfo.put(contractInfoPO.getContractId(), failInfo);
                continue;
            }
            try {
                pushInParam.put(contractInfoPO.getContractId(), JSONObject.toJSONString((Object)pushPlanReqBO));
                log.info("\u63a8\u9001\u8ba1\u5212\u5e73\u53f0\u53d1\u9001\u62a5\u6587" + JSONObject.toJSONString((Object)pushPlanReqBO));
                String result = HttpUtils.doPost(this.planUrl, JSONObject.toJSONString((Object)pushPlanReqBO));
                log.info("\u63a8\u9001\u8ba1\u5212\u5e73\u53f0\u8fd4\u56de\u62a5\u6587" + result);
                if (StringUtils.isEmpty((Object)result)) {
                    throw new ZTBusinessException("\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a\uff1b");
                }
                pushOutParam.put(contractInfoPO.getContractId(), result);
                JSONObject jsonResult = JSONObject.parseObject((String)result);
                if (StringUtils.isEmpty((Object)jsonResult.getString("code"))) {
                    throw new ZTBusinessException("\u63a8\u9001\u5931\u8d25\uff0c\u8fd4\u56de\u72b6\u6001\u7801\u4e3a\u7a7a\uff1b");
                }
                if ("200".equals(jsonResult.getString("code"))) {
                    success.put(contractInfoPO.getContractId().toString(), jsonResult.getString("msg"));
                    continue;
                }
                fail.put(contractInfoPO.getContractId().toString(), jsonResult.getString("msg"));
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u8ba1\u5212\u5e73\u53f0\u672a\u77e5\u5f02\u5e38" + e.getMessage());
                fail.put(contractInfoPO.getContractId().toString(), e.getMessage());
            }
        }
        ArrayList<CContractInfoPushErpPO> contractInfoPushErpPOS = new ArrayList<CContractInfoPushErpPO>();
        ArrayList<Long> pushErpOkContractIds = new ArrayList<Long>();
        ArrayList<Long> pushErpFailContractIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(success)) {
            for (Map.Entry each : success.entrySet()) {
                cContractInfoPushErpPO = new CContractInfoPushErpPO();
                cContractInfoPushErpPO.setContractId(Long.valueOf((String)each.getKey()));
                cContractInfoPushErpPO.setId(Sequence.getInstance().nextId());
                cContractInfoPushErpPO.setPlanPushInfo("\u6570\u636e\u5168\u90e8\u5904\u7406\u6210\u529f");
                cContractInfoPushErpPO.setPlanPushReturnInfo((String)each.getValue());
                cContractInfoPushErpPO.setPlanPushTime(new Date());
                if (pushInParam.containsKey(Long.valueOf((String)each.getKey()))) {
                    cContractInfoPushErpPO.setPushPlanInParameterInfo((String)pushInParam.get(Long.valueOf((String)each.getKey())));
                }
                if (pushOutParam.containsKey(Long.valueOf((String)each.getKey()))) {
                    cContractInfoPushErpPO.setPushPlanReturnInfo((String)pushOutParam.get(Long.valueOf((String)each.getKey())));
                }
                contractInfoPushErpPOS.add(cContractInfoPushErpPO);
                pushErpOkContractIds.add(Long.valueOf((String)each.getKey()));
            }
        }
        if (!CollectionUtils.isEmpty(fail)) {
            for (Map.Entry each : fail.entrySet()) {
                cContractInfoPushErpPO = new CContractInfoPushErpPO();
                cContractInfoPushErpPO.setContractId(Long.valueOf((String)each.getKey()));
                cContractInfoPushErpPO.setId(Sequence.getInstance().nextId());
                cContractInfoPushErpPO.setPlanPushInfo("\u6570\u636e\u5168\u90e8\u5904\u7406\u6210\u529f");
                cContractInfoPushErpPO.setPlanPushReturnInfo((String)each.getValue());
                cContractInfoPushErpPO.setPlanPushTime(new Date());
                if (pushInParam.containsKey(Long.valueOf((String)each.getKey()))) {
                    cContractInfoPushErpPO.setPushPlanInParameterInfo((String)pushInParam.get(Long.valueOf((String)each.getKey())));
                }
                if (pushOutParam.containsKey(Long.valueOf((String)each.getKey()))) {
                    cContractInfoPushErpPO.setPushPlanReturnInfo((String)pushOutParam.get(Long.valueOf((String)each.getKey())));
                }
                contractInfoPushErpPOS.add(cContractInfoPushErpPO);
                pushErpFailContractIds.add(Long.valueOf((String)each.getKey()));
            }
        }
        if (!CollectionUtils.isEmpty(failDealPushInfo)) {
            for (Map.Entry each : failDealPushInfo.entrySet()) {
                cContractInfoPushErpPO = new CContractInfoPushErpPO();
                cContractInfoPushErpPO.setContractId((Long)each.getKey());
                cContractInfoPushErpPO.setId(Sequence.getInstance().nextId());
                cContractInfoPushErpPO.setPlanPushInfo("\u6570\u636e\u5904\u7406\u5931\u8d25\uff1a" + (String)each.getValue());
                cContractInfoPushErpPO.setPlanPushTime(new Date());
                contractInfoPushErpPOS.add(cContractInfoPushErpPO);
                pushErpFailContractIds.add((Long)each.getKey());
            }
        }
        if (!CollectionUtils.isEmpty(pushErpOkContractIds)) {
            this.contractInfoMapper.updatePushPlanSyncStatusByCodes(pushErpOkContractIds, ContractConstant.PushErpStatus.ALREADY_SYNC);
        }
        if (!CollectionUtils.isEmpty(pushErpFailContractIds)) {
            this.contractInfoMapper.updatePushPlanSyncStatusByCodes(pushErpFailContractIds, ContractConstant.PushErpStatus.FAIL_SYNC);
        }
        Date nowDate = new Date();
        if (!CollectionUtils.isEmpty(needNot)) {
            needNot.forEach((k, v) -> {
                CContractInfoPushErpPO cContractInfoPushErpPO = new CContractInfoPushErpPO();
                cContractInfoPushErpPO.setContractId((Long)k);
                cContractInfoPushErpPO.setId(this.uccBatchSequence.nextId());
                cContractInfoPushErpPO.setPlanPushInfo("\u5904\u7406\u5b8c\u6210");
                cContractInfoPushErpPO.setPlanPushReturnInfo((String)v);
                cContractInfoPushErpPO.setPlanPushTime(nowDate);
                contractInfoPushErpPOS.add(cContractInfoPushErpPO);
            });
        }
        rspBo.setContractInfoPushErpPOS(contractInfoPushErpPOS);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String getMemErp(Long memId) {
        UmcMemDetailQueryAbilityReqBO reqBO = new UmcMemDetailQueryAbilityReqBO();
        reqBO.setMemId(memId);
        UmcMemDetailQueryAbilityRspBO abilityRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(reqBO);
        if (abilityRspBO.getUmcMemDetailInfoAbilityRspBO() != null) {
            UmcMemDetailInfoAbilityBO abilityBO = abilityRspBO.getUmcMemDetailInfoAbilityRspBO();
            return abilityBO.getAgentAccount();
        }
        return null;
    }

    private String getOrgErp(Long orgId) {
        UmcEnterpriseOrgQueryAbilityReqBO reqBO = new UmcEnterpriseOrgQueryAbilityReqBO();
        reqBO.setOrgIdWeb(orgId);
        UmcEnterpriseOrgDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(reqBO);
        if (abilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            return abilityRspBO.getUmcEnterpriseOrgAbilityBO().getOrgCode();
        }
        return null;
    }

    private String getErpOrgCode(String orgCode) {
        UmcEnterpriseOrgQueryAbilityReqBO reqBO = new UmcEnterpriseOrgQueryAbilityReqBO();
        reqBO.setOrgCodeWeb(orgCode);
        UmcEnterpriseOrgDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(reqBO);
        if (abilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            return abilityRspBO.getUmcEnterpriseOrgAbilityBO().getErpOrgCode();
        }
        return null;
    }

    private String getOrgErpCode(Long orgId) {
        UmcEnterpriseOrgQueryAbilityReqBO reqBO = new UmcEnterpriseOrgQueryAbilityReqBO();
        reqBO.setOrgIdWeb(orgId);
        UmcEnterpriseOrgDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(reqBO);
        if (abilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            return abilityRspBO.getUmcEnterpriseOrgAbilityBO().getErpOrgCode();
        }
        return null;
    }

    private boolean checkPushErpYc(ContractInfoPO contractInfoPO) {
        boolean flag = Boolean.FALSE;
        if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType())) {
            CContractInfoExtPO searchPO = new CContractInfoExtPO();
            ArrayList<Long> contractIds = new ArrayList<Long>();
            contractIds.add(contractInfoPO.getContractId());
            searchPO.setRelateIds(contractIds);
            List<CContractInfoExtPO> list = this.cContractInfoExtMapper.getList(searchPO);
            if (!CollectionUtils.isEmpty(list) && ContractConstant.ContractPushWmsStatus.YES.equals(list.get(0).getIsPushWms())) {
                UmcEnterpriseOrgQryDetailAbilityReqBO buyerBo = new UmcEnterpriseOrgQryDetailAbilityReqBO();
                if (!StringUtils.isEmpty((Object)contractInfoPO.getBuyerNo())) {
                    Integer isPushWms;
                    buyerBo.setOrgCode(contractInfoPO.getBuyerNo());
                    UmcEnterpriseOrgQryDetailAbilityRspBO buyerRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(buyerBo);
                    if ("0000".equals(buyerRspBO.getRespCode()) && buyerRspBO.getUmcEnterpriseOrgDetailBO() != null && (isPushWms = buyerRspBO.getUmcEnterpriseOrgDetailBO().getIsPushWms()) != null && ContractConstant.ContractPushWmsStatus.YES.equals(isPushWms)) {
                        flag = Boolean.TRUE;
                    }
                }
            }
        }
        if (flag) {
            ContractInfoPO updatePO = new ContractInfoPO();
            updatePO.setContractId(contractInfoPO.getContractId());
            updatePO.setPushPlanStatus(ContractConstant.PushErpStatus.NEED_NOT_SYNC);
            this.contractInfoMapper.updateContract(updatePO);
        }
        return flag;
    }
}

