/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractSaveReplenishmentReqBoReplenishmentList;
import com.tydic.contract.busi.ContractSaveReplenishmentBusiService;
import com.tydic.contract.busi.bo.ContractSaveReplenishmentBusiReqBo;
import com.tydic.contract.busi.bo.ContractSaveReplenishmentBusiRspBo;
import com.tydic.contract.dao.CPendingReplenishmentMapper;
import com.tydic.contract.dao.CPendingReplenishmentMatchMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.po.CPendingReplenishmentMatchPO;
import com.tydic.contract.po.CPendingReplenishmentPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractItemCanBuyListQryPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractSaveReplenishmentBusiServiceImpl
implements ContractSaveReplenishmentBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractSaveReplenishmentBusiServiceImpl.class);
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private CPendingReplenishmentMapper cPendingReplenishmentMapper;
    @Autowired
    private CPendingReplenishmentMatchMapper cPendingReplenishmentMatchMapper;

    @Override
    public ContractSaveReplenishmentBusiRspBo saveReplenishment(ContractSaveReplenishmentBusiReqBo reqBo) {
        ContractSaveReplenishmentBusiRspBo rspBo = new ContractSaveReplenishmentBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        List<String> materialCodeList = reqBo.getReplenishmentList().stream().map(ContractSaveReplenishmentReqBoReplenishmentList::getMaterialCode).collect(Collectors.toList());
        ContractItemCanBuyListQryPO contractItemCanBuyListQryPO = new ContractItemCanBuyListQryPO();
        contractItemCanBuyListQryPO.setMaterialCodes(materialCodeList);
        contractItemCanBuyListQryPO.setContractIds(reqBo.getContractIds());
        List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.getListByMaterialCodes(contractItemCanBuyListQryPO);
        if (CollectionUtils.isEmpty(contractInfoItemPOS)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5339\u914d\u5408\u540c\u660e\u7ec6\u4e3a\u7a7a");
            return rspBo;
        }
        ArrayList<CPendingReplenishmentPO> replenishmentPOList = new ArrayList<CPendingReplenishmentPO>();
        ArrayList<CPendingReplenishmentMatchPO> matchPOList = new ArrayList<CPendingReplenishmentMatchPO>();
        Map<String, List<ContractInfoItemPO>> contractInfoItemPOMap = contractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getMaterialCode));
        for (ContractSaveReplenishmentReqBoReplenishmentList po : reqBo.getReplenishmentList()) {
            List<ContractInfoItemPO> contractInfoItemPOList = contractInfoItemPOMap.get(po.getMaterialCode());
            if (CollectionUtils.isEmpty(contractInfoItemPOList)) continue;
            boolean flag = true;
            Long replenishmentId = Sequence.getInstance().nextId();
            for (ContractInfoItemPO contractInfoItemPO : contractInfoItemPOList) {
                if (flag) {
                    CPendingReplenishmentPO cPendingReplenishmentPO = (CPendingReplenishmentPO)JSON.parseObject((String)JSONObject.toJSONString((Object)po), CPendingReplenishmentPO.class);
                    cPendingReplenishmentPO.setId(replenishmentId);
                    cPendingReplenishmentPO.setContractId(contractInfoItemPO.getContractId());
                    cPendingReplenishmentPO.setContractNo(contractInfoItemPO.getContractCode());
                    cPendingReplenishmentPO.setContractName(contractInfoItemPO.getContractName());
                    cPendingReplenishmentPO.setRate(contractInfoItemPO.getRate());
                    cPendingReplenishmentPO.setAddrJc(contractInfoItemPO.getSupplierAddressAlias());
                    cPendingReplenishmentPO.setExecutionStandard(contractInfoItemPO.getExecutionStandard());
                    cPendingReplenishmentPO.setBrandOrigin(contractInfoItemPO.getBrandOrigin());
                    cPendingReplenishmentPO.setFactoryPrice(cPendingReplenishmentPO.getFactoryPrice());
                    cPendingReplenishmentPO.setItemId(contractInfoItemPO.getItemId());
                    cPendingReplenishmentPO.setCreateTime(new Date());
                    cPendingReplenishmentPO.setCreateUserId(reqBo.getUserId());
                    cPendingReplenishmentPO.setCreateUserName(reqBo.getName());
                    cPendingReplenishmentPO.setIsDelete(0);
                    replenishmentPOList.add(cPendingReplenishmentPO);
                    flag = false;
                }
                CPendingReplenishmentMatchPO matchPO = new CPendingReplenishmentMatchPO();
                matchPO.setId(Sequence.getInstance().nextId());
                matchPO.setReplenishmentId(replenishmentId);
                matchPO.setMaterialCode(contractInfoItemPO.getMaterialCode());
                matchPO.setContractId(contractInfoItemPO.getContractId());
                matchPO.setContractNo(contractInfoItemPO.getContractCode());
                matchPO.setContractName(contractInfoItemPO.getContractName());
                matchPO.setItemId(contractInfoItemPO.getItemId());
                matchPOList.add(matchPO);
            }
        }
        int count = this.cPendingReplenishmentMapper.insertBatch(replenishmentPOList);
        if (count != replenishmentPOList.size()) {
            throw new ZTBusinessException("\u65b0\u589e\u5f85\u8865\u8d27\u6570\u636e\u5931\u8d25");
        }
        count = this.cPendingReplenishmentMatchMapper.insertBatch(matchPOList);
        if (count != matchPOList.size()) {
            throw new ZTBusinessException("\u65b0\u589e\u5f85\u8865\u8d27\u5339\u914d\u6570\u636e\u5931\u8d25");
        }
        return rspBo;
    }
}

