/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.utils;

import com.tydic.contract.utils.FileType;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.ParseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.EofSensorInputStream;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileTypeJudge {
    private static final Logger log = LoggerFactory.getLogger(FileTypeJudge.class);

    private FileTypeJudge() {
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    private static String getFileContent(String filePath) throws IOException {
        byte[] b = new byte[28];
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            ((InputStream)inputStream).read(b, 0, 28);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        return FileTypeJudge.bytesToHexString(b);
    }

    private static String getFileContentByIs(InputStream inputStream) throws IOException {
        byte[] b = new byte[28];
        try {
            inputStream.read(b, 0, 28);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        return FileTypeJudge.bytesToHexString(b);
    }

    private static String getFileContentByBt(byte[] buffer) throws IOException {
        return FileTypeJudge.bytesToHexString(buffer);
    }

    public static FileType getType(String filePath) throws IOException {
        FileType[] fileTypes;
        String fileHead = FileTypeJudge.getFileContent(filePath);
        if (fileHead == null || fileHead.length() == 0) {
            return null;
        }
        fileHead = fileHead.toUpperCase();
        for (FileType type : fileTypes = FileType.values()) {
            if (!fileHead.startsWith(type.getValue())) continue;
            return type;
        }
        return null;
    }

    public static FileType getTypeByBt(byte[] buffer) throws IOException {
        FileType[] fileTypes;
        String fileHead = FileTypeJudge.getFileContentByBt(buffer);
        if (fileHead == null || fileHead.length() == 0) {
            return null;
        }
        fileHead = fileHead.toUpperCase();
        for (FileType type : fileTypes = FileType.values()) {
            if (!fileHead.startsWith(type.getValue())) continue;
            return type;
        }
        return null;
    }

    public static FileType getTypeByIs(InputStream inputStream) throws IOException {
        FileType[] fileTypes;
        String fileHead = FileTypeJudge.getFileContentByIs(inputStream);
        if (fileHead == null || fileHead.length() == 0) {
            return null;
        }
        fileHead = fileHead.toUpperCase();
        for (FileType type : fileTypes = FileType.values()) {
            if (!fileHead.startsWith(type.getValue())) continue;
            return type;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet("http://172.16.11.188:9998/ca_zmyg/api/open/envelopes/download?envelopeId=136");
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpGet.setConfig(requestConfig);
        httpGet.setHeader("Content-Type", "application/json;charset=utf8");
        httpGet.setHeader("Authorization", "eyJhbGciOiJIUzUxMiJ9.eyJ0ZW1wb3JhcnlfdXNlciI6bnVsbCwidXNlcl9pZCI6IjIyIiwiY3JlYXRlZCI6MTY4MTMwNDAxNTA4MCwibW9iaWxlIjpudWxsLCJpYXQiOjE2ODEzMDQwMTUsImNsaWVudF9pZCI6IjE4MzY5MGE4MWUzNTI1NDAwZWMzMWFlZjQ1MSJ9.Fx1Iqm9Pxcrh72ey_zeTJMN5KzJCKiiC5yKrmVRPcaAnaWEbLHdm33CsKWy0Qqv7R4H5PUEkBgyn6-yS4RQB2g");
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            EofSensorInputStream inputStream = (EofSensorInputStream)response.getEntity().getContent();
            System.out.println((Object)FileTypeJudge.getTypeByIs((InputStream)inputStream));
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println((Object)FileTypeJudge.getType("C:\\Users\\11932\\Desktop\\\u6d4b\u8bd5\u538b\u7f29.rar"));
    }
}

