/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.CceContractSettlementAbilityService;
import com.tydic.contract.ability.bo.CceContractSettlementReqBO;
import com.tydic.contract.ability.bo.CceContractSettlementRspBO;
import com.tydic.contract.ability.bo.ContractSettlementDetailBo;
import com.tydic.contract.busi.bo.ContractDetailInfoBO;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSettlementDetailMapper;
import com.tydic.contract.po.ContractSettlementDetailPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.CceContractSettlementAbilityService"})
public class CceContractSettlementAbilityServiceImpl
implements CceContractSettlementAbilityService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractSettlementDetailMapper contractSettlementDetailMapper;

    @PostMapping(value={"qryContractSettlement"})
    public CceContractSettlementRspBO qryContractSettlement(@RequestBody CceContractSettlementReqBO reqBO) {
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractDetailInfoBO contractDetailInfoBO = new ContractDetailInfoBO();
        contractDetailInfoBO.setContractId(reqBO.getContractId());
        ContractDetailInfoBO contractDetailInfo = this.contractInfoMapper.selectContractDetailInfo(contractDetailInfoBO);
        BigDecimal contractAmount = null == contractDetailInfo.getContractAmount() ? BigDecimal.ZERO : BigDecimal.valueOf(contractDetailInfo.getContractAmount());
        ContractSettlementDetailPO detailPO = new ContractSettlementDetailPO();
        detailPO.setRelateId(reqBO.getContractId());
        CceContractSettlementRspBO rspBO = new CceContractSettlementRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<ContractSettlementDetailPO> list = this.contractSettlementDetailMapper.getList(detailPO);
        if (CollectionUtils.isNotEmpty(list)) {
            List settlementDetailBos = JSONArray.parseArray((String)JSONObject.toJSONString(list), ContractSettlementDetailBo.class);
            settlementDetailBos.forEach(e -> {
                e.setContractName(contractDetailInfo.getContractName());
                e.setContractCode(contractDetailInfo.getContractCode());
                if (contractAmount.compareTo(BigDecimal.ZERO) > 0) {
                    e.setContractDetailAmount(contractAmount.multiply(e.getPayPercent().divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP));
                } else {
                    e.setContractDetailAmount(BigDecimal.ZERO);
                }
            });
            rspBO.setSettlementDetailBos(settlementDetailBos);
        }
        return rspBO;
    }
}

