/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.tydic.contract.ability.ContractArchiveAbilityService;
import com.tydic.contract.ability.ContractPushArchiveAbilityService;
import com.tydic.contract.ability.bo.ContractArchiveAbilityReqBO;
import com.tydic.contract.ability.bo.ContractArchiveAbilityRspBO;
import com.tydic.contract.ability.bo.ContractPushArchiveAbilityServiceReqBO;
import com.tydic.contract.ability.bo.ContractPushArchiveAbilityServiceRspBO;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractArchiveAbilityService"})
public class ContractArchiveAbilityServiceImpl
implements ContractArchiveAbilityService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Value(value="${CONTRACT_ARCHIVE_ROLE}")
    private String contractArchiveRole;
    @Autowired
    private ContractPushArchiveAbilityService contractPushArchiveAbilityService;

    @PostMapping(value={"contractArchive"})
    public ContractArchiveAbilityRspBO contractArchive(@RequestBody ContractArchiveAbilityReqBO reqBO) {
        ContractArchiveAbilityRspBO rspBO = new ContractArchiveAbilityRspBO();
        if (!reqBO.getAuthPermission().contains(this.contractArchiveRole)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u53ea\u6709\u8fd0\u8425-\u5f52\u6863\u7ba1\u7406\u5458\u624d\u80fd\u8fdb\u884c\u5f52\u6863\u64cd\u4f5c");
            return rspBO;
        }
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(reqBO.getContractIds());
        if (CollectionUtils.isEmpty(contractInfoPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540c\u4e0d\u5b58\u5728");
            return rspBO;
        }
        Map<Long, ContractInfoPO> map = contractInfoPOS.stream().collect(Collectors.toMap(a -> a.getContractId(), b -> b, (first, second) -> second));
        if (contractInfoPOS.size() != reqBO.getContractIds().size()) {
            for (Long contractId : reqBO.getContractIds()) {
                if (map.containsKey(contractId)) continue;
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5408\u540c" + contractId + "\u4e0d\u5b58\u5728");
                return rspBO;
            }
        }
        for (ContractInfoPO contractInfoPO : contractInfoPOS) {
            if (contractInfoPO.getArchiveStatus() == null || contractInfoPO.getArchiveStatus() != 1) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540c" + contractInfoPO.getContractCode() + "\u5df2\u5f52\u6863");
            return rspBO;
        }
        this.contractInfoMapper.batchUpdateContractArchive(reqBO.getContractIds(), 3, reqBO.getArchiveTime());
        new Thread(() -> {
            ArrayList<Long> successId = new ArrayList<Long>();
            ArrayList<Long> failId = new ArrayList<Long>();
            for (Long contractId : reqBO.getContractIds()) {
                ContractPushArchiveAbilityServiceReqBO pushArchiveReqBO = new ContractPushArchiveAbilityServiceReqBO();
                pushArchiveReqBO.setContractId(contractId);
                pushArchiveReqBO.setArchiveTime(reqBO.getArchiveTime());
                ContractPushArchiveAbilityServiceRspBO contractPushArchiveAbilityServiceRspBO = this.contractPushArchiveAbilityService.pushArchive(pushArchiveReqBO);
                if (!"0000".equals(contractPushArchiveAbilityServiceRspBO.getRespCode())) {
                    failId.add(contractId);
                    continue;
                }
                successId.add(contractId);
            }
            if (!CollectionUtils.isEmpty(successId)) {
                this.contractInfoMapper.batchUpdateContractArchive(successId, 1, reqBO.getArchiveTime());
            }
            if (!CollectionUtils.isEmpty(failId)) {
                this.contractInfoMapper.batchUpdateContractArchive(failId, 2, reqBO.getArchiveTime());
            }
        }).start();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

