/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractHtAddAbilityService;
import com.tydic.contract.ability.bo.ContractHtAddAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtAddAbilityRspBO;
import com.tydic.contract.ability.bo.ContractHtAddMsgDealAbilityReqBO;
import com.tydic.contract.busi.ContractHtAddBusiService;
import com.tydic.contract.dao.ContractAcceptLogMapper;
import com.tydic.contract.po.ContractAcceptLogPO;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractHtAddAbilityService"})
public class ContractHtAddAbilityServiceImpl
implements ContractHtAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractHtAddAbilityServiceImpl.class);
    @Autowired
    private ContractHtAddBusiService contractHtAddBusiService;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractAcceptLogMapper contractAcceptLogMapper;
    @Resource(name="mqContractHtAddProvider")
    private ProxyMessageProducer mqContractHtAddProvider;
    @Value(value="${CONTRACT_HT_ADD_TOPIC:CONTRACT_HT_ADD_TOPIC}")
    private String contractHtAddTopic;
    @Value(value="${CONTRACT_HT_ADD_TAG:*}")
    private String contractHtAddTag;

    @PostMapping(value={"addHtContract"})
    public ContractHtAddAbilityRspBO addHtContract(@RequestBody ContractHtAddAbilityReqBO reqBO) {
        Date acceptTime = new Date();
        long start = System.currentTimeMillis();
        ContractAcceptLogPO contractAcceptLogPO = new ContractAcceptLogPO();
        contractAcceptLogPO.setId(this.uccBatchSequence.nextId());
        contractAcceptLogPO.setAcceptInfo(JSONObject.toJSONString((Object)reqBO));
        contractAcceptLogPO.setAcceptTime(acceptTime);
        ContractHtAddAbilityRspBO rspBO = this.contractHtAddBusiService.addHtContract(reqBO);
        if (rspBO.getContractId() != null) {
            ContractHtAddMsgDealAbilityReqBO msgDealAbilityReqBO = new ContractHtAddMsgDealAbilityReqBO();
            msgDealAbilityReqBO.setContractId(rspBO.getContractId());
            msgDealAbilityReqBO.setIsFz(rspBO.getIsFz());
            try {
                this.mqContractHtAddProvider.send(new ProxyMessage(this.contractHtAddTopic, this.contractHtAddTag, JSON.toJSONString((Object)msgDealAbilityReqBO)));
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u83b7\u53d6\u7269\u6599\u7f16\u7801\u4fe1\u606f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)msgDealAbilityReqBO));
            }
        }
        contractAcceptLogPO.setType(5);
        Date figureOutTime = new Date();
        long end = System.currentTimeMillis();
        contractAcceptLogPO.setFigureOutTime(figureOutTime);
        contractAcceptLogPO.setTimeSpent("\u8017\u65f6\uff1a" + (double)(end - start) / 1000.0);
        contractAcceptLogPO.setFigureOutInfo("\u63a5\u6536\u5230\u5408\u540c\u7cfb\u7edf\u4e3b\u952eId" + reqBO.getInfoBO().getOutContractId() + "\u5904\u7406\u7ed3\u679c" + rspBO.getRespDesc());
        this.contractAcceptLogMapper.insert(contractAcceptLogPO);
        return rspBO;
    }
}

