/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.contract.ability.ContractItemQueryAbilityService;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.ability.bo.ContractItemQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemQueryAbilityRspBO;
import com.tydic.contract.busi.ContractItemQueryBusiService;
import com.tydic.contract.busi.bo.ContractItemQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemQueryBusiRspBO;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractItemQueryAbilityService"})
public class ContractItemQueryAbilityServiceImpl
implements ContractItemQueryAbilityService {
    @Autowired
    private ContractItemQueryBusiService contractItemQueryBusiService;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;

    @PostMapping(value={"contractItemQuery"})
    public ContractItemQueryAbilityRspBO contractItemQuery(@RequestBody ContractItemQueryAbilityReqBO reqBO) {
        ContractItemQueryAbilityRspBO contractItemQueryAbilityRspBO = new ContractItemQueryAbilityRspBO();
        ContractItemQueryBusiReqBO contractItemQueryBusiReqBO = new ContractItemQueryBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)contractItemQueryBusiReqBO));
        ContractItemQueryBusiRspBO contractItemQueryBusiRspBO = this.contractItemQueryBusiService.contractItemQueryTemp(contractItemQueryBusiReqBO);
        String jsonStr = JSON.toJSONString((Object)((Object)contractItemQueryBusiRspBO));
        contractItemQueryAbilityRspBO = (ContractItemQueryAbilityRspBO)JSON.parseObject((String)jsonStr, ContractItemQueryAbilityRspBO.class);
        if (!CollectionUtils.isEmpty((Collection)contractItemQueryAbilityRspBO.getRows())) {
            contractItemQueryAbilityRspBO.getRows().forEach(e -> {
                if (e.getPurchaseTaxUnitPrice() == null) {
                    e.setPurchaseTaxUnitPrice(BigDecimal.ZERO);
                }
                if (e.getTaxAmount() == null) {
                    e.setTaxAmount(BigDecimal.ZERO);
                }
                if (e.getUnitPriceExcludingTax() == null) {
                    e.setUnitPriceExcludingTax(BigDecimal.ZERO);
                }
                if (e.getNotIncludingTaxAmount() == null) {
                    e.setNotIncludingTaxAmount(BigDecimal.ZERO);
                }
                if (null != e.getSaleStatus()) {
                    if (1 == e.getSaleStatus()) {
                        e.setSaleStatusStr("\u6709\u6548");
                    } else if (2 == e.getSaleStatus()) {
                        e.setSaleStatusStr("\u9650\u91cf");
                    } else if (3 == e.getSaleStatus()) {
                        e.setSaleStatusStr("\u5931\u6548");
                    }
                }
            });
        }
        return contractItemQueryAbilityRspBO;
    }

    @PostMapping(value={"contractItemQueryWithList"})
    public ContractItemQueryAbilityRspBO contractItemQueryWithList(@RequestBody ContractItemQueryAbilityReqBO reqBO) {
        ContractItemQueryAbilityRspBO contractItemQueryAbilityRspBO = new ContractItemQueryAbilityRspBO();
        ContractItemQueryBusiReqBO contractItemQueryBusiReqBO = new ContractItemQueryBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)contractItemQueryBusiReqBO));
        ContractItemQueryBusiRspBO contractItemQueryBusiRspBO = this.contractItemQueryBusiService.contractItemQuery(contractItemQueryBusiReqBO);
        String jsonStr = JSON.toJSONString((Object)((Object)contractItemQueryBusiRspBO));
        contractItemQueryAbilityRspBO = (ContractItemQueryAbilityRspBO)JSON.parseObject((String)jsonStr, ContractItemQueryAbilityRspBO.class);
        return contractItemQueryAbilityRspBO;
    }

    @PostMapping(value={"verifyMaterial"})
    public ContractItemQueryAbilityRspBO verifyMaterial(@RequestBody ContractItemQueryAbilityReqBO reqBO) {
        ContractItemQueryAbilityRspBO rspBO = new ContractItemQueryAbilityRspBO();
        ArrayList<ContractItemAbilityBO> contractItemAbilityBOS = new ArrayList<ContractItemAbilityBO>();
        List<String> materialCodes = this.contractInfoItemTmpMapper.selectVerifyMaterial(reqBO);
        ArrayList<String> repetition = new ArrayList<String>();
        for (int i = 0; i < materialCodes.size() - 1; ++i) {
            for (int j = materialCodes.size() - 1; j > i; --j) {
                if (!materialCodes.get(j).equals(materialCodes.get(i))) continue;
                repetition.add(materialCodes.get(j));
            }
        }
        if (!ObjectUtils.isEmpty(repetition)) {
            List myList = repetition.stream().distinct().collect(Collectors.toList());
            for (String s : myList) {
                ContractItemAbilityBO bo = new ContractItemAbilityBO();
                bo.setMaterialCode(s);
                contractItemAbilityBOS.add(bo);
            }
        }
        rspBO.setRows(contractItemAbilityBOS);
        return rspBO;
    }
}

