/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractItemTmpUpdateRateBatchAbilityService;
import com.tydic.contract.ability.bo.ContractItemBatchUpdateDateAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemTmpUpdateRateBatchAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemTmpUpdateRateBatchAbilityRspBO;
import com.tydic.contract.busi.ContractItemBatchUpdateDateBusiService;
import com.tydic.contract.dao.CRelBuySaleContractMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.po.CRelBuySaleContractPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractItemTmpUpdateRateBatchAbilityService"})
public class ContractItemTmpUpdateRateBatchAbilityServiceImpl
implements ContractItemTmpUpdateRateBatchAbilityService {
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private CRelBuySaleContractMapper cRelBuySaleContractMapper;
    @Autowired
    ContractItemBatchUpdateDateBusiService contractItemBatchUpdateDateBusiService;

    @PostMapping(value={"updateRateBatch"})
    public ContractItemTmpUpdateRateBatchAbilityRspBO updateRateBatch(@RequestBody ContractItemTmpUpdateRateBatchAbilityReqBO reqBO) {
        ContractItemTmpUpdateRateBatchAbilityRspBO rspBO = new ContractItemTmpUpdateRateBatchAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getContractId() == null || reqBO.getAddRate() == null || reqBO.getAddRate() < 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5fc5\u4f20\u53c2\u6570");
            return rspBO;
        }
        ArrayList<ContractInfoItemTmpPO> updateList = new ArrayList<ContractInfoItemTmpPO>();
        Map<Object, Object> purchaseItemMap = new HashMap();
        Map<Object, Object> saleItemIdMap = new HashMap();
        Map<Object, Object> buyItemIdMap = new HashMap();
        List<ContractInfoItemTmpPO> contractInfoItemTmpPOS = this.contractInfoItemTmpMapper.getListByContractId(reqBO.getContractId());
        List<Long> itemIds = contractInfoItemTmpPOS.stream().map(ContractInfoItemTmpPO::getItemId).collect(Collectors.toList());
        List<CRelBuySaleContractPO> bySaleContractItemIds = this.cRelBuySaleContractMapper.getListBySaleContractItemIds(itemIds);
        if (!CollectionUtils.isEmpty(bySaleContractItemIds)) {
            List<Long> buyItemIds = bySaleContractItemIds.stream().map(CRelBuySaleContractPO::getBuyItemId).collect(Collectors.toList());
            List<ContractInfoItemPO> purchaseContractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(buyItemIds);
            if (!CollectionUtils.isEmpty(purchaseContractInfoItemPOS)) {
                buyItemIdMap = purchaseContractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getItemId));
            }
            saleItemIdMap = bySaleContractItemIds.stream().collect(Collectors.groupingBy(CRelBuySaleContractPO::getSaleItemId));
        }
        CRelBuySaleContractPO seachPO = new CRelBuySaleContractPO();
        seachPO.setSaleContractId(reqBO.getContractId());
        if (!CollectionUtils.isEmpty(contractInfoItemTmpPOS)) {
            List<ContractInfoItemPO> purchaseContractInfoItemPOS;
            List<Long> relateItemIds = contractInfoItemTmpPOS.stream().filter(e -> e.getRelateItemId() != null).map(ContractInfoItemTmpPO::getRelateItemId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(relateItemIds) && !CollectionUtils.isEmpty(purchaseContractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(relateItemIds))) {
                purchaseItemMap = purchaseContractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getItemId));
            }
            BigDecimal addRate = new BigDecimal(String.valueOf(1.0f + (float)reqBO.getAddRate().intValue() / 100.0f));
            for (ContractInfoItemTmpPO e2 : contractInfoItemTmpPOS) {
                ContractInfoItemTmpPO updatePo = new ContractInfoItemTmpPO();
                updatePo.setRelateId(reqBO.getContractId());
                updatePo.setAddRate(reqBO.getAddRate());
                if (e2.getRate() == null) {
                    throw new ZTBusinessException("\u660e\u7ec6\u7684\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
                }
                BigDecimal tax = new BigDecimal(String.valueOf(1.0f + (float)e2.getRate().intValue() / 100.0f));
                if (e2.getRelateItemId() != null && purchaseItemMap.containsKey(e2.getRelateItemId())) {
                    ContractInfoItemPO purchaseItemPO = (ContractInfoItemPO)((List)purchaseItemMap.get(e2.getRelateItemId())).get(0);
                    BigDecimal purchaseItemtaxUnitPrice = purchaseItemPO.getTaxUnitPrice().setScale(2, 4);
                    if (purchaseItemtaxUnitPrice == null) {
                        throw new ZTBusinessException("\u5bf9\u5e94\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                    }
                    e2.setTaxUnitPrice(purchaseItemtaxUnitPrice.multiply(addRate).setScale(2, 4));
                    e2.setUnitPriceExcludingTax(e2.getTaxUnitPrice().divide(tax, 2, 4).multiply(new BigDecimal("1")).setScale(2, 4));
                    e2.setTaxAmount(e2.getTaxUnitPrice().multiply(new BigDecimal(e2.getAmount().toString())).setScale(2, 4));
                    e2.setNotIncludingTaxAmount(e2.getUnitPriceExcludingTax().multiply(new BigDecimal(e2.getAmount().toString())).setScale(2, 4));
                    e2.setTax(e2.getNotIncludingTaxAmount().multiply(new BigDecimal(e2.getRate())).setScale(2, 4));
                } else if (saleItemIdMap.containsKey(e2.getItemId())) {
                    CRelBuySaleContractPO cRelBuySaleContractPO = (CRelBuySaleContractPO)((List)saleItemIdMap.get(e2.getItemId())).get(0);
                    if (buyItemIdMap.containsKey(cRelBuySaleContractPO.getBuyItemId())) {
                        ContractInfoItemPO purchaseItemPO = (ContractInfoItemPO)((List)buyItemIdMap.get(cRelBuySaleContractPO.getBuyItemId())).get(0);
                        BigDecimal purchaseItemtaxUnitPrice = purchaseItemPO.getTaxUnitPrice().setScale(2, 4);
                        if (purchaseItemtaxUnitPrice == null) {
                            throw new ZTBusinessException("\u5bf9\u5e94\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                        }
                        e2.setTaxUnitPrice(purchaseItemtaxUnitPrice.multiply(addRate).setScale(2, 4));
                        e2.setUnitPriceExcludingTax(e2.getTaxUnitPrice().divide(tax, 2, 4).multiply(new BigDecimal("1")).setScale(2, 4));
                        e2.setTaxAmount(e2.getTaxUnitPrice().multiply(new BigDecimal(e2.getAmount().toString())).setScale(2, 4));
                        e2.setNotIncludingTaxAmount(e2.getUnitPriceExcludingTax().multiply(new BigDecimal(e2.getAmount().toString())).setScale(2, 4));
                        e2.setTax(e2.getNotIncludingTaxAmount().multiply(new BigDecimal(e2.getRate())).setScale(2, 4));
                    } else {
                        e2.setUnitPriceExcludingTax(e2.getUnitPriceExcludingTax());
                        e2.setTaxUnitPrice(e2.getTaxUnitPrice().multiply(addRate).setScale(2, 4));
                        e2.setTaxAmount(e2.getTaxUnitPrice().multiply(new BigDecimal(e2.getAmount().toString())).setScale(2, 4));
                        e2.setNotIncludingTaxAmount(e2.getUnitPriceExcludingTax().multiply(new BigDecimal(e2.getAmount().toString())).setScale(2, 4));
                        e2.setTax(e2.getNotIncludingTaxAmount().multiply(new BigDecimal(e2.getRate())).setScale(2, 4));
                    }
                } else {
                    e2.setUnitPriceExcludingTax(e2.getUnitPriceExcludingTax());
                    e2.setTaxUnitPrice(e2.getTaxUnitPrice().multiply(addRate).setScale(2, 4));
                    e2.setTaxAmount(e2.getTaxUnitPrice().multiply(new BigDecimal(e2.getAmount().toString())).setScale(2, 4));
                    e2.setNotIncludingTaxAmount(e2.getUnitPriceExcludingTax().multiply(new BigDecimal(e2.getAmount().toString())).setScale(2, 4));
                    e2.setTax(e2.getNotIncludingTaxAmount().multiply(new BigDecimal(e2.getRate())).setScale(2, 4));
                }
                e2.setAddRate(reqBO.getAddRate());
                updateList.add(e2);
            }
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.contractInfoItemTmpMapper.updateAddRateAndPriceBatch(updateList);
        }
        return rspBO;
    }

    @PostMapping(value={"updateContractItemBatchDate"})
    public ContractItemTmpUpdateRateBatchAbilityRspBO updateContractItemBatchDate(@RequestBody ContractItemBatchUpdateDateAbilityReqBO reqBO) {
        this.ValidateParam(reqBO);
        return this.contractItemBatchUpdateDateBusiService.updateContractItemBatchDate(reqBO);
    }

    private void ValidateParam(ContractItemBatchUpdateDateAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getGuaranteePeriod()) && StringUtils.isEmpty((Object)reqBO.getSupplyCycle()) && reqBO.getTaxUnitPrice() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getContractId()) {
            throw new ZTBusinessException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

