/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.tydic.contract.ability.ContractItemUpdateWaitOrderPreSaleNumAbilityService;
import com.tydic.contract.ability.bo.ContractItemUpdateWaitOrderPreSaleNumAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemUpdateWaitOrderPreSaleNumAbilityRspBO;
import com.tydic.contract.dao.CContractPreBuyMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.po.CContractPreBuyPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractOrderPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractItemUpdateWaitOrderPreSaleNumAbilityService"})
public class ContractItemUpdateWaitOrderPreSaleNumAbilityServiceImpl
implements ContractItemUpdateWaitOrderPreSaleNumAbilityService {
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private CContractPreBuyMapper cContractPreBuyMapper;

    @PostMapping(value={"updateWaitOrderPreSaleNum"})
    public ContractItemUpdateWaitOrderPreSaleNumAbilityRspBO updateWaitOrderPreSaleNum(@RequestBody ContractItemUpdateWaitOrderPreSaleNumAbilityReqBO reqBO) {
        ContractItemUpdateWaitOrderPreSaleNumAbilityRspBO rspBO = new ContractItemUpdateWaitOrderPreSaleNumAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getItemId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u8bf7\u4e0d\u8981\u4f20\u5165\u7a7a\u503c");
            return rspBO;
        }
        if (reqBO.getPreSaleNum() == null || reqBO.getPreSaleNum().compareTo(BigDecimal.ZERO) < 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5927\u4e8e0");
            return rspBO;
        }
        if (reqBO.getUserId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u7528\u6237\u7684userId\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<Long> itemIds = new ArrayList<Long>();
        itemIds.add(reqBO.getItemId());
        List<ContractOrderPo> contractOrderPos = this.contractOrderMapper.selectListByItemIds(itemIds);
        List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(itemIds);
        BigDecimal sumDoOrderNum = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(contractOrderPos)) {
            sumDoOrderNum = contractOrderPos.get(0).getSumDoOrderNum();
        }
        if (CollectionUtils.isEmpty(contractInfoItemPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u660e\u7ec6\u5df2\u4e0d\u5b58\u5728");
            return rspBO;
        }
        amount = contractInfoItemPOS.get(0).getAmount();
        if (amount.subtract(sumDoOrderNum).compareTo(reqBO.getPreSaleNum()) < 0) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u4fee\u6539\u7684\u91c7\u8d2d\u6570\u91cf\u5df2\u8d85\u8fc7\u6b64\u660e\u7ec6\u7684\u53ef\u4e0b\u5355\u91cf");
            return rspBO;
        }
        CContractPreBuyPO updatePO = new CContractPreBuyPO();
        updatePO.setPreSaleNum(reqBO.getPreSaleNum());
        CContractPreBuyPO seachPO = new CContractPreBuyPO();
        seachPO.setItemId(reqBO.getItemId());
        seachPO.setCreateUserId(reqBO.getUserId());
        this.cContractPreBuyMapper.updateBy(updatePO, seachPO);
        return rspBO;
    }

    public ContractOrderMapper getContractOrderMapper() {
        return this.contractOrderMapper;
    }

    public ContractInfoItemMapper getContractInfoItemMapper() {
        return this.contractInfoItemMapper;
    }

    public CContractPreBuyMapper getCContractPreBuyMapper() {
        return this.cContractPreBuyMapper;
    }

    public void setContractOrderMapper(ContractOrderMapper contractOrderMapper) {
        this.contractOrderMapper = contractOrderMapper;
    }

    public void setContractInfoItemMapper(ContractInfoItemMapper contractInfoItemMapper) {
        this.contractInfoItemMapper = contractInfoItemMapper;
    }

    public void setCContractPreBuyMapper(CContractPreBuyMapper cContractPreBuyMapper) {
        this.cContractPreBuyMapper = cContractPreBuyMapper;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractItemUpdateWaitOrderPreSaleNumAbilityServiceImpl)) {
            return false;
        }
        ContractItemUpdateWaitOrderPreSaleNumAbilityServiceImpl other = (ContractItemUpdateWaitOrderPreSaleNumAbilityServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContractOrderMapper this$contractOrderMapper = this.getContractOrderMapper();
        ContractOrderMapper other$contractOrderMapper = other.getContractOrderMapper();
        if (this$contractOrderMapper == null ? other$contractOrderMapper != null : !this$contractOrderMapper.equals(other$contractOrderMapper)) {
            return false;
        }
        ContractInfoItemMapper this$contractInfoItemMapper = this.getContractInfoItemMapper();
        ContractInfoItemMapper other$contractInfoItemMapper = other.getContractInfoItemMapper();
        if (this$contractInfoItemMapper == null ? other$contractInfoItemMapper != null : !this$contractInfoItemMapper.equals(other$contractInfoItemMapper)) {
            return false;
        }
        CContractPreBuyMapper this$cContractPreBuyMapper = this.getCContractPreBuyMapper();
        CContractPreBuyMapper other$cContractPreBuyMapper = other.getCContractPreBuyMapper();
        return !(this$cContractPreBuyMapper == null ? other$cContractPreBuyMapper != null : !this$cContractPreBuyMapper.equals(other$cContractPreBuyMapper));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContractItemUpdateWaitOrderPreSaleNumAbilityServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContractOrderMapper $contractOrderMapper = this.getContractOrderMapper();
        result = result * 59 + ($contractOrderMapper == null ? 43 : $contractOrderMapper.hashCode());
        ContractInfoItemMapper $contractInfoItemMapper = this.getContractInfoItemMapper();
        result = result * 59 + ($contractInfoItemMapper == null ? 43 : $contractInfoItemMapper.hashCode());
        CContractPreBuyMapper $cContractPreBuyMapper = this.getCContractPreBuyMapper();
        result = result * 59 + ($cContractPreBuyMapper == null ? 43 : $cContractPreBuyMapper.hashCode());
        return result;
    }

    public String toString() {
        return "ContractItemUpdateWaitOrderPreSaleNumAbilityServiceImpl(contractOrderMapper=" + this.getContractOrderMapper() + ", contractInfoItemMapper=" + this.getContractInfoItemMapper() + ", cContractPreBuyMapper=" + this.getCContractPreBuyMapper() + ")";
    }
}

