/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractPushErpAbilityService;
import com.tydic.contract.ability.bo.ContractPushErpAbilityReqBO;
import com.tydic.contract.ability.bo.ContractPushErpAbilityRspBO;
import com.tydic.contract.busi.bo.ContractPushErpBusiReqBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoPushErpLogMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractPushErpAbilityService"})
public class ContractPushErpAbilityServiceImpl
implements ContractPushErpAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractPushErpAbilityServiceImpl.class);
    public static final Integer PUSH_ERP = 1;
    public static final Integer PUSH_PLAN = 2;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private CContractInfoPushErpLogMapper cContractInfoPushErpLogMapper;
    @Resource(name="mqContractPushErpProvider")
    private ProxyMessageProducer mqContractPushErpProvider;
    @Value(value="${CONTRACT_PUSH_ERP_TOPIC:CONTRACT_PUSH_ERP_TOPIC}")
    private String topic;
    @Value(value="${CONTRACT_PUSH_ERP_TAG:*}")
    private String tag;

    @PostMapping(value={"dealPushErp"})
    public ContractPushErpAbilityRspBO dealPushErp(@RequestBody ContractPushErpAbilityReqBO reqBO) {
        ContractPushErpAbilityRspBO abilityRspBO = new ContractPushErpAbilityRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getContractIds())) {
            abilityRspBO.setRespCode("8888");
            abilityRspBO.setRespDesc("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
            return abilityRspBO;
        }
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(reqBO.getContractIds());
        if (!CollectionUtils.isEmpty(contractInfoPOS)) {
            ArrayList pushErpInfos = new ArrayList();
            ArrayList<Long> pushErpIds = new ArrayList<Long>();
            ArrayList<Long> pushPlanIds = new ArrayList<Long>();
            for (ContractInfoPO e : contractInfoPOS) {
                if (!ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT.equals(e.getContractStatus()) && !ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER.equals(e.getContractStatus())) continue;
                if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(e.getContractType())) {
                    if (ContractConstant.PushErpStatus.FAIL_SYNC.equals(e.getPushErpStatus())) {
                        pushErpIds.add(e.getContractId());
                    }
                    if (!ContractConstant.PushErpStatus.FAIL_SYNC.equals(e.getPushPlanStatus())) continue;
                    pushPlanIds.add(e.getContractId());
                    continue;
                }
                if (!ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(e.getContractType()) || !ContractConstant.PushErpStatus.FAIL_SYNC.equals(e.getPushPlanStatus())) continue;
                pushPlanIds.add(e.getContractId());
            }
            if (PUSH_ERP.equals(reqBO.getOperType())) {
                pushPlanIds = null;
            } else if (PUSH_PLAN.equals(reqBO.getOperType())) {
                pushErpIds = null;
            }
            if (!CollectionUtils.isEmpty(pushErpIds)) {
                this.contractInfoMapper.updatePushErpSyncStatusByCodes(pushErpIds, ContractConstant.PushErpStatus.IN_SYNC, null);
            }
            if (!CollectionUtils.isEmpty(pushPlanIds)) {
                this.contractInfoMapper.updatePushPlanSyncStatusByCodes(pushPlanIds, ContractConstant.PushErpStatus.IN_SYNC);
            }
            if (!CollectionUtils.isEmpty(pushErpIds) || !CollectionUtils.isEmpty(pushPlanIds)) {
                ContractPushErpBusiReqBO contractPushErpBusiReqBO = new ContractPushErpBusiReqBO();
                try {
                    contractPushErpBusiReqBO.setContractIds(pushErpIds);
                    contractPushErpBusiReqBO.setPushPlanContractIds(pushPlanIds);
                    log.info("\u53d1\u9001\u540c\u6b65erp\u6d88\u606f\uff1a" + JSON.toJSONString((Object)((Object)contractPushErpBusiReqBO)));
                    this.mqContractPushErpProvider.send(new ProxyMessage(this.topic, this.tag, JSON.toJSONString((Object)((Object)contractPushErpBusiReqBO))));
                }
                catch (Exception e) {
                    log.error("\u53d1\u9001\u540c\u6b65erp\u6d88\u606f\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)((Object)contractPushErpBusiReqBO)));
                }
            }
        }
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setRespDesc("\u6210\u529f");
        return abilityRspBO;
    }
}

