/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractSafeStockExportAbilityService;
import com.tydic.contract.ability.ContractWmsStockListQryAbilityService;
import com.tydic.contract.ability.bo.ContractSafeStockExportAbilityReqBO;
import com.tydic.contract.ability.bo.ContractSafeStockExportAbilityRspBO;
import com.tydic.contract.ability.bo.ContractWmsStockListQryReqBo;
import com.tydic.contract.ability.bo.ContractWmsStockListQryRspBo;
import com.tydic.contract.ability.bo.ContractWmsStockListQryRspBoMaterialList;
import com.tydic.contract.atom.ContractUploadByteFileAtomService;
import com.tydic.contract.atom.bo.ContractUploadByteFileAtomReqBo;
import com.tydic.contract.atom.bo.ContractUploadByteFileAtomRspBo;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractSafeStockExportAbilityService"})
public class ContractSafeStockExportAbilityServiceImpl
implements ContractSafeStockExportAbilityService {
    @Autowired
    private ContractWmsStockListQryAbilityService contractWmsStockListQryAbilityService;
    @Autowired
    private ContractUploadByteFileAtomService contractUploadByteFileAtomService;

    @PostMapping(value={"safeStockExport"})
    public ContractSafeStockExportAbilityRspBO safeStockExport(@RequestBody ContractSafeStockExportAbilityReqBO reqBO) {
        ContractUploadByteFileAtomRspBo uploadByteFileAtomRspBo;
        String fileName;
        ContractSafeStockExportAbilityRspBO rspBo = new ContractSafeStockExportAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.checkReq(reqBO);
        ArrayList materialList = new ArrayList();
        ContractWmsStockListQryReqBo contractWmsStockListQryReqBo = (ContractWmsStockListQryReqBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ContractWmsStockListQryReqBo.class);
        Integer pageNo = 1;
        Integer pageSize = 1000;
        do {
            contractWmsStockListQryReqBo.setPageNo(pageNo.intValue());
            contractWmsStockListQryReqBo.setPageSize(pageSize.intValue());
            ContractWmsStockListQryRspBo contractWmsStockListQryRspBo = this.contractWmsStockListQryAbilityService.qryWmsStockList(contractWmsStockListQryReqBo);
            if (CollectionUtils.isEmpty((Collection)contractWmsStockListQryRspBo.getMaterialList())) break;
            materialList.addAll(contractWmsStockListQryRspBo.getMaterialList());
            if (contractWmsStockListQryRspBo.getMaterialList().size() < pageSize) break;
            Integer n = pageNo;
            Integer n2 = pageNo = Integer.valueOf(pageNo + 1);
        } while (pageNo < 20);
        if (!CollectionUtils.isEmpty(materialList)) {
            for (ContractWmsStockListQryRspBoMaterialList bo : materialList) {
                String safeNumExportStr = null;
                String limitNumExportStr = null;
                if (bo.getSafeNum() != null) {
                    safeNumExportStr = bo.getSafeNum().stripTrailingZeros().toPlainString();
                }
                if (bo.getLimitNum() != null) {
                    limitNumExportStr = bo.getLimitNum().stripTrailingZeros().toPlainString();
                }
                bo.setSafeNumExportStr(safeNumExportStr);
                bo.setLimitNumExportStr(limitNumExportStr);
            }
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> mainTemplate = new HashMap<String, Object>();
            mainTemplate.put("SHEET_NAME", "\u5b89\u5168\u5e93\u5b58\u7ef4\u62a4");
            String[] titles = new String[]{"\u660e\u7ec6\u884cID", "\u7269\u8d44\u7f16\u7801", "\u7269\u8d44\u63cf\u8ff0", "\u8ba1\u91cf\u5355\u4f4d", "\u5b89\u5168\u5e93\u5b58", "\u50a8\u5907\u4e0a\u9650"};
            mainTemplate.put("TITLES", titles);
            String[] fields = new String[]{"itemId", "materialCode", "materialDesc", "unit", "safeNumExportStr", "limitNumExportStr"};
            mainTemplate.put("FIELDS", fields);
            List<Integer> widths = Arrays.asList(15, 15, 15, 15, 15, 15);
            mainTemplate.put("WIDTHS", widths);
            mainTemplate.put("DATA", JSON.toJSONString(materialList));
            List<Integer> lockedList = Arrays.asList(0, 1, 2, 3);
            mainTemplate.put("LOCKED_LIST", lockedList);
            HashMap<Integer, Integer> extraLongMap = new HashMap<Integer, Integer>();
            extraLongMap.put(10, 1000);
            extraLongMap.put(11, 1000);
            mainTemplate.put("EXTRA_LONG_MAP", extraLongMap);
            dataList.add(mainTemplate);
            fileName = "\u5b89\u5168\u5e93\u5b58\u7ef4\u62a4\u6a21\u677f.xlsx";
            ContractUploadByteFileAtomReqBo uploadByteFileAtomReqBo = new ContractUploadByteFileAtomReqBo();
            uploadByteFileAtomReqBo.setFileName(fileName);
            uploadByteFileAtomReqBo.setDataList(dataList);
            uploadByteFileAtomRspBo = this.contractUploadByteFileAtomService.uploadByWorkbook(uploadByteFileAtomReqBo);
            if (!"0000".equals(uploadByteFileAtomRspBo.getRespCode())) {
                throw new BusinessException("8888", "\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        } else {
            throw new ZTBusinessException("\u67e5\u8be2\u6570\u636e\u7ed3\u679c\u4e3a\u7a7a");
        }
        rspBo.setTemplateUrl(uploadByteFileAtomRspBo.getFileUrl());
        rspBo.setTemplateName(fileName);
        return rspBo;
    }

    private void checkReq(ContractSafeStockExportAbilityReqBO reqBo) {
        if (reqBo.getContractId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTempId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

