/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractStockChangeDetailQryAbilityService;
import com.tydic.contract.ability.bo.ContractStockChangeDetailQryReqBo;
import com.tydic.contract.ability.bo.ContractStockChangeDetailQryRspBo;
import com.tydic.contract.ability.bo.ContractStockChangeDetailQryRspBoMaterialList;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractStockChangeItemMapper;
import com.tydic.contract.dao.CContractStockChangeMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.po.CContractStockChangeItemPO;
import com.tydic.contract.po.CContractStockChangePO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractStockChangeDetailQryAbilityService"})
public class ContractStockChangeDetailQryAbilityServiceImpl
implements ContractStockChangeDetailQryAbilityService {
    @Autowired
    private CContractStockChangeMapper cContractStockChangeMapper;
    @Autowired
    private CContractStockChangeItemMapper cContractStockChangeItemMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;

    @PostMapping(value={"qryStockChangeDetail"})
    public ContractStockChangeDetailQryRspBo qryStockChangeDetail(@RequestBody ContractStockChangeDetailQryReqBo reqBo) {
        if (reqBo.getChangeId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u53d8\u66f4id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CContractStockChangePO stockChangePO = this.cContractStockChangeMapper.queryById(reqBo.getChangeId());
        if (stockChangePO == null) {
            throw new ZTBusinessException("\u5f53\u524d\u53d8\u66f4\u7248\u672c\u4e0d\u5b58\u5728");
        }
        if (stockChangePO.getContractId() == null) {
            throw new ZTBusinessException("\u5f53\u524d\u53d8\u66f4\u7248\u672c\u5bf9\u5e94\u7684\u5408\u540cid\u4e0d\u5b58\u5728");
        }
        ContractStockChangeDetailQryRspBo rspBo = (ContractStockChangeDetailQryRspBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)stockChangePO), ContractStockChangeDetailQryRspBo.class);
        CContractStockChangeItemPO searchStockChangeItemPO = new CContractStockChangeItemPO();
        searchStockChangeItemPO.setChangeId(reqBo.getChangeId());
        Page page = PageHelper.startPage((int)reqBo.getPageNo(), (int)reqBo.getPageSize()).doSelectPage(() -> this.cContractStockChangeItemMapper.queryAll(searchStockChangeItemPO));
        List changeItemPOS = page.getResult();
        if (!CollectionUtils.isEmpty((Collection)changeItemPOS)) {
            List materialList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)changeItemPOS), ContractStockChangeDetailQryRspBoMaterialList.class);
            rspBo.setMaterialList(materialList);
        }
        rspBo.setRecordsTotal(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
        rspBo.setTotal(Integer.valueOf(page.getPages()));
        rspBo.setPageNo(reqBo.getPageNo());
        Map<Object, Object> lastChangeItemMap = new HashMap();
        Long lastChangeId = null;
        Integer lastNowNumber = stockChangePO.getNumber() - 1;
        CContractStockChangePO searchLastStockChangePO = new CContractStockChangePO();
        searchLastStockChangePO.setContractId(stockChangePO.getContractId());
        searchLastStockChangePO.setNumber(lastNowNumber);
        List<CContractStockChangePO> lastStockChangePOS = this.cContractStockChangeMapper.queryAll(searchLastStockChangePO);
        if (!CollectionUtils.isEmpty(lastStockChangePOS)) {
            lastChangeId = lastStockChangePOS.get(0).getId();
            CContractStockChangeItemPO searchLastStockChangeItemPO = new CContractStockChangeItemPO();
            searchLastStockChangeItemPO.setChangeId(lastChangeId);
            List<CContractStockChangeItemPO> lastChangeItemPOS = this.cContractStockChangeItemMapper.queryAll(searchLastStockChangeItemPO);
            if (!CollectionUtils.isEmpty(lastChangeItemPOS)) {
                lastChangeItemMap = lastChangeItemPOS.stream().collect(Collectors.groupingBy(CContractStockChangeItemPO::getItemId));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)rspBo.getMaterialList())) {
            List<ContractInfoItemPO> itemPOS = this.contractInfoItemMapper.getItemsByRelId(stockChangePO.getContractId());
            Map<Long, ContractInfoItemPO> itemIdMap = itemPOS.stream().collect(Collectors.toMap(ContractInfoItemPO::getItemId, o -> o));
            Map<Object, Object> orderNumMap = new HashMap();
            List<Long> itemIds = itemPOS.stream().map(ContractInfoItemPO::getItemId).collect(Collectors.toList());
            List<ContractOrderPo> contractOrderPos = this.contractOrderMapper.selectListByItemIds(itemIds);
            if (!CollectionUtils.isEmpty(contractOrderPos)) {
                orderNumMap = contractOrderPos.stream().collect(Collectors.toMap(ContractOrderPo::getItemId, ContractOrderPo::getSumDoOrderNum));
            }
            int serialNumber = 1;
            for (ContractStockChangeDetailQryRspBoMaterialList bo : rspBo.getMaterialList()) {
                List lastChangeItemPOList;
                if (lastChangeItemMap.containsKey(bo.getItemId()) && !CollectionUtils.isEmpty((Collection)(lastChangeItemPOList = (List)lastChangeItemMap.get(bo.getItemId())))) {
                    CContractStockChangeItemPO lastChangeItemPO = (CContractStockChangeItemPO)lastChangeItemPOList.get(0);
                    bo.setPreSafeNum(lastChangeItemPO.getSafeNum());
                    bo.setPreLimitNum(lastChangeItemPO.getLimitNum());
                }
                if (itemIdMap.containsKey(bo.getItemId())) {
                    ContractInfoItemPO infoItemPO = itemIdMap.get(bo.getItemId());
                    bo.setSaleStatus(infoItemPO.getSaleStatus());
                    BigDecimal orderNum = BigDecimal.ZERO;
                    if (orderNumMap.containsKey(bo.getItemId())) {
                        orderNum = (BigDecimal)orderNumMap.get(bo.getItemId());
                    }
                    if (infoItemPO.getAmount() == null) {
                        infoItemPO.setAmount(BigDecimal.ONE);
                    }
                    bo.setCanOrderNum(infoItemPO.getAmount().subtract(orderNum));
                    if (infoItemPO.getSaleStatus() != null) {
                        bo.setStatus(ContractTransFieldUtil.transSaleStatus(infoItemPO.getSaleStatus()));
                        if (ContractConstant.SaleStatus.VALID.equals(infoItemPO.getSaleStatus()) || ContractConstant.SaleStatus.INVALID.equals(infoItemPO.getSaleStatus())) {
                            bo.setCanOrderNumStr("-");
                        } else {
                            bo.setCanOrderNumStr(bo.getCanOrderNum().toString());
                        }
                    } else {
                        bo.setCanOrderNumStr(bo.getCanOrderNum().toString());
                    }
                }
                bo.setSerialNumber(Integer.valueOf(serialNumber++));
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

