/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractSyncStatusQryListAbilityService;
import com.tydic.contract.ability.bo.ContractInfoPushErpByTypeBO;
import com.tydic.contract.ability.bo.ContractSyncStatusQryListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractSyncStatusQryListAbilityRspBO;
import com.tydic.contract.busi.ContractInfoPushErpLogQryListBusiService;
import com.tydic.contract.busi.bo.ContractInfoPushErpLogQryListBusiReqBO;
import com.tydic.contract.busi.bo.ContractInfoPushErpLogQryListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoPushErpLogMapper;
import com.tydic.contract.po.CContractInfoPushErpPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractSyncStatusQryListAbilityService"})
public class ContractSyncStatusQryListAbilityServiceImpl
implements ContractSyncStatusQryListAbilityService {
    public static final Integer QRY_PUSH_TYPE_ERP = 1;
    public static final Integer QRY_PUSH_TYPE_PLAN = 2;
    @Autowired
    private ContractInfoPushErpLogQryListBusiService contractInfoPushErpLogQryListBusiService;
    @Autowired
    private CContractInfoPushErpLogMapper contractInfoPushErpLogMapper;

    @PostMapping(value={"qryContractInfoPushErpLog"})
    public ContractSyncStatusQryListAbilityRspBO qryContractInfoPushErpLog(@RequestBody ContractSyncStatusQryListAbilityReqBO reqBO) {
        this.validateParam(reqBO);
        ContractInfoPushErpLogQryListBusiReqBO busiReqBO = new ContractInfoPushErpLogQryListBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        ContractInfoPushErpLogQryListBusiRspBO rspBO = this.contractInfoPushErpLogQryListBusiService.qryLogList(busiReqBO);
        return (ContractSyncStatusQryListAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)rspBO)), ContractSyncStatusQryListAbilityRspBO.class);
    }

    private void validateParam(ContractSyncStatusQryListAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u67e5\u8be2erp\u72b6\u6001\u5217\u8868\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getContractId()) {
            throw new ZTBusinessException("\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    @PostMapping(value={"qryContractInfoPushErpLogByType"})
    public ContractSyncStatusQryListAbilityRspBO qryContractInfoPushErpLogByType(@RequestBody ContractSyncStatusQryListAbilityReqBO reqBO) {
        this.validateParamByType(reqBO);
        CContractInfoPushErpPO record = new CContractInfoPushErpPO();
        record.setContractId(reqBO.getContractId());
        record.setQryPushType(reqBO.getQryPushType());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoPushErpLogMapper.getList(record));
        String jsonString = JSONObject.toJSONString((Object)page.getResult());
        List infoPushErpBOList = JSONObject.parseArray((String)jsonString).toJavaList(CContractInfoPushErpPO.class);
        ContractSyncStatusQryListAbilityRspBO rspBO = new ContractSyncStatusQryListAbilityRspBO();
        ArrayList<ContractInfoPushErpByTypeBO> rows = new ArrayList<ContractInfoPushErpByTypeBO>();
        if (!CollectionUtils.isEmpty((Collection)infoPushErpBOList)) {
            for (CContractInfoPushErpPO each : infoPushErpBOList) {
                ContractInfoPushErpByTypeBO contractInfoPushErpByTypeBo = new ContractInfoPushErpByTypeBO();
                contractInfoPushErpByTypeBo.setId(each.getId());
                contractInfoPushErpByTypeBo.setContractId(each.getContractId());
                if (QRY_PUSH_TYPE_ERP.equals(reqBO.getQryPushType())) {
                    contractInfoPushErpByTypeBo.setPushInfo(each.getPushInfo());
                    contractInfoPushErpByTypeBo.setPushTime(each.getPushTime());
                    contractInfoPushErpByTypeBo.setPushReturnInfo(each.getPushReturnInfo());
                    contractInfoPushErpByTypeBo.setPushStatus(each.getPushErpStatus());
                } else {
                    contractInfoPushErpByTypeBo.setPushInfo(each.getPlanPushInfo());
                    contractInfoPushErpByTypeBo.setPushTime(each.getPlanPushTime());
                    contractInfoPushErpByTypeBo.setPushReturnInfo(each.getPlanPushReturnInfo());
                    contractInfoPushErpByTypeBo.setPushStatus(each.getPushPlanStatus());
                }
                if (ContractConstant.PushStatus.SUCCESS.equals(contractInfoPushErpByTypeBo.getPushStatus())) {
                    contractInfoPushErpByTypeBo.setPushStatusStr("\u540c\u6b65\u6210\u529f");
                } else if (ContractConstant.PushStatus.FAIL.equals(contractInfoPushErpByTypeBo.getPushStatus())) {
                    contractInfoPushErpByTypeBo.setPushStatusStr("\u540c\u6b65\u5931\u8d25");
                }
                rows.add(contractInfoPushErpByTypeBo);
            }
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParamByType(ContractSyncStatusQryListAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getContractId()) {
            throw new ZTBusinessException("\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getQryPushType()) {
            throw new ZTBusinessException("\u5165\u53c2\u63a8\u9001\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

