/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.atom.InterFaceContractErpUpdateAwardDealerAtomService;
import com.tydic.contract.atom.bo.InterFaceContractErpUpdateAwardDealerAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractErpUpdateAwardDealerAtomRspBO;
import com.tydic.contract.dao.ContractPushLogMapper;
import com.tydic.contract.po.ContractPushLogPO;
import com.tydic.contract.utils.HttpUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class InterFaceContractErpUpdateAwardDealerAtomServiceImpl
implements InterFaceContractErpUpdateAwardDealerAtomService {
    private static final Logger log = LoggerFactory.getLogger(InterFaceContractErpUpdateAwardDealerAtomServiceImpl.class);
    @Value(value="${CONTRACT_NO_RECRUIT_UPDATE_AWARD_DEALER_URL:}")
    private String contractNoRecruitupdateAwardDealerUrl;
    @Autowired
    private ContractPushLogMapper contractPushLogMapper;

    @Override
    public InterFaceContractErpUpdateAwardDealerAtomRspBO updateAwardDealer(InterFaceContractErpUpdateAwardDealerAtomReqBO reqBO) {
        InterFaceContractErpUpdateAwardDealerAtomRspBO rspBO = new InterFaceContractErpUpdateAwardDealerAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.debug("\u8c03\u7528\u975e\u62db\u4fee\u6539\u591a\u7ecf\u9500\u5546\u72b6\u6001\u63a5\u53e3\u5165\u53c2\uff1a" + JSONObject.toJSONString(reqBO.getUpdateBOS(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        String reqStr = JSONObject.toJSONString(reqBO.getUpdateBOS());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("ESB-TOKEN", (Object)reqBO.getToken());
        try {
            String rspStr = HttpUtil.doPost(this.contractNoRecruitupdateAwardDealerUrl, reqStr, jsonObject.toJSONString());
            ContractPushLogPO insertContractPushLogPO = new ContractPushLogPO();
            insertContractPushLogPO.setId(Sequence.getInstance().nextId());
            insertContractPushLogPO.setCreateTime(new Date());
            insertContractPushLogPO.setReqJson(reqStr);
            insertContractPushLogPO.setType(4);
            insertContractPushLogPO.setRspJson(rspStr);
            try {
                this.contractPushLogMapper.insert(insertContractPushLogPO);
            }
            catch (Exception exception) {
                // empty catch block
            }
            rspBO = this.resolveRsp(rspStr);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u975e\u62db\u4fee\u6539\u591a\u7ecf\u9500\u5546\u72b6\u6001\u63a5\u53e3\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
        }
        return rspBO;
    }

    private InterFaceContractErpUpdateAwardDealerAtomRspBO resolveRsp(String rspStr) {
        JSONObject jsonObject;
        InterFaceContractErpUpdateAwardDealerAtomRspBO rspBO = new InterFaceContractErpUpdateAwardDealerAtomRspBO();
        try {
            jsonObject = JSONObject.parseObject((String)rspStr);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u975e\u62db\u4fee\u6539\u591a\u7ecf\u9500\u5546\u72b6\u6001\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if (jsonObject.get((Object)"success") == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528\u975e\u62db\u4fee\u6539\u591a\u7ecf\u9500\u5546\u72b6\u6001\u63a5\u53e3\u8fd4\u56de\u72b6\u6001\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        if ("true".equals(jsonObject.getString("success"))) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc(jsonObject.get((Object)"message").toString());
        return rspBO;
    }
}

