/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.atom.InterFaceWmsStockListQryAtomService;
import com.tydic.contract.atom.bo.InterFaceWmsStockListQryAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceWmsStockListQryAtomRspBO;
import com.tydic.contract.utils.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InterFaceWmsStockListQryAtomServiceImpl
implements InterFaceWmsStockListQryAtomService {
    private static final Logger log = LoggerFactory.getLogger(InterFaceWmsStockListQryAtomServiceImpl.class);
    @Value(value="${WMS_STOCK_LIST_QRY_URL:WMS_STOCK_LIST_QRY_URL}")
    private String wmsStockListQryUrl;
    @Value(value="${WMS_STOCK_LIST_QRY_KEY:YG_STOCK_QUERY}")
    private String wmsStockListQryKey;

    @Override
    public InterFaceWmsStockListQryAtomRspBO qryWmsStockList(InterFaceWmsStockListQryAtomReqBO reqBO) {
        InterFaceWmsStockListQryAtomRspBO rspBO = new InterFaceWmsStockListQryAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        JSONObject reqJsonObject = new JSONObject();
        reqJsonObject.put("key", this.wmsStockListQryKey);
        reqJsonObject.put("data", reqBO);
        String reqStr = JSONObject.toJSONString((Object)reqJsonObject);
        try {
            log.info("\u8c03\u7528WMS\u5b89\u5168\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u5165\u53c2" + reqStr);
            String rspStr = HttpUtil.doPost(this.wmsStockListQryUrl, reqStr, null);
            log.info("\u8c03\u7528WMS\u5b89\u5168\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u51fa\u53c2" + rspStr);
            rspBO = this.resolveRsp(rspStr, rspBO);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528WMS\u5b89\u5168\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u63a5\u53e3\u5f02\u5e38" + e.getMessage());
        }
        return rspBO;
    }

    private InterFaceWmsStockListQryAtomRspBO resolveRsp(String rspStr, InterFaceWmsStockListQryAtomRspBO rspBO) {
        try {
            if (StringUtils.isEmpty((Object)rspStr)) {
                throw new ZTBusinessException("\u62a5\u6587\u8fd4\u56de\u4e3a\u7a7a");
            }
            JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8c03\u7528WMS\u5b89\u5168\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a");
            return rspBO;
        }
        try {
            rspBO = (InterFaceWmsStockListQryAtomRspBO)((Object)JSONObject.parseObject((String)rspStr, InterFaceWmsStockListQryAtomRspBO.class));
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8f6c\u6362\u8fd4\u56de\u62a5\u6587\u5f02\u5e38");
            return rspBO;
        }
        if ("200".equals(rspBO.getCode())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc(rspBO.getMsg());
        return rspBO;
    }
}

