/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.UccMaterialInfoQueryAbilityService;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityRspBO;
import com.tydic.contract.ability.bo.CContractOrderInfoBO;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.ability.bo.ContractItemAbilityUpdateVO;
import com.tydic.contract.ability.bo.DicDictionaryBO;
import com.tydic.contract.busi.ContractDictionaryBusiService;
import com.tydic.contract.busi.ContractItemChangeAddBusiService;
import com.tydic.contract.busi.bo.ContractItemChangeAddBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemChangeAddBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractOrderInfoMapper;
import com.tydic.contract.dao.CRelBuySaleContractMapper;
import com.tydic.contract.dao.ContractInfoChangeItemMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.dao.SysDicDictionaryMapper;
import com.tydic.contract.po.CRelBuySaleContractPO;
import com.tydic.contract.po.ContractInfoChangeItemPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.po.SysDicDictionaryPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.ExcelUtils;
import com.tydic.contract.utils.HttpUtil;
import com.tydic.ppc.ability.api.PlanQueryByPlanIdsAbilityService;
import com.tydic.ppc.ability.bo.CcePlanDiversionBO;
import com.tydic.ppc.ability.bo.PlanQueryByPlanIdsAbilityReqBO;
import com.tydic.ppc.ability.bo.PlanQueryByPlanIdsAbilityRspBO;
import com.tydic.uac.exception.BusinessException;
import com.tydic.umc.general.ability.api.UmcContractOrgSubQryAbilityService;
import com.tydic.umc.general.ability.api.UmcContractQueryBuyerInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcContractOrgSubQryAbilityBO;
import com.tydic.umc.general.ability.bo.UmcContractOrgSubQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcContractOrgSubQryAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ContractItemChangeAddBusiServiceImpl
implements ContractItemChangeAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemChangeAddBusiServiceImpl.class);
    @Autowired
    ContractInfoChangeItemMapper contractInfoChangeItemMapper;
    @Autowired
    ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    UccMaterialInfoQueryAbilityService uccMaterialInfoQueryAbilityService;
    @Autowired
    PlanQueryByPlanIdsAbilityService planQueryByPlanIdsAbilityService;
    @Autowired
    UmcContractQueryBuyerInfoAbilityService umcContractQueryBuyerInfoAbilityService;
    @Autowired
    private UccThematerialsearchAbilityService uccThematerialsearchAbilityService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private CRelBuySaleContractMapper cRelBuySaleContractMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Value(value="${GENERAL_MATERIAL_CODE:000000}")
    private String generalMaterialCode;
    @Autowired
    private CContractOrderInfoMapper cContractOrderInfoMapper;
    @Autowired
    private UmcContractOrgSubQryAbilityService umcContractOrgSubQryAbilityService;
    @Autowired
    private ContractDictionaryBusiService contractDictionaryBusiService;

    @Override
    public ContractItemChangeAddBusiRspBO contractItemChangeAdd(ContractItemChangeAddBusiReqBO reqBO) {
        ContractItemChangeAddBusiRspBO rspBO = new ContractItemChangeAddBusiRspBO();
        rspBO.setAddFlag(true);
        ArrayList<ContractInfoItemTmpPO> contractInfoChangeItemPOS = new ArrayList<ContractInfoItemTmpPO>();
        List<ContractItemAbilityBO> contractItemAbilityBOList = reqBO.getContractItemBOList();
        List<Object> itemChangeIdS = new ArrayList();
        if (ContractConstant.ItemAddType.ADD.equals(reqBO.getType())) {
            if (reqBO.getContractItemChangeBO().getUpdateApplyId() == null) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5f53\u524d\u5165\u53c2\u5217\u8868\u4e3a\u7a7a");
                return rspBO;
            }
            if (reqBO.getContractItemChangeBO().getRelateId() == null && CollectionUtils.isEmpty(reqBO.getContractItemBOList())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5f53\u524d\u5165\u53c2\u5217\u8868\u4e3a\u7a7a");
                return rspBO;
            }
            if (CollectionUtils.isEmpty(reqBO.getContractItemBOList())) {
                List<ContractInfoItemPO> listByItemIDS = this.contractInfoItemMapper.getListByItemIDS(reqBO.getContractItemChangeBO().getRelateId());
                Iterator iterator = listByItemIDS.iterator();
                while (iterator.hasNext()) {
                    ContractInfoItemPO listByItemID = (ContractInfoItemPO)iterator.next();
                    ContractInfoItemTmpPO contractInfoItemTmpPO = this.getContractInfoItemTmpPO(listByItemID, reqBO.getContractItemChangeBO().getUpdateApplyId());
                    contractInfoChangeItemPOS.add(contractInfoItemTmpPO);
                }
            } else {
                for (ContractItemAbilityBO contractItemAbilityBO : contractItemAbilityBOList) {
                    ContractInfoItemTmpPO contractInfoItemTmpPO = new ContractInfoItemTmpPO();
                    BeanUtils.copyProperties((Object)contractItemAbilityBO, (Object)contractInfoItemTmpPO);
                    contractInfoItemTmpPO.setUuid(Sequence.getInstance().nextId());
                    contractInfoItemTmpPO.setItemChangeId(Sequence.getInstance().nextId());
                    contractInfoItemTmpPO.setItemId(Sequence.getInstance().nextId());
                    contractInfoItemTmpPO.setUpdateApplyId(reqBO.getContractItemChangeBO().getUpdateApplyId());
                    contractInfoItemTmpPO.setDelFlag("0");
                    contractInfoChangeItemPOS.add(contractInfoItemTmpPO);
                }
                this.getBuyerAndUserCompanyName(contractInfoChangeItemPOS);
                this.getCatelogInfo(contractInfoChangeItemPOS);
            }
        } else if (ContractConstant.ItemAddType.IMPORT.equals(reqBO.getType())) {
            itemChangeIdS = this.importExcelV2(reqBO);
        } else if (ContractConstant.ItemAddType.FZ.equals(reqBO.getType())) {
            ArrayList<ContractInfoChangeItemPO> contractInfoChangeItemPOList = new ArrayList<ContractInfoChangeItemPO>();
            HashMap<String, ContractInfoItemTmpPO> contractItemAbilityBOHashMap = new HashMap<String, ContractInfoItemTmpPO>();
            for (ContractItemAbilityBO x : contractItemAbilityBOList) {
                if (StringUtils.isEmpty((Object)x.getAwardNumId()) || contractItemAbilityBOHashMap.containsKey(x.getAwardNumId())) continue;
                ContractInfoItemTmpPO contractInfoItemTmpPO = this.getContractInfoItemTmpPO(x);
                contractInfoItemTmpPO.setUpdateApplyId(reqBO.getContractItemChangeBO().getUpdateApplyId());
                contractItemAbilityBOHashMap.put(x.getAwardNumId(), contractInfoItemTmpPO);
                contractInfoChangeItemPOS.add(contractInfoItemTmpPO);
                ContractInfoChangeItemPO contractInfoItemPO = new ContractInfoChangeItemPO();
                BeanUtils.copyProperties((Object)contractInfoItemTmpPO, (Object)contractInfoItemPO);
                contractInfoChangeItemPOList.add(contractInfoItemPO);
            }
            if (CollectionUtils.isEmpty(contractInfoChangeItemPOList)) {
                rspBO.setAddFlag(false);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6388\u6807\u660e\u7ec6\u8868id\u90fd\u4e3a\u7a7a");
                return rspBO;
            }
            this.getBuyerAndUserCompanyName(contractInfoChangeItemPOS);
            this.getCatelogInfo(contractInfoChangeItemPOS);
        } else {
            rspBO.setRespCode("1017");
            rspBO.setRespDesc("\u6ca1\u6709\u5f53\u524d\u7c7b\u578b");
            return rspBO;
        }
        if (!CollectionUtils.isEmpty(contractInfoChangeItemPOS)) {
            if (CollectionUtils.isEmpty(reqBO.getContractItemBOList()) && ContractConstant.ItemAddType.ADD.equals(reqBO.getType())) {
                ContractInfoItemTmpPO deletePO = new ContractInfoItemTmpPO();
                deletePO.setRelateId(reqBO.getContractItemChangeBO().getRelateId());
                this.contractInfoItemTmpMapper.deleteBy(deletePO);
            }
            itemChangeIdS = this.insertTmp(contractInfoChangeItemPOS, reqBO.getType());
        }
        rspBO.setItemChangeIdS(itemChangeIdS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u65b0\u589e\u53d8\u66f4\u6210\u529f");
        this.AddCContractOrderInfo(reqBO);
        return rspBO;
    }

    private void AddCContractOrderInfo(ContractItemChangeAddBusiReqBO reqBO) {
        List<CContractOrderInfoBO> cContractOrderInfoList = reqBO.getCContractOrderInfoList();
        if (cContractOrderInfoList != null && cContractOrderInfoList.size() > 0) {
            this.cContractOrderInfoMapper.insertOrderList(cContractOrderInfoList);
        }
    }

    public void getCatelogInfo(List<ContractInfoItemTmpPO> contractInfoItemTmpPOS) {
        if (!CollectionUtils.isEmpty(contractInfoItemTmpPOS)) {
            Set collect = contractInfoItemTmpPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getMaterialCode())).map(ContractInfoItemTmpPO::getMaterialCode).collect(Collectors.toSet());
            ArrayList materialCodes = new ArrayList();
            materialCodes.addAll(collect);
            if (!CollectionUtils.isEmpty(materialCodes)) {
                List rows;
                UccThematerialsearchAbilityReqBO uccThematerialsearchAbilityReqBO = new UccThematerialsearchAbilityReqBO();
                uccThematerialsearchAbilityReqBO.setMaterialCodes(materialCodes);
                uccThematerialsearchAbilityReqBO.setPageNo(1);
                uccThematerialsearchAbilityReqBO.setPageSize(materialCodes.size());
                UccThematerialsearchAbilityRspBO uccThematerialsearchAbilityRspBO = this.uccThematerialsearchAbilityService.dealUccThematerialsearch(uccThematerialsearchAbilityReqBO);
                if ("0000".equals(uccThematerialsearchAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)(rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccThematerialsearchAbilityRspBO.getRows()), UccEMdmMaterialBO.class)))) {
                    Map<String, List<UccEMdmMaterialBO>> materialCodeMap = rows.stream().collect(Collectors.groupingBy(UccEMdmMaterialBO::getMaterialCode));
                    contractInfoItemTmpPOS.forEach(e -> {
                        if (materialCodeMap.containsKey(e.getMaterialCode())) {
                            e.setCatalogId(((UccEMdmMaterialBO)((List)materialCodeMap.get(e.getMaterialCode())).get(0)).getCatalogId().toString());
                            e.setCatalogCode(((UccEMdmMaterialBO)((List)materialCodeMap.get(e.getMaterialCode())).get(0)).getCatalogCode());
                            e.setCatalogName(((UccEMdmMaterialBO)((List)materialCodeMap.get(e.getMaterialCode())).get(0)).getCatalogName());
                        }
                    });
                }
            }
        }
    }

    public void getBuyerAndUserCompanyName(List<ContractInfoItemTmpPO> contractInfoItemTmpPOS) {
        Set planItemIds;
        Set decCompanyCodes = contractInfoItemTmpPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getErpOrgCode())).map(ContractInfoItemTmpPO::getErpOrgCode).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(decCompanyCodes)) {
            UmcContractQueryBuyerInfoAbilityReqBO umcContractQueryBuyerInfoAbilityReqBO = new UmcContractQueryBuyerInfoAbilityReqBO();
            ArrayList organizationCodes = new ArrayList();
            organizationCodes.addAll(decCompanyCodes);
            umcContractQueryBuyerInfoAbilityReqBO.setOrganizationIds(organizationCodes);
            UmcContractQueryBuyerInfoAbilityRspBO umcContractQueryBuyerInfoAbilityRspBO = this.umcContractQueryBuyerInfoAbilityService.queryContractBuyerInfo(umcContractQueryBuyerInfoAbilityReqBO);
            if ("0000".equals(umcContractQueryBuyerInfoAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)umcContractQueryBuyerInfoAbilityRspBO.getRows())) {
                Map<String, List<UmcEntityOrgSubBO>> oIdMap = umcContractQueryBuyerInfoAbilityRspBO.getRows().stream().collect(Collectors.groupingBy(UmcEntityOrgSubBO::getOrganizationId));
                contractInfoItemTmpPOS.forEach(e -> {
                    if (!CollectionUtils.isEmpty((Collection)((Collection)oIdMap.get(e.getErpOrgCode())))) {
                        UmcEntityOrgSubBO umcEntityOrgSubBO = (UmcEntityOrgSubBO)((List)oIdMap.get(e.getErpOrgCode())).get(0);
                        e.setBuyerId(umcEntityOrgSubBO.getEntityId());
                        if (umcEntityOrgSubBO.getEntityId() != null) {
                            e.setBuyerNo(umcEntityOrgSubBO.getEntityId().toString());
                        }
                        e.setBuyerName(umcEntityOrgSubBO.getEntityName());
                    }
                });
            }
        }
        if (!CollectionUtils.isEmpty(planItemIds = contractInfoItemTmpPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getPlanItemId())).map(ContractInfoItemTmpPO::getPlanItemId).collect(Collectors.toSet()))) {
            List planIds = planItemIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
            PlanQueryByPlanIdsAbilityReqBO planQueryByPlanIdsAbilityReqBO = new PlanQueryByPlanIdsAbilityReqBO();
            planQueryByPlanIdsAbilityReqBO.setPlanIds(planIds);
            PlanQueryByPlanIdsAbilityRspBO planQueryByPlanIdsAbilityRspBO = this.planQueryByPlanIdsAbilityService.qry(planQueryByPlanIdsAbilityReqBO);
            if ("0000".equals(planQueryByPlanIdsAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)planQueryByPlanIdsAbilityRspBO.getRows())) {
                Map<String, CcePlanDiversionBO> planIdMap = planQueryByPlanIdsAbilityRspBO.getRows().stream().collect(Collectors.toMap(CcePlanDiversionBO::getPlanId, CcePlanDiversionBO2 -> CcePlanDiversionBO2));
                contractInfoItemTmpPOS.forEach(e -> {
                    if (planIdMap.containsKey(e.getPlanItemId())) {
                        e.setUserCompanyName(((CcePlanDiversionBO)planIdMap.get(e.getPlanItemId())).getUseDepartment());
                        e.setScheduleNo(((CcePlanDiversionBO)planIdMap.get(e.getPlanItemId())).getScheduleNo());
                    }
                });
            }
        }
    }

    private List<Long> importExcelV2(ContractItemChangeAddBusiReqBO reqBO) {
        ContractInfoPO contractInfoPO;
        Long l;
        Object contractInfoItemPOS;
        ArrayList<ContractInfoItemTmpPO> contractInfoItemTmpPOS = new ArrayList<ContractInfoItemTmpPO>();
        List<Long> rspItemList = new ArrayList<Long>();
        ArrayList<String> title = new ArrayList<String>();
        JSONObject data = new JSONObject();
        try {
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload(reqBO.getUrl(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            this.getExcelDateByImport((MultipartFile)multipartFile, data, title);
            HttpUtil.deleteFile("temporaryfile/" + file.getName());
        }
        catch (Exception e2) {
            throw new BusinessException("6018", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38: " + e2);
        }
        if (CollectionUtils.isEmpty(title)) {
            throw new BusinessException("6018", "\u6587\u4ef6\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Map)data)) {
            throw new BusinessException("6018", "\u6587\u4ef6\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<Object> contractItemAbilityBOList = this.getContractItemAbilityBOListFromExcel(data, reqBO.getModelType());
        if (!CollectionUtils.isEmpty(contractItemAbilityBOList) && reqBO.getModelType() != null && (reqBO.getModelType().equals(ContractConstant.ModelType.B_TAX_UNIT) || reqBO.getModelType().equals(ContractConstant.ModelType.B_UNIT_PRICE) || ContractConstant.ModelType.UNIT_B_TAX_UNIT.equals(reqBO.getModelType()) || ContractConstant.ModelType.UNIT_B_UNIT_PRICE.equals(reqBO.getModelType()))) {
            contractItemAbilityBOList = contractItemAbilityBOList.stream().filter(e -> !StringUtils.isEmpty((Object)e.getMaterialCode()) && !e.getMaterialCode().endsWith(this.generalMaterialCode)).collect(Collectors.toList());
        }
        log.debug("\u6839\u636e\u4e0d\u540c\u6a21\u677f\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6570\u636e\uff1a" + contractItemAbilityBOList.size());
        ArrayList<ContractItemAbilityBO> updateBos = new ArrayList<ContractItemAbilityBO>();
        ArrayList<ContractItemAbilityBO> insertBos = new ArrayList<ContractItemAbilityBO>();
        Boolean isCollectionUpdate = false;
        Integer contractType = null;
        if (((ContractItemAbilityBO)contractItemAbilityBOList.get(0)).getItemId() != null && !CollectionUtils.isEmpty((Collection)(contractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(Lists.newArrayList((Object[])new Long[]{((ContractItemAbilityBO)contractItemAbilityBOList.get(0)).getItemId()})))) && (l = ((ContractInfoItemPO)contractInfoItemPOS.get(0)).getRelateId()) != null && (contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(l)) != null) {
            contractType = contractInfoPO.getContractType();
        }
        for (ContractItemAbilityBO contractItemAbilityBO : contractItemAbilityBOList) {
            if (contractType != null) {
                if (ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(contractType) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractType) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractType) || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(contractType)) {
                    if (contractItemAbilityBO.getSaleStatus() != null && contractItemAbilityBO.getSaleStatus() == 2 && contractItemAbilityBO.getSaleAmount() == null) {
                        contractItemAbilityBO.setSaleAmount(contractItemAbilityBO.getAmount());
                    }
                } else if (contractItemAbilityBO.getSaleStatus() != null && contractItemAbilityBO.getSaleStatus() == 2) {
                    contractItemAbilityBO.setSaleStatus(Integer.valueOf(1));
                }
            }
            if (contractItemAbilityBO.getSaleStatus() != null && (contractItemAbilityBO.getSaleStatus() == 1 || contractItemAbilityBO.getSaleStatus() == 3)) {
                contractItemAbilityBO.setSaleAmount(null);
            }
            if (contractItemAbilityBO.getItemId() != null && contractItemAbilityBO.getItemChangeId() != null) {
                updateBos.add(contractItemAbilityBO);
                continue;
            }
            insertBos.add(contractItemAbilityBO);
        }
        if (!CollectionUtils.isEmpty(insertBos)) {
            this.getUccMaterialInfo(insertBos, reqBO.getModelType());
            insertBos.forEach(x -> {
                ContractInfoItemTmpPO contractInfoItemPO = this.getContractInfoItemTmpPO((ContractItemAbilityBO)x);
                contractInfoItemPO.setRelateId(reqBO.getContractItemChangeBO().getRelateId());
                contractInfoItemPO.setRelateCode(reqBO.getContractItemChangeBO().getRelateCode());
                contractInfoItemPO.setUpdateApplyId(reqBO.getContractItemChangeBO().getUpdateApplyId());
                ContractInfoItemTmpPO tax = this.getTax(contractInfoItemPO);
                contractInfoItemTmpPOS.add(tax);
            });
            rspItemList = this.insertTmp(contractInfoItemTmpPOS, reqBO.getType());
        }
        if (!CollectionUtils.isEmpty(updateBos)) {
            List<Long> importItemIds = updateBos.stream().filter(e -> e.getItemId() != null).map(ContractItemAbilityBO::getItemId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(importItemIds)) {
                throw new ZTBusinessException("\u5bfc\u5165\u7684\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getContractItemChangeBO() != null && reqBO.getContractItemChangeBO().getRelateId() != null && reqBO.getContractItemChangeBO().getUpdateApplyId() != null) {
                List<ContractOrderPo> contractOrderPos;
                ContractInfoPO contractInfoPO2 = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractItemChangeBO().getRelateId());
                if ((ContractConstant.ContractType.SALE_CONTRACT.equals(contractInfoPO2.getContractType()) || ContractConstant.ContractType.PURCHASE_CONTRACT.equals(contractInfoPO2.getContractType()) || ContractConstant.ContractType.DEVELOPMENT_CONTRACT.equals(contractInfoPO2.getContractType())) && !CollectionUtils.isEmpty(importItemIds) && !CollectionUtils.isEmpty(contractOrderPos = this.contractOrderMapper.selectListByItemIds(importItemIds))) {
                    Map<Long, List<ContractOrderPo>> itemIdMap = contractOrderPos.stream().collect(Collectors.groupingBy(ContractOrderPo::getItemId));
                    for (ContractItemAbilityBO itemAbilityBO : updateBos) {
                        if (CollectionUtils.isEmpty((Collection)itemIdMap.get(itemAbilityBO.getItemId()))) continue;
                        ContractOrderPo contractOrderPo = itemIdMap.get(itemAbilityBO.getItemId()).get(0);
                        if (itemAbilityBO.getAmount().compareTo(contractOrderPo.getSumDoOrderNum()) >= 0) continue;
                        throw new ZTBusinessException("\u660e\u7ec6id\uff1a" + itemAbilityBO.getItemId() + "\u7684\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u4e0b\u5355\u6570\u91cf\uff1a" + contractOrderPo.getSumDoOrderNum());
                    }
                }
                if (ContractConstant.ContractType.SALE_CONTRACT.equals(contractInfoPO2.getContractType())) {
                    List<Long> relateItemIds;
                    List<ContractInfoItemPO> purchaseContractInfoItemPOS;
                    ContractInfoItemTmpPO po = new ContractInfoItemTmpPO();
                    List<Long> itemChangeIdS = updateBos.stream().filter(e -> e.getItemChangeId() != null).map(ContractItemAbilityBO::getItemChangeId).collect(Collectors.toList());
                    po.setUpdateApplyId(reqBO.getContractItemChangeBO().getUpdateApplyId());
                    List<ContractInfoItemTmpPO> contractInfoItemTmpPOList = this.contractInfoItemTmpMapper.contractItemChangeQuery(po, itemChangeIdS);
                    List<ContractInfoChangeItemPO> itemsByRelId = this.contractInfoChangeItemMapper.selectItemByContractId(reqBO.getContractItemChangeBO().getRelateId());
                    if (!CollectionUtils.isEmpty(itemsByRelId)) {
                        List contractInfoItemTmpPOS1 = JSONObject.parseArray((String)JSONObject.toJSONString(itemsByRelId), ContractInfoItemTmpPO.class);
                        contractInfoItemTmpPOList.addAll(contractInfoItemTmpPOS1);
                    }
                    if (CollectionUtils.isEmpty(contractInfoItemTmpPOList)) {
                        return rspItemList;
                    }
                    Map<Long, List<ContractInfoItemTmpPO>> ItemTempIdMap = contractInfoItemTmpPOList.stream().collect(Collectors.groupingBy(ContractInfoItemTmpPO::getItemId));
                    List<Long> itemIds = contractInfoItemTmpPOList.stream().map(ContractInfoItemTmpPO::getItemId).collect(Collectors.toList());
                    ArrayList<ContractItemAbilityBO> updateContractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
                    Map<Object, Object> purchaseItemMap = new HashMap();
                    for (ContractItemAbilityBO e3 : updateBos) {
                        if (!itemIds.contains(e3.getItemId())) continue;
                        ContractItemAbilityUpdateVO syncVO = new ContractItemAbilityUpdateVO();
                        ContractInfoItemTmpPO contractInfoItemTmpPO = ItemTempIdMap.get(e3.getItemId()).get(0);
                        BeanUtils.copyProperties((Object)e3, (Object)syncVO);
                        BeanUtils.copyProperties((Object)contractInfoItemTmpPO, (Object)e3);
                        BeanUtils.copyProperties((Object)syncVO, (Object)e3);
                        updateContractItemAbilityBOList.add(e3);
                    }
                    if (CollectionUtils.isEmpty(updateContractItemAbilityBOList)) {
                        return rspItemList;
                    }
                    Map<Object, Object> buyItemIdMap = new HashMap();
                    Map<Object, Object> saleItemIdMap = new HashMap();
                    List<CRelBuySaleContractPO> bySaleContractItemIds = this.cRelBuySaleContractMapper.getListBySaleContractItemIds(itemIds);
                    if (!CollectionUtils.isEmpty(bySaleContractItemIds)) {
                        List<Long> buyItemIds = bySaleContractItemIds.stream().map(CRelBuySaleContractPO::getBuyItemId).collect(Collectors.toList());
                        purchaseContractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(buyItemIds);
                        if (!CollectionUtils.isEmpty(purchaseContractInfoItemPOS)) {
                            buyItemIdMap = purchaseContractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getItemId));
                        }
                        saleItemIdMap = bySaleContractItemIds.stream().collect(Collectors.groupingBy(CRelBuySaleContractPO::getSaleItemId));
                    }
                    if (!CollectionUtils.isEmpty(relateItemIds = updateContractItemAbilityBOList.stream().filter(e -> e.getRelateItemId() != null).map(ContractItemAbilityBO::getRelateItemId).collect(Collectors.toList())) && !CollectionUtils.isEmpty(purchaseContractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(relateItemIds))) {
                        purchaseItemMap = purchaseContractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getItemId));
                    }
                    for (ContractItemAbilityBO e4 : updateContractItemAbilityBOList) {
                        if (e4.getAddRate() == null) {
                            e4.setAddRate(Integer.valueOf(0));
                        }
                        BigDecimal tax = new BigDecimal(String.valueOf(1.0f + (float)e4.getRate().intValue() / 100.0f));
                        BigDecimal addRate = new BigDecimal(String.valueOf(1.0f + (float)e4.getAddRate().intValue() / 100.0f));
                        if (e4.getRelateItemId() != null && purchaseItemMap.containsKey(e4.getRelateItemId())) {
                            ContractInfoItemPO purchaseItemPO = (ContractInfoItemPO)((List)purchaseItemMap.get(e4.getRelateItemId())).get(0);
                            BigDecimal purchaseItemtaxUnitPrice = purchaseItemPO.getTaxUnitPrice().setScale(2, 4);
                            if (purchaseItemtaxUnitPrice == null) {
                                throw new ZTBusinessException("\u5bf9\u5e94\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                            }
                            if (e4.getAmount().compareTo(purchaseItemPO.getAmount()) > 0) {
                                throw new ZTBusinessException("\u6570\u91cf\uff08\u4e0d\u80fd\u8d85\u8fc7\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\uff09");
                            }
                            e4.setTaxUnitPrice(purchaseItemtaxUnitPrice.multiply(addRate).setScale(2, 4));
                            e4.setUnitPriceExcludingTax(e4.getTaxUnitPrice().divide(tax, 2, 4).multiply(new BigDecimal("1")).setScale(2, 4));
                            e4.setTaxAmount(e4.getTaxUnitPrice().multiply(new BigDecimal(e4.getAmount().toString())).setScale(2, 4));
                            e4.setNotIncludingTaxAmount(e4.getUnitPriceExcludingTax().multiply(new BigDecimal(e4.getAmount().toString())).setScale(2, 4));
                            e4.setTax(e4.getTaxAmount().subtract(e4.getNotIncludingTaxAmount()).setScale(2, 4));
                            continue;
                        }
                        if (saleItemIdMap.containsKey(e4.getItemId())) {
                            CRelBuySaleContractPO cRelBuySaleContractPO = (CRelBuySaleContractPO)((List)saleItemIdMap.get(e4.getItemId())).get(0);
                            if (buyItemIdMap.containsKey(cRelBuySaleContractPO.getBuyItemId())) {
                                ContractInfoItemPO purchaseItemPO = (ContractInfoItemPO)((List)buyItemIdMap.get(cRelBuySaleContractPO.getBuyItemId())).get(0);
                                BigDecimal purchaseItemtaxUnitPrice = purchaseItemPO.getTaxUnitPrice().setScale(2, 4);
                                if (purchaseItemtaxUnitPrice == null) {
                                    throw new ZTBusinessException("\u5bf9\u5e94\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u7684\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                                }
                                if (e4.getAmount().compareTo(purchaseItemPO.getAmount()) > 0) {
                                    throw new ZTBusinessException("\u6570\u91cf\uff08\u4e0d\u80fd\u8d85\u8fc7\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\uff09");
                                }
                                e4.setTaxUnitPrice(purchaseItemtaxUnitPrice.multiply(addRate).setScale(2, 4));
                                e4.setUnitPriceExcludingTax(e4.getTaxUnitPrice().divide(tax, 2, 4).multiply(new BigDecimal("1")).setScale(2, 4));
                                e4.setTaxAmount(e4.getTaxUnitPrice().multiply(new BigDecimal(e4.getAmount().toString())).setScale(2, 4));
                                e4.setNotIncludingTaxAmount(e4.getUnitPriceExcludingTax().multiply(new BigDecimal(e4.getAmount().toString())).setScale(2, 4));
                                e4.setTax(e4.getTaxAmount().subtract(e4.getNotIncludingTaxAmount()).setScale(2, 4));
                                continue;
                            }
                            throw new ZTBusinessException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u6570\u636e");
                        }
                        throw new ZTBusinessException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u5408\u540c\u660e\u7ec6\u6570\u636e");
                    }
                    updateBos = updateContractItemAbilityBOList;
                }
            }
            for (ContractItemAbilityBO x2 : updateBos) {
                ContractInfoItemTmpPO contractInfoItemPO = this.getContractInfoItemTmpPO(x2);
                contractInfoItemPO.setRelateId(reqBO.getContractItemChangeBO().getRelateId());
                contractInfoItemPO.setRelateCode(reqBO.getContractItemChangeBO().getRelateCode());
                contractInfoItemPO.setUpdateApplyId(reqBO.getContractItemChangeBO().getUpdateApplyId());
                contractInfoItemPO.setItemChangeId(x2.getItemChangeId());
                ContractInfoItemTmpPO tax = null;
                tax = !ContractConstant.ModelType.SALE_CONTRACT_ITEM.equals(reqBO.getModelType()) && !ContractConstant.ModelType.UNIT_NEIMAO_UNIT_PRICE.equals(reqBO.getModelType()) ? this.getTax(contractInfoItemPO) : contractInfoItemPO;
                this.contractInfoItemTmpMapper.updateByPO(tax);
                rspItemList.add(tax.getItemChangeId());
            }
        }
        return rspItemList;
    }

    private void getUccMaterialInfo(List<ContractItemAbilityBO> contractItemAbilityBOList, Integer modelType) {
        if (modelType == null) {
            log.info("modelType\u4e3a\u7a7a");
            return;
        }
        ArrayList materialCodes = new ArrayList();
        contractItemAbilityBOList.stream().filter(e -> !StringUtils.isEmpty((Object)e.getMaterialCode())).forEach(x -> materialCodes.add(x.getMaterialCode()));
        UccMaterialInfoQueryAbilityReqBo reqBo = new UccMaterialInfoQueryAbilityReqBo();
        reqBo.setMaterialCodes(materialCodes);
        reqBo.setQueryErpFlag(true);
        reqBo.setPageNo(1);
        reqBo.setIsprofess("0");
        reqBo.setPageSize(contractItemAbilityBOList.size());
        log.debug("\u67e5\u8be2\u7269\u6599\u4fe1\u606f\u5165\u53c2\uff1a" + reqBo);
        if (CollectionUtils.isEmpty(materialCodes)) {
            log.info("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            return;
        }
        UccMaterialInfoQueryAbilityRspBo uccMaterialInfo = this.uccMaterialInfoQueryAbilityService.getUccMaterialInfo(reqBo);
        log.debug("uccMaterialInfo\u4e3a\uff1a" + uccMaterialInfo);
        List rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)uccMaterialInfo.getRows()), UccMaterialInfoQueryAbilityBo.class);
        for (ContractItemAbilityBO contractItemAbilityBO : contractItemAbilityBOList) {
            for (UccMaterialInfoQueryAbilityBo row : rows) {
                if (!contractItemAbilityBO.getMaterialCode().equals(row.getMaterialCode())) continue;
                contractItemAbilityBO.setUnitName(row.getUnit());
                contractItemAbilityBO.setMaterialDesc(row.getMaterialDesc());
                contractItemAbilityBO.setMaterialLongName(row.getMaterialDesc());
                contractItemAbilityBO.setMaterialName(row.getMaterialName());
                contractItemAbilityBO.setMaterialId(Long.valueOf(Long.parseLong(row.getMaterialId())));
                if (row.getCatalogId() != null) {
                    contractItemAbilityBO.setCatalogId(row.getCatalogId().toString());
                }
                contractItemAbilityBO.setCatalogCode(row.getCatalogCode());
                contractItemAbilityBO.setCatalogName(row.getCatalogName());
            }
        }
    }

    private ContractInfoItemTmpPO getTax(ContractInfoItemTmpPO contractInfoItemTmpPO) {
        if (null != contractInfoItemTmpPO.getTaxUnitPrice()) {
            BigDecimal taxUnitPrice = contractInfoItemTmpPO.getTaxUnitPrice();
            if (null == contractInfoItemTmpPO.getAmount()) {
                contractInfoItemTmpPO.setAmount(BigDecimal.ZERO);
            }
            Integer rate = contractInfoItemTmpPO.getRate();
            BigDecimal bigDecimal = new BigDecimal(100 + rate).divide(BigDecimal.valueOf(100L), 10, 4);
            BigDecimal unitPriceExcludingTax = taxUnitPrice.divide(bigDecimal, 10, 4);
            BigDecimal notIncludingTaxAmount = unitPriceExcludingTax.multiply(contractInfoItemTmpPO.getAmount()).setScale(2, 4).stripTrailingZeros();
            BigDecimal taxAmount = taxUnitPrice.multiply(contractInfoItemTmpPO.getAmount()).setScale(2, 4).stripTrailingZeros();
            BigDecimal tax = taxAmount.subtract(notIncludingTaxAmount);
            contractInfoItemTmpPO.setTax(tax);
            contractInfoItemTmpPO.setTaxAmount(taxAmount);
            contractInfoItemTmpPO.setNotIncludingTaxAmount(notIncludingTaxAmount);
            contractInfoItemTmpPO.setUnitPriceExcludingTax(unitPriceExcludingTax);
        } else if (null != contractInfoItemTmpPO.getUnitPriceExcludingTax()) {
            BigDecimal unitPriceExcludingTax = contractInfoItemTmpPO.getUnitPriceExcludingTax();
            if (null == contractInfoItemTmpPO.getAmount()) {
                contractInfoItemTmpPO.setAmount(BigDecimal.ZERO);
            }
            Integer rate = contractInfoItemTmpPO.getRate();
            BigDecimal bigDecimal = new BigDecimal(100 + rate).divide(BigDecimal.valueOf(100L), 10, 4);
            BigDecimal taxUnitPrice = unitPriceExcludingTax.multiply(bigDecimal);
            BigDecimal taxAmount = taxUnitPrice.multiply(contractInfoItemTmpPO.getAmount()).setScale(2, 4).stripTrailingZeros();
            BigDecimal notIncludingTaxAmount = unitPriceExcludingTax.multiply(contractInfoItemTmpPO.getAmount()).setScale(2, 4).stripTrailingZeros();
            BigDecimal tax = taxAmount.subtract(notIncludingTaxAmount);
            contractInfoItemTmpPO.setTax(tax);
            contractInfoItemTmpPO.setNotIncludingTaxAmount(notIncludingTaxAmount);
            contractInfoItemTmpPO.setTaxAmount(taxAmount);
            contractInfoItemTmpPO.setTaxUnitPrice(taxUnitPrice);
        } else {
            log.info("\u542b\u7a0e\u5355\u4ef7\u3001\u4e0d\u542b\u7a0e\u5355\u4ef7\u90fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8ba1\u7b97\u91d1\u989d");
        }
        return contractInfoItemTmpPO;
    }

    List<ContractItemAbilityBO> getContractItemAbilityBOListFromExcel(JSONObject excel, Integer type) {
        List<ContractItemAbilityBO> contractItemAbilityBOListFromBTaxUnit = new ArrayList<ContractItemAbilityBO>();
        if (null == type) {
            log.info("\u5bfc\u5165\u6a21\u677f\u7c7b\u578b\u7c7b\u578b\u4e3a\u7a7a");
            return contractItemAbilityBOListFromBTaxUnit;
        }
        if (ContractConstant.ModelType.B_TAX_UNIT.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromBTaxUnit(excel);
        } else if (ContractConstant.ModelType.B_UNIT_PRICE.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromBTaxUnitPrice(excel);
        } else if (ContractConstant.ModelType.Tend_TAX_UNIT.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromATaxUnit(excel);
        } else if (ContractConstant.ModelType.Tend_UNIT_PRICE.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromATaxUnitPrice(excel);
        } else if (ContractConstant.ModelType.AWAD_TAX_UNIT.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromATaxUnit(excel);
        } else if (ContractConstant.ModelType.AWAD_UNIT_PRICE.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getContractItemAbilityBOListFromATaxUnitPrice(excel);
        } else if (ContractConstant.ModelType.SALE_CONTRACT_ITEM.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getSaleContractItemAbilityBOListFromExport(excel);
            if (CollectionUtils.isEmpty(contractItemAbilityBOListFromBTaxUnit)) {
                Set itemIdSets = contractItemAbilityBOListFromBTaxUnit.stream().filter(e -> e.getItemId() != null).map(ContractItemAbilityBO::getItemId).collect(Collectors.toSet());
                if (contractItemAbilityBOListFromBTaxUnit.size() != itemIdSets.size()) {
                    throw new ZTBusinessException("\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        } else if (ContractConstant.ModelType.UNIT_B_TAX_UNIT.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getUnitContractItemAbilityBOListFromBTaxUnit(excel);
        } else if (ContractConstant.ModelType.UNIT_B_UNIT_PRICE.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getUnitContractItemAbilityBOListFromBTaxUnitPrice(excel);
        } else if (ContractConstant.ModelType.UNIT_Tend_TAX_UNIT.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getUnitContractItemAbilityBOListFromATaxUnit(excel);
        } else if (ContractConstant.ModelType.UNIT_Tend_UNIT_PRICE.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getUnitContractItemAbilityBOListFromATaxUnitPrice(excel);
        } else if (ContractConstant.ModelType.UNIT_AWAD_TAX_UNIT.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getUnitContractItemAbilityBOListFromATaxUnit(excel);
        } else if (ContractConstant.ModelType.UNIT_AWAD_UNIT_PRICE.equals(type)) {
            contractItemAbilityBOListFromBTaxUnit = this.getUnitContractItemAbilityBOListFromATaxUnitPrice(excel);
        } else {
            log.info("\u5bfc\u5165\u6a21\u677f\u7c7b\u578b\u4e0d\u5339\u914d");
        }
        return contractItemAbilityBOListFromBTaxUnit;
    }

    private List<ContractItemAbilityBO> getSaleContractItemAbilityBOListFromExport(JSONObject excel) {
        List<SysDicDictionaryPO> contractAddRateList;
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        ArrayList<ContractItemAbilityBO> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        Iterator iterator = excelJSON.iterator();
        List<Object> contractTaxRates = new ArrayList();
        List<Object> contractAddRates = new ArrayList();
        List<SysDicDictionaryPO> contractTaxRateList = this.sysDicDictionaryMapper.selectByPCode("CONTRACT_TAX_RATE");
        if (!CollectionUtils.isEmpty(contractTaxRateList)) {
            contractTaxRates = contractTaxRateList.stream().map(e -> Integer.valueOf(e.getCode())).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(contractAddRateList = this.sysDicDictionaryMapper.selectByPCode("CONTRACT_ADD_RATE"))) {
            contractAddRates = contractAddRateList.stream().map(e -> Integer.valueOf(e.getCode())).collect(Collectors.toList());
        }
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setAmount(next.getBigDecimal("\u6570\u91cf") == null ? next.getBigDecimal("*\u6570\u91cf") : next.getBigDecimal("\u6570\u91cf"));
            if (contractItemAbilityBO.getAmount() == null) {
                throw new ZTBusinessException("\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (contractItemAbilityBO.getAmount().compareTo(BigDecimal.ZERO) < 0) {
                throw new ZTBusinessException("\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setPriceCategories(ContractTransFieldUtil.transPriceCategories(next.getString("\u6bd4\u4ef7\u7c7b\u522b")));
            if (!StringUtils.isEmpty((Object)next.getString("\u52a0\u4ef7\u6bd4\u7387(%)"))) {
                try {
                    String addRateStr = next.getString("\u52a0\u4ef7\u6bd4\u7387(%)");
                    addRateStr = addRateStr.replaceAll("%", "");
                    contractItemAbilityBO.setAddRate(Integer.valueOf(addRateStr));
                }
                catch (Exception e2) {
                    throw new ZTBusinessException("\u8f6c\u6362\u52a0\u4ef7\u6bd4\u7387\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            if (contractItemAbilityBO.getAddRate() != null && contractItemAbilityBO.getAddRate() < 0) {
                throw new ZTBusinessException("\u52a0\u4ef7\u6bd4\u7387\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            if (!CollectionUtils.isEmpty(contractAddRates) && !contractAddRates.contains(contractItemAbilityBO.getAddRate())) {
                throw new ZTBusinessException("\u52a0\u4ef7\u6bd4\u7387\u4e0d\u662f\u6240\u8bbe\u7f6e\u7684\u679a\u4e3e\u503c\uff0c\u662f\u9519\u8bef\u7684\u53c2\u6570\u503c");
            }
            contractItemAbilityBO.setSupplyCycle(next.getInteger("*\u4f9b\u8d27\u5468\u671f(\u5929)"));
            contractItemAbilityBO.setGuaranteePeriod(next.getInteger("*\u8d28\u4fdd\u671f(\u5929)"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBO.setMetalContent(next.getBigDecimal("*\u91d1\u5c5e\u542b\u91cf"));
            contractItemAbilityBO.setBidderAmount(next.getBigDecimal("\u4e2d\u6807\u5355\u4ef7"));
            contractItemAbilityBO.setItemId(next.getLong("*\u660e\u7ec6id"));
            contractItemAbilityBO.setItemChangeId(next.getLong("*\u660e\u7ec6\u53d8\u66f4id"));
            contractItemAbilityBO.setSaleStatus(ContractTransFieldUtil.transSaleStatusStr(next.getString("\u72b6\u6001")));
            contractItemAbilityBO.setSaleAmount(next.getBigDecimal("\u53ef\u4e0b\u5355\u6570\u91cf"));
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getContractItemAbilityBOListFromBTaxUnit(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        List<Object> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        ArrayList<String> erpOrgCodeList = new ArrayList<String>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("*\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("\u6570\u91cf") == null ? next.getBigDecimal("*\u6570\u91cf") : next.getBigDecimal("\u6570\u91cf"));
            contractItemAbilityBO.setTaxUnitPrice(next.getBigDecimal("*\u542b\u7a0e\u5355\u4ef7"));
            if (!StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387")) || !StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387(%)"))) {
                try {
                    String rateStr = next.getString("*\u7a0e\u7387");
                    if (StringUtils.isEmpty((Object)rateStr)) {
                        rateStr = next.getString("*\u7a0e\u7387(%)");
                    }
                    rateStr = rateStr.replaceAll("%", "");
                    contractItemAbilityBO.setRate(Integer.valueOf(rateStr));
                }
                catch (Exception e2) {
                    throw new ZTBusinessException("\u8f6c\u6362\u7a0e\u7387\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            if (contractItemAbilityBO.getRate() == null || contractItemAbilityBO.getRate() < 0) {
                throw new ZTBusinessException("\u7a0e\u7387\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            contractItemAbilityBO.setSupplyCycle(next.getInteger("*\u4f9b\u8d27\u5468\u671f(\u5929)"));
            contractItemAbilityBO.setGuaranteePeriod(next.getInteger("*\u8d28\u4fdd\u671f(\u5929)"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("*\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setErpOrgCode(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            if (!StringUtils.isEmpty((Object)next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"))) {
                erpOrgCodeList.add(contractItemAbilityBO.getErpOrgCode());
            }
            contractItemAbilityBO.setComponentID(next.getString("\u90e8\u4ef6\u53f7"));
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBO.setMetalContent(next.getBigDecimal("*\u91d1\u5c5e\u542b\u91cf"));
            contractItemAbilityBO.setBidderAmount(next.getBigDecimal("\u4e2d\u6807\u5355\u4ef7"));
            contractItemAbilityBO.setItemId(next.getLong("*\u660e\u7ec6id"));
            contractItemAbilityBO.setItemChangeId(next.getLong("*\u660e\u7ec6\u53d8\u66f4id"));
            contractItemAbilityBO.setSaleStatus(ContractTransFieldUtil.transSaleStatusStr(next.getString("\u72b6\u6001")));
            contractItemAbilityBO.setSaleAmount(next.getBigDecimal("\u53ef\u4e0b\u5355\u6570\u91cf"));
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        if (!CollectionUtils.isEmpty(erpOrgCodeList)) {
            List<UmcContractOrgSubQryAbilityBO> organization = this.getInventoryOrganization(erpOrgCodeList);
            Map<String, String> organizations = organization.stream().collect(Collectors.toMap(UmcContractOrgSubQryAbilityBO::getSubOrganizationId, UmcContractOrgSubQryAbilityBO::getSubOrganizationName));
            contractItemAbilityBOList = contractItemAbilityBOList.stream().map(e -> {
                e.setInventoryOrganization((String)organizations.get(e.getErpOrgCode()));
                return e;
            }).collect(Collectors.toList());
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getContractItemAbilityBOListFromBTaxUnitPrice(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        List<Object> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        ArrayList<String> erpOrgCodeList = new ArrayList<String>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("*\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("\u6570\u91cf") == null ? next.getBigDecimal("*\u6570\u91cf") : next.getBigDecimal("\u6570\u91cf"));
            contractItemAbilityBO.setUnitPriceExcludingTax(next.getBigDecimal("*\u4e0d\u542b\u7a0e\u5355\u4ef7"));
            if (!StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387")) || !StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387(%)"))) {
                try {
                    String rateStr = next.getString("*\u7a0e\u7387");
                    if (StringUtils.isEmpty((Object)rateStr)) {
                        rateStr = next.getString("*\u7a0e\u7387(%)");
                    }
                    rateStr = rateStr.replaceAll("%", "");
                    contractItemAbilityBO.setRate(Integer.valueOf(rateStr));
                }
                catch (Exception e2) {
                    throw new ZTBusinessException("\u8f6c\u6362\u7a0e\u7387\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            if (contractItemAbilityBO.getRate() == null || contractItemAbilityBO.getRate() < 0) {
                throw new ZTBusinessException("\u7a0e\u7387\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            contractItemAbilityBO.setSupplyCycle(next.getInteger("*\u4f9b\u8d27\u5468\u671f(\u5929)"));
            contractItemAbilityBO.setGuaranteePeriod(next.getInteger("*\u8d28\u4fdd\u671f(\u5929)"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("*\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setErpOrgCode(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            if (!StringUtils.isEmpty((Object)next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"))) {
                erpOrgCodeList.add(contractItemAbilityBO.getErpOrgCode());
            }
            contractItemAbilityBO.setComponentID(next.getString("\u90e8\u4ef6\u53f7"));
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBO.setMetalContent(next.getBigDecimal("*\u91d1\u5c5e\u542b\u91cf"));
            contractItemAbilityBO.setBidderAmount(next.getBigDecimal("\u4e2d\u6807\u5355\u4ef7"));
            contractItemAbilityBO.setItemId(next.getLong("*\u660e\u7ec6id"));
            contractItemAbilityBO.setItemChangeId(next.getLong("*\u660e\u7ec6\u53d8\u66f4id"));
            contractItemAbilityBO.setSaleStatus(ContractTransFieldUtil.transSaleStatusStr(next.getString("\u72b6\u6001")));
            contractItemAbilityBO.setSaleAmount(next.getBigDecimal("\u53ef\u4e0b\u5355\u6570\u91cf"));
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        if (!CollectionUtils.isEmpty(erpOrgCodeList)) {
            List<UmcContractOrgSubQryAbilityBO> organization = this.getInventoryOrganization(erpOrgCodeList);
            Map<String, String> organizations = organization.stream().collect(Collectors.toMap(UmcContractOrgSubQryAbilityBO::getSubOrganizationId, UmcContractOrgSubQryAbilityBO::getSubOrganizationName));
            contractItemAbilityBOList = contractItemAbilityBOList.stream().map(e -> {
                e.setInventoryOrganization((String)organizations.get(e.getErpOrgCode()));
                return e;
            }).collect(Collectors.toList());
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getContractItemAbilityBOListFromATaxUnitPrice(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        List<Object> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        ArrayList<String> erpOrgCodeList = new ArrayList<String>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("*\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("*\u6570\u91cf") == null ? next.getBigDecimal("\u6570\u91cf") : next.getBigDecimal("*\u6570\u91cf"));
            contractItemAbilityBO.setUnitPriceExcludingTax(next.getBigDecimal("*\u4e0d\u542b\u7a0e\u5355\u4ef7"));
            if (!StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387")) || !StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387(%)"))) {
                try {
                    String rateStr = next.getString("*\u7a0e\u7387");
                    if (StringUtils.isEmpty((Object)rateStr)) {
                        rateStr = next.getString("*\u7a0e\u7387(%)");
                    }
                    rateStr = rateStr.replaceAll("%", "");
                    contractItemAbilityBO.setRate(Integer.valueOf(rateStr));
                }
                catch (Exception e2) {
                    throw new ZTBusinessException("\u8f6c\u6362\u7a0e\u7387\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            if (contractItemAbilityBO.getRate() == null || contractItemAbilityBO.getRate() < 0) {
                throw new ZTBusinessException("\u7a0e\u7387\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setPriceCategories(ContractTransFieldUtil.transPriceCategories(next.getString("\u6bd4\u4ef7\u7c7b\u522b")));
            if (!StringUtils.isEmpty((Object)next.getString("\u5bf9\u6bd4\u5355\u4ef7"))) {
                try {
                    contractItemAbilityBO.setUnitPrice(new BigDecimal(next.getString("\u5bf9\u6bd4\u5355\u4ef7")));
                }
                catch (Exception e3) {
                    throw new ZTBusinessException("\u8f6c\u6362\u5bf9\u6bd4\u5355\u4ef7\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            contractItemAbilityBO.setSupplyCycle(next.getInteger("*\u4f9b\u8d27\u5468\u671f(\u5929)"));
            contractItemAbilityBO.setGuaranteePeriod(next.getInteger("*\u8d28\u4fdd\u671f(\u5929)"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("*\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setErpOrgCode(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            if (!StringUtils.isEmpty((Object)next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"))) {
                erpOrgCodeList.add(contractItemAbilityBO.getErpOrgCode());
            }
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBO.setMetalContent(next.getBigDecimal("*\u91d1\u5c5e\u542b\u91cf"));
            contractItemAbilityBO.setBidderAmount(next.getBigDecimal("\u4e2d\u6807\u5355\u4ef7"));
            contractItemAbilityBO.setItemId(next.getLong("*\u660e\u7ec6id"));
            contractItemAbilityBO.setItemChangeId(next.getLong("*\u660e\u7ec6\u53d8\u66f4id"));
            contractItemAbilityBO.setSaleStatus(ContractTransFieldUtil.transSaleStatusStr(next.getString("\u72b6\u6001")));
            contractItemAbilityBO.setSaleAmount(next.getBigDecimal("\u53ef\u4e0b\u5355\u6570\u91cf"));
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        if (!CollectionUtils.isEmpty(erpOrgCodeList)) {
            List<UmcContractOrgSubQryAbilityBO> organization = this.getInventoryOrganization(erpOrgCodeList);
            Map<String, String> organizations = organization.stream().collect(Collectors.toMap(UmcContractOrgSubQryAbilityBO::getSubOrganizationId, UmcContractOrgSubQryAbilityBO::getSubOrganizationName));
            contractItemAbilityBOList = contractItemAbilityBOList.stream().map(e -> {
                e.setInventoryOrganization((String)organizations.get(e.getErpOrgCode()));
                return e;
            }).collect(Collectors.toList());
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getContractItemAbilityBOListFromATaxUnit(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        List<Object> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        ArrayList<String> erpOrgCodeList = new ArrayList<String>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("*\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("\u6570\u91cf") == null ? next.getBigDecimal("*\u6570\u91cf") : next.getBigDecimal("\u6570\u91cf"));
            contractItemAbilityBO.setTaxUnitPrice(next.getBigDecimal("*\u542b\u7a0e\u5355\u4ef7"));
            if (!StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387")) || !StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387(%)"))) {
                try {
                    String rateStr = next.getString("*\u7a0e\u7387");
                    if (StringUtils.isEmpty((Object)rateStr)) {
                        rateStr = next.getString("*\u7a0e\u7387(%)");
                    }
                    rateStr = rateStr.replaceAll("%", "");
                    contractItemAbilityBO.setRate(Integer.valueOf(rateStr));
                }
                catch (Exception e2) {
                    throw new ZTBusinessException("\u8f6c\u6362\u7a0e\u7387\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            if (contractItemAbilityBO.getRate() == null || contractItemAbilityBO.getRate() < 0) {
                throw new ZTBusinessException("\u7a0e\u7387\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setPriceCategories(ContractTransFieldUtil.transPriceCategories(next.getString("\u6bd4\u4ef7\u7c7b\u522b")));
            if (!StringUtils.isEmpty((Object)next.getString("\u5bf9\u6bd4\u5355\u4ef7"))) {
                try {
                    contractItemAbilityBO.setUnitPrice(new BigDecimal(next.getString("\u5bf9\u6bd4\u5355\u4ef7")));
                }
                catch (Exception e3) {
                    throw new ZTBusinessException("\u8f6c\u6362\u5bf9\u6bd4\u5355\u4ef7\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            contractItemAbilityBO.setSupplyCycle(next.getInteger("*\u4f9b\u8d27\u5468\u671f(\u5929)"));
            contractItemAbilityBO.setGuaranteePeriod(next.getInteger("*\u8d28\u4fdd\u671f(\u5929)"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("*\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setErpOrgCode(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            if (!StringUtils.isEmpty((Object)next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"))) {
                erpOrgCodeList.add(contractItemAbilityBO.getErpOrgCode());
            }
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBO.setMetalContent(next.getBigDecimal("*\u91d1\u5c5e\u542b\u91cf"));
            contractItemAbilityBO.setBidderAmount(next.getBigDecimal("\u4e2d\u6807\u5355\u4ef7"));
            contractItemAbilityBO.setItemId(next.getLong("*\u660e\u7ec6id"));
            contractItemAbilityBO.setItemChangeId(next.getLong("*\u660e\u7ec6\u53d8\u66f4id"));
            contractItemAbilityBO.setSaleStatus(ContractTransFieldUtil.transSaleStatusStr(next.getString("\u72b6\u6001")));
            contractItemAbilityBO.setSaleAmount(next.getBigDecimal("\u53ef\u4e0b\u5355\u6570\u91cf"));
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        if (!CollectionUtils.isEmpty(erpOrgCodeList)) {
            List<UmcContractOrgSubQryAbilityBO> organization = this.getInventoryOrganization(erpOrgCodeList);
            Map<String, String> organizations = organization.stream().collect(Collectors.toMap(UmcContractOrgSubQryAbilityBO::getSubOrganizationId, UmcContractOrgSubQryAbilityBO::getSubOrganizationName));
            contractItemAbilityBOList = contractItemAbilityBOList.stream().map(e -> {
                e.setInventoryOrganization((String)organizations.get(e.getErpOrgCode()));
                return e;
            }).collect(Collectors.toList());
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getUnitContractItemAbilityBOListFromBTaxUnit(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        List<Object> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        ArrayList<String> erpOrgCodeList = new ArrayList<String>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("*\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("*\u6570\u91cf") == null ? next.getBigDecimal("\u6570\u91cf") : next.getBigDecimal("*\u6570\u91cf"));
            contractItemAbilityBO.setTaxUnitPrice(next.getBigDecimal("*\u542b\u7a0e\u5355\u4ef7"));
            if (!StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387")) || !StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387(%)"))) {
                try {
                    String rateStr = next.getString("*\u7a0e\u7387");
                    if (StringUtils.isEmpty((Object)rateStr)) {
                        rateStr = next.getString("*\u7a0e\u7387(%)");
                    }
                    rateStr = rateStr.replaceAll("%", "");
                    contractItemAbilityBO.setRate(Integer.valueOf(rateStr));
                }
                catch (Exception e2) {
                    throw new ZTBusinessException("\u8f6c\u6362\u7a0e\u7387\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            if (contractItemAbilityBO.getRate() == null || contractItemAbilityBO.getRate() < 0) {
                throw new ZTBusinessException("\u7a0e\u7387\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            contractItemAbilityBO.setSupplyCycle(next.getInteger("*\u4f9b\u8d27\u5468\u671f(\u5929)"));
            contractItemAbilityBO.setGuaranteePeriod(next.getInteger("*\u8d28\u4fdd\u671f(\u5929)"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setErpOrgCode(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            if (!StringUtils.isEmpty((Object)next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"))) {
                erpOrgCodeList.add(contractItemAbilityBO.getErpOrgCode());
            }
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setPriceCategories(ContractTransFieldUtil.transPriceCategories(next.getString("\u6bd4\u4ef7\u7c7b\u522b")));
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setComponentID(next.getString("\u90e8\u4ef6\u53f7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBO.setItemId(next.getLong("\u660e\u7ec6id"));
            contractItemAbilityBO.setItemChangeId(next.getLong("\u660e\u7ec6\u53d8\u66f4id"));
            contractItemAbilityBO.setDeliveryDateDesc(next.getString("\u4ea4\u8d27\u671f\u8bf4\u660e"));
            contractItemAbilityBO.setOrderDeliveryDate(next.getBigDecimal("\u8ba2\u5355\u751f\u6548\u540e\u4ea4\u671f\uff08\u5929\uff09"));
            contractItemAbilityBO.setSaleStatus(ContractTransFieldUtil.transSaleStatusStr(next.getString("\u72b6\u6001")));
            contractItemAbilityBO.setSaleAmount(next.getBigDecimal("\u53ef\u4e0b\u5355\u6570\u91cf"));
            this.validParam(contractItemAbilityBO);
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        if (!CollectionUtils.isEmpty(erpOrgCodeList)) {
            List<UmcContractOrgSubQryAbilityBO> organization = this.getInventoryOrganization(erpOrgCodeList);
            Map<String, String> organizations = organization.stream().collect(Collectors.toMap(UmcContractOrgSubQryAbilityBO::getSubOrganizationId, UmcContractOrgSubQryAbilityBO::getSubOrganizationName));
            contractItemAbilityBOList = contractItemAbilityBOList.stream().map(e -> {
                e.setInventoryOrganization((String)organizations.get(e.getErpOrgCode()));
                return e;
            }).collect(Collectors.toList());
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getUnitContractItemAbilityBOListFromBTaxUnitPrice(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        List<Object> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        ArrayList<String> erpOrgCodeList = new ArrayList<String>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("\u6570\u91cf") == null ? next.getBigDecimal("*\u6570\u91cf") : next.getBigDecimal("\u6570\u91cf"));
            contractItemAbilityBO.setUnitPriceExcludingTax(next.getBigDecimal("\u4e0d\u542b\u7a0e\u5355\u4ef7"));
            if (!StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387")) || !StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387(%)"))) {
                try {
                    String rateStr = next.getString("*\u7a0e\u7387");
                    if (StringUtils.isEmpty((Object)rateStr)) {
                        rateStr = next.getString("*\u7a0e\u7387(%)");
                    }
                    rateStr = rateStr.replaceAll("%", "");
                    contractItemAbilityBO.setRate(Integer.valueOf(rateStr));
                }
                catch (Exception e2) {
                    throw new ZTBusinessException("\u8f6c\u6362\u7a0e\u7387\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            if (contractItemAbilityBO.getRate() == null || contractItemAbilityBO.getRate() < 0) {
                throw new ZTBusinessException("\u7a0e\u7387\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            contractItemAbilityBO.setSupplyCycle(next.getInteger("*\u4f9b\u8d27\u5468\u671f(\u5929)"));
            contractItemAbilityBO.setGuaranteePeriod(next.getInteger("*\u8d28\u4fdd\u671f(\u5929)"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setErpOrgCode(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            if (!StringUtils.isEmpty((Object)next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"))) {
                erpOrgCodeList.add(contractItemAbilityBO.getErpOrgCode());
            }
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setPriceCategories(ContractTransFieldUtil.transPriceCategories(next.getString("\u6bd4\u4ef7\u7c7b\u522b")));
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBO.setComponentID(next.getString("\u90e8\u4ef6\u53f7"));
            contractItemAbilityBO.setItemId(next.getLong("\u660e\u7ec6id"));
            contractItemAbilityBO.setItemChangeId(next.getLong("\u660e\u7ec6\u53d8\u66f4id"));
            contractItemAbilityBO.setDeliveryDateDesc(next.getString("\u4ea4\u8d27\u671f\u8bf4\u660e"));
            contractItemAbilityBO.setOrderDeliveryDate(next.getBigDecimal("\u8ba2\u5355\u751f\u6548\u540e\u4ea4\u671f\uff08\u5929\uff09"));
            contractItemAbilityBO.setSaleStatus(ContractTransFieldUtil.transSaleStatusStr(next.getString("\u72b6\u6001")));
            contractItemAbilityBO.setSaleAmount(next.getBigDecimal("\u53ef\u4e0b\u5355\u6570\u91cf"));
            this.validParam(contractItemAbilityBO);
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        if (!CollectionUtils.isEmpty(erpOrgCodeList)) {
            List<UmcContractOrgSubQryAbilityBO> organization = this.getInventoryOrganization(erpOrgCodeList);
            Map<String, String> organizations = organization.stream().collect(Collectors.toMap(UmcContractOrgSubQryAbilityBO::getSubOrganizationId, UmcContractOrgSubQryAbilityBO::getSubOrganizationName));
            contractItemAbilityBOList = contractItemAbilityBOList.stream().map(e -> {
                e.setInventoryOrganization((String)organizations.get(e.getErpOrgCode()));
                return e;
            }).collect(Collectors.toList());
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getUnitContractItemAbilityBOListFromATaxUnitPrice(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        List<Object> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        ArrayList<String> erpOrgCodeList = new ArrayList<String>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(next.getString("\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("\u6570\u91cf") == null ? next.getBigDecimal("*\u6570\u91cf") : next.getBigDecimal("\u6570\u91cf"));
            contractItemAbilityBO.setUnitPriceExcludingTax(next.getBigDecimal("\u4e0d\u542b\u7a0e\u5355\u4ef7"));
            if (!StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387")) || !StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387(%)"))) {
                try {
                    String rateStr = next.getString("*\u7a0e\u7387");
                    if (StringUtils.isEmpty((Object)rateStr)) {
                        rateStr = next.getString("*\u7a0e\u7387(%)");
                    }
                    rateStr = rateStr.replaceAll("%", "");
                    contractItemAbilityBO.setRate(Integer.valueOf(rateStr));
                }
                catch (Exception e2) {
                    throw new ZTBusinessException("\u8f6c\u6362\u7a0e\u7387\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            if (contractItemAbilityBO.getRate() == null || contractItemAbilityBO.getRate() < 0) {
                throw new ZTBusinessException("\u7a0e\u7387\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setPriceCategories(ContractTransFieldUtil.transPriceCategories(next.getString("\u6bd4\u4ef7\u7c7b\u522b")));
            if (!StringUtils.isEmpty((Object)next.getString("\u5bf9\u6bd4\u5355\u4ef7"))) {
                try {
                    contractItemAbilityBO.setUnitPrice(new BigDecimal(next.getString("\u5bf9\u6bd4\u5355\u4ef7")));
                }
                catch (Exception e3) {
                    throw new ZTBusinessException("\u8f6c\u6362\u5bf9\u6bd4\u5355\u4ef7\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            contractItemAbilityBO.setSupplyCycle(next.getInteger("*\u4f9b\u8d27\u5468\u671f(\u5929)"));
            contractItemAbilityBO.setGuaranteePeriod(next.getInteger("*\u8d28\u4fdd\u671f(\u5929)"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setErpOrgCode(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            if (!StringUtils.isEmpty((Object)next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"))) {
                erpOrgCodeList.add(contractItemAbilityBO.getErpOrgCode());
            }
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBO.setComponentID(next.getString("\u90e8\u4ef6\u53f7"));
            contractItemAbilityBO.setItemId(next.getLong("\u660e\u7ec6id"));
            contractItemAbilityBO.setItemChangeId(next.getLong("\u660e\u7ec6\u53d8\u66f4id"));
            contractItemAbilityBO.setDeliveryDateDesc(next.getString("\u4ea4\u8d27\u671f\u8bf4\u660e"));
            contractItemAbilityBO.setOrderDeliveryDate(next.getBigDecimal("\u8ba2\u5355\u751f\u6548\u540e\u4ea4\u671f\uff08\u5929\uff09"));
            contractItemAbilityBO.setSaleStatus(ContractTransFieldUtil.transSaleStatusStr(next.getString("\u72b6\u6001")));
            contractItemAbilityBO.setSaleAmount(next.getBigDecimal("\u53ef\u4e0b\u5355\u6570\u91cf"));
            this.validParam(contractItemAbilityBO);
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        if (!CollectionUtils.isEmpty(erpOrgCodeList)) {
            List<UmcContractOrgSubQryAbilityBO> organization = this.getInventoryOrganization(erpOrgCodeList);
            Map<String, String> organizations = organization.stream().collect(Collectors.toMap(UmcContractOrgSubQryAbilityBO::getSubOrganizationId, UmcContractOrgSubQryAbilityBO::getSubOrganizationName));
            contractItemAbilityBOList = contractItemAbilityBOList.stream().map(e -> {
                e.setInventoryOrganization((String)organizations.get(e.getErpOrgCode()));
                return e;
            }).collect(Collectors.toList());
        }
        return contractItemAbilityBOList;
    }

    private List<ContractItemAbilityBO> getUnitContractItemAbilityBOListFromATaxUnit(JSONObject excel) {
        JSONArray excelJSON = excel.getJSONArray("excelJSON");
        List<Object> contractItemAbilityBOList = new ArrayList<ContractItemAbilityBO>();
        ArrayList<String> erpOrgCodeList = new ArrayList<String>();
        Iterator iterator = excelJSON.iterator();
        while (iterator.hasNext()) {
            ContractItemAbilityBO contractItemAbilityBO = new ContractItemAbilityBO();
            JSONObject next = (JSONObject)iterator.next();
            contractItemAbilityBO.setMaterialCode(StringUtils.isEmpty((Object)next.getString("\u7269\u8d44\u7f16\u7801")) ? next.getString("*\u7269\u8d44\u7f16\u7801") : next.getString("\u7269\u8d44\u7f16\u7801"));
            contractItemAbilityBO.setAmount(next.getBigDecimal("\u6570\u91cf") == null ? next.getBigDecimal("*\u6570\u91cf") : next.getBigDecimal("\u6570\u91cf"));
            contractItemAbilityBO.setTaxUnitPrice(next.getBigDecimal("*\u542b\u7a0e\u5355\u4ef7"));
            if (!StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387")) || !StringUtils.isEmpty((Object)next.getString("*\u7a0e\u7387(%)"))) {
                try {
                    String rateStr = next.getString("*\u7a0e\u7387");
                    if (StringUtils.isEmpty((Object)rateStr)) {
                        rateStr = next.getString("*\u7a0e\u7387(%)");
                    }
                    rateStr = rateStr.replaceAll("%", "");
                    contractItemAbilityBO.setRate(Integer.valueOf(rateStr));
                }
                catch (Exception e2) {
                    throw new ZTBusinessException("\u8f6c\u6362\u7a0e\u7387\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            if (contractItemAbilityBO.getRate() == null || contractItemAbilityBO.getRate() < 0) {
                throw new ZTBusinessException("\u7a0e\u7387\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setPriceCategories(ContractTransFieldUtil.transPriceCategories(next.getString("\u6bd4\u4ef7\u7c7b\u522b")));
            if (!StringUtils.isEmpty((Object)next.getString("\u5bf9\u6bd4\u5355\u4ef7"))) {
                try {
                    contractItemAbilityBO.setUnitPrice(new BigDecimal(next.getString("\u5bf9\u6bd4\u5355\u4ef7")));
                }
                catch (Exception e3) {
                    throw new ZTBusinessException("\u8f6c\u6362\u5bf9\u6bd4\u5355\u4ef7\u4e3a\u6570\u5b57\u5931\u8d25");
                }
            }
            contractItemAbilityBO.setSupplyCycle(next.getInteger("*\u4f9b\u8d27\u5468\u671f(\u5929)"));
            contractItemAbilityBO.setGuaranteePeriod(next.getInteger("*\u8d28\u4fdd\u671f(\u5929)"));
            contractItemAbilityBO.setNeedArriveTime(next.getString("\u4ea4\u8d27\u65e5\u671f"));
            contractItemAbilityBO.setPriceCategoriesStr(next.getString("\u6bd4\u4ef7\u7c7b\u522b"));
            contractItemAbilityBO.setErpOrgCode(next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"));
            if (!StringUtils.isEmpty((Object)next.getString("\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801"))) {
                erpOrgCodeList.add(contractItemAbilityBO.getErpOrgCode());
            }
            contractItemAbilityBO.setRemark(next.getString("\u5907\u6ce8"));
            contractItemAbilityBO.setExecutionStandard(next.getString("\u6267\u884c\u6807\u51c6"));
            contractItemAbilityBO.setBrandOrigin(next.getString("\u4ea7\u5730\u54c1\u724c"));
            contractItemAbilityBO.setSpecificPurpose(next.getString("\u5177\u4f53\u7528\u9014"));
            contractItemAbilityBO.setFactoryPriceStr(next.getString("\u5230/\u51fa\u5382\u4ef7"));
            contractItemAbilityBO.setFactoryPrice(ContractTransFieldUtil.transFactoryPrice(next.getString("\u5230/\u51fa\u5382\u4ef7")));
            contractItemAbilityBO.setQualityTechnicalRequirements(next.getString("\u8d28\u91cf\u6280\u672f\u8981\u6c42"));
            contractItemAbilityBO.setComponentID(next.getString("\u90e8\u4ef6\u53f7"));
            contractItemAbilityBO.setItemId(next.getLong("\u660e\u7ec6id"));
            contractItemAbilityBO.setItemChangeId(next.getLong("\u660e\u7ec6\u53d8\u66f4id"));
            contractItemAbilityBO.setDeliveryDateDesc(next.getString("\u4ea4\u8d27\u671f\u8bf4\u660e"));
            contractItemAbilityBO.setOrderDeliveryDate(next.getBigDecimal("\u8ba2\u5355\u751f\u6548\u540e\u4ea4\u671f\uff08\u5929\uff09"));
            contractItemAbilityBO.setSaleStatus(ContractTransFieldUtil.transSaleStatusStr(next.getString("\u72b6\u6001")));
            contractItemAbilityBO.setSaleAmount(next.getBigDecimal("\u53ef\u4e0b\u5355\u6570\u91cf"));
            this.validParam(contractItemAbilityBO);
            contractItemAbilityBOList.add(contractItemAbilityBO);
        }
        if (!CollectionUtils.isEmpty(erpOrgCodeList)) {
            List<UmcContractOrgSubQryAbilityBO> organization = this.getInventoryOrganization(erpOrgCodeList);
            Map<String, String> organizations = organization.stream().collect(Collectors.toMap(UmcContractOrgSubQryAbilityBO::getSubOrganizationId, UmcContractOrgSubQryAbilityBO::getSubOrganizationName));
            contractItemAbilityBOList = contractItemAbilityBOList.stream().map(e -> {
                e.setInventoryOrganization((String)organizations.get(e.getErpOrgCode()));
                return e;
            }).collect(Collectors.toList());
        }
        return contractItemAbilityBOList;
    }

    public List<Long> insertTmp(List<ContractInfoItemTmpPO> contractInfoItemTmpPOS, Integer type) {
        if (!CollectionUtils.isEmpty(contractInfoItemTmpPOS)) {
            contractInfoItemTmpPOS.forEach(each -> {
                if (each.getTaxAmount() != null) {
                    each.setTaxAmount(each.getTaxAmount().setScale(2, 4).stripTrailingZeros());
                }
                if (each.getNotIncludingTaxAmount() != null) {
                    each.setNotIncludingTaxAmount(each.getNotIncludingTaxAmount().setScale(2, 4).stripTrailingZeros());
                }
                if (each.getTax() != null) {
                    each.setTax(each.getTax().setScale(2, 4).stripTrailingZeros());
                }
            });
        }
        ArrayList<Long> itemChangeIdS = new ArrayList<Long>();
        ContractInfoItemTmpPO po = new ContractInfoItemTmpPO();
        po.setUpdateApplyId(contractInfoItemTmpPOS.get(0).getUpdateApplyId());
        List<Object> exists = new ArrayList();
        ArrayList<ContractInfoItemTmpPO> notExists = new ArrayList<ContractInfoItemTmpPO>();
        if (ContractConstant.ItemAddType.FZ.equals(type)) {
            exists = this.contractInfoItemTmpMapper.getItemsByAwardNumId(po, contractInfoItemTmpPOS);
            log.debug("\u5f53\u524d\u5b58\u5728\u7684\u660e\u7ec6\u53d8\u66f4\uff1a {}", exists);
            for (ContractInfoItemTmpPO contractInfoItemPO : contractInfoItemTmpPOS) {
                boolean exFlag = false;
                if (null != contractInfoItemPO.getAwardNumId()) {
                    for (ContractInfoItemTmpPO contractInfoItemTmpPO : exists) {
                        if (!contractInfoItemPO.getAwardNumId().equals(contractInfoItemTmpPO.getAwardNumId())) continue;
                        exFlag = true;
                    }
                    if (exFlag) continue;
                    notExists.add(contractInfoItemPO);
                    itemChangeIdS.add(contractInfoItemPO.getItemChangeId());
                    continue;
                }
                break;
            }
        } else {
            for (ContractInfoItemTmpPO contractInfoItemPO : contractInfoItemTmpPOS) {
                contractInfoItemPO.setDelFlag("0");
                if (contractInfoItemPO.getItemId() == null) {
                    contractInfoItemPO.setItemId(Sequence.getInstance().nextId());
                }
                notExists.add(contractInfoItemPO);
                itemChangeIdS.add(contractInfoItemPO.getItemChangeId());
            }
        }
        if (!CollectionUtils.isEmpty(notExists)) {
            this.contractInfoItemTmpMapper.insertBatch(notExists);
            log.info("\u5bfc\u5165\u4fe1\u606fbo\uff1a" + JSONObject.toJSONString(notExists));
        }
        return itemChangeIdS;
    }

    private ContractInfoItemTmpPO getContractInfoItemTmpPO(ContractItemAbilityBO x) {
        ContractInfoItemTmpPO contractInfoItemTmpPO = new ContractInfoItemTmpPO();
        BeanUtils.copyProperties((Object)x, (Object)contractInfoItemTmpPO);
        contractInfoItemTmpPO.setItemChangeId(Sequence.getInstance().nextId());
        contractInfoItemTmpPO.setUuid(Sequence.getInstance().nextId());
        contractInfoItemTmpPO.setDelFlag("0");
        if (null != x.getAmount()) {
            contractInfoItemTmpPO.setAmount(x.getAmount());
        }
        if (null != x.getUnitPrice()) {
            contractInfoItemTmpPO.setUnitPrice(x.getUnitPrice());
        }
        if (null != x.getTotalAmount()) {
            contractInfoItemTmpPO.setTotalAmount(x.getTotalAmount());
        }
        if (null != x.getTaxAmount()) {
            contractInfoItemTmpPO.setTaxAmount(x.getTaxAmount().setScale(2, 4).stripTrailingZeros());
        }
        if (null != x.getTaxUnitPrice()) {
            contractInfoItemTmpPO.setTaxUnitPrice(x.getTaxUnitPrice());
        }
        if (null != x.getTax()) {
            contractInfoItemTmpPO.setTax(x.getTax().setScale(2, 4).stripTrailingZeros());
        }
        if (null != x.getUnitPriceExcludingTax()) {
            contractInfoItemTmpPO.setUnitPriceExcludingTax(x.getUnitPriceExcludingTax());
        }
        if (null != x.getNotIncludingTaxAmount()) {
            contractInfoItemTmpPO.setNotIncludingTaxAmount(x.getNotIncludingTaxAmount().setScale(2, 4).stripTrailingZeros());
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (!StringUtils.isEmpty((Object)x.getUpdateTime())) {
                contractInfoItemTmpPO.setUpdateTime(simpleDateFormat.parse(x.getUpdateTime()));
            }
            if (!StringUtils.isEmpty((Object)x.getNeedArriveTime())) {
                contractInfoItemTmpPO.setNeedArriveTime(simpleDateFormat.parse(x.getNeedArriveTime()));
            }
            if (!StringUtils.isEmpty((Object)x.getCreateTime())) {
                contractInfoItemTmpPO.setCreateTime(simpleDateFormat.parse(x.getCreateTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contractInfoItemTmpPO;
    }

    private ContractInfoItemTmpPO getContractInfoItemTmpPO(ContractInfoItemPO x, Long updateApplyId) {
        ContractInfoItemTmpPO contractInfoItemTmpPO = (ContractInfoItemTmpPO)JSON.parseObject((String)JSON.toJSONString((Object)x), ContractInfoItemTmpPO.class);
        contractInfoItemTmpPO.setUpdateApplyId(updateApplyId);
        contractInfoItemTmpPO.setItemChangeId(Sequence.getInstance().nextId());
        contractInfoItemTmpPO.setUuid(Sequence.getInstance().nextId());
        contractInfoItemTmpPO.setDelFlag("0");
        return contractInfoItemTmpPO;
    }

    private void getExcelDateByImport(MultipartFile multipartFile, JSONObject jsonData, List<String> title) {
        try {
            Cell cell;
            ExcelUtils.checkExcelVaild(multipartFile);
            Workbook workbook = ExcelUtils.getWorkbok(multipartFile);
            Sheet sheet = workbook.getSheetAt(0);
            int rowLength = sheet.getLastRowNum();
            Row row = sheet.getRow(0);
            int colLength = row.getLastCellNum();
            for (int i = 0; i < colLength; ++i) {
                cell = row.getCell(i);
                if (cell == null) continue;
                cell.setCellType(CellType.STRING);
                title.add(cell.getStringCellValue());
            }
            JSONArray jsonArray = new JSONArray();
            jsonData.put("excelJSON", (Object)jsonArray);
            for (int i = 1; i <= rowLength; ++i) {
                row = sheet.getRow(i);
                JSONObject rowJson = new JSONObject();
                for (int j = 0; j < colLength; ++j) {
                    cell = row.getCell(j);
                    if (cell == null) continue;
                    rowJson.put(title.get(j), (Object)ContractItemChangeAddBusiServiceImpl.getCellValueByCell(cell));
                }
                jsonArray.add((Object)rowJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String cellValue = "";
        CellType cellTypeEnum = cell.getCellTypeEnum();
        switch (cellTypeEnum) {
            case NUMERIC: {
                short format = cell.getCellStyle().getDataFormat();
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    if (format == 20 || format == 32) {
                        sdf = new SimpleDateFormat("HH:mm");
                    } else if (format == 14 || format == 31 || format == 57 || format == 58) {
                        sdf = new SimpleDateFormat("yyyy-MM-dd");
                        double value = cell.getNumericCellValue();
                        Date date = DateUtil.getJavaDate((double)value);
                        cellValue = sdf.format(date);
                    } else {
                        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    }
                    try {
                        cellValue = sdf.format(cell.getDateCellValue());
                        break;
                    }
                    catch (Exception e) {
                        try {
                            throw new Exception("exception on get date data !".concat(e.toString()));
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            break;
                        }
                    }
                    finally {
                        sdf = null;
                    }
                }
                BigDecimal bd = new BigDecimal(cell.getNumericCellValue() + "");
                cellValue = bd.stripTrailingZeros().toPlainString();
                break;
            }
            case STRING: {
                cellValue = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue() + "";
                break;
            }
            default: {
                cellValue = "UNKNOW VALUE";
            }
        }
        return cellValue;
    }

    private List<UmcContractOrgSubQryAbilityBO> getInventoryOrganization(List<String> erporgCodeList) {
        UmcContractOrgSubQryAbilityReqBO qryAbilityReqBO = new UmcContractOrgSubQryAbilityReqBO();
        List collect = erporgCodeList.stream().distinct().collect(Collectors.toList());
        qryAbilityReqBO.setErporgCodeList(collect);
        UmcContractOrgSubQryAbilityRspBO umcContractOrgSubQryAbilityRspBO = this.umcContractOrgSubQryAbilityService.contractOrgSubQry(qryAbilityReqBO);
        if ("0000".equals(umcContractOrgSubQryAbilityRspBO.getRespCode())) {
            List abilityBOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)umcContractOrgSubQryAbilityRspBO.getRows())).toJavaList(UmcContractOrgSubQryAbilityBO.class);
            if (collect.size() != abilityBOS.size()) {
                throw new ZTBusinessException("\u9519\u8bef\u7684\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\uff01");
            }
            return abilityBOS;
        }
        throw new ZTBusinessException("\u67e5\u8be2\u5e93\u5b58\u7ec4\u7ec7\u5931\u8d25\uff01" + umcContractOrgSubQryAbilityRspBO.getRespDesc());
    }

    private void validParam(ContractItemAbilityBO bo) {
        List collect;
        if (!(StringUtils.isEmpty((Object)bo.getFactoryPriceStr()) || "\u51fa\u5382\u4ef7".equals(bo.getFactoryPriceStr()) || "\u5230\u5382\u4ef7".equals(bo.getFactoryPriceStr()))) {
            throw new ZTBusinessException("\u53ea\u80fd\u662f\u5230\u5382\u4ef7\u6216\u51fa\u5382\u4ef7");
        }
        String rateStr = bo.getRate() + "%";
        List<DicDictionaryBO> dictionaryBOS = this.contractDictionaryBusiService.queryBypCodeBackPo("CONTRACT", "TAX_RATE_PCODE", "");
        if (!CollectionUtils.isEmpty(dictionaryBOS) && !(collect = dictionaryBOS.stream().map(e -> e.getTitle()).collect(Collectors.toList())).contains(rateStr)) {
            throw new ZTBusinessException("\u7a0e\u7387\u4e0d\u7b26\u5408\uff01");
        }
    }
}

