/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQryComparePriceAbilityService;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.ability.bo.ContractItemChangeAbilityBO;
import com.tydic.contract.ability.bo.ContractQryComparePriceAbilityBO;
import com.tydic.contract.ability.bo.ContractQryComparePriceAbilityQryBO;
import com.tydic.contract.ability.bo.ContractQryComparePriceAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryComparePriceAbilityRspBO;
import com.tydic.contract.atom.InterFaceContractGetCanOrderNumAtomService;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomRspBO;
import com.tydic.contract.busi.ContractItemChangeQueryBusiService;
import com.tydic.contract.busi.bo.ContractItemChangeQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemChangeQueryBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoItemHistoryLogMapper;
import com.tydic.contract.dao.CContractOrderInfoMapper;
import com.tydic.contract.dao.ContractInfoChangeItemMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.po.CContractInfoItemHistoryLogPO;
import com.tydic.contract.po.CContractOrderInfoPO;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractItemChangeQueryBusiServiceImpl
implements ContractItemChangeQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemChangeQueryBusiServiceImpl.class);
    @Autowired
    ContractInfoChangeItemMapper contractInfoChangeItemMapper;
    @Autowired
    ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private InterFaceContractGetCanOrderNumAtomService interFaceContractGetCanOrderNumAtomService;
    @Autowired
    private CContractOrderInfoMapper cContractOrderInfoMapper;
    @Autowired
    private ContractQryComparePriceAbilityService contractQryComparePriceAbilityService;
    @Autowired
    private CContractInfoItemHistoryLogMapper cContractInfoItemHistoryLogMapper;
    @Value(value="${ORDER_QRY:1}")
    private String orderQry;

    @Override
    public ContractItemChangeQueryBusiRspBO contractItemChangeQuery(ContractItemChangeQueryBusiReqBO reqBO) {
        ContractItemChangeQueryBusiRspBO rspBO = new ContractItemChangeQueryBusiRspBO();
        BigDecimal notIncludingTaxAmountTotal = null;
        BigDecimal taxAmountTotal = null;
        BigDecimal taxTotal = null;
        ContractInfoItemTmpPO po = new ContractInfoItemTmpPO();
        po.setUpdateApplyId(reqBO.getUpdateApplyId());
        po.setBatchAfterRefresh(reqBO.getBatchAfterRefresh());
        po.setMaterialCode(reqBO.getMaterialCode());
        List<Long> itemChangeIdS = reqBO.getItemChangeIdS();
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemTmpMapper.contractItemChangeQuery(po, itemChangeIdS));
        if (!CollectionUtils.isEmpty((Collection)page.getResult())) {
            List<Long> qryOldItemIds;
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u53d8\u66f4\u5217\u8868\u67e5\u8be2\u6210\u529f");
            List result = page.getResult();
            ArrayList<ContractItemChangeAbilityBO> rows = new ArrayList<ContractItemChangeAbilityBO>();
            Map<Object, Object> itemPoMap = new HashMap();
            List<Object> oldItemIds = new ArrayList();
            if (!StringUtils.isEmpty((Object)reqBO.getAuthToken())) {
                List<ContractInfoItemPO> contractInfoItemPOS;
                Map<Long, BigDecimal> itemAmountMap = new HashMap();
                List<Long> itemIds = result.stream().map(ContractInfoItemTmpPO::getItemId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(itemIds) && !CollectionUtils.isEmpty(contractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(itemIds))) {
                    itemAmountMap = contractInfoItemPOS.stream().filter(a -> a.getAmount() != null).collect(Collectors.toMap(a -> a.getItemId(), b -> b.getAmount(), (first, second) -> first));
                    oldItemIds = contractInfoItemPOS.stream().map(ContractInfoItemPO::getItemId).collect(Collectors.toList());
                    itemPoMap = contractInfoItemPOS.stream().collect(Collectors.toMap(a -> a.getItemId(), b -> b, (k1, k2) -> k1));
                }
                String materialSource = null;
                Long relateId = ((ContractInfoItemTmpPO)result.get(0)).getRelateId();
                ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(relateId);
                if (contractInfoPO == null) {
                    List<ContractInfoChangePO> list = this.contractInfoChangeMapper.selectByContractId(relateId);
                    if (!CollectionUtils.isEmpty(list)) {
                        materialSource = list.get(0).getMaterialSource();
                    }
                } else {
                    materialSource = contractInfoPO.getMaterialSource();
                }
                ArrayList<InterFaceContractGetCanOrderNumAtomBO> arrayList = new ArrayList<InterFaceContractGetCanOrderNumAtomBO>();
                if (!StringUtils.isEmpty((Object)materialSource)) {
                    for (ContractInfoItemTmpPO e2 : result) {
                        if (StringUtils.isEmpty((Object)e2.getAwardNumId())) continue;
                        InterFaceContractGetCanOrderNumAtomBO interFaceContractGetCanOrderNumAtomBO = new InterFaceContractGetCanOrderNumAtomBO();
                        interFaceContractGetCanOrderNumAtomBO.setType(Integer.valueOf(materialSource));
                        interFaceContractGetCanOrderNumAtomBO.setQueryType(ObjectUtils.isEmpty((Object)contractInfoPO) ? null : contractInfoPO.getDbType());
                        interFaceContractGetCanOrderNumAtomBO.setGoodTypeId(e2.getAwardNumId());
                        arrayList.add(interFaceContractGetCanOrderNumAtomBO);
                    }
                }
                if (!CollectionUtils.isEmpty(arrayList)) {
                    InterFaceContractGetCanOrderNumAtomReqBO interFaceContractGetCanOrderNumAtomReqBO = new InterFaceContractGetCanOrderNumAtomReqBO();
                    interFaceContractGetCanOrderNumAtomReqBO.setOrderItem(arrayList);
                    interFaceContractGetCanOrderNumAtomReqBO.setToken(reqBO.getAuthToken());
                    interFaceContractGetCanOrderNumAtomReqBO.setTypeAmount(0);
                    InterFaceContractGetCanOrderNumAtomRspBO interFaceContractGetCanOrderNumAtomRspBO = this.interFaceContractGetCanOrderNumAtomService.getCanOrderNum(interFaceContractGetCanOrderNumAtomReqBO);
                    if ("0000".equals(interFaceContractGetCanOrderNumAtomRspBO.getRespCode()) && !CollectionUtils.isEmpty(interFaceContractGetCanOrderNumAtomRspBO.getOrderItem())) {
                        Map<String, BigDecimal> resultAwardNumIdAndCount = interFaceContractGetCanOrderNumAtomRspBO.getOrderItem().stream().collect(Collectors.toMap(a -> a.getGoodTypeId(), b -> b.getOrderNum(), (first, second) -> first));
                        for (ContractInfoItemTmpPO contractInfoItemTmpPO : result) {
                            if (StringUtils.isEmpty((Object)contractInfoItemTmpPO.getAwardNumId()) || !resultAwardNumIdAndCount.containsKey(contractInfoItemTmpPO.getAwardNumId())) continue;
                            BigDecimal amount = itemAmountMap.get(contractInfoItemTmpPO.getItemId());
                            if (amount != null) {
                                contractInfoItemTmpPO.setItemNum(resultAwardNumIdAndCount.get(contractInfoItemTmpPO.getAwardNumId()).doubleValue() + amount.doubleValue());
                                continue;
                            }
                            contractInfoItemTmpPO.setItemNum(resultAwardNumIdAndCount.get(contractInfoItemTmpPO.getAwardNumId()).doubleValue());
                        }
                    }
                }
            }
            for (ContractInfoItemTmpPO contractInfoItemTmpPO : result) {
                CContractOrderInfoPO cContractOrderInfoPO;
                ContractItemChangeAbilityBO contractItemChangeAbilityBO;
                if (notIncludingTaxAmountTotal == null && null != contractInfoItemTmpPO.getNotIncludingTaxAmountTotal()) {
                    notIncludingTaxAmountTotal = contractInfoItemTmpPO.getNotIncludingTaxAmountTotal();
                }
                if (taxAmountTotal == null && null != contractInfoItemTmpPO.getTaxAmountTotal()) {
                    taxAmountTotal = contractInfoItemTmpPO.getTaxAmountTotal();
                }
                if (taxTotal == null && null != contractInfoItemTmpPO.getTaxTotal()) {
                    taxTotal = contractInfoItemTmpPO.getTaxTotal();
                }
                if (oldItemIds.contains((contractItemChangeAbilityBO = this.getContractItemChangeAbilityBO(contractInfoItemTmpPO)).getItemId())) {
                    contractItemChangeAbilityBO.setIsOldItemStatus(Integer.valueOf(0));
                } else {
                    contractItemChangeAbilityBO.setIsOldItemStatus(Integer.valueOf(1));
                }
                if (contractItemChangeAbilityBO.getOrderId() != null && (cContractOrderInfoPO = this.cContractOrderInfoMapper.selectByPrimaryKey(contractItemChangeAbilityBO.getOrderId())) != null) {
                    contractItemChangeAbilityBO.setOrderType(cContractOrderInfoPO.getOrderType());
                    contractItemChangeAbilityBO.setOrderSource(cContractOrderInfoPO.getOrderSource());
                    contractItemChangeAbilityBO.setSaleVoucherId(cContractOrderInfoPO.getSaleVoucherId());
                }
                if (!itemPoMap.containsKey(contractItemChangeAbilityBO.getItemId())) {
                    contractItemChangeAbilityBO.setIsNewInsert(Integer.valueOf(1));
                } else {
                    contractItemChangeAbilityBO.setIsNewInsert(Integer.valueOf(0));
                }
                rows.add(contractItemChangeAbilityBO);
            }
            if (!CollectionUtils.isEmpty(rows)) {
                List<ContractOrderPo> contractOrderPos;
                Map<Long, List<Object>> itemIdMap;
                List<ContractInfoItemPO> relContractInfoItemPOS;
                List<Long> itemIds = rows.stream().map(ContractItemChangeAbilityBO::getItemId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(itemIds) && !CollectionUtils.isEmpty(relContractInfoItemPOS = this.contractInfoItemMapper.selectRelateListByItemIds(itemIds))) {
                    itemIdMap = relContractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getItemId));
                    rows.forEach(e -> {
                        if (!CollectionUtils.isEmpty((Collection)((Collection)itemIdMap.get(e.getItemId())))) {
                            ContractInfoItemPO contractInfoItemPO = (ContractInfoItemPO)((List)itemIdMap.get(e.getItemId())).get(0);
                            e.setPurchaseAmount(contractInfoItemPO.getAmount());
                            e.setPurchaseTaxUnitPrice(contractInfoItemPO.getTaxUnitPrice());
                        }
                    });
                }
                if (!CollectionUtils.isEmpty(itemIds) && !CollectionUtils.isEmpty(contractOrderPos = this.contractOrderMapper.selectListByItemIds(itemIds))) {
                    itemIdMap = contractOrderPos.stream().collect(Collectors.groupingBy(ContractOrderPo::getItemId));
                    rows.forEach(e -> {
                        if (!CollectionUtils.isEmpty((Collection)((Collection)itemIdMap.get(e.getItemId())))) {
                            ContractOrderPo contractOrderPo = (ContractOrderPo)((List)itemIdMap.get(e.getItemId())).get(0);
                            e.setOrderNum(contractOrderPo.getSumDoOrderNum());
                        } else {
                            e.setOrderNum(BigDecimal.ZERO);
                        }
                    });
                }
            }
            rspBO.setNotIncludingTaxAmountTotal(notIncludingTaxAmountTotal);
            rspBO.setTaxAmountTotal(taxAmountTotal);
            rspBO.setTaxTotal(taxTotal);
            if (!CollectionUtils.isEmpty(rows)) {
                try {
                    this.qryPriceCategorie(rows);
                }
                catch (Exception e3) {
                    throw new ZTBusinessException("\u5bf9\u6bd4\u5355\u4ef7\u67e5\u8be2\u5f02\u5e38" + e3.getMessage());
                }
            }
            if (!CollectionUtils.isEmpty(rows) && !CollectionUtils.isEmpty(qryOldItemIds = rows.stream().map(ContractItemChangeAbilityBO::getItemId).collect(Collectors.toList())) && reqBO.getUpdateApplyId() != null) {
                ContractInfoChangePO infoChangePO = this.contractInfoChangeMapper.selectByPrimaryKey(reqBO.getUpdateApplyId());
                List<Object> oleItemPOS = new ArrayList();
                if (infoChangePO == null || !ContractConstant.ModifyStatus.MODIFY_STATUS_APPROVED.equals(infoChangePO.getModifyStatus()) && !ContractConstant.ModifyStatus.MODIFY_STATUS_EFFECT.equals(infoChangePO.getModifyStatus())) {
                    oleItemPOS = this.contractInfoItemMapper.selectListByItemIds(qryOldItemIds);
                } else {
                    List<CContractInfoItemHistoryLogPO> historyOleItemPOS = this.cContractInfoItemHistoryLogMapper.selectListByItemIds(qryOldItemIds, reqBO.getUpdateApplyId());
                    if (!CollectionUtils.isEmpty(historyOleItemPOS)) {
                        oleItemPOS = JSONObject.parseArray((String)JSONObject.toJSONString(historyOleItemPOS), ContractInfoItemPO.class);
                    }
                }
                if (!CollectionUtils.isEmpty(oleItemPOS)) {
                    ArrayList<ContractItemAbilityBO> oleItemBOS = new ArrayList<ContractItemAbilityBO>();
                    for (ContractInfoItemPO contractInfoItemPO : oleItemPOS) {
                        ContractItemAbilityBO oleItemBO = (ContractItemAbilityBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contractInfoItemPO), ContractItemAbilityBO.class);
                        if (null != contractInfoItemPO.getAmount()) {
                            oleItemBO.setAmount(contractInfoItemPO.getAmount());
                        }
                        if (null != contractInfoItemPO.getFactoryPrice()) {
                            oleItemBO.setFactoryPriceStr(ContractTransFieldUtil.transFactoryPrice(contractInfoItemPO.getFactoryPrice()));
                        }
                        if (null != contractInfoItemPO.getCreateTime()) {
                            oleItemBO.setCreateTime(DateUtils.dateToStrAsFormat(contractInfoItemPO.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
                        }
                        if (null != contractInfoItemPO.getUpdateTime()) {
                            oleItemBO.setUpdateTime(DateUtils.dateToStrAsFormat(contractInfoItemPO.getUpdateTime(), "yyyy-MM-dd HH:mm:ss"));
                        }
                        if (null != contractInfoItemPO.getNeedArriveTime()) {
                            oleItemBO.setNeedArriveTime(DateUtils.dateToStrAsFormat(contractInfoItemPO.getNeedArriveTime(), "yyyy-MM-dd HH:mm:ss"));
                        }
                        if (null != contractInfoItemPO.getPriceCategories()) {
                            oleItemBO.setPriceCategoriesStr(ContractTransFieldUtil.transPriceCategories(contractInfoItemPO.getPriceCategories()));
                        }
                        oleItemBOS.add(oleItemBO);
                    }
                    this.qryOldPriceCategorie(oleItemBOS);
                    Map<Long, ContractItemAbilityBO> oldItemIdMap = oleItemBOS.stream().collect(Collectors.toMap(ContractItemAbilityBO::getItemId, e -> e));
                    rows.stream().forEach(e -> {
                        if (oldItemIdMap.keySet().contains(e.getItemId())) {
                            ContractItemAbilityBO oldItemPO = (ContractItemAbilityBO)oldItemIdMap.get(e.getItemId());
                            e.setOldItemBO(oldItemPO);
                            Field[] declaredFields2 = oldItemPO.getClass().getDeclaredFields();
                            Field[] declaredFields23 = e.getClass().getDeclaredFields();
                            String checkFields = "amount\u3001priceCategoriesStr\u3001unitPrice\u3001taxUnitPrice\u3001taxAmount\u3001rate\u3001unitPriceExcludingTax\u3001notIncludingTaxAmount\u3001tax\u3001needArriveTime\u3001supplyCycle\u3001guaranteePeriod\u3001remark\u3001executionStandard\u3001brandOrigin\u3001specificPurpose\u3001factoryPriceStr";
                            ArrayList<String> updateFields = new ArrayList<String>();
                            HashMap<String, Object> declaredFields2Map = new HashMap<String, Object>();
                            HashMap<String, Object> declaredFields23Map = new HashMap<String, Object>();
                            try {
                                int i;
                                for (i = 0; i < declaredFields2.length; ++i) {
                                    declaredFields2[i].setAccessible(true);
                                    declaredFields2Map.put(declaredFields2[i].getName(), declaredFields2[i].get(oldItemPO));
                                }
                                for (i = 0; i < declaredFields23.length; ++i) {
                                    declaredFields23[i].setAccessible(true);
                                    declaredFields23Map.put(declaredFields23[i].getName(), declaredFields23[i].get(e));
                                }
                                for (String checkField : checkFields.split("\u3001")) {
                                    if (StringUtils.isEmpty((Object)checkField)) continue;
                                    if (declaredFields2Map.get(checkField) != null && declaredFields23Map.get(checkField) != null) {
                                        if (declaredFields2Map.get(checkField).equals(declaredFields23Map.get(checkField))) continue;
                                        updateFields.add(checkField);
                                        break;
                                    }
                                    if (declaredFields2Map.get(checkField) == null && declaredFields23Map.get(checkField) != null) {
                                        updateFields.add(checkField);
                                        break;
                                    }
                                    if (declaredFields2Map.get(checkField) == null || declaredFields23Map.get(checkField) != null) continue;
                                    updateFields.add(checkField);
                                    break;
                                }
                                if (!CollectionUtils.isEmpty(updateFields)) {
                                    e.setIsUpdateOldItemStatus(Integer.valueOf(0));
                                }
                                e.setIsUpdateOldItemStatus(Integer.valueOf(2));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                throw new ZTBusinessException("\u6bd4\u8f83\u53d8\u66f4\u7684\u5185\u5bb9\u5931\u8d25");
                            }
                        } else {
                            e.setIsUpdateOldItemStatus(Integer.valueOf(1));
                        }
                    });
                }
            }
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNum());
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            rspBO.getRows().forEach(each -> {
                ContractItemAbilityBO oldItemBO;
                if (each.getTaxUnitPrice() != null) {
                    each.setTaxUnitPrice(Convert.toBigDecimal((Object)each.getTaxUnitPrice().setScale(8, 4).toPlainString()));
                }
                if (each.getUnitPriceExcludingTax() != null) {
                    each.setUnitPriceExcludingTax(Convert.toBigDecimal((Object)each.getUnitPriceExcludingTax().setScale(8, 4).toPlainString()));
                }
                if (each.getUnitPrice() != null) {
                    each.setUnitPrice(each.getUnitPrice().setScale(8, 4).stripTrailingZeros());
                }
                if (each.getTaxAmount() != null) {
                    each.setTaxAmount(Convert.toBigDecimal((Object)each.getTaxAmount().setScale(2, 4).toPlainString()));
                }
                if (each.getNotIncludingTaxAmount() != null) {
                    each.setNotIncludingTaxAmount(Convert.toBigDecimal((Object)each.getNotIncludingTaxAmount().setScale(2, 4).toPlainString()));
                }
                if (each.getTax() != null) {
                    each.setTax(each.getTax().setScale(2, 4).stripTrailingZeros());
                }
                if ((oldItemBO = each.getOldItemBO()) != null && oldItemBO.getUnitPriceExcludingTax() != null) {
                    oldItemBO.setUnitPriceExcludingTax(oldItemBO.getUnitPriceExcludingTax().setScale(8, 4).stripTrailingZeros());
                }
            });
        }
        return rspBO;
    }

    private ContractItemChangeAbilityBO getContractItemChangeAbilityBO(ContractInfoItemTmpPO x) {
        ContractItemChangeAbilityBO contractItemAbilityBO = new ContractItemChangeAbilityBO();
        BeanUtils.copyProperties((Object)x, (Object)contractItemAbilityBO);
        if (null != x.getAmount()) {
            contractItemAbilityBO.setAmount(x.getAmount());
        }
        if (null != x.getFactoryPrice()) {
            contractItemAbilityBO.setFactoryPriceStr(ContractTransFieldUtil.transFactoryPrice(contractItemAbilityBO.getFactoryPrice()));
        }
        if (null != x.getCreateTime()) {
            contractItemAbilityBO.setCreateTime(DateUtils.dateToStrAsFormat(x.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (null != x.getUpdateTime()) {
            contractItemAbilityBO.setUpdateTime(DateUtils.dateToStrAsFormat(x.getUpdateTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (null != x.getNeedArriveTime()) {
            contractItemAbilityBO.setNeedArriveTime(DateUtils.dateToStrAsFormat(x.getNeedArriveTime(), "yyyy-MM-dd HH:mm:ss"));
        }
        if (null != x.getPriceCategories()) {
            contractItemAbilityBO.setPriceCategoriesStr(ContractTransFieldUtil.transPriceCategories(x.getPriceCategories()));
        }
        return contractItemAbilityBO;
    }

    public void qryPriceCategorie(List<ContractItemChangeAbilityBO> contractItemBusiBOList) {
        if (!CollectionUtils.isEmpty(contractItemBusiBOList)) {
            ArrayList<ContractQryComparePriceAbilityQryBO> qryBOS = new ArrayList<ContractQryComparePriceAbilityQryBO>();
            ContractQryComparePriceAbilityReqBO priceAbilityReqBO = new ContractQryComparePriceAbilityReqBO();
            priceAbilityReqBO.setIsChangeQry(Integer.valueOf(2));
            priceAbilityReqBO.setQryBOS(qryBOS);
            for (ContractItemChangeAbilityBO bo : contractItemBusiBOList) {
                ContractQryComparePriceAbilityQryBO qryBO = new ContractQryComparePriceAbilityQryBO();
                if (ContractConstant.PriceCategoriesType.CONTRACT_PRICE.equals(bo.getPriceCategories())) {
                    qryBO.setItemChangeId(bo.getItemChangeId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.DEF_AGR_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (ContractConstant.PriceCategoriesType.AVERAGE_PRICE.equals(bo.getPriceCategories())) {
                    qryBO.setItemChangeId(bo.getItemChangeId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setAwardNumId(bo.getAwardNumId());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.AVERAGE_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (ContractConstant.PriceCategoriesType.COUNTERPARTY_QUOTATION.equals(bo.getPriceCategories())) {
                    qryBO.setItemChangeId(bo.getItemChangeId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setAwardNumId(bo.getAwardNumId());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.QOTP_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (ContractConstant.PriceCategoriesType.BUDGET_PRICE.equals(bo.getPriceCategories())) {
                    qryBO.setItemChangeId(bo.getItemChangeId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setPlanItemId(bo.getPlanItemId());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.BUDGET_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (!Objects.equals("\u6307\u5bfc\u4ef7", bo.getPriceCategories())) continue;
                bo.setUnitPrice(BigDecimal.ZERO);
            }
            if (!CollectionUtils.isEmpty(qryBOS)) {
                ContractQryComparePriceAbilityRspBO contractQryComparePriceAbilityRspBO;
                priceAbilityReqBO.setIsBackEndQryItem(Integer.valueOf(1));
                if ("1".equals(this.orderQry) && "0000".equals((contractQryComparePriceAbilityRspBO = this.contractQryComparePriceAbilityService.qryComparePrice(priceAbilityReqBO)).getRespCode()) && !CollectionUtils.isEmpty((Collection)contractQryComparePriceAbilityRspBO.getPriceAbilityBOS())) {
                    Map<Long, BigDecimal> itemIdMap = contractQryComparePriceAbilityRspBO.getPriceAbilityBOS().stream().collect(Collectors.toMap(ContractQryComparePriceAbilityBO::getItemChangeId, ContractQryComparePriceAbilityBO::getPrice));
                    for (ContractItemChangeAbilityBO bo : contractItemBusiBOList) {
                        if (!ContractConstant.PriceCategoriesType.CONTRACT_PRICE.equals(bo.getPriceCategories()) && !ContractConstant.PriceCategoriesType.AVERAGE_PRICE.equals(bo.getPriceCategories()) && !ContractConstant.PriceCategoriesType.COUNTERPARTY_QUOTATION.equals(bo.getPriceCategories()) && !ContractConstant.PriceCategoriesType.BUDGET_PRICE.equals(bo.getPriceCategories()) || !itemIdMap.keySet().contains(bo.getItemChangeId())) continue;
                        bo.setUnitPrice(itemIdMap.get(bo.getItemChangeId()));
                    }
                }
            }
        }
    }

    public void qryOldPriceCategorie(List<ContractItemAbilityBO> contractItemBusiBOList) {
        if (!CollectionUtils.isEmpty(contractItemBusiBOList)) {
            ArrayList<ContractQryComparePriceAbilityQryBO> qryBOS = new ArrayList<ContractQryComparePriceAbilityQryBO>();
            ContractQryComparePriceAbilityReqBO priceAbilityReqBO = new ContractQryComparePriceAbilityReqBO();
            priceAbilityReqBO.setIsChangeQry(Integer.valueOf(1));
            priceAbilityReqBO.setQryBOS(qryBOS);
            for (ContractItemAbilityBO bo : contractItemBusiBOList) {
                ContractQryComparePriceAbilityQryBO qryBO = new ContractQryComparePriceAbilityQryBO();
                if (ContractConstant.PriceCategoriesType.CONTRACT_PRICE.equals(bo.getPriceCategories())) {
                    qryBO.setItemId(bo.getItemId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.DEF_AGR_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (ContractConstant.PriceCategoriesType.AVERAGE_PRICE.equals(bo.getPriceCategories())) {
                    qryBO.setItemId(bo.getItemId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setAwardNumId(bo.getAwardNumId());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.AVERAGE_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (ContractConstant.PriceCategoriesType.COUNTERPARTY_QUOTATION.equals(bo.getPriceCategories())) {
                    qryBO.setItemId(bo.getItemId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setAwardNumId(bo.getAwardNumId());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.QOTP_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (ContractConstant.PriceCategoriesType.BUDGET_PRICE.equals(bo.getPriceCategories())) {
                    qryBO.setItemId(bo.getItemId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setAwardNumId(bo.getAwardNumId());
                    qryBO.setPlanItemId(bo.getPlanItemId());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.BUDGET_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (!Objects.equals("\u6307\u5bfc\u4ef7", bo.getPriceCategories())) continue;
                bo.setUnitPrice(BigDecimal.ZERO);
            }
            if (!CollectionUtils.isEmpty(qryBOS)) {
                ContractQryComparePriceAbilityRspBO contractQryComparePriceAbilityRspBO;
                priceAbilityReqBO.setIsBackEndQryItem(Integer.valueOf(1));
                if ("1".equals(this.orderQry) && "0000".equals((contractQryComparePriceAbilityRspBO = this.contractQryComparePriceAbilityService.qryComparePrice(priceAbilityReqBO)).getRespCode()) && !CollectionUtils.isEmpty((Collection)contractQryComparePriceAbilityRspBO.getPriceAbilityBOS())) {
                    Map<Long, BigDecimal> itemIdMap = contractQryComparePriceAbilityRspBO.getPriceAbilityBOS().stream().collect(Collectors.toMap(ContractQryComparePriceAbilityBO::getItemId, ContractQryComparePriceAbilityBO::getPrice));
                    for (ContractItemAbilityBO bo : contractItemBusiBOList) {
                        if (!ContractConstant.PriceCategoriesType.CONTRACT_PRICE.equals(bo.getPriceCategories()) && !ContractConstant.PriceCategoriesType.AVERAGE_PRICE.equals(bo.getPriceCategories()) && !ContractConstant.PriceCategoriesType.COUNTERPARTY_QUOTATION.equals(bo.getPriceCategories()) && !ContractConstant.PriceCategoriesType.BUDGET_PRICE.equals(bo.getPriceCategories()) || !itemIdMap.keySet().contains(bo.getItemId())) continue;
                        bo.setUnitPrice(itemIdMap.get(bo.getItemId()));
                    }
                }
            }
        }
    }
}

