/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractItemBatchUpdateDateAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemChangeAbilityBO;
import com.tydic.contract.ability.bo.ContractItemChangeUpdateAbilityRspBO;
import com.tydic.contract.busi.ContractItemChangeUpdateBusiService;
import com.tydic.contract.busi.bo.ContractItemChangeUpdateBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemChangeUpdateBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoChangeItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.po.ContractInfoChangeItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.umc.general.ability.api.UmcContractQueryBuyerInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcContractQueryBuyerInfoAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubBO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractItemChangeUpdateBusiServiceImpl
implements ContractItemChangeUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemChangeUpdateBusiServiceImpl.class);
    @Autowired
    private ContractInfoChangeItemMapper contractInfoChangeItemMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    UmcContractQueryBuyerInfoAbilityService umcContractQueryBuyerInfoAbilityService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @Override
    public ContractItemChangeUpdateBusiRspBO contractItemChangeUpdate(ContractItemChangeUpdateBusiReqBO reqBO) {
        Set erpOrgCodes;
        List<ContractInfoPO> contractInfoPOS;
        List<ContractOrderPo> contractOrderPos;
        ContractItemChangeUpdateBusiRspBO rspBO = new ContractItemChangeUpdateBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getContractItemList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u660e\u7ec6\u53d8\u66f4\u5217\u8868\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        List<Long> itemIds = reqBO.getContractItemList().stream().filter(e -> e.getItemId() != null).map(ContractItemChangeAbilityBO::getItemId).collect(Collectors.toList());
        Map<Object, Object> itemIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(itemIds) && !CollectionUtils.isEmpty(contractOrderPos = this.contractOrderMapper.selectListByItemIds(itemIds))) {
            itemIdMap = contractOrderPos.stream().collect(Collectors.groupingBy(ContractOrderPo::getItemId));
        }
        HashMap<Long, Integer> itemIdContractTypeMap = new HashMap<Long, Integer>();
        List<Long> relateIds = reqBO.getContractItemList().stream().filter(e -> e.getRelateId() != null).map(ContractItemChangeAbilityBO::getRelateId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(relateIds) && !CollectionUtils.isEmpty(contractInfoPOS = this.contractInfoMapper.getListByContractIds(relateIds))) {
            for (ContractInfoPO contractInfoPO : contractInfoPOS) {
                itemIdContractTypeMap.put(contractInfoPO.getContractId(), contractInfoPO.getContractType());
            }
        }
        Map<Object, Object> oIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(reqBO.getContractItemList()) && !org.apache.commons.collections.CollectionUtils.isEmpty(erpOrgCodes = reqBO.getContractItemList().stream().filter(e -> !StringUtils.isEmpty((Object)e.getErpOrgCode())).map(ContractItemChangeAbilityBO::getErpOrgCode).collect(Collectors.toSet()))) {
            UmcContractQueryBuyerInfoAbilityReqBO umcContractQueryBuyerInfoAbilityReqBO = new UmcContractQueryBuyerInfoAbilityReqBO();
            ArrayList organizationCodes = new ArrayList();
            organizationCodes.addAll(erpOrgCodes);
            umcContractQueryBuyerInfoAbilityReqBO.setOrganizationIds(organizationCodes);
            UmcContractQueryBuyerInfoAbilityRspBO umcContractQueryBuyerInfoAbilityRspBO = this.umcContractQueryBuyerInfoAbilityService.queryContractBuyerInfo(umcContractQueryBuyerInfoAbilityReqBO);
            if ("0000".equals(umcContractQueryBuyerInfoAbilityRspBO.getRespCode()) && !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)umcContractQueryBuyerInfoAbilityRspBO.getRows())) {
                oIdMap = umcContractQueryBuyerInfoAbilityRspBO.getRows().stream().collect(Collectors.groupingBy(UmcEntityOrgSubBO::getOrganizationId));
            }
        }
        for (ContractItemChangeAbilityBO x : reqBO.getContractItemList()) {
            if (StringUtils.isEmpty((Object)x.getItemChangeId())) continue;
            ContractInfoItemTmpPO po = this.getContractInfoItemTmpPO(x);
            if (po.getItemId() != null && !CollectionUtils.isEmpty((Collection)((Collection)itemIdMap.get(po.getItemId())))) {
                Integer contractType;
                ContractOrderPo contractOrderPo = (ContractOrderPo)((List)itemIdMap.get(po.getItemId())).get(0);
                BigDecimal orderNum = contractOrderPo.getSumDoOrderNum();
                if (orderNum == null) {
                    orderNum = BigDecimal.ZERO;
                }
                if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractType = (Integer)itemIdContractTypeMap.get(po.getRelateId())) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractType) || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(contractType)) {
                    if (ContractConstant.SaleStatus.LIMIT.equals(po.getSaleStatus())) {
                        if (po.getSaleAmount() == null) {
                            throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u4e3a\u9650\u91cf\u65f6\u53ef\u4e0b\u5355\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a,\u660e\u7ec6id:" + po.getItemId() + "\u7269\u8d44\u7f16\u7801:" + po.getMaterialCode());
                        }
                        if (po.getSaleAmount().compareTo(orderNum) < 0) {
                            throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u6570\u91cf\u5c0f\u4e8e\u4e86\u5df2\u4e0b\u5355\u6570\u91cf,\u660e\u7ec6id:" + po.getItemId() + "\u7269\u8d44\u7f16\u7801:" + po.getMaterialCode());
                        }
                    }
                } else if (po.getAmount().compareTo(orderNum) < 0) {
                    throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u6570\u91cf\u5c0f\u4e8e\u4e86\u5df2\u4e0b\u5355\u6570\u91cf,\u660e\u7ec6id:" + po.getItemId() + "\u7269\u8d44\u7f16\u7801:" + po.getMaterialCode());
                }
            }
            if (oIdMap.containsKey(po.getErpOrgCode())) {
                UmcEntityOrgSubBO umcEntityOrgSubBO = (UmcEntityOrgSubBO)((List)oIdMap.get(po.getErpOrgCode())).get(0);
                po.setBuyerId(umcEntityOrgSubBO.getEntityId());
                if (umcEntityOrgSubBO.getEntityId() != null) {
                    po.setBuyerNo(umcEntityOrgSubBO.getEntityId().toString());
                }
                po.setBuyerName(umcEntityOrgSubBO.getEntityName());
            }
            if (po.getTaxAmount() != null) {
                po.setTaxAmount(po.getTaxAmount().setScale(2, 4).stripTrailingZeros());
            }
            if (po.getNotIncludingTaxAmount() != null) {
                po.setNotIncludingTaxAmount(po.getNotIncludingTaxAmount().setScale(2, 4).stripTrailingZeros());
            }
            if (po.getTax() != null) {
                po.setTax(po.getTax().setScale(2, 4).stripTrailingZeros());
            }
            log.debug("mxsj :  ------- " + po);
            this.contractInfoItemTmpMapper.updateByPO(po);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u53d8\u66f4\u4fee\u6539\u6210\u529f\uff01");
        return rspBO;
    }

    @Override
    public ContractItemChangeUpdateAbilityRspBO updateContractChangeItemBatchDate(ContractItemBatchUpdateDateAbilityReqBO reqBO) {
        ContractItemChangeUpdateAbilityRspBO rspBO = new ContractItemChangeUpdateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ContractInfoChangeItemPO contractInfoChangeItemPO = new ContractInfoChangeItemPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)contractInfoChangeItemPO);
        contractInfoChangeItemPO.setUpdateApplyId(reqBO.getContractId());
        if (contractInfoChangeItemPO.getTaxAmount() != null) {
            contractInfoChangeItemPO.setTaxAmount(contractInfoChangeItemPO.getTaxAmount().setScale(2, 4).stripTrailingZeros());
        }
        if (contractInfoChangeItemPO.getNotIncludingTaxAmount() != null) {
            contractInfoChangeItemPO.setNotIncludingTaxAmount(contractInfoChangeItemPO.getNotIncludingTaxAmount().setScale(2, 4).stripTrailingZeros());
        }
        if (contractInfoChangeItemPO.getTax() != null) {
            contractInfoChangeItemPO.setTax(contractInfoChangeItemPO.getTax().setScale(2, 4).stripTrailingZeros());
        }
        this.contractInfoChangeItemMapper.updateByRelateId(contractInfoChangeItemPO);
        ContractInfoItemTmpPO contractInfoItemTmpPO = new ContractInfoItemTmpPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)contractInfoItemTmpPO);
        contractInfoItemTmpPO.setUpdateApplyId(reqBO.getContractId());
        if (contractInfoItemTmpPO.getTaxAmount() != null) {
            contractInfoItemTmpPO.setTaxAmount(contractInfoItemTmpPO.getTaxAmount().setScale(2, 4).stripTrailingZeros());
        }
        if (contractInfoItemTmpPO.getNotIncludingTaxAmount() != null) {
            contractInfoItemTmpPO.setNotIncludingTaxAmount(contractInfoItemTmpPO.getNotIncludingTaxAmount().setScale(2, 4).stripTrailingZeros());
        }
        if (contractInfoItemTmpPO.getTax() != null) {
            contractInfoItemTmpPO.setTax(contractInfoItemTmpPO.getTax().setScale(2, 4).stripTrailingZeros());
        }
        this.contractInfoItemTmpMapper.updateItemTmpByRelateId(contractInfoItemTmpPO);
        return rspBO;
    }

    private ContractInfoItemTmpPO getContractInfoItemTmpPO(ContractItemChangeAbilityBO x) {
        ContractInfoItemTmpPO contractInfoItemTmpPO = (ContractInfoItemTmpPO)JSON.parseObject((String)JSON.toJSONString((Object)x), ContractInfoItemTmpPO.class);
        contractInfoItemTmpPO.setDelFlag("0");
        if (null != x.getAmount()) {
            contractInfoItemTmpPO.setAmount(x.getAmount());
        }
        if (null != x.getUnitPrice()) {
            contractInfoItemTmpPO.setUnitPrice(x.getUnitPrice());
        }
        if (null != x.getTotalAmount()) {
            contractInfoItemTmpPO.setTotalAmount(x.getTotalAmount());
        }
        if (null != x.getTaxAmount()) {
            contractInfoItemTmpPO.setTaxAmount(x.getTaxAmount());
        }
        if (null != x.getTaxUnitPrice()) {
            contractInfoItemTmpPO.setTaxUnitPrice(x.getTaxUnitPrice());
        }
        if (null != x.getTax()) {
            contractInfoItemTmpPO.setTax(x.getTax());
        }
        if (null != x.getUnitPriceExcludingTax()) {
            contractInfoItemTmpPO.setUnitPriceExcludingTax(x.getUnitPriceExcludingTax());
        }
        if (null != x.getNotIncludingTaxAmount()) {
            contractInfoItemTmpPO.setNotIncludingTaxAmount(x.getNotIncludingTaxAmount());
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (!StringUtils.isEmpty((Object)x.getUpdateTime())) {
                contractInfoItemTmpPO.setUpdateTime(simpleDateFormat.parse(x.getUpdateTime()));
            }
            if (!StringUtils.isEmpty((Object)x.getNeedArriveTime())) {
                contractInfoItemTmpPO.setNeedArriveTime(simpleDateFormat.parse(x.getNeedArriveTime()));
            }
            if (!StringUtils.isEmpty((Object)x.getCreateTime())) {
                contractInfoItemTmpPO.setCreateTime(simpleDateFormat.parse(x.getCreateTime()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contractInfoItemTmpPO;
    }
}

