/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.busi.ContractItemDeleteBusiService;
import com.tydic.contract.busi.bo.ContractItemDeleteBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemDeleteBusiRspBO;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ContractItemDeleteBusiServiceImpl
implements ContractItemDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemDeleteBusiServiceImpl.class);
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;

    @Override
    public ContractItemDeleteBusiRspBO contractItemDelete(ContractItemDeleteBusiReqBO reqBO) {
        ContractItemDeleteBusiRspBO contractItemDeleteBusiRspBO = new ContractItemDeleteBusiRspBO();
        if (reqBO.getContractDetailList() == null || reqBO.getContractDetailList().size() < 1) {
            contractItemDeleteBusiRspBO.setRespCode("8888");
            contractItemDeleteBusiRspBO.setRespDesc("\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff01");
            return contractItemDeleteBusiRspBO;
        }
        for (ContractItemAbilityBO temp : reqBO.getContractDetailList()) {
            if (temp.getItemId() == null) {
                contractItemDeleteBusiRspBO.setRespCode("8888");
                contractItemDeleteBusiRspBO.setRespDesc("\u660e\u7ec6Id\u4e3a\u7a7a\uff01");
                return contractItemDeleteBusiRspBO;
            }
            int flag = this.contractInfoItemMapper.deleteByPrimaryKey(temp.getItemId());
            if (flag >= 1) continue;
            contractItemDeleteBusiRspBO.setRespCode("8888");
            contractItemDeleteBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5220\u9664\u5931\u8d25\uff01");
            return contractItemDeleteBusiRspBO;
        }
        contractItemDeleteBusiRspBO.setRespCode("0000");
        contractItemDeleteBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5220\u9664\u6210\u529f\uff01");
        return contractItemDeleteBusiRspBO;
    }

    @Override
    public ContractItemDeleteBusiRspBO contractItemDeleteTmp(ContractItemDeleteBusiReqBO reqBO) {
        ContractItemDeleteBusiRspBO contractItemDeleteBusiRspBO = new ContractItemDeleteBusiRspBO();
        if (reqBO.getContractDetailList() == null || reqBO.getContractDetailList().size() < 1) {
            contractItemDeleteBusiRspBO.setRespCode("8888");
            contractItemDeleteBusiRspBO.setRespDesc("\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a\uff01");
            return contractItemDeleteBusiRspBO;
        }
        for (ContractItemAbilityBO temp : reqBO.getContractDetailList()) {
            if (temp.getItemId() == null) {
                contractItemDeleteBusiRspBO.setRespCode("8888");
                contractItemDeleteBusiRspBO.setRespDesc("\u660e\u7ec6\u4e34\u65f6\u8868Id\u4e3a\u7a7a\uff01");
                return contractItemDeleteBusiRspBO;
            }
            ContractInfoItemTmpPO contractInfoItemTmpPO = (ContractInfoItemTmpPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)temp), ContractInfoItemTmpPO.class);
            int flag = this.contractInfoItemTmpMapper.delete(contractInfoItemTmpPO);
            if (flag >= 1) continue;
            contractItemDeleteBusiRspBO.setRespCode("8888");
            contractItemDeleteBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5220\u9664\u5931\u8d25\uff01");
            return contractItemDeleteBusiRspBO;
        }
        contractItemDeleteBusiRspBO.setRespCode("0000");
        contractItemDeleteBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5220\u9664\u6210\u529f\uff01");
        return contractItemDeleteBusiRspBO;
    }

    @Override
    public ContractItemDeleteBusiRspBO contractItemPre(ContractItemDeleteBusiReqBO reqBO) {
        ContractItemDeleteBusiRspBO contractItemDeleteBusiRspBO = new ContractItemDeleteBusiRspBO();
        if (reqBO.getContractDetailList() == null || reqBO.getContractDetailList().get(0).getRelateId() == null) {
            contractItemDeleteBusiRspBO.setRespCode("8888");
            contractItemDeleteBusiRspBO.setRespDesc("\u5408\u540cid\u4e3a\u7a7a\uff01");
            return contractItemDeleteBusiRspBO;
        }
        int flag = this.contractInfoItemTmpMapper.contractItemPre(reqBO.getContractDetailList().get(0).getRelateId());
        contractItemDeleteBusiRspBO.setRespCode("0000");
        contractItemDeleteBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u9884\u5904\u7406\u6210\u529f\uff01");
        return contractItemDeleteBusiRspBO;
    }
}

