/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.contract.ability.bo.ContractTemplateApplyOrgInfoBO;
import com.tydic.contract.ability.bo.ContractTemplateInfoBO;
import com.tydic.contract.ability.bo.ContractTermsInfoBO;
import com.tydic.contract.busi.ContractQryTermsListBusiService;
import com.tydic.contract.busi.bo.ContractQryTermsListBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryTermsListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractRelOrgMapper;
import com.tydic.contract.dao.CContractTemplateTermParamItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractTemplateMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.CContractRelOrgPO;
import com.tydic.contract.po.CContractTemplateTermParamItemPO;
import com.tydic.contract.po.ContractTemplatePo;
import com.tydic.contract.po.ContractTermsPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.umc.general.ability.api.DycUmcQueryBuyerPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractQryTermsListBusiServiceImpl
implements ContractQryTermsListBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryTermsListBusiServiceImpl.class);
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    private DycUmcQueryBuyerPermissionService dycUmcQueryBuyerPermissionService;
    @Autowired
    private CContractRelOrgMapper cContractRelOrgMapper;
    @Autowired
    private ContractTemplateMapper contractTemplateMapper;
    @Value(value="${CONTRACT_QRY_ALL_TERMS_ROLE}")
    private String contractQryAllTermsRole;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    CContractTemplateTermParamItemMapper cContractTemplateTermParamItemMapper;

    @Override
    public ContractQryTermsListBusiRspBO qryTermsList(ContractQryTermsListBusiReqBO reqBO) {
        ContractQryTermsListBusiRspBO rspBO = new ContractQryTermsListBusiRspBO();
        ContractTermsPo po = new ContractTermsPo();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)po));
        if (StringUtils.isEmpty((Object)reqBO.getOrgCodeIn())) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setTotal(0);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u7528\u6237\u7684\u673a\u6784\u7f16\u7801\u4e3a\u7a7a");
            return rspBO;
        }
        po.setSearchCreateDeptCode(reqBO.getOrgCodeIn());
        if (!(StringUtils.isEmpty((Object)reqBO.getIsClause()) || "1".equals(reqBO.getIsClause()) || StringUtils.isEmpty((Object)reqBO.getOccupation()))) {
            DycUmcQueryBuyerPermissionReqBo dycUmcQueryBuyerPermissionReqBo = new DycUmcQueryBuyerPermissionReqBo();
            dycUmcQueryBuyerPermissionReqBo.setErpCode(reqBO.getOccupation());
            DycUmcQueryBuyerPermissionRspBo dycUmcQueryBuyerPermissionRspBo = this.dycUmcQueryBuyerPermissionService.queryBuyerPermission(dycUmcQueryBuyerPermissionReqBo);
            if ("0000".equals(dycUmcQueryBuyerPermissionRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)dycUmcQueryBuyerPermissionRspBo.getRows())) {
                List<String> buyerNos = dycUmcQueryBuyerPermissionRspBo.getRows().stream().filter(e -> !StringUtils.isEmpty((Object)e.getOrgCode())).map(e -> e.getOrgCode()).collect(Collectors.toList());
                log.info("\u4e70\u53d7\u4eba" + buyerNos);
                po.setBuyerNos(buyerNos);
            }
        }
        String roleCode = "";
        if (!StringUtils.isEmpty((Object)this.contractQryAllTermsRole)) {
            roleCode = this.contractQryAllTermsRole;
        }
        if (!StringUtils.isEmpty((Object)roleCode) && reqBO.getAuthPermission().contains(roleCode)) {
            po.setSearchCreateDeptCode(null);
        }
        if (reqBO.getIsTemplateDetailQry() != null && reqBO.getIsTemplateDetailQry() == 1) {
            po.setSearchCreateDeptCode(null);
        }
        po.setOrgIds(null);
        po.setCreateUserId(reqBO.getUserId());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractTermsMapper.qryContractTermsList2(po));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)page.getResult())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u6761\u6b3e\u5217\u8868\u67e5\u8be2\u6210\u529f");
            List<ContractTermsInfoBO> rows = this.transResultData(page.getResult());
            Map<Object, Object> termIdRelOrgMap = new HashMap();
            Map<Object, Object> termIdRelTemplateMap = new HashMap();
            Set<Object> qryTemplateCodes = new HashSet();
            ArrayList existRelTemplateCodes = new ArrayList();
            List<Object> existReltermIds = new ArrayList();
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(rows)) {
                List<CContractTemplateTermParamItemPO> cContractTemplateTermParamItemPOS;
                List<ContractTemplatePo> templatePos;
                List<Long> termIds = rows.stream().map(ContractTermsInfoBO::getTermId).collect(Collectors.toList());
                List<CContractRelOrgPO> contractRelOrgPOS = this.cContractRelOrgMapper.getListByTermIds(termIds);
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(contractRelOrgPOS)) {
                    termIdRelOrgMap = contractRelOrgPOS.stream().collect(Collectors.groupingBy(CContractRelOrgPO::getRelateId));
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(templatePos = this.contractTemplateMapper.getListByTermIds(termIds))) {
                    termIdRelTemplateMap = templatePos.stream().collect(Collectors.groupingBy(ContractTemplatePo::getTermId));
                    qryTemplateCodes = templatePos.stream().filter(e -> !StringUtils.isEmpty((Object)e.getTemplateCode())).map(ContractTemplatePo::getTemplateCode).collect(Collectors.toSet());
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(cContractTemplateTermParamItemPOS = this.cContractTemplateTermParamItemMapper.getListByTermIds(termIds))) {
                    existReltermIds = cContractTemplateTermParamItemPOS.stream().filter(e -> e.getTermId() != null).map(CContractTemplateTermParamItemPO::getTermId).collect(Collectors.toList());
                }
            }
            for (ContractTermsInfoBO bo : rows) {
                if (bo.getCreateDeptId() != null && bo.getCreateDeptId().equals(reqBO.getCurrentOrgId())) {
                    bo.setIsCurrentData(Boolean.valueOf(true));
                } else {
                    bo.setIsCurrentData(Boolean.valueOf(false));
                }
                if (bo.getValidStatus() != null) {
                    bo.setValidStatusStr(ContractTransFieldUtil.transContractTermsValidStatus(bo.getValidStatus()));
                }
                if (termIdRelOrgMap.containsKey(bo.getTermId())) {
                    ArrayList<ContractTemplateApplyOrgInfoBO> orgInfos = new ArrayList<ContractTemplateApplyOrgInfoBO>();
                    for (CContractRelOrgPO orgPO : (List)termIdRelOrgMap.get(bo.getTermId())) {
                        ContractTemplateApplyOrgInfoBO orgInfoBO = new ContractTemplateApplyOrgInfoBO();
                        orgInfoBO.setOrgId(orgPO.getApplyDeptId());
                        orgInfoBO.setOrgCode(orgPO.getApplyDeptCode());
                        orgInfoBO.setOrgName(orgPO.getApplyDeptName());
                        orgInfos.add(orgInfoBO);
                    }
                    bo.setOrgInfos(orgInfos);
                }
                if (existReltermIds.contains(bo.getTermId())) {
                    bo.setIsQuote(Integer.valueOf(1));
                }
                if (termIdRelTemplateMap.containsKey(bo.getTermId())) {
                    List templateInfos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)termIdRelTemplateMap.get(bo.getTermId())), ContractTemplateInfoBO.class);
                    bo.setTemplateInfos(templateInfos);
                }
                if (!StringUtils.isEmpty((Object)bo.getCreateUserCode())) {
                    bo.setExportCreateUserName(bo.getCreateUserCode() + "-" + bo.getCreateUserName());
                    continue;
                }
                bo.setExportCreateUserName(bo.getCreateUserName());
            }
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNum());
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return rspBO;
    }

    private List<ContractTermsInfoBO> transResultData(List<ContractTermsPo> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractTermsInfoBO.class);
        for (ContractTermsInfoBO contractTermsInfoBO : rows) {
            if (ContractConstant.TermType.TERM_TYPE_AGREE_CODE.equals(contractTermsInfoBO.getTermType())) {
                contractTermsInfoBO.setTermTypeStr("\u534f\u8bae\u5408\u540c");
                continue;
            }
            if (ContractConstant.TermType.TERM_TYPE_ORDER_CODE.equals(contractTermsInfoBO.getTermType())) {
                contractTermsInfoBO.setTermTypeStr("\u8ba2\u5355\u5408\u540c");
                continue;
            }
            if (ContractConstant.TermType.TERM_TYPE_ENTRY_CODE.equals(contractTermsInfoBO.getTermType())) {
                contractTermsInfoBO.setTermTypeStr("\u5165\u9a7b\u5408\u540c");
                continue;
            }
            contractTermsInfoBO.setTermTypeStr("\u9519\u8bef\u7684\u6761\u6b3e\u7c7b\u578b");
        }
        return rows;
    }
}

