/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractSaveStockChangeReqBo;
import com.tydic.contract.ability.bo.ContractSaveStockChangeRspBo;
import com.tydic.contract.busi.ContractSaveStockChangeBusiService;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractStockChangeItemMapper;
import com.tydic.contract.dao.CContractStockChangeMapper;
import com.tydic.contract.dao.CContractStockTempMapper;
import com.tydic.contract.po.CContractStockChangeItemPO;
import com.tydic.contract.po.CContractStockChangePO;
import com.tydic.contract.po.CContractStockTempPO;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractSaveStockChangeBusiServiceImpl
implements ContractSaveStockChangeBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractSaveStockChangeBusiServiceImpl.class);
    @Autowired
    private CContractStockTempMapper cContractStockTempMapper;
    @Autowired
    private CContractStockChangeMapper cContractStockChangeMapper;
    @Autowired
    private CContractStockChangeItemMapper cContractStockChangeItemMapper;

    @Override
    public ContractSaveStockChangeRspBo saveStockChange(ContractSaveStockChangeReqBo reqBo) {
        CContractStockTempPO searchPO = new CContractStockTempPO();
        searchPO.setTempId(reqBo.getTempId());
        List<CContractStockTempPO> stockTempPOS = this.cContractStockTempMapper.queryAll(searchPO);
        if (CollectionUtils.isEmpty(stockTempPOS)) {
            throw new ZTBusinessException("\u4e34\u65f6\u8868\u6570\u636e\u4e0d\u5b58\u5728");
        }
        HashSet<String> failMaterialCodeSet = new HashSet<String>();
        for (CContractStockTempPO stockTempPO : stockTempPOS) {
            if (stockTempPO.getSafeNum() != null && stockTempPO.getLimitNum() != null) continue;
            failMaterialCodeSet.add(stockTempPO.getMaterialCode());
        }
        if (!CollectionUtils.isEmpty(failMaterialCodeSet)) {
            throw new ZTBusinessException("\u7269\u6599\u7f16\u7801\uff1a" + String.join((CharSequence)",", failMaterialCodeSet) + "\u5b89\u5168\u5e93\u5b58\u548c\u50a8\u5907\u4e0a\u9650\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer maxNumber = this.cContractStockChangeMapper.queryMaxNumberByContractId(reqBo.getContractId());
        if (maxNumber == null) {
            maxNumber = 0;
        }
        Date nowDate = new Date();
        CContractStockChangePO stockChangePO = (CContractStockChangePO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBo), CContractStockChangePO.class);
        stockChangePO.setId(reqBo.getTempId());
        maxNumber = maxNumber + 1;
        stockChangePO.setNumber(maxNumber);
        stockChangePO.setCreateUserName(reqBo.getName());
        stockChangePO.setCreateUserId(reqBo.getUserId());
        stockChangePO.setCreateTime(nowDate);
        stockChangePO.setChangeTime(nowDate);
        stockChangePO.setCreateUserCode(reqBo.getUsername());
        stockChangePO.setIsDelete(ContractConstant.IsDeleteFlag.EXIST);
        this.cContractStockChangeMapper.insert(stockChangePO);
        List changeItemPOS = JSONObject.parseArray((String)JSONObject.toJSONString(stockTempPOS), CContractStockChangeItemPO.class);
        changeItemPOS.stream().forEach(e -> e.setChangeId(reqBo.getTempId()));
        int count = this.cContractStockChangeItemMapper.insertBatch(changeItemPOS);
        if (count == 0) {
            throw new ZTBusinessException("\u5b89\u5168\u5e93\u5b58\u8bbe\u7f6e\u63d0\u4ea4\u5931\u8d25");
        }
        ContractSaveStockChangeRspBo rspBo = new ContractSaveStockChangeRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

