/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractSaveStockTempReqBo;
import com.tydic.contract.ability.bo.ContractSaveStockTempReqBoMaterialList;
import com.tydic.contract.ability.bo.ContractSaveStockTempRspBo;
import com.tydic.contract.busi.ContractSaveStockTempBusiService;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractBuyerRelStockInitMapper;
import com.tydic.contract.dao.CContractStockChangeItemMapper;
import com.tydic.contract.dao.CContractStockChangeMapper;
import com.tydic.contract.dao.CContractStockTempMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractBuyerRelStockInitPO;
import com.tydic.contract.po.CContractStockChangeItemPO;
import com.tydic.contract.po.CContractStockChangePO;
import com.tydic.contract.po.CContractStockTempPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.umc.general.ability.api.UmcEnterpriseQryListAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseQryListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractSaveStockTempBusiServiceImpl
implements ContractSaveStockTempBusiService {
    @Autowired
    private CContractStockTempMapper cContractStockTempMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private CContractBuyerRelStockInitMapper cContractBuyerRelStockInitMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private UmcEnterpriseQryListAbilityService umcEnterpriseQryListAbilityService;
    @Autowired
    private CContractStockChangeMapper cContractStockChangeMapper;
    @Autowired
    private CContractStockChangeItemMapper cContractStockChangeItemMapper;

    @Override
    public ContractSaveStockTempRspBo saveStockTemp(ContractSaveStockTempReqBo reqBO) {
        ContractSaveStockTempRspBo rspBo = new ContractSaveStockTempRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (reqBO.getIsQryAllAdd() != null && reqBO.getIsQryAllAdd() == 1) {
            this.initTemp(reqBO);
        } else {
            List<Long> itemIds = reqBO.getMaterialList().stream().map(ContractSaveStockTempReqBoMaterialList::getItemId).collect(Collectors.toList());
            CContractStockTempPO searchPO = new CContractStockTempPO();
            searchPO.setTempId(reqBO.getTempId());
            searchPO.setItemIds(itemIds);
            List<CContractStockTempPO> stockTempPOS = this.cContractStockTempMapper.queryAll(searchPO);
            if (!CollectionUtils.isEmpty(stockTempPOS)) {
                ArrayList<CContractStockTempPO> updateStockTempPOS = new ArrayList<CContractStockTempPO>();
                Map<Long, List<ContractSaveStockTempReqBoMaterialList>> itemIdMap = reqBO.getMaterialList().stream().collect(Collectors.groupingBy(ContractSaveStockTempReqBoMaterialList::getItemId));
                for (CContractStockTempPO po : stockTempPOS) {
                    if (!itemIdMap.containsKey(po.getItemId())) continue;
                    ContractSaveStockTempReqBoMaterialList materialList = itemIdMap.get(po.getItemId()).get(0);
                    CContractStockTempPO updatePO = new CContractStockTempPO();
                    updatePO.setId(po.getId());
                    updatePO.setSafeNum(materialList.getSafeNum());
                    updatePO.setLimitNum(materialList.getLimitNum());
                    updateStockTempPOS.add(updatePO);
                }
                if (!CollectionUtils.isEmpty(updateStockTempPOS)) {
                    this.cContractStockTempMapper.updateBatch(updateStockTempPOS);
                }
            } else {
                throw new ZTBusinessException("\u4e34\u65f6\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u4fee\u6539");
            }
        }
        return rspBo;
    }

    private void initTemp(ContractSaveStockTempReqBo reqBO) {
        CContractStockTempPO searchPO = new CContractStockTempPO();
        searchPO.setTempId(reqBO.getTempId());
        Integer countSize = this.cContractStockTempMapper.queryCount(searchPO);
        if (countSize != null && countSize > 0) {
            return;
        }
        List<ContractInfoItemPO> itemPOS = this.contractInfoItemMapper.getItemsByRelId(reqBO.getContractId());
        if (CollectionUtils.isEmpty(itemPOS)) {
            throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u6570\u636e\u4e0d\u5b58\u5728");
        }
        String purchaseOrgId = null;
        String supplierCode = null;
        ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractInfoPO == null) {
            throw new ZTBusinessException("\u5408\u540c\u4e0d\u5b58\u5728");
        }
        if (!ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType())) {
            throw new ZTBusinessException("\u8be5\u5408\u540c\u7c7b\u578b\u4e0d\u652f\u6301\u5b89\u5168\u5e93\u5b58\u7ba1\u7406");
        }
        if (StringUtils.isEmpty((Object)contractInfoPO.getBuyerNo())) {
            throw new ZTBusinessException("\u4e70\u53d7\u4eba\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)contractInfoPO.getSupplierId())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)contractInfoPO.getSupplierAddressAliasId())) {
            throw new ZTBusinessException("\u60a8\u9009\u62e9\u7684\u5408\u540c\u6ca1\u6709\u7ef4\u62a4\u5730\u5740\u7b80\u79f0\uff0c\u8bf7\u5148\u7ef4\u62a4\u76f8\u5173\u4fe1\u606f\u540e\u518d\u8fdb\u884c\u5b89\u5168\u5e93\u5b58\u4fe1\u606f\u7ef4\u62a4\uff01");
        }
        ArrayList<String> buyerNoList = new ArrayList<String>();
        buyerNoList.add(contractInfoPO.getBuyerNo());
        ArrayList<Long> supplierIdList = new ArrayList<Long>();
        supplierIdList.add(contractInfoPO.getSupplierId());
        UmcEnterpriseQryListAbilityReqBO abilityReqBO = new UmcEnterpriseQryListAbilityReqBO();
        abilityReqBO.setOrgCodeWebList(buyerNoList);
        abilityReqBO.setOrgIdWebList(supplierIdList);
        UmcEnterpriseQryListAbilityRspBO abilityRspBO = this.umcEnterpriseQryListAbilityService.qryList(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2erp\u7f16\u7801\u4fe1\u606f\u5931\u8d25" + abilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
            throw new ZTBusinessException("\u67e5\u8be2erp\u7f16\u7801\u4fe1\u606f\u7ed3\u679c\u4e3a\u7a7a");
        }
        Map<Long, UmcEnterpriseOrgDetailBO> orgIdMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getOrgId, o -> o));
        Map<String, UmcEnterpriseOrgDetailBO> orgCodeMap = abilityRspBO.getRows().stream().collect(Collectors.toMap(UmcEnterpriseOrgDetailBO::getOrgCode, o -> o));
        if (orgIdMap.containsKey(contractInfoPO.getSupplierId())) {
            supplierCode = orgIdMap.get(contractInfoPO.getSupplierId()).getErpOrgCode();
        }
        if (StringUtils.isEmpty(supplierCode)) {
            throw new ZTBusinessException("\u5408\u540c\u4f9b\u5e94\u5546\u673a\u6784\u4fe1\u606f\u672a\u5b58\u5728erp\u5355\u4f4d\u7f16\u7801\u8bf7\u8054\u7cfb\u7ef4\u62a4");
        }
        if (orgCodeMap.containsKey(contractInfoPO.getBuyerNo())) {
            purchaseOrgId = orgCodeMap.get(contractInfoPO.getBuyerNo()).getErpOrgCode();
        }
        if (StringUtils.isEmpty(purchaseOrgId)) {
            throw new ZTBusinessException("\u5408\u540c\u4e70\u53d7\u4eba\u673a\u6784\u4fe1\u606f\u672a\u5b58\u5728erp\u5355\u4f4d\u7f16\u7801\u8bf7\u8054\u7cfb\u7ef4\u62a4");
        }
        List<CContractBuyerRelStockInitPO> buyerRelStockInitPOS = this.cContractBuyerRelStockInitMapper.selectListByBuyerNo(contractInfoPO.getBuyerNo());
        if (CollectionUtils.isEmpty(buyerRelStockInitPOS)) {
            throw new ZTBusinessException("\u5408\u540c\u4e70\u53d7\u4eba\u672a\u5b58\u5728\u5e93\u623f\u4fe1\u606f\u8bf7\u8054\u7cfb\u7ef4\u62a4");
        }
        CContractBuyerRelStockInitPO buyerRelStockInitPO = buyerRelStockInitPOS.get(0);
        Date nowDate = new Date();
        Map<Object, Object> lastChangeItemMap = new HashMap();
        Long lastChangeId = null;
        Integer lastNowNumber = null;
        Integer maxNumber = this.cContractStockChangeMapper.queryMaxNumberByContractId(reqBO.getContractId());
        if (maxNumber != null) {
            lastNowNumber = maxNumber;
            CContractStockChangePO searchLastStockChangePO = new CContractStockChangePO();
            searchLastStockChangePO.setContractId(reqBO.getContractId());
            searchLastStockChangePO.setNumber(lastNowNumber);
            List<CContractStockChangePO> lastStockChangePOS = this.cContractStockChangeMapper.queryAll(searchLastStockChangePO);
            if (!CollectionUtils.isEmpty((Collection)lastStockChangePOS)) {
                lastChangeId = ((CContractStockChangePO)lastStockChangePOS.get(0)).getId();
                CContractStockChangeItemPO searchLastStockChangeItemPO = new CContractStockChangeItemPO();
                searchLastStockChangeItemPO.setChangeId(lastChangeId);
                List<CContractStockChangeItemPO> lastChangeItemPOS = this.cContractStockChangeItemMapper.queryAll(searchLastStockChangeItemPO);
                if (!CollectionUtils.isEmpty(lastChangeItemPOS)) {
                    lastChangeItemMap = lastChangeItemPOS.stream().collect(Collectors.groupingBy(CContractStockChangeItemPO::getItemId));
                }
            }
        }
        if (!CollectionUtils.isEmpty(itemPOS)) {
            ArrayList<CContractStockTempPO> addStockTempPOS = new ArrayList<CContractStockTempPO>();
            for (ContractInfoItemPO itemPO : itemPOS) {
                List lastChangeItemPOList;
                CContractStockTempPO addPO = (CContractStockTempPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)itemPO), CContractStockTempPO.class);
                addPO.setId(this.uccBatchSequence.nextId());
                addPO.setContractId(reqBO.getContractId());
                addPO.setTempId(reqBO.getTempId());
                addPO.setItemId(itemPO.getItemId());
                addPO.setUnit(itemPO.getUnitName());
                addPO.setNum(itemPO.getAmount());
                if (itemPO.getSaleStatus() != null) {
                    addPO.setStatus(ContractTransFieldUtil.transSaleStatus(itemPO.getSaleStatus()));
                }
                addPO.setErpOrgId(purchaseOrgId);
                addPO.setErpOrgName(contractInfoPO.getBuyerName());
                addPO.setSupplierCode(supplierCode);
                addPO.setSupplierName(contractInfoPO.getSupplierName());
                addPO.setWarehouseId(buyerRelStockInitPO.getWarehouseId());
                addPO.setWarehouseCode(buyerRelStockInitPO.getWarehouseCode());
                addPO.setWarehouseName(buyerRelStockInitPO.getWarehouseName());
                addPO.setWarehouseAddress(buyerRelStockInitPO.getWarehouseAddress());
                if (lastChangeItemMap.containsKey(addPO.getItemId()) && !CollectionUtils.isEmpty((Collection)(lastChangeItemPOList = (List)lastChangeItemMap.get(addPO.getItemId())))) {
                    CContractStockChangeItemPO lastChangeItemPO = (CContractStockChangeItemPO)lastChangeItemPOList.get(0);
                    addPO.setSafeNum(lastChangeItemPO.getSafeNum());
                    addPO.setLimitNum(lastChangeItemPO.getLimitNum());
                }
                addPO.setExecutionStandard(itemPO.getExecutionStandard());
                addPO.setBrandOrigin(itemPO.getBrandOrigin());
                addPO.setCreateTime(nowDate);
                addPO.setIsDelete(ContractConstant.IsDeleteFlag.EXIST);
                addStockTempPOS.add(addPO);
            }
            int count = this.cContractStockTempMapper.insertBatch(addStockTempPOS);
            if (count == 0) {
                throw new ZTBusinessException("\u6dfb\u52a0\u6570\u636e\u5931\u8d25");
            }
        }
    }
}

