/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.contract.ability.bo.ContractTemplateApplyOrgInfoBO;
import com.tydic.contract.ability.bo.ContractTemplateInfoBO;
import com.tydic.contract.busi.QueryContractTemplateListBusiService;
import com.tydic.contract.busi.bo.QueryContractTemplateListBusiReqBO;
import com.tydic.contract.busi.bo.QueryContractTemplateListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractTemplateApplyUnitMapper;
import com.tydic.contract.dao.ContractTemplateMapper;
import com.tydic.contract.po.ContractTemplateAndApplyUnitPo;
import com.tydic.contract.po.ContractTemplateApplyUnitPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class QueryContractTemplateListBusiServiceImpl
implements QueryContractTemplateListBusiService {
    private static final Logger log = LoggerFactory.getLogger(QueryContractTemplateListBusiServiceImpl.class);
    @Autowired
    private ContractTemplateMapper contractTemplateMapper;
    private static final String CREATE_TIME = "CREATE_TIME";
    private static final String UPDATE_TIME = "UPDATE_TIME";
    @Autowired
    private ContractTemplateApplyUnitMapper contractTemplateApplyUnitMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Value(value="${CONTRACT_QRY_ALL_TERMS_ROLE}")
    private String contractQryAllTermsRole;

    @Override
    public QueryContractTemplateListBusiRspBO queryContractTemplateList(QueryContractTemplateListBusiReqBO reqBO) {
        log.info("\u6309\u7167\u521b\u5efa\u65f6\u95f4\u5012\u5e8f\u6392\u5e8f*****\u5165\u53c2" + (Object)((Object)reqBO));
        QueryContractTemplateListBusiRspBO rspBO = new QueryContractTemplateListBusiRspBO();
        ContractTemplateAndApplyUnitPo queryContractTemplateAndApplyUnitPo = new ContractTemplateAndApplyUnitPo();
        if (reqBO.getOrgIdWeb() != null) {
            reqBO.setOrgIdWebShow(reqBO.getOrgIdWeb());
            reqBO.setOrgIdWeb(null);
        }
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryContractTemplateAndApplyUnitPo);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getOrderField())) {
            queryContractTemplateAndApplyUnitPo.setOrderField(CREATE_TIME);
        } else {
            if (reqBO.getOrderField().equals("CT")) {
                queryContractTemplateAndApplyUnitPo.setOrderField(CREATE_TIME);
            }
            if (reqBO.getOrderField().equals("UT")) {
                queryContractTemplateAndApplyUnitPo.setOrderField(UPDATE_TIME);
            }
        }
        if (null != reqBO.getIsolate() && reqBO.getIsolate().equals(1)) {
            queryContractTemplateAndApplyUnitPo.setCreateDeptId(reqBO.getOrgId());
            queryContractTemplateAndApplyUnitPo.setOrgIdWeb(reqBO.getOrgId());
        }
        List<Object> pos = new ArrayList();
        try (Page page = null;){
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            String roleCode = "";
            if (!StringUtils.isEmpty((Object)this.contractQryAllTermsRole)) {
                roleCode = this.contractQryAllTermsRole;
            }
            if (!StringUtils.isEmpty((Object)roleCode) && reqBO.getAuthPermission().contains(roleCode)) {
                queryContractTemplateAndApplyUnitPo.setCreateDeptId(null);
                queryContractTemplateAndApplyUnitPo.setOrgIdWeb(null);
                queryContractTemplateAndApplyUnitPo.setOrgCodeList(null);
            }
            queryContractTemplateAndApplyUnitPo.setCreateUserId(reqBO.getUserId());
            if (reqBO.getPageNo().equals(-1)) {
                pos = this.contractTemplateMapper.qryTemplateList(queryContractTemplateAndApplyUnitPo);
            } else {
                queryContractTemplateAndApplyUnitPo.setPageOrderField(queryContractTemplateAndApplyUnitPo.getOrderField() + " desc");
                queryContractTemplateAndApplyUnitPo.setOrderField(null);
                page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize(), (String)queryContractTemplateAndApplyUnitPo.getPageOrderField()).doSelectPage(() -> this.contractTemplateMapper.qryTemplateList(queryContractTemplateAndApplyUnitPo));
                pos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)page.getResult()), ContractTemplateAndApplyUnitPo.class);
            }
        }
        if (!CollectionUtils.isEmpty(pos)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u6a21\u677f\u5217\u8868\u67e5\u8be2\u6210\u529f");
            List<String> collect = pos.stream().map(ContractTemplateAndApplyUnitPo::getTemplateCode).collect(Collectors.toList());
            Map<Object, Object> poMap = new HashMap();
            List<ContractTemplateApplyUnitPo> applyUnitPos = this.contractTemplateApplyUnitMapper.getListByTemplateCode(collect);
            if (!CollectionUtils.isEmpty(applyUnitPos)) {
                poMap = applyUnitPos.stream().collect(Collectors.groupingBy(ContractTemplateApplyUnitPo::getTemplateCode));
                for (ContractTemplateAndApplyUnitPo contractTemplateAndApplyUnitPo : pos) {
                    if (!poMap.containsKey(contractTemplateAndApplyUnitPo.getTemplateCode())) continue;
                    List templateInfos = JSONObject.parseArray((String)JSONObject.toJSONString((Object)poMap.get(contractTemplateAndApplyUnitPo.getTemplateCode())), ContractTemplateApplyOrgInfoBO.class);
                    contractTemplateAndApplyUnitPo.setOrgInfoBOList(templateInfos);
                }
            }
            List<ContractTemplateInfoBO> rows = this.transResultData(pos);
            for (ContractTemplateInfoBO bo : rows) {
                if (bo.getCreateDeptId().equals(reqBO.getCurrentOrgId())) {
                    bo.setIsCurrentData(Boolean.valueOf(true));
                } else {
                    bo.setIsCurrentData(Boolean.valueOf(false));
                }
                Integer check = this.contractInfoMapper.checkByTemplateCode(bo.getTemplateCode());
                if (check != null && check > 0) {
                    bo.setIsQuote(Integer.valueOf(1));
                    continue;
                }
                bo.setIsQuote(Integer.valueOf(0));
            }
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNum());
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return rspBO;
    }

    private List<ContractTemplateInfoBO> transResultData(List<ContractTemplateAndApplyUnitPo> list) {
        ArrayList<ContractTemplateInfoBO> rows = new ArrayList<ContractTemplateInfoBO>();
        for (ContractTemplateAndApplyUnitPo po : list) {
            ContractTemplateInfoBO contractTemplateInfoBO = new ContractTemplateInfoBO();
            BeanUtils.copyProperties((Object)po, (Object)contractTemplateInfoBO);
            if (po.getTemplateUnitId() != null) {
                ContractTemplateApplyOrgInfoBO contractTemplateApplyOrgInfoBO = new ContractTemplateApplyOrgInfoBO();
                contractTemplateApplyOrgInfoBO.setTemplateUnitId(po.getTemplateUnitId());
                contractTemplateApplyOrgInfoBO.setOrgId(po.getOrgId());
                contractTemplateApplyOrgInfoBO.setOrgCode(po.getOrgCode());
                contractTemplateApplyOrgInfoBO.setOrgName(po.getOrgName());
                contractTemplateApplyOrgInfoBO.setOrgCertificateCode(po.getOrgCertificateCode());
                contractTemplateInfoBO.setOrgInfo(contractTemplateApplyOrgInfoBO);
            }
            if (contractTemplateInfoBO.getTemplateType() != null) {
                contractTemplateInfoBO.setTemplateTypeStr(ContractTransFieldUtil.transTemplateType(contractTemplateInfoBO.getTemplateType()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)contractTemplateInfoBO.getOrgType())) {
                contractTemplateInfoBO.setOrgTypeStr(ContractTransFieldUtil.transOrgType(contractTemplateInfoBO.getOrgType()));
            }
            if (contractTemplateInfoBO.getValidStatus() != null) {
                contractTemplateInfoBO.setValidStatusStr(ContractTransFieldUtil.transContractTemplateValidStatus(contractTemplateInfoBO.getValidStatus()));
            }
            if (contractTemplateInfoBO.getPurpose() != null) {
                contractTemplateInfoBO.setPurposeStr(ContractTransFieldUtil.transContractTemplatePurpose(contractTemplateInfoBO.getPurpose()));
            }
            if (contractTemplateInfoBO.getPertainLevel() != null) {
                contractTemplateInfoBO.setPertainLevelStr(ContractConstant.PertainLevelEnum.getValueByCode(contractTemplateInfoBO.getPertainLevel()));
            }
            if (contractTemplateInfoBO.getPertainBusinessCategory() != null) {
                if (contractTemplateInfoBO.getPertainLevel() != null && contractTemplateInfoBO.getPertainLevel().equals(2)) {
                    contractTemplateInfoBO.setPertainBusinessCategoryStr(ContractConstant.PertainLevelByEnterpriseEnum.getValueByCode(contractTemplateInfoBO.getPertainBusinessCategory()));
                } else {
                    contractTemplateInfoBO.setPertainBusinessCategoryStr(ContractConstant.ContractModelBusinessCategoryEnum.getValueByCode(contractTemplateInfoBO.getPertainBusinessCategory()));
                }
            }
            rows.add(contractTemplateInfoBO);
        }
        return rows;
    }
}

