/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.constant;

import com.google.common.collect.Lists;
import java.util.List;

public class ContractConstant {
    public static final List<Integer> purchaseContractTypeList = Lists.newArrayList((Object[])new Integer[]{11, 12, 13, 20, 21});
    public static final int showUnitPirceDecimalPlace = 8;
    public static final int showTotalPirceDecimalPlace = 2;
    public static final String DIC_EXCEPTION = "163033";

    public static final class PaymentType {
        public static final String YINGFK = "YINGFK";
        public static final String YUFK = "YUFK";
        public static final String ZBJ = "ZBJ";
    }

    public static final class PushStatus {
        public static final Integer SUCCESS = 0;
        public static final String SUCCESS_STR = "\u540c\u6b65\u6210\u529f";
        public static final Integer FAIL = 1;
        public static final String FAIL_STR = "\u540c\u6b65\u5931\u8d25";
    }

    public static final class ContractSource {
        public static final String YG = "\u6613\u8d2d\u7cfb\u7edf";
        public static final String HT = "\u667a\u63a7\u5408\u540c";
    }

    public static final class ContractTypeHtDesc {
        public static final String PURCHASE_SPOT_CONTRACT_DESC = "\u73b0\u8d27\u5408\u540c";
        public static final String PURCHASE_LONG_TERM_CONTRACT_DESC = "\u6846\u67b6\u534f\u8bae(\u5b9a\u4ef7)";
        public static final String PURCHASE_LONG_TERM_CONS_SALE_CONTRACT_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5bc4\u552e\uff09";
    }

    public static final class MoneyType {
        public static final Integer PRE_PAY_CODE = 0;
        public static final Integer ACCOUNT_PAY_CODE = 2;
        public static final Integer GUARANTEE_PAY_CODE = 1;
    }

    public static final class HtPanelPointCode {
        public static final String ONE = "1";
        public static final String TWO = "2";
        public static final String THREE = "3";
        public static final String FOUR = "4";
        public static final String FIVE = "5";
        public static final String SIX = "6";
        public static final String SEVEN = "7";
    }

    public static enum ContractWorkbenchEnum {
        CONTRACT_CREATE("100", "\u5408\u540c\u521b\u5efa", 1),
        CONTRACT_APPROVAL("101", "\u5408\u540c\u5ba1\u6279", 2),
        CONTRACT_EFFECTIVE("102", "\u5408\u540c\u751f\u6548", 3);

        private String code;
        private String title;
        private Integer sort;

        private ContractWorkbenchEnum(String code, String title, Integer sort) {
            this.code = code;
            this.title = title;
            this.sort = sort;
        }

        public String getCode() {
            return this.code;
        }

        public String getTitle() {
            return this.title;
        }

        public Integer getSort() {
            return this.sort;
        }
    }

    public static final class FileService {
        public static final String FILE_TYPE_FASTDFS = "FASTDFS";
        public static final String FILE_TYPE_OSS = "OSS";
        public static final String PATH = "dyc-common/";
        public static final String XLSX_SUFFIX = ".xlsx";
    }

    public static final class BatchImportUtils {
        public static final String IMPORT_RESULT = "importResult";
        public static final String FAIL_CODE = "failCode";
        public static final String FAIL_DESC = "failDesc";
        public static final String FIELD_TITLE_MAPPING_LIST = "fieldTitleMappingList";
        public static final String IMPORT_RESULT_STR = "importResultStr";
        public static final String SUCCESS_STR = "\u6210\u529f";
        public static final String FAILED_STR = "\u5931\u8d25";
        public static final String IMPORT_RESULTS_CHINESE = "\u5bfc\u5165\u7ed3\u679c";
        public static final String FAILURE_REASON_CHINESE = "\u5931\u8d25\u539f\u56e0";
    }

    public static final class IsDeleteFlag {
        public static final Integer DELETE = 1;
        public static final Integer EXIST = 0;
    }

    public static final class ContractAddHtChangeStatus {
        public static final String APPROVAL_ING = "1";
        public static final String APPROVAL_PASS = "2";
        public static final String APPROVAL_REJECT = "3";
    }

    public static final class ContractAddHtMsgStatus {
        public static final Integer FAIL = 2;
        public static final Integer OK = 1;
    }

    public static final class ContractPushWmsStatus {
        public static final Integer FAIL = 0;
        public static final Integer OK = 1;
        public static final Integer NO_PUSH = 2;
        public static final String SAFE_STOCK_IMPOR_PCODE = "SAFE_STOCK_IMPOR_PCODE";
        public static final String WMS_CODE_SUCCESS = "200";
        public static final Integer NO = 0;
        public static final Integer YES = 1;
    }

    public static final class ContractPushLogType {
        public static final Integer PUSH_WMS = 16;
    }

    public static enum PertainLevelByEnterpriseEnum {
        PertainLevelByEnterprise1(1, "\u81ea\u6709\u6a21\u677f");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (PertainLevelByEnterpriseEnum typeEnum : PertainLevelByEnterpriseEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private PertainLevelByEnterpriseEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum PertainLevelEnum {
        PertainLevel1(1, "\u96c6\u56e2\u7ea7\u7ed3\u6784\u5316\u6a21\u677f"),
        PertainLevel2(2, "\u4f01\u4e1a\u7ea7\u7ed3\u6784\u5316\u6a21\u677f");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (PertainLevelEnum typeEnum : PertainLevelEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private PertainLevelEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum ContractModelBusinessCategoryEnum {
        BusinessCategory1(1, "\u914d\u4ef6\u6216\u6750\u6599\u7c7b"),
        BusinessCategory2(2, "\u8bbe\u5907\u7c7b"),
        BusinessCategory3(3, "\u7535\u529b\u65b0\u80fd\u6e90\u7c7b"),
        BusinessCategory4(4, "\u8fdb\u53e3\u7c7b\uff08\u542b\u670d\u52a1\uff09"),
        BusinessCategory5(5, "\u6280\u672f\u670d\u52a1\u7c7b"),
        BusinessCategory6(6, "\u751f\u4ea7\u670d\u52a1\u7c7b");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (ContractModelBusinessCategoryEnum typeEnum : ContractModelBusinessCategoryEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private ContractModelBusinessCategoryEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum MaterialCategoryEnum {
        MODELSTATUS0(0, "\u672a\u8bc4\u4ef7"),
        MODELSTATUS1(1, "\u5df2\u8bc4\u4ef7");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (MaterialCategoryEnum typeEnum : MaterialCategoryEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private MaterialCategoryEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum ContractModelStatusEnum {
        MODELSTATUS0(0, "\u6b63\u5e38"),
        MODELSTATUS1(1, "\u5df2\u66f4\u65b0"),
        MODELSTATUS2(2, "\u5df2\u5220\u9664");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (ContractModelStatusEnum typeEnum : ContractModelStatusEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private ContractModelStatusEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static final class ContractApprovalTabId {
        public static final Integer TAB_ID_NO_APPROVAL = 2000;
        public static final Integer TAB_ID_APPROVED = 2001;
        public static final Integer TAB_ID_ALL = 2002;
    }

    public static enum ArchiveStatusEnum {
        ARCHIVE0(0, "\u5426"),
        ARCHIVE1(1, "\u662f"),
        ARCHIVE2(2, "\u6863\u6848\u7cfb\u7edf\u63a8\u9001\u5931\u8d25"),
        ARCHIVE3(3, "\u5f52\u6863\u4e2d"),
        ARCHIVE4(4, "\u65e0\u9700\u5f52\u6863");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (ArchiveStatusEnum typeEnum : ArchiveStatusEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private ArchiveStatusEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum NatureEnum {
        QUALITY1(1, "\u5b9a\u91d1"),
        QUALITY2(2, "\u8ba2\u91d1"),
        QUALITY3(3, "\u9884\u4ed8\u6b3e"),
        QUALITY4(4, "\u8d28\u4fdd\u91d1"),
        QUALITY5(5, "\u5408\u540c\u6b3e"),
        QUALITY6(6, "\u5c65\u7ea6\u4fdd\u8bc1\u91d1"),
        QUALITY7(7, "\u8fdb\u5ea6\u6b3e"),
        QUALITY8(8, "\u5230\u8d27\u6b3e"),
        QUALITY9(9, "\u9a8c\u6536\u6b3e"),
        OTHER(99, "\u5176\u4ed6");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (NatureEnum typeEnum : NatureEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private NatureEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum MaterialsupplyEnum {
        QUALITY1(1, "\u53d1\u5305\u65b9\u4f9b\u5e94"),
        QUALITY2(2, "\u627f\u5305\u65b9\u81ea\u8d2d"),
        QUALITY3(3, "\u53d1\u5305\u65b9\u4e0e\u627f\u5305\u65b9\u5171\u8d2d"),
        QUALITY4(4, "\u627f\u5305\u65b9\u4e0e\u5206\u5305\u65b9\u5171\u8d2d"),
        QUALITY5(5, "\u5206\u5305\u65b9\u81ea\u8d2d"),
        OTHER(99, "\u5176\u4ed6");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (MaterialsupplyEnum typeEnum : MaterialsupplyEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private MaterialsupplyEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum ChangeAccessoryStatusEnum {
        QUALITY1(1, "11,12,13"),
        QUALITY2(2, "5,6,7"),
        QUALITY3(3, "15,16,30,31"),
        QUALITY4(4, "8,10");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (ChangeAccessoryStatusEnum typeEnum : ChangeAccessoryStatusEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private ChangeAccessoryStatusEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static class AgreementChangeType {
        public static String SUSPEND = "1";
        public static String ENABLE = "2";
        public static String TERMINATION = "3";
        public static String PRICE_ADJUSTMENT = "4";
        public static String DELAY = "5";
        public static String SUPPLEMENT = "6";
        public static String OTHER_CHANGES = "7";
    }

    public static class SendType {
        public static String STOP_TYPE = "2";
        public static String OTHER = "1";
    }

    public static enum ContractingTypeEnum {
        CONTRACTING_TYPE_ENUM1(1, "\u6211\u65b9\u76f4\u63a5\u7b7e\u8ba2\u5408\u540c"),
        CONTRACTING_TYPE_ENUM2(2, "\u6211\u65b9\u5bf9\u5916\u5206\u5305\u5408\u540c");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (ContractingTypeEnum typeEnum : ContractingTypeEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private ContractingTypeEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum QualityGradeEnum {
        QUALITY1(1, "\u9c81\u73ed\u5956"),
        QUALITY2(2, "\u56fd\u5bb6\u7ea7\u5956"),
        QUALITY3(3, "\u7701\u3001\u90e8\u7ea7\u5956"),
        QUALITY4(4, "\u5730\u7ea7\u5e02\u5956"),
        QUALITY5(5, "\u4f18\u79c0"),
        QUALITY6(6, "\u5408\u683c"),
        OTHER(99, "\u5176\u4ed6");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (QualityGradeEnum typeEnum : QualityGradeEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private QualityGradeEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum ContractClassificationEnum {
        CONSTRUCT1(1, "\u5efa\u8bbe\u5de5\u7a0b\u5408\u540c"),
        PROFESSIONAL(2, "\u4e13\u4e1a\u5206\u5305\u5408\u540c"),
        CONSTRUCT3(3, "\u77ff\u5efa\u5de5\u7a0b\u5408\u540c"),
        CONSTRUCT4(4, "\u65bd\u5de5\u5408\u540c"),
        CONSTRUCT5(5, "\u52b3\u52a1\u5206\u5305\u5408\u540c"),
        CONSTRUCT6(6, "\u7eff\u5316"),
        CONSTRUCT7(7, "\u590d\u57a6\u5408\u540c"),
        CONSTRUCT8(8, "\u65bd\u5de5\u8bbe\u8ba1\u5408\u540c"),
        CONSTRUCT9(9, "\u52d8\u5bdf\u5408\u540c"),
        CONSTRUCT10(10, "\u8bbe\u8ba1\u5408\u540c"),
        SUPERVIOSIN(11, "\u76d1\u7406\u5408\u540c"),
        CONSULTANT(12, "\u54a8\u8be2\u5408\u540c"),
        GENERALCONTARCTING(13, "\u603b\u627f\u5305\u5408\u540c"),
        CIVILWORKS(14, "\u571f\u5efa\u5de5\u7a0b\u5408\u540c"),
        UNDERGROUNDINSTALLATION(15, "\u4e95\u4e0b\u5b89\u88c5\u5de5\u7a0b\u5408\u540c"),
        OTHER(99, "\u5176\u4ed6");

        private int code;
        private String value;

        public Integer getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(int code) {
            for (ContractClassificationEnum typeEnum : ContractClassificationEnum.values()) {
                if (typeEnum.getCode() != code) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private ContractClassificationEnum(int code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum ContractSubjectParty {
        CONTRACT_KAIFA("1", "\u4e2d\u7164\u5f00\u53d1"),
        CONTRACT_ZHAOBIAO("2", "\u4e2d\u7164\u62db\u6807"),
        CONTRACT_STOCK("3", "\u603b\u90e8-\u80a1\u4efd"),
        CONTRACT_GROUP("4", "\u603b\u90e8-\u96c6\u56e2"),
        CONTRACT_MATERIAL("5", "\u7269\u8d44\u516c\u53f8"),
        CONTRACT_DEVICE("6", "\u8bbe\u5907\u516c\u53f8");

        private String code;
        private String value;

        public String getCode() {
            return this.code;
        }

        public String getValue() {
            return this.value;
        }

        public static String getValueByCode(String code) {
            for (ContractSubjectParty typeEnum : ContractSubjectParty.values()) {
                if (!typeEnum.getCode().equals(code)) continue;
                return typeEnum.getValue();
            }
            return null;
        }

        private ContractSubjectParty(String code, String value) {
            this.code = code;
            this.value = value;
        }
    }

    public static enum PurchaseTypeEnum {
        PURCHASE_TYPE_ONE("\u516c\u5f00\u62db\u6807", 1),
        PURCHASE_TYPE_TWO("\u9080\u8bf7\u62db\u6807", 2),
        PURCHASE_TYPE_THREE("\u516c\u5f00\u8be2\u6bd4", 3),
        PURCHASE_TYPE_FOUR("\u9080\u8bf7\u8be2\u6bd4", 4),
        PURCHASE_TYPE_FIVE("\u516c\u5f00\u7ade\u4ef7", 5),
        PURCHASE_TYPE_SIX("\u9080\u8bf7\u7ade\u4ef7", 6),
        PURCHASE_TYPE_SEVEN("\u516c\u5f00\u7ade\u8c08", 7),
        PURCHASE_TYPE_EIGHT("\u9080\u8bf7\u7ade\u8c08", 8),
        PURCHASE_TYPE_NINE("\u5355\u4e00\u6765\u6e90", 9),
        PURCHASE_TYPE_TEN("\u76f4\u63a5\u91c7\u8d2d", 10),
        PURCHASE_TYPE_ELEVEN("\u76f4\u63a5\u91c7\u8d2d(\u6267\u884c\u534f\u8bae)", 11);

        private final Integer name;
        private final String value;

        public Integer getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        private PurchaseTypeEnum(String value, Integer name) {
            this.name = name;
            this.value = value;
        }

        public static Integer getValueByName(String name) {
            for (PurchaseTypeEnum typeEnum : PurchaseTypeEnum.values()) {
                if (!typeEnum.getValue().equals(name)) continue;
                return typeEnum.getName();
            }
            return null;
        }
    }

    public static final class ContractTemplatePurpose {
        public static final Integer CONTRACT_REFERENCE = 1;
        public static final Integer SOURCE_REFERENCE = 2;
        public static final String CONTRACT_REFERENCE_DESC = "\u5408\u540c\u5f15\u7528";
        public static final String SOURCE_REFERENCE_DESC = "\u5bfb\u6e90\u53c2\u8003";
    }

    public static final class ContractTemplateValidStatus {
        public static final Integer DRAFT = 1;
        public static final Integer DISABLE = 2;
        public static final Integer PUBLISHED = 3;
        public static final String DRAFT_DESC = "\u8349\u7a3f";
        public static final String DISABLE_DESC = "\u505c\u7528";
        public static final String PUBLISHED_DESC = "\u5df2\u53d1\u5e03";
    }

    public static final class ContractTermType {
        public static final Integer GENERAL_TERMS = 1;
        public static final Integer SUPPLEMENT_TERMS = 1;
        public static final String GENERAL_TERMS_DESC = "\u666e\u901a\u6761\u6b3e";
        public static final String SUPPLEMENT_TERMS_DESC = "\u8865\u5145\u6761\u6b3e";
    }

    public static final class ContractTermsValidStatus {
        public static final Integer DISABLE = 0;
        public static final Integer DRAFT = 1;
        public static final Integer DELETE = 2;
        public static final Integer PUBLISHED = 3;
        public static final String DISABLE_DESC = "\u505c\u7528";
        public static final String DRAFT_DESC = "\u8349\u7a3f";
        public static final String DELETE_DESC = "\u5220\u9664";
        public static final String PUBLISHED_DESC = "\u5df2\u53d1\u5e03";
    }

    public static final class ComparePriceType {
        public static final Integer DEF_AGR_PRICE = 1;
        public static final Integer INDICATIVE_PRICE = 2;
        public static final Integer AVERAGE_PRICE = 3;
        public static final Integer QOTP_PRICE = 4;
        public static final Integer BUDGET_PRICE = 5;
        public static final Integer OTHER_PRICE = 6;
    }

    public static final class PushLegalSealType {
        public static final String ENTERPRISE_CACHET = "2000100010867";
        public static final String CONTRACT_SPECIAL = "2000100010868";
        public static final String PERSONAL_SEAL = "2000100010869";
        public static final String COMPANY_NAME_FLAT_SEAL = "2000100010870";
        public static final String ACCOUNTING_SPECIAL = "2000100010871";
    }

    public static final class ContractSignerStatus {
        public static final String CONTRACT_SPECIAL = "2000100010867";
        public static final Integer UNDER_SIGN = 5;
        public static final Integer SIGNED_SUCCESS = 10;
        public static final Integer REVOKE_SIGN = 12;
        public static final Integer REJECT_SIGN = 30;
        public static final Integer INVALID_SIGN = 40;
    }

    public static final class SignOperLogType {
        public static final Integer SIGN_INIT = 1;
        public static final Integer SIGN_OK = 2;
        public static final Integer SIGN_REJECT = 3;
        public static final Integer SIGN_INIT_BACK = 4;
        public static final Integer SIGN_INVALID = 5;
        public static final Integer SIGN_OVERDUE = 6;
        public static final Integer SIGN_NAME_OK = 7;
        public static final String SIGN_INIT_DESC = " \u53d1\u8d77\u7b7e\u7ae0";
        public static final String SIGN_OK_DESC = "\u7b7e\u7ae0\u5b8c\u6210";
        public static final String SIGN_REJECT_DESC = "\u62d2\u7b7e";
        public static final String SIGN_INIT_BACK_DESC = "\u53d1\u8d77\u65b9\u64a4\u56de";
        public static final String SIGN_INVALID_DESC = "\u4f5c\u5e9f\u7b7e\u7f72";
        public static final String SIGN_OVERDUE_DESC = "\u4fe1\u5c01\u8fc7\u671f";
        public static final String SIGN_NAME_OK_DESC = "\u7b7e\u540d\u5b8c\u6210";
    }

    public static final class PushErpStatus {
        public static final Integer IN_SYNC = 1;
        public static final Integer WAIT_SYNC = 2;
        public static final Integer ALREADY_SYNC = 3;
        public static final Integer FAIL_SYNC = 4;
        public static final Integer NEED_NOT_SYNC = 5;
        public static final String IN_SYNC_DESC = "\u540c\u6b65\u4e2d";
        public static final String WAIT_SYNC_DESC = "\u5f85\u540c\u6b65";
        public static final String ALREADY_SYNC_DESC = "\u5df2\u540c\u6b65";
        public static final String FAIL_SYNC_DESC = "\u540c\u6b65\u5931\u8d25";
        public static final String NEED_NOT_SYNC_DESC = "\u65e0\u9700\u540c\u6b65";
    }

    public static final class ContractPushErpParameter {
        public static final String CONTRACT_PUSH_ERP_SETTLE = "CONTRACT_PUSH_ERP_SETTLE";
    }

    public static final class ContractPushLegalParameter {
        public static final String CONTRACT_PUSH_LEGAL_SETTLE = "CONTRACT_PUSH_LEGAL_SETTLE";
    }

    public static final class TermOfValidity {
        public static final String MONTHS_DESC = "\u4e2a\u6708";
        public static final String YEARS_DESC = "\u5e74";
        public static final String DAY_DESC = "\u65e5";
    }

    public static final class TermOfValidityType {
        public static final Integer MONTHS = 9;
        public static final Integer YEARS = 10;
        public static final Integer DAY = 11;
    }

    public static final class PurchaseChannel {
        public static final String DOMESTIC_DESC = "\u56fd\u5185";
        public static final String INTERNATIONAL_DESC = "\u56fd\u9645";
    }

    public static final class PurchaseChannelType {
        public static final Integer DOMESTIC = 1;
        public static final Integer INTERNATIONAL = 2;
    }

    public static final class SealType {
        public static final Integer CONTRACT_SPECIAL = 1;
        public static final Integer ENTERPRISE_CACHET = 2;
        public static final Integer PERSONAL_SEAL = 3;
        public static final Integer ACCOUNTING_SPECIAL = 4;
        public static final Integer COMPANY_NAME_FLAT_SEAL = 5;
        public static final String CONTRACT_SPECIAL_DESC = " \u5408\u540c\u4e13\u7528\u7ae0";
        public static final String ENTERPRISE_CACHET_DESC = "\u4f01\u4e1a\u516c\u7ae0";
        public static final String PERSONAL_SEAL_DESC = "\u4eba\u540d\u7ae0";
        public static final String ACCOUNTING_SPECIAL_DESC = "\u8d26\u52a1\u4e13\u7528\u7ae0";
        public static final String COMPANY_NAME_FLAT_SEAL_DESC = "\u516c\u53f8\u540d\u79f0\u6241\u6761\u7ae0";
    }

    public static final class MaterialCategory {
        public static final Integer PROJECT = 1;
        public static final Integer SERVICES = 2;
        public static final Integer EQUIPMENT = 3;
        public static final Integer ACCESSORIES = 4;
        public static final Integer METAL_MATERIALS = 5;
        public static final Integer NON_METALLIC_MATERIAL = 6;
        public static final String PROJECT_DESC = "\u5de5\u7a0b";
        public static final String SERVICES_DESC = "\u670d\u52a1";
        public static final String EQUIPMENT_DESC = "\u8bbe\u5907";
        public static final String ACCESSORIES_DESC = "\u914d\u4ef6";
        public static final String METAL_MATERIALS_DESC = "\u91d1\u5c5e\u6750\u6599";
        public static final String NON_METALLIC_MATERIAL_DESC = "\u975e\u91d1\u5c5e\u6750\u6599";
    }

    public static final class ContractSignatureCertType {
        public static final String U_KEY = "U_KEY";
        public static final String MOBILE_CERT = "MOBILE_CERT";
        public static final String DISPOSABLE_CERT = "DISPOSABLE_CERT";
    }

    public static final class ContractSignatureEnvelopeStatus {
        public static final Integer ING_EDIT_DRAFT = 0;
        public static final Integer WAITING_TO_SIGN = 11;
        public static final Integer SIGNED_SUCCESS = 50;
        public static final Integer REJECT = 61;
        public static final Integer REVOKE = 63;
        public static final Integer INVALID = 64;
        public static final Integer EXPIRED = 65;
    }

    public static final class ContractSignatureParameter {
        public static final String CONTRACT_SIGNATURE_SETTLE = "CONTRACT_SIGNATURE_SETTLE";
        public static final String CONTRACT = "CONTRACT";
    }

    public static final class UpdateApplyType {
        public static final Integer CHANGE_CONTRACT = 1;
        public static final String CHANGE_CONTRACT_DESC = "\u53d8\u66f4\u5408\u540c";
        public static final Integer END_CONTRACT = 2;
        public static final String END_CONTRACT_DESC = "\u7ec8\u6b62\u5408\u540c";
        public static final Integer MATERIAL_CHANGE_CONTRACT = 3;
        public static final String MATERIAL_CHANGE_CONTRACT_DESC = "\u7269\u8d44\u53d8\u66f4";
    }

    public static final class PayNodeRuleAllow {
        public static final Integer ORDER_TICKET = 1;
        public static final String ORDER_TICKET_DESC = "\u8ba2\u5355\u6536\u7968";
        public static final Integer ORDER_ACCEPTANCE = 2;
        public static final String ORDER_ACCEPTANCE_DESC = "\u8ba2\u5355/\u9a8c\u6536\u5355\u9a8c\u6536";
        public static final Integer ORDER_INVOICE = 3;
        public static final String ORDER_INVOICE_DESC = "\u8ba2\u5355/\u53d1\u8d27\u5355\u5230\u8d27";
        public static final Integer PAYMENT = 4;
        public static final String PAYMENT_DESC = "\u53d1\u7968\u6302\u8d26";
    }

    public static final class FactoryPrice {
        public static final Integer ARRIVE_PRICE = 1;
        public static final String ARRIVE_PRICE_DESC = "\u5230\u5382\u4ef7";
        public static final Integer OUT_PRICE = 2;
        public static final String OUT_PRICE_DESC = "\u51fa\u5382\u4ef7";
    }

    public static final class PriceCategoriesType {
        public static final Integer CONTRACT_PRICE = 1;
        public static final String CONTRACT_PRICE_DESC = "\u534f\u8bae\u4ef7";
        public static final Integer GUIDED = 2;
        public static final String GUIDED_DESC = "\u6307\u5bfc\u4ef7";
        public static final Integer AVERAGE_PRICE = 3;
        public static final String AVERAGE_PRICE_DESC = "\u5e73\u5747\u62a5\u4ef7";
        public static final Integer COUNTERPARTY_QUOTATION = 4;
        public static final String COUNTERPARTY_QUOTATION_DESC = "\u6210\u4ea4\u65b9\u62a5\u4ef7";
        public static final Integer BUDGET_PRICE = 5;
        public static final String BUDGET_PRICE_DESC = "\u9884\u7b97\u4ef7";
        public static final Integer OTHER = 6;
        public static final String OTHER_DESC = "\u5176\u4ed6";
    }

    public static final class CommunicationType {
        public static final String PHONE = "1";
        public static final String PHONE_DESC = "\u7535\u8bdd";
        public static final String FAX = "2";
        public static final String FAX_DESC = "\u4f20\u771f";
        public static final String MAIL = "3";
        public static final String MAIL_DESC = "\u7535\u5b50\u90ae\u7bb1";
        public static final String LETTER = "4";
        public static final String LETTER_DESC = "\u4fe1\u51fd";
        public static final String INTERVIEW = "5";
        public static final String INTERVIEW_DESC = "\u9762\u8c08";
    }

    public static final class IsNewBrand {
        public static final Integer YES = 1;
        public static final String YES_DESC = "\u6709";
        public static final Integer NO = 0;
        public static final String NO_DESC = "\u65e0";
    }

    public static final class IsNewSupplier {
        public static final Integer YES = 1;
        public static final String YES_DESC = "\u662f";
        public static final Integer NO = 0;
        public static final String NO_DESC = "\u5426";
    }

    public static final class SaleStatus {
        public static final Integer VALID = 1;
        public static final String VALID_DESC = "\u6709\u6548";
        public static final Integer LIMIT = 2;
        public static final String LIMIT_DESC = "\u9650\u91cf";
        public static final Integer INVALID = 3;
        public static final String INVALID_DESC = "\u65e0\u6548";
    }

    public static final class BusinessType {
        public static final Integer PROCUREMENT = 1;
        public static final String PROCUREMENT_DESC = "\u91c7\u8d2d";
        public static final Integer SALES = 2;
        public static final String SALES_DESC = "\u670d\u52a1";
        public static final Integer AGENT = 3;
        public static final String AGENT_DESC = "\u8fdb\u53e3\u4ee3\u7406";
        public static final Integer SALE = 4;
        public static final String SALE_DESC = "\u9500\u552e";
        public static final Integer COLLECTIVE_PURCHASE_SELF = 5;
        public static final String COLLECTIVE_PURCHASE_SELF_DESC = "\u96c6\u91c7\u81ea\u8425";
        public static final Integer IMPORT_SELF = 6;
        public static final String IMPORT_SELF_DESC = "\u8fdb\u53e3\u81ea\u8425";
        public static final Integer SELF_PURCHASE = 7;
        public static final String SELF_PURCHASE_DESC = "\u81ea\u9700\u91c7\u8d2d";
        public static final Integer TRIPARTITE_INTERNAL_AGENCY = 8;
        public static final String TRIPARTITE_INTERNAL_AGENCY_DESC = "\u4e09\u65b9-\u5185\u8d38\u4ee3\u7406";
        public static final Integer TRIPARTITE_OTHER = 9;
        public static final String TRIPARTITE_OTHER_DESC = "\u4e09\u65b9-\u5176\u4ed6";
        public static final Integer TALK_SIGN_SEPARATELY = 10;
        public static final String TALK_SIGN_SEPARATELY_DESC = "\u7edf\u8c08\u5206\u7b7e";
        public static final Integer AGENT_PURCHASE = 11;
        public static final String AGENT_PURCHASE_DESC = "\u96c6\u91c7\u5206\u7b7e";
        public static final Integer ENTRUSTED_BIDDING = 12;
        public static final String ENTRUSTED_BIDDING_DESC = "\u59d4\u6258\u62db\u6807(\u670d\u52a1)";
        public static final Integer ENTRUSTED_TRZ = 13;
        public static final String ENTRUSTED_TRZ_DESC = "\u6295\u878d\u8d44\u7c7b";
        public static final Integer ENTRUSTED_YC = 14;
        public static final String ENTRUSTED_YC_DESC = "\u96c6\u91c7\u81ea\u8425-\u4e91\u4ed3";
        public static final Integer NIENTE = 20;
        public static final String NIENTE_DESC = "\u5176\u4ed6";
    }

    public static final class DeleteFlag {
        public static final String DELETE = "1";
        public static final String EXIST = "0";
    }

    public static final class ContractInfoOrgType {
        public static final String LIMITED_LIABILITY = "1";
        public static final String JOINT_STOCK_LIABILITY = "2";
        public static final String WHOLLY_STATE_OWNED = "3";
        public static final String PERSONAL_OWNED = "4";
        public static final String PARTNERSHIP = "5";
        public static final String INDIVIDUAL_BUSINESS = "6";
        public static final String LIMITED_LIABILITY_DESC = "\u6709\u9650\u8d23\u4efb\u516c\u53f8";
        public static final String JOINT_STOCK_LIABILITY_DESC = "\u80a1\u4efd\u8d23\u4efb\u516c\u53f8";
        public static final String WHOLLY_STATE_OWNED_DESC = "\u56fd\u6709\u72ec\u8d44\u4f01\u4e1a";
        public static final String PERSONAL_OWNED_DESC = "\u4e2a\u4eba\u72ec\u8d44\u4f01\u4e1a";
        public static final String PARTNERSHIP_DESC = "\u5408\u4f19\u4f01\u4e1a";
        public static final String INDIVIDUAL_BUSINESS_DESC = "\u4e2a\u4f53\u5de5\u5546\u6237";
    }

    public static final class MaterialSource {
        public static final String AWARD_RESULT = "1";
        public static final String TENDER_REPORT = "2";
        public static final String MANUAL_ENTRY = "3";
        public static final String INTRATRADE = "4";
        public static final String PURCHASE_ORDER = "5";
        public static final String ERP_INITIALIZE = "6";
        public static final String PROTOCOL_SCHEME = "7";
        public static final String DETERMINE_THE_PRICING_PLAN = "8";
        public static final String NEIMAO_AGREEMENT = "9";
        public static final String AWARD_RESULT_DESC = "\u8be2\u6bd4\u7ed3\u679c";
        public static final String TENDER_REPORT_DESC = "\u5b9a\u6807\u62a5\u544a";
        public static final String MANUAL_ENTRY_DESC = "\u624b\u5de5\u5f55\u5165";
        public static final String INTRATRADE_DESC = "\u5185\u90e8\u8d38\u6613";
        public static final String PURCHASE_ORDER_DESC = "\u91c7\u8d2d\u8ba2\u5355";
        public static final String ERP_INITIALIZE_DESC = "ERP\u521d\u59cb\u5316";
        public static final String PROTOCOL_SCHEME_DESC = "\u534f\u8bae\u65b9\u6848";
        public static final String DETERMINE_THE_PRICING_PLAN_DESC = "\u5b9a\u5546\u5b9a\u4ef7\u65b9\u6848";
        public static final String NEIMAO_AGREEMENT_DESC = "\u96c6\u91c7\u5206\u7b7e\u534f\u8bae";
    }

    public static final class ContractCategory {
        public static final Integer FRAMEWORK_AGREEMENT_PRICE = 1;
        public static final Integer FRAMEWORK_AGREEMENT_CONSIGNMENT = 2;
        public static final Integer SPOT_CONTRACT = 3;
        public static final Integer DEVELOPMENT_CONTRACT = 9;
        public static final Integer FRAME_AGR_SELF_EXPLOITATION_CONTRACT = 22;
        public static final Integer OTHER_LONG_TERM_PRICING_CONTRACT = 30;
        public static final Integer OTHER_PROMPT_CONTRACT = 31;
        public static final String FRAMEWORK_AGREEMENT_PRICE_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7)";
        public static final String FRAMEWORK_AGREEMENT_CONSIGNMENT_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5bc4\u552e\uff09";
        public static final String SPOT_CONTRACT_DESC = "\u73b0\u8d27\u5408\u540c\uff08\u81ea\u8425-\u96c6\u91c7\u8ba1\u5212\uff09";
        public static final String DEVELOPMENT_CONTRACT_DESC = "\u73b0\u8d27\u5408\u540c\uff08\u5f00\u53d1\u81ea\u91c7\uff09";
        public static final String FRAME_AGR_SELF_EXPLOITATION_CONTRACT_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5f00\u53d1\u81ea\u91c7\uff09";
        public static final String OTHER_LONG_TERM_PRICING_CONTRACT_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        public static final String OTHER_PROMPT_CONTRACT_DESC = "\u73b0\u8d27\u5408\u540c";
    }

    public static final class ErpSyncStatus {
        public static final String TO_BE_SYNC = "0";
        public static final String SYNC_SUCCESS = "1";
        public static final String SYNC_FAILURE = "2";
        public static final String TO_BE_SYNC_DESC = "\u5f85\u540c\u6b65";
        public static final String SYNC_SUCCESS_DESC = "\u540c\u6b65\u6210\u529f";
        public static final String SYNC_FAILURE_DESC = "\u540c\u6b65\u5931\u8d25";
    }

    public static final class ContractPurchaseType {
        public static final Integer PUBLIC_BIDDING_CODE = 1;
        public static final Integer INVITATION_TO_BID_CODE = 2;
        public static final Integer PUBLIC_INQUIRY_CODE = 3;
        public static final Integer DIRECTIONAL_INQUIRY_CODE = 4;
        public static final Integer OPEN_OUTCRY_CODE = 5;
        public static final Integer DIRECTIONAL_BIDDING_CODE = 6;
        public static final Integer COMPETITIVE_NEGOTIATION_CODE = 7;
        public static final Integer SINGLE_SOURCE_CODE = 8;
        public static final Integer FIXED_PRICE_CODE = 9;
        public static final Integer DS_CG_CODE = 10;
        public static final Integer XY_CAI_CODE = 11;
        public static final Integer DSDJ_CAI_CODE = 12;
        public static final String PUBLIC_BIDDING_DESC = "\u516c\u5f00\u62db\u6807";
        public static final String INVITATION_TO_BID_DESC = "\u9080\u8bf7\u62db\u6807";
        public static final String PUBLIC_INQUIRY_DESC = "\u516c\u5f00\u8be2\u6bd4";
        public static final String DIRECTIONAL_INQUIRY_DESC = "\u9080\u8bf7\u8be2\u6bd4";
        public static final String OPEN_OUTCRY_DESC = "\u516c\u5f00\u7ade\u4ef7";
        public static final String DIRECTIONAL_BIDDING_DESC = "\u9080\u8bf7\u7ade\u4ef7";
        public static final String COMPETITIVE_NEGOTIATION_DESC = "\u516c\u5f00\u7ade\u8c08";
        public static final String SINGLE_SOURCE_DESC = "\u9080\u8bf7\u7ade\u8c08";
        public static final String FIXED_PRICE_DESC = "\u5355\u4e00\u6765\u6e90";
        public static final String DS_CG_DESC = "\u76f4\u63a5\u91c7\u8d2d";
        public static final String XY_CAI_DESC = "\u76f4\u63a5\u91c7\u8d2d(\u6267\u884c\u534f\u8bae)";
        public static final String DSDJ_CAI_DESC = "\u76f4\u63a5\u91c7\u8d2d(\u5b9a\u5546\u5b9a\u4ef7)";
    }

    public static final class DicDelFlag {
        public static final Integer YES = 1;
        public static final Integer NO = 0;
    }

    public static final class DictPCode {
        public static final String CONTRACT = "CONTRACT";
    }

    public static final class FileUploadCode {
        public static final String ANALYSIS_FILE_ERROR = "6018";
    }

    public static final class ModelType {
        public static final Integer B_TAX_UNIT = 1;
        public static final Integer B_UNIT_PRICE = 2;
        public static final Integer Tend_TAX_UNIT = 3;
        public static final Integer Tend_UNIT_PRICE = 4;
        public static final Integer AWAD_TAX_UNIT = 5;
        public static final Integer AWAD_UNIT_PRICE = 6;
        public static final Integer SALE_CONTRACT_ITEM = 7;
        public static final Integer UNIT_B_TAX_UNIT = 8;
        public static final Integer UNIT_B_UNIT_PRICE = 9;
        public static final Integer UNIT_Tend_TAX_UNIT = 10;
        public static final Integer UNIT_Tend_UNIT_PRICE = 11;
        public static final Integer UNIT_AWAD_TAX_UNIT = 12;
        public static final Integer UNIT_AWAD_UNIT_PRICE = 13;
        public static final Integer UNIT_NEIMAO_UNIT_PRICE = 14;
    }

    public static final class ItemAddType {
        public static final Integer ADD = 1;
        public static final Integer IMPORT = 2;
        public static final Integer RATE_IMPORT = 4;
        public static final Integer FZ = 3;
    }

    public static final class TodoItemCode {
        public static final String CODE_1 = "6001";
        public static final String CODE_2 = "6002";
        public static final String CODE_3 = "6003";
        public static final String CODE_4 = "6004";
        public static final String CODE_5 = "6005";
        public static final String CODE_6 = "6006";
        public static final String CODE_7 = "6007";
        public static final String CODE_8 = "6008";
        public static final String CODE_9 = "6009";
        public static final String CODE_10 = "6010";
        public static final String CODE_11 = "6011";
        public static final String CODE_12 = "6012";
        public static final String CODE_13 = "6013";
        public static final String CODE_14 = "6014";
        public static final String CODE_15 = "6015";
        public static final String CODE_16 = "6016";
        public static final String CODE_17 = "6017";
    }

    public static final class SignFlag {
        public static final Integer NO_SIGN_STATUS = 0;
        public static final Integer GENERATOR_FIRST_STATUS = 1;
        public static final Integer SINGER_FIRST_STATUS = 2;
        public static final String NO_SIGN_DESC = "\u4e0d\u7b7e\u7ae0";
        public static final String GENERATOR_FIRST_DESC = "\u751f\u6210\u65b9\u5148\u7b7e\u7ae0\uff0c\u518d\u5230\u7b7e\u8ba2\u65b9\u7b7e\u7ae0";
        public static final String SINGER_FIRST_DESC = "\u7b7e\u8ba2\u65b9\u5148\u7b7e\u7ae0\uff0c\u518d\u5230\u751f\u6210\u65b9\u7b7e\u7ae0";
    }

    public static final class ContractCode {
        public static final String CONTRACT_CODE = "CONTRACT";
    }

    public static final class ContractTabList {
        public static final Integer TO_BE_EFFECTIVE_STATUS = 1000;
        public static final Integer TO_BE_CONFIRMED_STATUS = 1001;
        public static final Integer IN_CONFIRM_STATUS = 1002;
        public static final Integer TO_BE_SIGNATURE_STATUS = 1003;
        public static final Integer EFFECTED_STATUS = 1004;
        public static final Integer FAILURE_STUTUS = 1005;
        public static final Integer EXECUTED_STUTUS = 1006;
        public static final Integer ALL_STUTUS = 1007;
        public static final String TO_BE_EFFECTIVE_DESC = "\u5f85\u751f\u6548";
        public static final String TO_BE_CONFIRMED_STATUS_DESC = "\u5f85\u786e\u8ba4";
        public static final String IN_CONFIRM_STATUS_DESC = "\u5df2\u786e\u8ba4";
        public static final String TO_BE_SIGNATURE_DESC = "\u5f85\u7b7e\u7ae0";
        public static final String EFFECTED_DESC = "\u5df2\u751f\u6548";
        public static final String FAILURE_DESC = "\u5df2\u5931\u6548";
        public static final String EXECUTED_STUTUS_DESC = "\u5df2\u6267\u884c";
        public static final String ALL_STUTUS_DESC = "\u5168\u90e8";
    }

    public static final class ServiceFeeType {
        public static final Integer SERVICE_FEE_TYPE_MONTHLY = 1;
        public static final Integer SERVICE_FEE_TYPE_REAL_TIME = 2;
        public static final String SERVICE_FEE_TYPE_MONTHLY_DESC = "\u6708\u7ed3";
        public static final String SERVICE_FEE_TYPE_REAL_TIME_DESC = "\u5b9e\u65f6\u6263\u9664";
    }

    public static final class ModifyStatus {
        public static final Integer MODIFY_STATUS_DRAFT = 1;
        public static final Integer MODIFY_STATUS_EXAMINE = 2;
        public static final Integer MODIFY_STATUS_APPROVED = 3;
        public static final Integer MODIFY_STATUS_REJECT = 4;
        public static final Integer MODIFY_STATUS_IN_CONFIRM = 5;
        public static final Integer MODIFY_STATUS_IN_NEGOTIATION = 6;
        public static final Integer MODIFY_STATUS_EFFECT = 7;
        public static final Integer MODIFY_STATUS__PENDING_PUSH_LEGAL = 8;
        public static final Integer MODIFY_STATUS_PENDING_PUSH_LEGAL_RETURN = 9;
        public static final String MODIFY_STATUS_DRAFT_DESC = "\u8349\u7a3f";
        public static final String MODIFY_STATUS_EXAMINE_DESC = "\u5ba1\u6838\u4e2d";
        public static final String MODIFY_STATUS_APPROVED_DESC = "\u5ba1\u6838\u901a\u8fc7";
        public static final String MODIFY_STATUS_REJECT_DESC = "\u5ba1\u6279\u62d2\u7edd";
        public static final String MODIFY_STATUS_IN_CONFIRM_DESC = "\u786e\u8ba4\u4e2d";
        public static final String MODIFY_STATUS_IN_NEGOTIATION_DESC = "\u534f\u5546\u4e2d";
        public static final String MODIFY_STATUS_EFFECT_DESC = "\u5df2\u751f\u6548";
        public static final String MODIFY_STATUS__PENDING_PUSH_LEGAL_DESC = "\u5f85\u63a8\u9001\u6cd5\u52a1";
        public static final String MODIFY_STATUS_PENDING_PUSH_LEGAL_RETURN_DESC = "\u6cd5\u52a1\u9000\u56de";
    }

    public static final class SupplyType {
        public static final Integer SUPPLIER_CODE = 1;
        public static final Integer PURCHASER_CODE = 2;
        public static final Integer SUPPLIER_PURCHASER_CODE = 3;
        public static final String SUPPLIER_DESC = "\u4f9b\u5e94\u5546";
        public static final String PURCHASER_DESC = "\u91c7\u8d2d\u5546";
        public static final String SUPPLIER_PURCHASER_DESC = "\u4f9b\u5e94\u5546+\u91c7\u8d2d\u5546";
    }

    public static final class ContractType {
        public static final Integer UNIT_AGREE_CONTRACT_TYPE = 1;
        public static final Integer PLATFORM_AGREE_CONTRACT_TYPE = 2;
        public static final Integer ORDER_CONTRACT_TYPE = 3;
        public static final Integer ENTER_CONTRACT_TYPE = 4;
        public static final Integer LONG_TERM_CONTRACT_TYPE = 5;
        public static final Integer SPOT_CONTRACT = 6;
        public static final Integer PURCHASE_CONTRACT = 7;
        public static final Integer SALE_CONTRACT = 8;
        public static final Integer DEVELOPMENT_CONTRACT = 9;
        public static final Integer ORDER_CONTRACT = 10;
        public static final Integer PURCHASE_SPOT_CONTRACT = 11;
        public static final Integer PURCHASE_LONG_TERM_CONS_SALE_CONTRACT = 12;
        public static final Integer PURCHASE_LONG_TERM_PRICING_CONTRACT = 13;
        public static final Integer FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT = 15;
        public static final Integer FUNCTION_SPOTS_CONTRACT = 16;
        public static final Integer PURCHASE_ORDER_CONTRACT = 20;
        public static final Integer PURCHASE_ORDER_NON_TRADE_CONTRACT = 21;
        public static final Integer FRAME_AGR_SELF_EXPLOITATION_CONTRACT = 22;
        public static final Integer OTHER_LONG_TERM_PRICING_CONTRACT = 30;
        public static final Integer OTHER_PROMPT_CONTRACT = 31;
        public static final Integer PURCHASE_TRADE_ORDER_CONTRACT = 32;
        public static final Integer PURCHASE_NO_TRADE_ORDER_CONTRACT = 33;
        public static final String UNIT_CONTRACT_TYPE_DESC = " \u5355\u4f4d\u534f\u8bae\u5408\u540c";
        public static final String PLATFORM_CONTRACT_TYPE_DESC = "\u5e73\u53f0\u534f\u8bae\u5408\u540c";
        public static final String ORDER_CONTRACT_TYPE_DESC = "\u8ba2\u5355\u5408\u540c";
        public static final String ENTER_CONTRACT_TYPE_DESC = "\u5165\u9a7b\u5408\u540c";
        public static final String LONG_TERM_CONTRACT_TYPE_DESC = "\u957f\u534f\u5408\u540c";
        public static final String SPOT_CONTRACT_DESC = "\u73b0\u8d27\u5408\u540c\uff08\u81ea\u8425-\u96c6\u91c7\u8ba1\u5212\uff09";
        public static final String PURCHASE_CONTRACT_DESC = "\u91c7\u8d2d\u5408\u540c";
        public static final String SALE_CONTRACT_DESC = "\u9500\u552e\u5408\u540c";
        public static final String DEVELOPMENT_CONTRACT_DESC = "\u73b0\u8d27\u5408\u540c\uff08\u5f00\u53d1\u81ea\u91c7\uff09";
        public static final String ORDER_CONTRACT_DESC = "\u9500\u552e\u8ba2\u5355\u5408\u540c";
        public static final String PURCHASE_SPOT_CONTRACT_DESC = "\u91c7\u8d2d\u6807\u51c6\u5408\u540c";
        public static final String PURCHASE_LONG_TERM_CONTRACT_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5bc4\u552e\uff09";
        public static final String PURCHASE_LONG_TERM_CONS_SALE_CONTRACT_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        public static final String PURCHASE_ORDER_CONTRACT_DESC = "\u91c7\u8d2d\u8ba2\u5355\u5408\u540c\uff08\u8d38\u6613\uff09";
        public static final String PURCHASE_ORDER_NON_TRADE_CONTRACT_DESC = "\u91c7\u8d2d\u8ba2\u5355\u5408\u540c\uff08\u975e\u8d38\u6613\uff09";
        public static final String FRAME_AGR_SELF_EXPLOITATION_CONTRACT_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5f00\u53d1\u81ea\u91c7\uff09";
        public static final String OTHER_LONG_TERM_PRICING_CONTRACT_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        public static final String OTHER_PROMPT_CONTRACT_DESC = "\u73b0\u8d27\u5408\u540c";
        public static final String PLATFORM_FRAMEWORK_AGREEMENT_CONTRACT_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        public static final String PLATFORM_SPOT_CONTRACT_DESC = "\u73b0\u8d27\u5408\u540c";
        public static final String PURCHASE_TRADE_ORDER_CONTRACT_DESC = "\u91c7\u8d2d\u8ba2\u5355\u5408\u540c";
        public static final String PURCHASE_NO_TRADE_ORDER_CONTRACT_DESC = "\u91c7\u8d2d\u8ba2\u5355\u5408\u540c";
        public static final String FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT_DESC = "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        public static final String FUNCTION_SPOTS_CONTRACT_DESC = "\u73b0\u8d27\u5408\u540c";
    }

    public static final class NeedUnsignTab {
        public static final Integer STATUS_NEED = 1;
        public static final Integer STATUS_NOT_NEED = 0;
        public static final String STATUS_NEED_DESC = "\u67e5\u8be2";
        public static final String STATUS_NOT_NEED_DESC = "\u4e0d\u67e5\u8be2";
    }

    public static final class ExecutionStatus {
        public static final Integer EXECUTION_STATUS_DRAFT = 1;
        public static final String EXECUTION_STATUS_DRAFT_DESC = "\u534f\u8bae\u53ef\u6267\u884c\u4f59\u989d\u4e0d\u8db330%";
        public static final Integer EXECUTION_STATUS_CHAO = 2;
        public static final String EXECUTION_STATUS_CHAO_DESC = "\u534f\u8bae\u6267\u884c\u989d\u5df2\u8d85";
        public static final Integer EXECUTION_STATUS_NOT = 3;
        public static final String EXECUTION_STATUS_NOT_DESC = "\u534f\u8bae\u5230\u671f\u4e0d\u8db34\u6708";
    }

    public static final class ContractStatus {
        public static final Integer CONTRACT_STATUS_DRAFT = 1;
        public static final Integer CONTRACT_STATUS_UNDER_APPROVAL = 2;
        public static final Integer CONTRACT_STATUS_APPROVAL = 3;
        public static final Integer CONTRACT_STATUS_REJECT = 4;
        public static final Integer CONTRACT_STATUS_CHANGE_APPLY = 5;
        public static final Integer CONTRACT_STATUS_UNDER_PRODUCER_SIGN_ = 6;
        public static final Integer CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_ = 7;
        public static final Integer CONTRACT_STATUS_EFFECT = 8;
        public static final Integer CONTRACT_STATUS_FAILUSER = 9;
        public static final Integer CONTRACT_STATUS_HIS = 10;
        public static final Integer CONTRACT_STATUS_ABOLISH = 11;
        public static final Integer CONTRACT_STATUS_WAIT_FOR_SIGN = 12;
        public static final Integer CONTRACT_STATUS_IN_CONFIRM = 13;
        public static final Integer CONTRACT_STATUS_IN_NEGOTIATION = 14;
        public static final Integer CONTRACT_STATUS_EXECUTED = 15;
        public static final Integer CONTRACT_STATUS_FREEZE = 16;
        public static final Integer CONTRACT_PENDING_SUBMISSION = 17;
        public static final Integer CONTRACT_FIRST_PARTY_WAIT_SIGNATURE = 18;
        public static final Integer CONTRACT_SECOND_PARTY_WAIT_SIGNATURE = 19;
        public static final Integer CONTRACT_PENDING_PUSH_LEGAL = 20;
        public static final Integer CONTRACT_PENDING_PUSH_LEGAL_RETURN = 21;
        public static final Integer CONTRACT_STATUS_CHANGE_APPROVAL_OK = 22;
        public static final Integer CONTRACT_THIRD_PARTY_WAIT_SIGNATURE = 23;
        public static final String CONTRACT_STATUS_DRAFT_DESC = "\u8349\u7a3f";
        public static final String CONTRACT_STATUS_UNDER_APPROVAL_DESC = "\u5ba1\u6279\u4e2d";
        public static final String CONTRACT_STATUS_APPROVAL_DESC = "\u5ba1\u6279\u901a\u8fc7";
        public static final String CONTRACT_STATUS_REJECT_DESC = "\u5ba1\u6279\u62d2\u7edd";
        public static final String CONTRACT_STATUS_CHANGE_APPLY_DESC = "\u53d8\u66f4\u7533\u8bf7\u4e2d";
        public static final String CONTRACT_STATUS_UNDER_PRODUCER_SIGN_DESC = "\u751f\u6210\u65b9\u5f85\u7b7e\u7ae0";
        public static final String CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_DESC = "\u7b7e\u8ba2\u65b9\u5f85\u7b7e\u7ae0";
        public static final String CONTRACT_STATUS_EFFECT_DESC = "\u5df2\u751f\u6548";
        public static final String CONTRACT_STATUS_FAILUSER_DESC = "\u5df2\u5931\u6548";
        public static final String CONTRACT_STATUS_HIS_DESC = "\u5386\u53f2\u7248\u672c";
        public static final String CONTRACT_STATUS_ABOLISH_DESC = "\u5df2\u5e9f\u6b62";
        public static final String CONTRACT_STATUS_WAIT_FOR_SIGN_DESC = "\u5f85\u7b7e\u7ae0";
        public static final String CONTRACT_STATUS_IN_CONFIRM_DESC = "\u786e\u8ba4\u4e2d";
        public static final String CONTRACT_STATUS_IN_NEGOTIATION_DESC = "\u534f\u5546\u4e2d";
        public static final String CONTRACT_STATUS_EXECUTED_DESC = "\u5df2\u6267\u884c";
        public static final String CONTRACT_STATUS_FREEZE_DESC = "\u51bb\u7ed3";
        public static final String CONTRACT_PENDING_SUBMISSION_DESC = "\u5f85\u63d0\u4ea4\u751f\u6548";
        public static final String CONTRACT_FIRST_PARTY_WAIT_SIGNATURE_DESC = "\u7532\u65b9\u5f85\u7b7e\u7ae0";
        public static final String CONTRACT_SECOND_PARTY_WAIT_SIGNATURE_DESC = "\u4e59\u65b9\u5f85\u7b7e\u7ae0";
        public static final String CONTRACT_PENDING_PUSH_LEGAL_DESC = "\u5f85\u63a8\u9001\u6cd5\u52a1";
        public static final String CONTRACT_PENDING_PUSH_LEGAL_RETURN_DESC = "\u6cd5\u52a1\u9000\u56de";
        public static final String CONTRACT_STATUS_CHANGE_APPROVAL_OK_DESC = "\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7";
        public static final String CONTRACT_THIRD_PARTY_WAIT_SIGNATURE_DESC = "\u4e19\u65b9\u5f85\u7b7e\u7ae0";
    }

    public static final class ContractApplyOperType {
        public static final String MODIFY_APPLY_ADD = "0";
        public static final String MODIFY_APPLY_SAVE = "1";
        public static final String MODIFY_APPLY_SUBMIT = "2";
        public static final String MODIFY_APPLY_ADD_DESC = "\u65b0\u589e";
        public static final String MODIFY_APPLY_SAVE_DESC = "\u4fdd\u5b58";
        public static final String MODIFY_APPLY_SUBMIT_DESC = "\u63d0\u4ea4";
    }

    public static final class RelateType {
        public static final Integer RELATE_TYPE_CONTRACT = 1;
        public static final Integer RELATE_TYPE_MODIFY_APPLY = 2;
        public static final Integer RELATE_TYPE_CONTRACT_BASIC = 3;
        public static final Integer RELATE_TYPE_MODIFY_APPLY_BASIC = 4;
        public static final Integer RELATE_TYPE_CONTRACT_FW = 5;
        public static final Integer RELATE_TYPE_MODIFY_APPLY_FW = 6;
        public static final Integer RELATE_TYPE_CONTRACT_SUPPLIER = 7;
        public static final Integer RELATE_TYPE_MODIFY_APPLY_SUPPLIER = 8;
        public static final Integer RELATE_TYPE_BASE_OTHER_ACCESSORY = 9;
        public static final Integer RELATE_TYPE_THIRD_CONFIRM = 10;
    }

    public static final class ContractOperType {
        public static final String ADD_CODE = "0";
        public static final String SAVE_CODE = "1";
        public static final String SUBMIT_CODE = "2";
        public static final String ADD_DESC = "\u65b0\u589e";
        public static final String SAVE_DESC = "\u4fdd\u5b58";
        public static final String SUBMIT_DESC = "\u63d0\u4ea4";
        public static final String DRAFT_DESC = "\u8d77\u8349";
    }

    public static final class ContractPayTypeRelationType {
        public static final Integer RELATION_TYPE_CONTRACT = 0;
        public static final Integer RELATION_TYPE__AGREEMENT = 1;
        public static final String RELATION_TYPE_CONTRACT_DESC = "\u5408\u540c";
        public static final String RELATION_TYPE__AGREEMENT_DESC = "\u8865\u5145\u534f\u8bae";
    }

    public static final class OrderContractPayType {
        public static final Integer ALI_PAY_PHONE_CODE = 1;
        public static final Integer ALI_PAY_COMPUTER_CODE = 2;
        public static final Integer WECHAT_PAY_SCAN_CODE = 3;
        public static final Integer WECHAT_PAY_MINIPROGRAM_CODE = 4;
        public static final Integer OFFLINE_PAY_CODE = 5;
        public static final String ALI_PAY_PHONE_DESC = "\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8";
        public static final String ALI_PAY_COMPUTER_DESC = "\u652f\u4ed8\u5b9d\u7535\u8111\u7f51\u7ad9\u652f\u4ed8";
        public static final String WECHAT_PAY_SCAN_DESC = "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8";
        public static final String WECHAT_PAY_MINIPROGRAM_DESC = "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8";
        public static final String OFFLINE_PAY_DESC = "\u7ebf\u4e0b\u652f\u4ed8";
    }

    public static final class ChargeLadderRateFee {
        public static final Integer YES_CODE = 1;
        public static final Integer NO_CODE = 0;
        public static final String YES_DESC = "\u6536\u53d6";
        public static final String NO_DESC = "\u4e0d\u6536\u53d6";
    }

    public static final class BussNode {
        public static final Integer ORDER_RECEIPT_CODE = 1;
        public static final Integer ORDER_CHECK_CODE = 2;
        public static final Integer ORDER_ARRIVE_CODE = 3;
        public static final Integer INVOICE_ON_ACCOUNT_CODE = 4;
        public static final String ORDER_RECEIPT_DESC = "\u8ba2\u5355\u6536\u7968";
        public static final String ORDER_CHECK_DESC = "\u8ba2\u5355/\u9a8c\u6536\u5355\u9a8c\u6536";
        public static final String ORDER_ARRIVE_DESC = "\u8ba2\u5355/\u53d1\u8d27\u5355\u5230\u8d27";
        public static final String INVOICE_ON_ACCOUNT_DESC = "\u53d1\u7968\u6302\u8d26";
    }

    public static final class ChargeSaleCategoryFeeNode {
        public static final Integer ORDER_COLLECTION_CODE = 1;
        public static final Integer REMITTANCE_COLLECTION_CODE = 2;
        public static final String ORDER_COLLECTION_DESC = "\u4e0b\u5355\u6536\u53d6";
        public static final String REMITTANCE_COLLECTION_DESC = "\u6c47\u6b3e\u6536\u53d6";
    }

    public static final class ChargeSaleCategoryFee {
        public static final Integer YES_CODE = 1;
        public static final Integer NO_CODE = 0;
        public static final String YES_DESC = "\u6536\u53d6";
        public static final String NO_DESC = "\u4e0d\u6536\u53d6";
    }

    public static final class ExpectSettle {
        public static final Integer EXPECT_SETTLE_YES_CODE = 1;
        public static final Integer EXPECT_SETTLE_NO_CODE = 2;
        public static final String EXPECT_SETTLE_YES_DESC = "\u6307\u5b9a\u7ed3\u7b97\u65e5";
        public static final String EXPECT_SETTLE_NO_DESC = "\u4e0d\u6307\u5b9a\u7ed3\u7b97\u65e5";
    }

    public static final class PayType {
        public static final Integer PRE_PAY_CODE = 0;
        public static final Integer ACCOUNTING_PERIOD_CODE = 2;
        public static final Integer PHASED_PAYMENT_CODE = 1;
        public static final Integer ADVANCE_PAY_CODE = 3;
        public static final Integer NO_HAVE_PAY = 9;
        public static final String ADVANCE_PAY_DESC = "\u9884\u5b58\u6b3e\u652f\u4ed8";
        public static final String PRE_PAY_DESC = "\u9884\u4ed8\u6b3e\u652f\u4ed8";
        public static final String ACCOUNTING_PERIOD_DESC = "\u8d26\u671f\u652f\u4ed8";
        public static final String PHASED_PAYMENT_DESC = "\u5206\u9636\u6bb5\u652f\u4ed8";
        public static final String NO_HAVE_PAY_DESC = "\u5176\u4ed6";
    }

    public static final class HaveChangeReCode {
        public static final Integer YES = 1;
        public static final Integer NO = 0;
    }

    public static final class ContractOrgType {
        public static final Integer EXT_ENTERPRISE_CODE = 1;
        public static final Integer EXT_PERSON_CODE = 2;
        public static final String EXT_ENTERPRISE_DESC = "\u5916\u90e8\u4f01\u4e1a";
        public static final String EXT_PERSON_DESC = "\u5916\u90e8\u4e2a\u4eba";
    }

    public static final class OrgType {
        public static final String EXT_ENTERPRISE_CODE = "1";
        public static final String EXT_PERSON_CODE = "2";
        public static final String EXT_ENTERPRISE_DESC = "\u5916\u90e8\u4f01\u4e1a";
        public static final String EXT_PERSON_DESC = "\u5916\u90e8\u4e2a\u4eba";
    }

    public static final class TemplateType {
        public static final Integer TERM_TYPE_AGREE_CODE = 1;
        public static final String TERM_TYPE_AGREE_DESC = "\u534f\u8bae\u5408\u540c";
        public static final Integer TERM_TYPE_ORDER_CODE = 2;
        public static final String TERM_TYPE_ORDER_DESC = "\u8ba2\u5355\u5408\u540c";
        public static final Integer TERM_TYPE_ENTRY_CODE = 3;
        public static final String TERM_TYPE_ENTRY_DESC = "\u5165\u9a7b\u5408\u540c";
    }

    public static final class ValidStatus {
        public static final Integer VALID_STATUS_IN_USE = 1;
        public static final Integer VALID_STATUS_NOT_USE = 0;
        public static final Integer VALID_STATUS_IN_DRAFT = 1;
        public static final Integer VALID_STATUS_IN_RELEASE = 3;
    }

    public static final class TermType {
        public static final Integer TERM_TYPE_AGREE_CODE = 1;
        public static final String TERM_TYPE_AGREE_DESC = "\u534f\u8bae\u5408\u540c";
        public static final Integer TERM_TYPE_ORDER_CODE = 2;
        public static final String TERM_TYPE_ORDER_DESC = "\u8ba2\u5355\u5408\u540c";
        public static final Integer TERM_TYPE_ENTRY_CODE = 3;
        public static final String TERM_TYPE_ENTRY_DESC = "\u5165\u9a7b\u5408\u540c";
    }

    public static final class ContractApprovalResult {
        public static final Integer APPROVAL_RESULT_YES = 1;
        public static final Integer APPROVAL_RESULT_NO = 2;
        public static final String APPROVAL_RESULT_YES_DESC = "\u901a\u8fc7";
        public static final String APPROVAL_RESULT_NO_DESC = "\u9a73\u56de";
        public static final String APPROVAL = "\u5ba1\u6279";
    }

    public static final class ContractSignOrder {
        public static final Integer PRODUCERS_TO_SIGNATORIES = 1;
        public static final Integer SIGNATORIES_TO_PRODUCERS = 2;
    }

    public static final class ExceptionCode {
        public static final String RESP_DESC_ERROR = "\u5931\u8d25";
        public static final String REQ_PARAM_NULL_ERROR = "0001";
    }

    public static final class OrderSource {
        public static final Integer ORDER_SOURCE_NO_AGREE = 1;
        public static final String ORDER_SOURCE_NO_AGREE_DESC = "\u65e0\u534f\u8bae\u8ba2\u5355";
    }

    public static final class SsBusiWay {
        public static final Integer SS_BUSI_WAY_ZTB = 1;
        public static final Integer SS_BUSI_WAY_XBJ = 2;
        public static final Integer SS_BUSI_WAY_JJ = 3;
        public static final Integer SS_BUSI_WAY_WLY = 4;
        public static final String SS_BUSI_WAY_ZTB_DESC = "\u62db\u6295\u6807";
        public static final String SS_BUSI_WAY_XBJ_DESC = "\u8be2\u6bd4\u4ef7";
        public static final String SS_BUSI_WAY_JJ_DESC = "\u7ade\u4ef7";
        public static final String SS_BUSI_WAY_WLY_DESC = "\u65e0\u6765\u6e90";
    }

    public static final class AuditResult {
        public static final Integer AUDIT_RESULT_YES = 0;
        public static final Integer AUDIT_RESULT_NO = 1;
    }

    public static final class NodeType {
        public static final Integer NODE_TYPE_CONTRACT = 1;
        public static final Integer NODE_TYPE_MODIFY = 2;
    }

    public static final class RspCode {
        public static final String RESP_CODE_SUCCESS = "0000";
        public static final String RESP_DESC_SUCCESS = "\u6210\u529f";
        public static final String RESP_CODE_ERROR = "8888";
        public static final String RESP_DESC_ERROR = "\u5931\u8d25";
        public static final String QUERY_TERM_DETAILS_ERROR = "1001";
        public static final String QUERY_TERM_DETAILS_ERROR_DESC = "\u672a\u67e5\u8be2\u5230\u6761\u6b3e\u8be6\u7ec6\u6570\u636e";
        public static final String UPDATE_TERM_ERROR = "1002";
        public static final String DELETE_TERM_ERROR = "1002";
        public static final String ADD_TEMPLATE_ERROR = "1003";
        public static final String ADD_TERM_ERROR = "1004";
        public static final String UPDATE_TEMPLATE_ERROR = "1005";
        public static final String COPY_TEMPLATE_ERROR = "1006";
        public static final String ADD_CONTRACT_ERROR = "1007";
        public static final String QUERY_CONTRACT_DETAILS_ERROR = "1008";
        public static final String DELETE_CONTRACT_ERROR = "1009";
        public static final String ABOLISH_CONTRACT_ERROR = "1010";
        public static final String QUERY_CONTRACT_TAB_AMOUNT_ERROR = "1011";
        public static final String QUERY_CONTRACT_MODIFY_APPLY_DETAILS_ERROR = "1012";
        public static final String APPROVEL_CONTRACT_ERROR = "1013";
        public static final String SEND_SIGN_ERROR = "1014";
        public static final String ONLINE_EDIT_CONTRACT_ERROR = "1015";
        public static final String APPROVEL_CONTRACT_MODIFY_ERROR = "1016";
        public static final String ADD_CONTRACT_TYPE_ERROR = "1017";
        public static final String LEGAL_CONTRACT_RETURN_ERROR = "1018";
        public static final String LEGAL_CONTRACT_RETURN_UPDATE_ERROR = "1019";
        public static final String QUERY_ERP_AGR_DETAILS_CODE_ERROR = "1020";
        public static final String QUERY_ERP_AGR_DETAILS_DESC_ERROR = "\u67e5\u8be2\u5408\u540cERP\u534f\u8bae\u8be6\u60c5\u4e3a\u7a7a";
    }

    public static final class AuditMenuId {
        public static final String DW_CONTRACT = "M001003";
        public static final String PT_CONTRACT = "M001005";
        public static final String DW_CONTRACT_CHANGE = "M001004";
        public static final String PT_CONTRACT_CHANGE = "M001006";
        public static final String SPOT_CONTRACT = "M001001";
        public static final String SPOT_CONTRACT_CHANGE = "M001002";
        public static final String SPOT_PURCHASE_CONTRACT = "M0010011";
        public static final String SPOT_PURCHASE_CONTRACT_CHANGE = "M0010012";
        public static final String SPOT_SALE_CONTRACT = "M0010013";
        public static final String SPOT_SALE_CONTRACT_CHANGE = "M0010014";
        public static final String SPOT_DEVELOPMENT_CONTRACT = "M0010015";
        public static final String SPOT_DEVELOPMENT_CONTRACT_CHANGE = "M0010016";
        public static final String SPOT_ORDER_CONTRACT = "M0010017";
        public static final String SPOT_ORDER_CONTRACT_CHANGE = "M0010018";
        public static final String PURCHASE_SPOT_CONTRACT = "M0010019";
        public static final String PURCHASE_SPOT_CONTRACT_CHANGE = "M0010020";
        public static final String PURCHASE_LONG_TERM_CONS_SALE_CONTRACT = "M0010021";
        public static final String PURCHASE_LONG_TERM_CONS_SALE_CONTRACT_CHANGE = "M0010022";
        public static final String PURCHASE_LONG_TERM_PRICING_CONTRACT = "M0010023";
        public static final String PURCHASE_LONG_TERM_PRICING_CONTRACT_CHANGE = "M0010024";
        public static final String PURCHASE_ORDER_CONTRACT = "M0010025";
        public static final String PURCHASE_ORDER_CONTRACT_CHANGE = "M0010026";
        public static final String PURCHASE_ORDER_NON_TRADE_CONTRACT = "M0010027";
        public static final String PURCHASE_ORDER_NON_TRADE_CONTRACT_CHANGE = "M0010028";
        public static final String PURCHASE_ERP_INT_CONTRACT_CHANGE = "M0010029";
        public static final String OTHER_CONTRACT = "M0010030";
        public static final String PURCHASE_SPOT_CONTRACT_CHANGE_MATERIAL = "M0010001";
        public static final String PURCHASE_LONG_TERM_PRICING_CONTRACT_CHANGE_MATERIAL = "M0010002";
        public static final String PURCHASE_LONG_TERM_CONS_SALE_CONTRACT_CHANGE_MATERIAL = "M0010003";
        public static final String PURCHASE_ORDER_CONTRACT_CHANGE_MATERIAL = "M00100012";
        public static final String PURCHASE_ORDER_NON_TRADE_CONTRACT_CHANGE_MATERIAL = "M00100013";
        public static final String DW_CONTRACT_CHANGE_MATERIAL = "M00100014";
        public static final String SPOT_CONTRACT_CHANGE_MATERIAL = "M0010006";
        public static final String SPOT_PURCHASE_CONTRACT_CHANGE_MATERIAL = "M0010007";
        public static final String SPOT_SALE_CONTRACT_CHANGE_MATERIAL = "M0010008";
        public static final String SPOT_DEVELOPMENT_CONTRACT_CHANGE_MATERIAL = "M0010009";
        public static final String SPOT_ORDER_CONTRACT_CHANGE_MATERIAL = "M00100010";
        public static final String PT_CONTRACT_CHANGE_MATERIAL = "M00100011";
    }

    public static final class PushMdm {
        public static final String MDM_KUCUN = "1";
        public static final String MDM_KUCUN_DESC = "\u5e93\u5b58\u7c7b";
        public static final String MDM_ZIHCHAN = "2";
        public static final String MDM_ZIHCHAN_DESC = "\u8d44\u4ea7\u7c7b";
    }

    public static final class NodeCode {
        public static final String NODE_CODE_CREATE_CONTRACT = "CREATE_CONTRACT";
        public static final String NODE_CODE_CONTRACT_APPROVAL = "CONTRACT_APPROVAL";
        public static final String NODE_CODE_SEND_SIGN = "SEND_SIGN";
        public static final String NODE_CODE_PRODUCER_SIGN = "PRODUCER_SIGN";
        public static final String NODE_CODE_SIGNATORIES_SIGN = "SIGNATORIES_SIGN";
        public static final String NODE_CODE_CONTRACT_EFFECT = "CONTRACT_EFFECT";
        public static final String NODE_CODE_CONTRACT_CONFIRM = "CONTRACT_CONFIRM";
        public static final String NODE_CODE_CONTRACT_ABOLISH = "CONTRACT_ABOLISH";
        public static final String NODE_CODE_FIRST_PARTY_SIGN = "FIRST_PARTY_SIGN";
        public static final String NODE_CODE_SECOND_PARTY_SIGN = "SECOND_PARTY_SIGN";
        public static final String NODE_CODE_THIRD_PARTY_SIGN = "THIRD_PARTY_SIGN";
        public static final String NODE_CODE_SUBORDINATE_UNITS_APPROVAL = "SUBORDINATE_UNITS_APPROVAL";
        public static final String NODE_NAME_CREATE_CONTRACT = "\u65b0\u5efa\u5408\u540c";
        public static final String NODE_NAME_CONTRACT_APPROVAL = "\u5408\u540c\u5ba1\u6279";
        public static final String NODE_NAME_SEND_SIGN = "\u53d1\u8d77\u7b7e\u7ae0";
        public static final String NODE_NAME_PRODUCER_SIGN = "\u751f\u6210\u65b9\u7b7e\u7ae0";
        public static final String NODE_NAME_SIGNATORIES_SIGN = "\u7b7e\u8ba2\u65b9\u7b7e\u7ae0";
        public static final String NODE_NAME_CONTRACT_EFFECT = "\u5408\u540c\u751f\u6548";
        public static final String NODE_NAME_CONTRACT_CONFIRM = "\u5408\u540c\u786e\u8ba4";
        public static final String NODE_NAME_CONTRACT_ABOLISH = "\u5408\u540c\u5e9f\u6b62";
        public static final String NODE_NAME_FIRST_PARTY_SIGN = "\u7532\u65b9\u7b7e\u7ae0";
        public static final String NODE_NAME_SECOND_PARTY_SIGN = "\u4e59\u65b9\u7b7e\u7ae0";
        public static final String NODE_NAME_THIRD_PARTY_SIGN = "\u4e19\u65b9\u7b7e\u7ae0";
        public static final String NODE_NAME_SUBORDINATE_UNITS_APPROVAL = "\u6240\u5c5e\u5355\u4f4d\u5ba1\u6279";
    }
}

