/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.CContractSignerAbilityService;
import com.tydic.contract.ability.bo.CContractSignerQuerAbilityReq;
import com.tydic.contract.ability.bo.CContractSignerQuerAbilityRsp;
import com.tydic.contract.ability.bo.CContractSignerSaveReq;
import com.tydic.contract.ability.bo.CContractSignerSaveRsp;
import com.tydic.contract.ability.bo.other.CContractSignerBO;
import com.tydic.contract.busi.CContractSignerBusiService;
import com.tydic.contract.dao.CContractSignerMapper;
import com.tydic.contract.po.CContractSigner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.CContractSignerAbilityService"})
public class CContractSignerAbilityServiceImpl
implements CContractSignerAbilityService {
    @Autowired
    private CContractSignerBusiService cContractSignerBusiService;
    @Autowired
    private CContractSignerMapper cContractSignerMapper;

    @PostMapping(value={"saveContractSigner"})
    public CContractSignerSaveRsp saveContractSigner(@RequestBody CContractSignerSaveReq req) {
        this.verify(req);
        return this.cContractSignerBusiService.saveContractSigner(req);
    }

    @PostMapping(value={"getListSignByOrgId"})
    public CContractSignerQuerAbilityRsp getListSignByOrgId(@RequestBody CContractSignerQuerAbilityReq reqBO) {
        CContractSignerQuerAbilityRsp rspBO = new CContractSignerQuerAbilityRsp();
        CContractSigner cContractSigner = new CContractSigner();
        cContractSigner.setOrgCode(reqBO.getOrgCode());
        cContractSigner.setIsSigner(reqBO.getIsSigner());
        if (reqBO.getIsSigner() == 0) {
            cContractSigner.setSignerName(reqBO.getSignerName());
            cContractSigner.setSignerPhone(reqBO.getSignerPhone());
        } else {
            cContractSigner.setSignerName(reqBO.getSignatureName());
            cContractSigner.setSignerPhone(reqBO.getSignaturePhone());
        }
        List<CContractSigner> cContractSigners = this.cContractSignerMapper.queryAllLike(cContractSigner);
        if (CollectionUtils.isEmpty(cContractSigners)) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRows(new ArrayList());
            rspBO.setRecordsTotal(Integer.valueOf(0));
            return rspBO;
        }
        List collect = cContractSigners.stream().sorted(Comparator.comparing(CContractSigner::getId)).skip((reqBO.getPageNo() - 1) * reqBO.getPageSize()).limit(reqBO.getPageSize().intValue()).collect(Collectors.toList());
        List<CContractSignerBO> contractPayTypeBOS = new ArrayList();
        if (reqBO.getIsSigner() == 0) {
            if (!CollectionUtils.isEmpty(collect)) {
                contractPayTypeBOS = JSONArray.parseArray((String)JSON.toJSONString(collect)).toJavaList(CContractSignerBO.class);
            }
        } else {
            for (CContractSigner e : collect) {
                CContractSignerBO cContractSignerBO = new CContractSignerBO();
                BeanUtils.copyProperties((Object)e, (Object)cContractSignerBO);
                cContractSignerBO.setSignatureName(e.getSignerName());
                cContractSignerBO.setSignaturePhone(e.getSignerPhone());
                contractPayTypeBOS.add(cContractSignerBO);
            }
        }
        rspBO.setRows(contractPayTypeBOS);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(Integer.valueOf(collect.size()));
        rspBO.setRecordsTotal(Integer.valueOf(cContractSigners.size()));
        return rspBO;
    }

    private void verify(CContractSignerSaveReq req) {
        if (null == req) {
            throw new ZTBusinessException("\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)req.getCContractSignerBOS())) {
            throw new ZTBusinessException("\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List cContractSignerBOS = req.getCContractSignerBOS();
        cContractSignerBOS.forEach(e -> {
            if (StringUtils.isEmpty((Object)e.getOrgCode())) {
                throw new ZTBusinessException("\u5355\u4f4did/\u4e70\u53d7\u4eba\u7f16\u7801\uff01");
            }
            if (StringUtils.isEmpty((Object)e.getSignerName())) {
                throw new ZTBusinessException("\u7b7e\u540d\u4eba\u540d\u79f0\uff01");
            }
            if (StringUtils.isEmpty((Object)e.getSignatureName())) {
                throw new ZTBusinessException("\u7b7e\u7ae0\u4eba\u540d\u79f0\uff01");
            }
        });
    }
}

