/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractAddNewAbilityService;
import com.tydic.contract.ability.ContractBusinessToDoComAbilityService;
import com.tydic.contract.ability.bo.ContractAddNewAbilityReqBO;
import com.tydic.contract.ability.bo.ContractAddNewAbilityRspBO;
import com.tydic.contract.ability.bo.ContractApproveWaitNotificationReqBO;
import com.tydic.contract.ability.bo.ContractCheckContractIsHaveReqBO;
import com.tydic.contract.ability.bo.ContractFixedContractBeforeReqBO;
import com.tydic.contract.ability.bo.ContractFixedContractCodeReqBO;
import com.tydic.contract.ability.bo.ContractFixedContractReqBO;
import com.tydic.contract.ability.bo.ContractPushDealConvFwTextFileAbilityReqBO;
import com.tydic.contract.ability.bo.ContractReqInfoBO;
import com.tydic.contract.ability.bo.ContractTodoBusinessWaitDoneAbilityRspBo;
import com.tydic.contract.ability.bo.ContractTodoBusinessWaitDoneAddAbilityReqBo;
import com.tydic.contract.busi.ContractAddNewBusiService;
import com.tydic.contract.busi.ContractTodoBusiService;
import com.tydic.contract.busi.bo.ContractAddNewBusiReqBO;
import com.tydic.contract.busi.bo.ContractAddNewBusiRspBO;
import com.tydic.contract.busi.bo.ContractFixedContractBeforeBusiReqBO;
import com.tydic.contract.busi.bo.ContractFixedContractBusiReqBO;
import com.tydic.contract.busi.bo.ContractFixedContractBusiRspBO;
import com.tydic.contract.busi.bo.ContractFixedContractCodeBusiReqBO;
import com.tydic.contract.busi.bo.TodoWaitDoneReqBo;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.todo.ability.api.TodoBusinessWaitDoneAddAbilityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractAddNewAbilityService"})
public class ContractAddNewAbilityServiceImpl
implements ContractAddNewAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractAddNewAbilityServiceImpl.class);
    @Autowired
    private ContractAddNewBusiService contractAddNewBusiService;
    @Resource(name="mqContractPushDealConvFwTextFileProvider")
    private ProxyMessageProducer mqContractPushDealConvFwTextFileProvider;
    @Value(value="${CONTRACT_PUSH_DEAL_CONV_FW_TEXT_FILE_TOPIC:CONTRACT_PUSH_DEAL_CONV_FW_TEXT_FILE_TOPIC}")
    private String contractPushDealConvFwTextFileTopic;
    @Value(value="${CONTRACT_PUSH_DEAL_CONV_FW_TEXT_FILE_TAG:*}")
    private String contractPushDealConvFwTextFileTag;
    @Resource(name="pushAgentProvider")
    private ProxyMessageProducer pushAgentProvider;
    @Value(value="${TODO_ADD_WAIT_DONE_TOPIC:TODO_ADD_WAIT_DONE_TOPIC}")
    private String todoAddWaitDoneTopic;
    @Value(value="${TODO_ADD_WAIT_DONE_TAG:*}")
    private String todoAddWaitDoneTag;
    @Autowired
    private ContractTodoBusiService contractTodoBusiService;
    @Autowired
    private TodoBusinessWaitDoneAddAbilityService addWaitDoneService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Resource(name="mqContractApproveWaitNotificationProvider")
    private ProxyMessageProducer mqContractApproveWaitNotificationProvider;
    @Value(value="${CONTRACT_APPROVE_WAIT_NOTIFICATION_PID_TOPIC:CONTRACT_APPROVE_WAIT_NOTIFICATION_PID_TOPIC}")
    private String contractApproveWaitNotificationPidTopic;
    @Value(value="${CONTRACT_APPROVE_WAIT_NOTIFICATION_PID_TAG:*}")
    private String contractApproveWaitNotificationPidTag;
    @Resource(name="mqContractApproveEntrustNotificationProvider")
    private ProxyMessageProducer mqContractApproveEntrustNotificationProvider;
    @Value(value="${CONTRACT_APPROVE_ENTRUST_NOTIFICATION_TOPIC:CONTRACT_APPROVE_ENTRUST_NOTIFICATION_TOPIC}")
    private String contractApproveEntrustNotificationTopic;
    @Value(value="${CONTRACT_APPROVE_ENTRUST_NOTIFICATION_TAG:*}")
    private String contractApproveEntrustNotificationTag;
    private List<Integer> CG_KJ_XY = Arrays.asList(12, 13);
    private List<Integer> CG_HT = Arrays.asList(11, 20, 21);
    @Autowired
    private ContractBusinessToDoComAbilityService contractBusinessToDoComService;

    @PostMapping(value={"addContractNew"})
    public ContractAddNewAbilityRspBO addContractNew(@RequestBody ContractAddNewAbilityReqBO reqBO) {
        ContractAddNewBusiRspBO contractAddNewBusiRspBO;
        ContractAddNewBusiReqBO contractAddNewBusiReqBO = new ContractAddNewBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)contractAddNewBusiReqBO));
        ContractAddNewAbilityRspBO rspBO = this.checkContractIsHave(reqBO);
        if (rspBO != null) {
            return rspBO;
        }
        if (!StringUtils.isEmpty((String)reqBO.getTemplateCode())) {
            contractAddNewBusiReqBO.setContractDocUrl(null);
        }
        if ("0000".equals((contractAddNewBusiRspBO = this.contractAddNewBusiService.addContractNew(contractAddNewBusiReqBO)).getRespCode()) && reqBO.getContractId() != null) {
            ContractInfoPO po = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
            if (po != null && po.getPushLegalFlag() != null && po.getPushLegalFlag() == 1 && !StringUtils.isEmpty((String)po.getContractDocUrl()) && !po.getContractDocUrl().endsWith(".pdf") && (po.getContractDocUrl().endsWith(".doc") || po.getContractDocUrl().endsWith(".docx"))) {
                List<Object> materialCategoryList = new ArrayList();
                String extFiled2 = po.getExtFiled2();
                if (!StringUtils.isEmpty((String)extFiled2)) {
                    List codes = JSONObject.parseArray((String)extFiled2, String.class);
                    materialCategoryList = codes.stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList());
                }
                if (materialCategoryList.contains(po.getMaterialCategory())) {
                    ContractPushDealConvFwTextFileAbilityReqBO pushDealConvFwTextFileAbilityReqBO = new ContractPushDealConvFwTextFileAbilityReqBO();
                    pushDealConvFwTextFileAbilityReqBO.setContractId(reqBO.getContractId());
                    try {
                        log.info("\u8f6c\u6362\u6cd5\u52a1\u6587\u672c\u9644\u4ef6\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)pushDealConvFwTextFileAbilityReqBO));
                        this.mqContractPushDealConvFwTextFileProvider.send(new ProxyMessage(this.contractPushDealConvFwTextFileTopic, this.contractPushDealConvFwTextFileTag, JSON.toJSONString((Object)pushDealConvFwTextFileAbilityReqBO)));
                    }
                    catch (Exception e2) {
                        log.error("\u8f6c\u6362\u6cd5\u52a1\u6587\u672c\u9644\u4ef6\u6d88\u606f\u5931\u8d25\uff1a" + e2.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)pushDealConvFwTextFileAbilityReqBO));
                    }
                }
            }
            log.info("*************\u63a8\u9001\u5ba1\u6279\u4e2d\u6570\u636e\u5230\u4ee3\u529e\uff1a" + JSON.toJSONString((Object)po));
            if (po.getContractStatus() == 2 && (po.getPushLegalContractCode() == null || "".equals(po.getPushLegalContractCode()))) {
                TodoWaitDoneReqBo todoWaitDoneReqBo = new TodoWaitDoneReqBo();
                todoWaitDoneReqBo.setContractId(po.getContractId());
                todoWaitDoneReqBo.setContractCode(po.getContractCode());
                todoWaitDoneReqBo.setContractType(po.getContractType());
                todoWaitDoneReqBo.setContractName(po.getContractName());
                log.info("*************\u63a8\u9001\u5ba1\u6279\u4e2d\u6570\u636e\u5230\u4ee3\u529e\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString((Object)todoWaitDoneReqBo));
                this.contractTodoBusiService.todoAddWaitDone(todoWaitDoneReqBo, (ContractReqInfoBO)reqBO);
            }
            if (ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL.equals(po.getContractStatus())) {
                ContractApproveWaitNotificationReqBO contractApproveWaitNotificationReqBO = new ContractApproveWaitNotificationReqBO();
                ArrayList<Long> contractIds = new ArrayList<Long>();
                contractIds.add(contractAddNewBusiReqBO.getContractId());
                contractApproveWaitNotificationReqBO.setContractIds(contractIds);
                contractApproveWaitNotificationReqBO.setType(Integer.valueOf(1));
                try {
                    log.info("\u5408\u540c\u5ba1\u6279\u5f85\u529e\u901a\u77e5\u53d1\u9001\u670d\u52a1\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)contractApproveWaitNotificationReqBO));
                    this.mqContractApproveWaitNotificationProvider.send(new ProxyMessage(this.contractApproveWaitNotificationPidTopic, this.contractApproveWaitNotificationPidTag, JSON.toJSONString((Object)contractApproveWaitNotificationReqBO)));
                }
                catch (Exception e3) {
                    log.error("\u5408\u540c\u5ba1\u6279\u5f85\u529e\u901a\u77e5\u53d1\u9001\u670d\u52a1\u6d88\u606f\u5931\u8d25\uff1a" + e3.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)contractApproveWaitNotificationReqBO));
                }
            }
            if (po != null && po.getIsNeedSupplierConfirm() != null && po.getContractType() != null) {
                HashMap<String, String> map = null;
                try {
                    map = new HashMap<String, String>();
                    List<Integer> contractTypeOfXH = Arrays.asList(ContractConstant.ContractType.SPOT_CONTRACT, ContractConstant.ContractType.PURCHASE_CONTRACT, ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT, ContractConstant.ContractType.FUNCTION_SPOTS_CONTRACT, ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT, ContractConstant.ContractType.PURCHASE_TRADE_ORDER_CONTRACT, ContractConstant.ContractType.PURCHASE_NO_TRADE_ORDER_CONTRACT);
                    List<Integer> contractTypeOfKJ = Arrays.asList(ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE, ContractConstant.ContractType.DEVELOPMENT_CONTRACT, ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT, ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT, ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT, ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT);
                    if (po.getIsNeedSupplierConfirm() == 0 && contractTypeOfXH.contains(po.getContractType())) {
                        map.put("busiCode", "6024");
                    } else if (po.getIsNeedSupplierConfirm() == 0 && contractTypeOfKJ.contains(po.getContractType())) {
                        map.put("busiCode", "6025");
                    }
                }
                catch (Exception e4) {
                    log.error("\u533a\u5206\u4e1a\u52a1\u7c7b\u578b\u5931\u8d25");
                }
                if (map.size() != 0 && map.get("busiCode") != null) {
                    try {
                        ContractTodoBusinessWaitDoneAddAbilityReqBo waitDoneBo = new ContractTodoBusinessWaitDoneAddAbilityReqBo();
                        waitDoneBo.setBusiCode((String)map.get("busiCode"));
                        waitDoneBo.setBusiName("\u901a\u77e5\u4e0b\u53d1\u5f85\u529e");
                        waitDoneBo.setObjId(String.valueOf(reqBO.getContractId()));
                        waitDoneBo.setObjNo(reqBO.getContractNo());
                        waitDoneBo.setObjName(reqBO.getContractName());
                        waitDoneBo.setHandleUserName(reqBO.getUsername());
                        waitDoneBo.setHandleUserNo(String.valueOf(reqBO.getUserId()));
                        waitDoneBo.setSubmitUserName(reqBO.getUsername());
                        waitDoneBo.setSubmitUserNo(String.valueOf(reqBO.getUserId()));
                        waitDoneBo.setHandleOrgNo(reqBO.getOrgCodeIn());
                        waitDoneBo.setHandleOrgName(reqBO.getOrgName());
                        waitDoneBo.setSupId(reqBO.getSupplierId());
                        waitDoneBo.setSupName(reqBO.getSupplierName());
                        log.error("\u4e1a\u52a1\u5f85\u529e-\u63a8\u9001\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)waitDoneBo));
                        ContractTodoBusinessWaitDoneAbilityRspBo businessWaitDone = this.contractBusinessToDoComService.addWaitDone(waitDoneBo);
                        if (!"0000".equals(businessWaitDone.getRespCode())) {
                            log.error("9001\u901a\u77e5\u4e0b\u53d1\u5f85\u529e-\u8be2\u6bd4\u7ed3\u679c\u5ba1\u6279\u901a\u8fc7\uff08\u65b0\u589e\u5f85\u529e\uff09,\u63a8\u9001\u5931\u8d25\uff1a{}", (Object)businessWaitDone.getRespDesc());
                        }
                    }
                    catch (Exception e5) {
                        log.error("\u63a8\u9001\u4e1a\u52a1\u4ee3\u529e\u5f02\u5e38\uff1a", (Throwable)e5);
                    }
                }
            }
        }
        ContractAddNewAbilityRspBO contractAddNewAbilityRspBO = (ContractAddNewAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)contractAddNewBusiRspBO)), ContractAddNewAbilityRspBO.class);
        try {
            this.addTodo(contractAddNewBusiRspBO, reqBO);
        }
        catch (Exception e6) {
            log.error("------------------->\u63a8\u9001\u65b0\u589e\u4e1a\u52a1\u5f85\u529e\u5f02\u5e38\uff1a" + e6.getMessage());
        }
        if ("0000".equals(contractAddNewBusiRspBO.getRespCode()) && !CollectionUtils.isEmpty(contractAddNewBusiRspBO.getAuditNoticeList())) {
            ContractApproveWaitNotificationReqBO approveWaitNotificationReqBO = new ContractApproveWaitNotificationReqBO();
            try {
                approveWaitNotificationReqBO.setAuditNoticeList(contractAddNewBusiRspBO.getAuditNoticeList());
                approveWaitNotificationReqBO.setApproveEntrustType(Integer.valueOf(1));
                log.info("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveWaitNotificationReqBO));
                this.mqContractApproveEntrustNotificationProvider.send(new ProxyMessage(this.contractApproveEntrustNotificationTopic, this.contractApproveEntrustNotificationTag, JSON.toJSONString((Object)approveWaitNotificationReqBO)));
            }
            catch (Exception e7) {
                log.error("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e7.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)approveWaitNotificationReqBO));
            }
        }
        return (ContractAddNewAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)contractAddNewBusiRspBO)), ContractAddNewAbilityRspBO.class);
    }

    private void addTodo(ContractAddNewBusiRspBO contractAddNewBusiRspBO, ContractAddNewAbilityReqBO reqBO) {
        log.error("\u63a8\u9001\u6cd5\u52a1\u5f85\u529e\u5165\u53c2{}", (Object)JSON.toJSONString((Object)reqBO));
        ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId());
        log.error("\u63a8\u9001\u6cd5\u52a1\u5f85\u529e\u5408\u540c", (Object)JSON.toJSONString((Object)contractInfoPO));
        if (ContractConstant.ContractStatus.CONTRACT_PENDING_PUSH_LEGAL.equals(contractInfoPO.getContractStatus())) {
            ContractTodoBusinessWaitDoneAddAbilityReqBo todoBusinessWaitDoneAddReqBo = new ContractTodoBusinessWaitDoneAddAbilityReqBo();
            if (this.CG_HT.contains(reqBO.getContractType())) {
                todoBusinessWaitDoneAddReqBo.setBusiCode("6029");
            } else if (this.CG_KJ_XY.contains(reqBO.getContractType())) {
                todoBusinessWaitDoneAddReqBo.setBusiCode("6030");
            } else {
                return;
            }
            todoBusinessWaitDoneAddReqBo.setSubmitTime(new Date());
            todoBusinessWaitDoneAddReqBo.setHandleUserNo(reqBO.getOrgName());
            todoBusinessWaitDoneAddReqBo.setHandleOrgNo(reqBO.getOrgCodeIn());
            todoBusinessWaitDoneAddReqBo.setHandleUserNo(reqBO.getOccupation());
            todoBusinessWaitDoneAddReqBo.setHandleUserName(reqBO.getName());
            todoBusinessWaitDoneAddReqBo.setSubmitUserNo(reqBO.getOccupation());
            todoBusinessWaitDoneAddReqBo.setSubmitUserName(reqBO.getName());
            todoBusinessWaitDoneAddReqBo.setObjId(String.valueOf(contractInfoPO.getContractId()));
            todoBusinessWaitDoneAddReqBo.setObjNo(contractInfoPO.getContractCode());
            this.contractBusinessToDoComService.addWaitDone(todoBusinessWaitDoneAddReqBo);
        }
    }

    protected ContractAddNewAbilityRspBO checkContractIsHave(ContractAddNewAbilityReqBO reqBO) {
        if (!ObjectUtils.isEmpty((Object)reqBO) && (ObjectUtil.equal((Object)reqBO.getContractType(), (Object)ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT) || ObjectUtil.equal((Object)reqBO.getContractType(), (Object)ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT)) && StringUtils.isNotBlank((String)reqBO.getAgencyContractCode())) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            contractInfoPO.setAgencyContractCode(reqBO.getAgencyContractCode());
            contractInfoPO.setBuyerNo(reqBO.getBuyerNo());
            ContractInfoPO contractInfoPOData = this.contractInfoMapper.qryContractByBuyNoAndAgreementCode(contractInfoPO);
            if (!ObjectUtils.isEmpty((Object)contractInfoPOData) && !ObjectUtil.equal((Object)contractInfoPOData.getContractId(), (Object)reqBO.getContractId())) {
                StringBuilder msg = new StringBuilder();
                msg.append(contractInfoPOData.getBuyerName()).append("\u5df2\u5f15\u7528\u96c6\u91c7\u6846\u67b6\u534f\u8bae\u3010").append(contractInfoPOData.getAgencyContractCode()).append("\u3011\u521b\u5efa\u534f\u8bae\uff0c\u5bf9\u5e94\u534f\u8bae\u7f16\u53f7").append(contractInfoPOData.getContractNo());
                ContractAddNewAbilityRspBO rspBO = new ContractAddNewAbilityRspBO();
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setResultMessage(String.valueOf(msg));
                return rspBO;
            }
        }
        return null;
    }

    @PostMapping(value={"fixedContractAfter"})
    public ContractAddNewAbilityRspBO fixedContractAfter(@RequestBody ContractFixedContractReqBO reqBO) {
        ContractFixedContractBusiReqBO contractFixedContractReqBO = new ContractFixedContractBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)contractFixedContractReqBO);
        ContractFixedContractBusiRspBO contractFixedContractBusiRspBO = new ContractFixedContractBusiRspBO();
        Map<String, String> dataResult = contractFixedContractBusiRspBO.getDataResult();
        if (!CollectionUtils.isEmpty(contractFixedContractReqBO.getPlaAgreementCodes())) {
            for (String plaAgreementCode : contractFixedContractReqBO.getPlaAgreementCodes()) {
                try {
                    ContractFixedContractBusiRspBO rspData = this.contractAddNewBusiService.fixedContract(plaAgreementCode, contractFixedContractReqBO.getName());
                    dataResult.put(plaAgreementCode, rspData.getRespDesc());
                }
                catch (Exception e) {
                    log.info("\u5904\u7406" + plaAgreementCode + "\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e);
                    dataResult.put(plaAgreementCode, "\u5931\u8d25");
                }
            }
        }
        return (ContractAddNewAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)contractFixedContractBusiRspBO)), ContractAddNewAbilityRspBO.class);
    }

    @PostMapping(value={"fixedContractBefore"})
    public ContractAddNewAbilityRspBO fixedContractBefore(@RequestBody ContractFixedContractBeforeReqBO reqBO) {
        ContractFixedContractBeforeBusiReqBO contractFixedContractReqBO = new ContractFixedContractBeforeBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)contractFixedContractReqBO);
        ContractFixedContractBusiRspBO contractFixedContractBusiRspBO = new ContractFixedContractBusiRspBO();
        contractFixedContractBusiRspBO = this.contractAddNewBusiService.fixedContractBefore(contractFixedContractReqBO);
        return (ContractAddNewAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)contractFixedContractBusiRspBO)), ContractAddNewAbilityRspBO.class);
    }

    @PostMapping(value={"fixedContractCode"})
    public ContractAddNewAbilityRspBO fixedContractCode(@RequestBody ContractFixedContractCodeReqBO reqBO) {
        ContractFixedContractCodeBusiReqBO contractFixedContractNoBusiReqBO = new ContractFixedContractCodeBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)contractFixedContractNoBusiReqBO);
        ContractFixedContractBusiRspBO contractFixedContractBusiRspBO = this.contractAddNewBusiService.fixedContractCode(contractFixedContractNoBusiReqBO);
        return (ContractAddNewAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)contractFixedContractBusiRspBO)), ContractAddNewAbilityRspBO.class);
    }

    @PostMapping(value={"checkContractIsHaveHT"})
    public ContractAddNewAbilityRspBO checkContractIsHaveHT(@RequestBody ContractCheckContractIsHaveReqBO reqBO) {
        ContractAddNewAbilityRspBO rspBO = new ContractAddNewAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!ObjectUtils.isEmpty((Object)reqBO) && StringUtils.isNotBlank((String)reqBO.getAgencyContractCode())) {
            ContractInfoPO contractInfoPO = new ContractInfoPO();
            contractInfoPO.setAgencyContractCode(reqBO.getAgencyContractCode());
            contractInfoPO.setBuyerNo(reqBO.getBuyerNo());
            ContractInfoPO contractInfoPOData = this.contractInfoMapper.qryContractByBuyNoAndAgreementCode(contractInfoPO);
            if (!ObjectUtils.isEmpty((Object)contractInfoPOData)) {
                StringBuilder msg = new StringBuilder();
                msg.append(contractInfoPOData.getBuyerName()).append("\u5df2\u5f15\u7528\u96c6\u91c7\u6846\u67b6\u534f\u8bae\u3010").append(contractInfoPOData.getAgencyContractCode()).append("\u3011\u521b\u5efa\u534f\u8bae\uff0c\u5bf9\u5e94\u534f\u8bae\u7f16\u53f7").append(contractInfoPOData.getContractNo());
                rspBO.setResultMessage(String.valueOf(msg));
            }
        }
        return rspBO;
    }
}

