/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractBusinessToDoComAbilityService;
import com.tydic.contract.ability.ContractItemAddWaitOrderAbilityService;
import com.tydic.contract.ability.bo.ContractItemAddWaitOrderAbilityBO;
import com.tydic.contract.ability.bo.ContractItemAddWaitOrderAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemAddWaitOrderAbilityRspBO;
import com.tydic.contract.ability.bo.ContractTodoBusinessWaitDoneAddAbilityReqBo;
import com.tydic.contract.ability.bo.ContractTodoBusinessWaitDoneDealAbilityReqBo;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractPreBuyMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.po.CContractPreBuyPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractOrderPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractItemAddWaitOrderAbilityService"})
public class ContractItemAddWaitOrderAbilityServiceImpl
implements ContractItemAddWaitOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemAddWaitOrderAbilityServiceImpl.class);
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private CContractPreBuyMapper cContractPreBuyMapper;
    @Autowired
    private ContractBusinessToDoComAbilityService contractBusinessToDoComAbilityService;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"addWaitOrder"})
    public ContractItemAddWaitOrderAbilityRspBO addWaitOrder(@RequestBody ContractItemAddWaitOrderAbilityReqBO reqBO) {
        Object contractInfoPOS;
        ContractItemAddWaitOrderAbilityRspBO rspBO = new ContractItemAddWaitOrderAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getContractItems())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4e0d\u8981\u4f20\u5165\u7a7a\u503c");
            return rspBO;
        }
        if (reqBO.getUserId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u7528\u6237\u7684userId\u4e3a\u7a7a");
            return rspBO;
        }
        for (ContractItemAddWaitOrderAbilityBO contractItem : reqBO.getContractItems()) {
            if (contractItem.getContractId() == null) {
                throw new ZTBusinessException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (contractItem.getItemId() == null) {
                throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (contractItem.getPreSaleNum() != null) continue;
            throw new ZTBusinessException("\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Long> itemIds = reqBO.getContractItems().stream().map(ContractItemAddWaitOrderAbilityBO::getItemId).collect(Collectors.toList());
        List<ContractOrderPo> contractOrderPos = this.contractOrderMapper.selectListByItemIds(itemIds);
        List<ContractInfoItemPO> contractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(itemIds);
        if (CollectionUtils.isEmpty(contractInfoItemPOS) || contractInfoItemPOS.size() != reqBO.getContractItems().size()) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u53ef\u80fd\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\uff1b\u6216\u52a0\u5165\u7684\u660e\u7ec6\u4e2d\u6709\u91cd\u590d\u7684\u6570\u636e\u8bf7\u6ce8\u610f");
            return rspBO;
        }
        Map<Long, List<ContractInfoItemPO>> itemMap = contractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getItemId));
        Map<Long, List<ContractOrderPo>> orderMap = contractOrderPos.stream().filter(e -> e.getItemId() != null).collect(Collectors.groupingBy(ContractOrderPo::getItemId));
        List<Long> contractIds = contractInfoItemPOS.stream().filter(e -> e.getRelateId() != null).map(ContractInfoItemPO::getRelateId).collect(Collectors.toList());
        List<Object> jumpContractIds = new ArrayList();
        if (!CollectionUtils.isEmpty(contractIds) && !CollectionUtils.isEmpty((Collection)(contractInfoPOS = this.contractInfoMapper.getListByContractIds(contractIds)))) {
            jumpContractIds = contractInfoPOS.stream().filter(e -> ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(e.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(e.getContractType()) || ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT.equals(e.getContractType()) || ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(e.getContractType()) && ContractConstant.BusinessType.SELF_PURCHASE.equals(e.getBusinessType())).map(ContractInfoPO::getContractId).collect(Collectors.toList());
        }
        for (ContractItemAddWaitOrderAbilityBO contractItem : reqBO.getContractItems()) {
            BigDecimal amount = null;
            BigDecimal sumDoOrderNum = null;
            List<ContractInfoItemPO> infoItemPOS = itemMap.get(contractItem.getItemId());
            if (CollectionUtils.isEmpty(infoItemPOS)) {
                throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6id\uff1a" + contractItem.getItemId() + "\u4e0d\u5b58\u5728");
            }
            amount = infoItemPOS.get(0).getAmount();
            List<ContractOrderPo> orderPos = orderMap.get(contractItem.getItemId());
            sumDoOrderNum = !CollectionUtils.isEmpty(orderPos) ? orderPos.get(0).getSumDoOrderNum() : BigDecimal.ZERO;
            if (jumpContractIds.contains(contractItem.getContractId()) || amount.subtract(sumDoOrderNum).compareTo(contractItem.getPreSaleNum()) >= 0) continue;
            throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6id\uff1a" + contractItem.getItemId() + "\u4e0d\u6ee1\u8db3\u53ef\u4e0b\u5355\u91cf\uff1b\u7269\u8d44\u7f16\u7801:" + infoItemPOS.get(0).getMaterialCode());
        }
        CContractPreBuyPO seachPO = new CContractPreBuyPO();
        seachPO.setCreateUserId(reqBO.getUserId());
        seachPO.setItemIds(itemIds);
        List<CContractPreBuyPO> aleadyInsertPOS = this.cContractPreBuyMapper.getList(seachPO);
        List<Object> aleadyItemIds = new ArrayList();
        if (!CollectionUtils.isEmpty(aleadyInsertPOS)) {
            aleadyItemIds = aleadyInsertPOS.stream().map(CContractPreBuyPO::getItemId).collect(Collectors.toList());
        }
        Date now = new Date();
        ArrayList<CContractPreBuyPO> insertPos = new ArrayList<CContractPreBuyPO>();
        ArrayList<CContractPreBuyPO> updatePos = new ArrayList<CContractPreBuyPO>();
        for (ContractItemAddWaitOrderAbilityBO e2 : reqBO.getContractItems()) {
            CContractPreBuyPO po;
            if (!aleadyItemIds.contains(e2.getItemId())) {
                po = new CContractPreBuyPO();
                BeanUtils.copyProperties((Object)e2, (Object)po);
                po.setId(this.uccBatchSequence.nextId());
                po.setCreateTime(now);
                po.setCreateUserId(reqBO.getUserId());
                po.setCreateUserName(reqBO.getName());
                insertPos.add(po);
                continue;
            }
            po = new CContractPreBuyPO();
            BeanUtils.copyProperties((Object)e2, (Object)po);
            po.setCreateUserId(reqBO.getUserId());
            updatePos.add(po);
        }
        if (!CollectionUtils.isEmpty(insertPos)) {
            this.cContractPreBuyMapper.insertBatch(insertPos);
        }
        if (!CollectionUtils.isEmpty(updatePos)) {
            this.cContractPreBuyMapper.updateBatch(updatePos);
        }
        try {
            this.addWaitDone(reqBO, contractInfoItemPOS);
        }
        catch (Exception e3) {
            log.error("\u63a8\u9001\u5408\u540c\u5f85\u529e{}", (Object)e3.getMessage());
        }
        return rspBO;
    }

    private void addWaitDone(ContractItemAddWaitOrderAbilityReqBO reqBO, List<ContractInfoItemPO> contractInfoItemPOS) {
        ContractTodoBusinessWaitDoneAddAbilityReqBo contractTodoBusinessWaitDoneAddAbilityReqBo = new ContractTodoBusinessWaitDoneAddAbilityReqBo();
        contractTodoBusinessWaitDoneAddAbilityReqBo.setSubmitUserName(reqBO.getName());
        contractTodoBusinessWaitDoneAddAbilityReqBo.setBusiCode("6007");
        contractTodoBusinessWaitDoneAddAbilityReqBo.setSubmitUserNo(reqBO.getUsername());
        contractTodoBusinessWaitDoneAddAbilityReqBo.setSubmitTime(new Date());
        ContractTodoBusinessWaitDoneDealAbilityReqBo dealAbilityReqBo = new ContractTodoBusinessWaitDoneDealAbilityReqBo();
        dealAbilityReqBo.setDealUserNo(reqBO.getUsername());
        dealAbilityReqBo.setDealUserName(reqBO.getName());
        dealAbilityReqBo.setHandleUserNo(reqBO.getUsername());
        dealAbilityReqBo.setBusiCode("6007");
        Map<Long, ContractInfoItemPO> itemMap = contractInfoItemPOS.stream().collect(Collectors.toMap(ContractInfoItemPO::getItemId, e -> e));
        for (ContractItemAddWaitOrderAbilityBO bo : reqBO.getContractItems()) {
            ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(bo.getContractId());
            contractTodoBusinessWaitDoneAddAbilityReqBo.setObjId(String.valueOf(bo.getItemId()));
            contractTodoBusinessWaitDoneAddAbilityReqBo.setObjNo(String.valueOf(contractInfoPO.getContractId()));
            contractTodoBusinessWaitDoneAddAbilityReqBo.setObjName(itemMap.get(bo.getItemId()).getMaterialName());
            contractTodoBusinessWaitDoneAddAbilityReqBo.setHandleUserName(contractInfoPO.getBuyerName());
            contractTodoBusinessWaitDoneAddAbilityReqBo.setHandleUserNo(contractInfoPO.getBuyerNo());
            contractTodoBusinessWaitDoneAddAbilityReqBo.setHandleOrgName(contractInfoPO.getPurchaserUnitName());
            contractTodoBusinessWaitDoneAddAbilityReqBo.setHandleOrgNo(contractInfoPO.getPurchaserUnitCode());
            dealAbilityReqBo.setObjId(String.valueOf(bo.getItemId()));
            this.contractBusinessToDoComAbilityService.dealWaitDone(dealAbilityReqBo);
            this.contractBusinessToDoComAbilityService.addWaitDone(contractTodoBusinessWaitDoneAddAbilityReqBo);
        }
    }
}

