/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractItemCanBuyListQryAbilityService;
import com.tydic.contract.ability.bo.ContractItemCanBuyListQryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemCanBuyListQryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemCanBuyListQryRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.po.ContractItemCanBuyListQryPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.ppc.ability.api.PlanQueryByPlanIdsAbilityService;
import com.tydic.ppc.ability.bo.CcePlanDiversionBO;
import com.tydic.ppc.ability.bo.PlanQueryByPlanIdsAbilityReqBO;
import com.tydic.ppc.ability.bo.PlanQueryByPlanIdsAbilityRspBO;
import com.tydic.umc.general.ability.api.DycUmcQueryBuyerPermissionService;
import com.tydic.umc.general.ability.api.UmcEntityOrgSubQryAbilityService;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionRspBo;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubQryAbilityBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgSubQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractItemCanBuyListQryAbilityService"})
public class ContractItemCanBuyListQryAbilityServiceImpl
implements ContractItemCanBuyListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemCanBuyListQryAbilityServiceImpl.class);
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Value(value="${DEVELOP_COMPANY_DEPARTMENT}")
    private String developCompanyDepartment;
    @Autowired
    private DycUmcQueryBuyerPermissionService dycUmcQueryBuyerPermissionService;
    @Autowired
    private UmcEntityOrgSubQryAbilityService umcEntityOrgSubQryAbilityService;
    @Autowired
    private PlanQueryByPlanIdsAbilityService planQueryByPlanIdsAbilityService;
    private final String SUPPLIER_ISPROFESS = "2";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostMapping(value={"queryItemCanBuyList"})
    public ContractItemCanBuyListQryAbilityRspBO queryItemCanBuyList(@RequestBody ContractItemCanBuyListQryAbilityReqBO reqBO) {
        ContractItemCanBuyListQryAbilityRspBO rspBO = new ContractItemCanBuyListQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        reqBO.setIsStatusDisabled(Integer.valueOf(1));
        if (reqBO.getIsPlanQry() != null && reqBO.getIsPlanQry() == 1 || "2".equals(reqBO.getIsprofess())) {
            ContractItemCanBuyListQryPO seachPO = (ContractItemCanBuyListQryPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ContractItemCanBuyListQryPO.class);
            if (CollectionUtils.isEmpty((Collection)reqBO.getItemIds())) {
                throw new ZTBusinessException("\u67e5\u8be2\u7684\u660e\u7ec6ids\u4e0d\u80fd\u4e3a\u7a7a");
            }
            reqBO.setPageNo(Integer.valueOf(0));
            reqBO.setPageSize(Integer.valueOf(0));
            seachPO.setSearchDate(new Date());
            Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemMapper.selectItemCanBuyList2NoPermissions(seachPO));
            List result = page.getResult();
            ArrayList<ContractItemCanBuyListQryRspBO> rows = new ArrayList<ContractItemCanBuyListQryRspBO>();
            if (!CollectionUtils.isEmpty((Collection)result)) {
                for (ContractItemCanBuyListQryPO infoItemPO : result) {
                    ContractItemCanBuyListQryRspBO bo = (ContractItemCanBuyListQryRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)infoItemPO), ContractItemCanBuyListQryRspBO.class);
                    if (infoItemPO.getAmountLimit() != null) {
                        bo.setAmountLimit(MoneyUtils.haoToYuan(infoItemPO.getAmountLimit()));
                    }
                    if (infoItemPO.getOrderAmount() != null) {
                        bo.setOrderAmount(MoneyUtils.haoToYuan(infoItemPO.getOrderAmount()));
                    }
                    if (infoItemPO.getOrderdeliverydate() != null) {
                        bo.setOrderdeliverydateStr(infoItemPO.getOrderdeliverydate().stripTrailingZeros().toPlainString());
                    }
                    bo.setPlanId(infoItemPO.getPlanItemId());
                    rows.add(bo);
                }
            }
            this.buildRows(rows);
            rspBO.setRows(rows);
            rspBO.setRecordsTotal(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
            rspBO.setTotal(Integer.valueOf(page.getPages()));
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRows(rows);
            return rspBO;
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)reqBO.getOccupation())) {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(Integer.valueOf(0));
            rspBO.setTotal(Integer.valueOf(0));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5f53\u524d\u7528\u6237\u7684occupation\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getOrgId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        ContractItemCanBuyListQryPO seachPO = (ContractItemCanBuyListQryPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ContractItemCanBuyListQryPO.class);
        seachPO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        if (!org.springframework.util.StringUtils.isEmpty((Object)this.developCompanyDepartment)) {
            if (this.developCompanyDepartment.contains(",")) {
                String[] split;
                for (String s : split = this.developCompanyDepartment.split(",")) {
                    try {
                        orgIdList.add(Long.valueOf(s));
                    }
                    catch (Exception e2) {
                        log.error("\u8f6c\u6362\u673a\u6784id\u51fa\u73b0\u5f02\u5e38\uff0c\u673a\u6784id\uff1a" + s);
                    }
                }
            } else {
                try {
                    orgIdList.add(Long.valueOf(this.developCompanyDepartment));
                }
                catch (Exception e3) {
                    log.error("\u8f6c\u6362\u673a\u6784id\u51fa\u73b0\u5f02\u5e38\uff0c\u673a\u6784id\uff1a" + this.developCompanyDepartment);
                }
            }
        }
        if (orgIdList.contains(reqBO.getOrgId())) {
            seachPO.setContractTypes(Lists.newArrayList((Object[])new Integer[]{ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE, ContractConstant.ContractType.SPOT_CONTRACT, ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT, ContractConstant.ContractType.FUNCTION_SPOTS_CONTRACT}));
            seachPO.setBusinessTypes(Lists.newArrayList((Object[])new Integer[]{ContractConstant.BusinessType.SELF_PURCHASE, ContractConstant.BusinessType.TRIPARTITE_INTERNAL_AGENCY}));
            if (reqBO.getIsAdmin() == null || !"1".equals(reqBO.getIsAdmin().toString())) {
                DycUmcQueryBuyerPermissionReqBo dycUmcQueryBuyerPermissionReqBo = new DycUmcQueryBuyerPermissionReqBo();
                dycUmcQueryBuyerPermissionReqBo.setErpCode(reqBO.getOccupation());
                DycUmcQueryBuyerPermissionRspBo dycUmcQueryBuyerPermissionRspBo = this.dycUmcQueryBuyerPermissionService.queryBuyerPermission(dycUmcQueryBuyerPermissionReqBo);
                if ("0000".equals(dycUmcQueryBuyerPermissionRspBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)dycUmcQueryBuyerPermissionRspBo.getRows())) {
                    seachPO.setBuyerNos(dycUmcQueryBuyerPermissionRspBo.getRows().stream().filter(e -> !org.springframework.util.StringUtils.isEmpty((Object)e.getOrgCode())).map(e -> e.getOrgCode()).collect(Collectors.toList()));
                }
            }
        } else {
            ArrayList<Integer> contractTypes = new ArrayList<Integer>();
            if (reqBO.getIsAdmin() == null || !"1".equals(reqBO.getIsAdmin().toString())) {
                seachPO.setContractType(ContractConstant.ContractType.SALE_CONTRACT);
                seachPO.setAwardEmployeeNumber(reqBO.getOccupation());
                DycUmcQueryBuyerPermissionReqBo dycUmcQueryBuyerPermissionReqBo = new DycUmcQueryBuyerPermissionReqBo();
                dycUmcQueryBuyerPermissionReqBo.setErpCode(reqBO.getOccupation());
                DycUmcQueryBuyerPermissionRspBo dycUmcQueryBuyerPermissionRspBo = this.dycUmcQueryBuyerPermissionService.queryBuyerPermission(dycUmcQueryBuyerPermissionReqBo);
                if (!"0000".equals(dycUmcQueryBuyerPermissionRspBo.getRespCode())) throw new ZTBusinessException(dycUmcQueryBuyerPermissionRspBo.getRespDesc());
                if (!CollectionUtils.isEmpty((Collection)dycUmcQueryBuyerPermissionRspBo.getRows())) {
                    List<String> buyerNos = dycUmcQueryBuyerPermissionRspBo.getRows().stream().filter(e -> !org.springframework.util.StringUtils.isEmpty((Object)e.getOrgCode())).map(e -> e.getOrgCode()).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(buyerNos)) {
                        seachPO.setBuyerNos(buyerNos);
                    }
                    log.info("\u4e70\u53d7\u4eba" + buyerNos);
                }
            } else {
                contractTypes.add(ContractConstant.ContractType.SALE_CONTRACT);
            }
            contractTypes.add(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT);
            seachPO.setSearchDate(new Date());
            seachPO.setUnitContractPricingType(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
            seachPO.setContractTypes(contractTypes);
            seachPO.setUnitContractPricingConsType(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
            seachPO.setIsDevelopCompanyDepartment(1);
            ArrayList<Integer> excludeMaterialCategoryList = new ArrayList<Integer>();
            excludeMaterialCategoryList.add(ContractConstant.MaterialCategory.PROJECT);
            excludeMaterialCategoryList.add(ContractConstant.MaterialCategory.SERVICES);
            seachPO.setExcludeMaterialCategoryList(excludeMaterialCategoryList);
        }
        seachPO.setVendorStatus(1);
        seachPO.setSearchDate(new Date());
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemMapper.selectItemCanBuyList2(seachPO));
        List<ContractItemCanBuyListQryPO> result = page.getResult();
        List<Long> itemIds = result.stream().map(ContractItemCanBuyListQryPO::getItemId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(itemIds)) {
            result = this.contractInfoItemMapper.selectItemCanBuyList2ByItemIds(itemIds, seachPO.getAwardEmployeeNumber());
        }
        List rows = JSONObject.parseArray((String)JSONObject.toJSONString((Object)result), ContractItemCanBuyListQryRspBO.class);
        this.buildRows(rows);
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(rows);
        return rspBO;
    }

    @PostMapping(value={"queryItemCanBuyListByMaterialCodes"})
    public ContractItemCanBuyListQryAbilityRspBO queryItemCanBuyListByMaterialCodes(@RequestBody ContractItemCanBuyListQryAbilityReqBO reqBO) {
        ContractItemCanBuyListQryAbilityRspBO rspBO = new ContractItemCanBuyListQryAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ContractItemCanBuyListQryPO seachPO = (ContractItemCanBuyListQryPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), ContractItemCanBuyListQryPO.class);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemMapper.selectByMaterialCode(seachPO));
        List result = page.getResult();
        ArrayList<ContractItemCanBuyListQryRspBO> rows = new ArrayList<ContractItemCanBuyListQryRspBO>();
        if (!CollectionUtils.isEmpty((Collection)result)) {
            for (ContractItemCanBuyListQryPO infoItemPO : result) {
                ContractItemCanBuyListQryRspBO bo = (ContractItemCanBuyListQryRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)infoItemPO), ContractItemCanBuyListQryRspBO.class);
                if (infoItemPO.getAmountLimit() != null) {
                    bo.setAmountLimit(MoneyUtils.haoToYuan(infoItemPO.getAmountLimit()));
                }
                if (infoItemPO.getOrderAmount() != null) {
                    bo.setOrderAmount(MoneyUtils.haoToYuan(infoItemPO.getOrderAmount()));
                }
                if (infoItemPO.getOrderdeliverydate() != null) {
                    bo.setOrderdeliverydateStr(infoItemPO.getOrderdeliverydate().stripTrailingZeros().toPlainString());
                }
                bo.setPlanId(infoItemPO.getPlanItemId());
                rows.add(bo);
            }
        }
        if (!CollectionUtils.isEmpty(rows)) {
            rows.forEach(e -> {
                if (e.getAmount() == null) {
                    e.setAmount(BigDecimal.ZERO);
                }
                if (e.getOrderNum() == null) {
                    e.setOrderNum(BigDecimal.ZERO);
                }
                e.setCanSaleNum(e.getAmount().subtract(e.getOrderNum()));
            });
        }
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(Integer.valueOf(Integer.parseInt(String.valueOf(page.getTotal()))));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRows(rows);
        return rspBO;
    }

    private void buildRows(List<ContractItemCanBuyListQryRspBO> rows) {
        Map<Object, Object> codeMap;
        HashSet<String> codeSet = new HashSet<String>();
        for (ContractItemCanBuyListQryRspBO row : rows) {
            if (org.springframework.util.StringUtils.isEmpty((Object)row.getErpOrgCode())) continue;
            codeSet.add(row.getErpOrgCode());
        }
        if (CollectionUtils.isEmpty(codeSet)) {
            codeMap = new HashMap();
        } else {
            UmcEntityOrgSubQryAbilityRspBO umcEntityOrgSubQryAbilityRspBO = null;
            try {
                UmcEntityOrgSubQryAbilityReqBO umcEntityOrgSubQryAbilityReqBO = new UmcEntityOrgSubQryAbilityReqBO();
                umcEntityOrgSubQryAbilityReqBO.setSubOrgIdList(new ArrayList(codeSet));
                umcEntityOrgSubQryAbilityRspBO = this.umcEntityOrgSubQryAbilityService.qryOrgCode(umcEntityOrgSubQryAbilityReqBO);
            }
            catch (Exception e) {
                log.error("\u8c03\u7528\u4f1a\u5458\u670d\u52a1\u67e5\u8be2\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u5f02\u5e38\uff1a" + e);
            }
            codeMap = Objects.nonNull(umcEntityOrgSubQryAbilityRspBO) && !CollectionUtils.isEmpty((Collection)umcEntityOrgSubQryAbilityRspBO.getSubQryAbilityBOS()) ? umcEntityOrgSubQryAbilityRspBO.getSubQryAbilityBOS().stream().collect(Collectors.toMap(UmcEntityOrgSubQryAbilityBO::getOrganizationId, Function.identity(), (k1, k2) -> k1)) : new HashMap();
        }
        if (!CollectionUtils.isEmpty(rows)) {
            Map<Object, Object> planIdMap = new HashMap(16);
            List planIds = rows.stream().map(ContractItemCanBuyListQryRspBO::getPlanItemId).filter(StringUtils::isNotBlank).distinct().map(Long::parseLong).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(planIds)) {
                List planInfos;
                PlanQueryByPlanIdsAbilityReqBO planQueryByPlanIdsAbilityReqBO = new PlanQueryByPlanIdsAbilityReqBO();
                planQueryByPlanIdsAbilityReqBO.setPlanIds(planIds);
                planQueryByPlanIdsAbilityReqBO.setPageNo(Integer.valueOf(1));
                planQueryByPlanIdsAbilityReqBO.setPageSize(Integer.valueOf(planIds.size()));
                PlanQueryByPlanIdsAbilityRspBO planQueryByPlanIdsAbilityRspBO = this.planQueryByPlanIdsAbilityService.qry(planQueryByPlanIdsAbilityReqBO);
                if ("0000".equals(planQueryByPlanIdsAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)(planInfos = planQueryByPlanIdsAbilityRspBO.getRows()))) {
                    planIdMap = planInfos.stream().collect(Collectors.groupingBy(CcePlanDiversionBO::getPlanId));
                }
            }
            for (ContractItemCanBuyListQryRspBO row : rows) {
                List ccePlanDiversionBOS;
                if (row.getAmount() == null) {
                    row.setAmount(BigDecimal.ZERO);
                }
                if (row.getOrderNum() == null) {
                    row.setOrderNum(BigDecimal.ZERO);
                }
                if (row.getOrderdeliverydate() != null) {
                    row.setOrderdeliverydateStr(row.getOrderdeliverydate().stripTrailingZeros().toPlainString());
                }
                if (row.getContractType() != null) {
                    row.setContractTypeStr(ContractTransFieldUtil.transContractType(row.getContractType()));
                }
                if (!org.springframework.util.StringUtils.isEmpty((Object)row.getErpOrgCode()) && org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)row.getErpOrgCode()) && !CollectionUtils.isEmpty(codeMap) && Objects.nonNull(codeMap.get(Long.valueOf(row.getErpOrgCode())))) {
                    row.setOrganizationCode(((UmcEntityOrgSubQryAbilityBO)codeMap.get(Long.valueOf(row.getErpOrgCode()))).getOrganizationCode());
                }
                row.setCanSaleNum(row.getAmount().subtract(row.getOrderNum()));
                row.setPlanId(row.getPlanItemId());
                if (!MapUtil.isNotEmpty(planIdMap) || CollectionUtils.isEmpty((Collection)(ccePlanDiversionBOS = (List)planIdMap.get(row.getPlanId())))) continue;
                row.setPlanNo(((CcePlanDiversionBO)ccePlanDiversionBOS.get(0)).getScheduleNo());
            }
        }
    }
}

