/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractLegalReturnAbilityService;
import com.tydic.contract.ability.bo.CceReturnContractReqBO;
import com.tydic.contract.ability.bo.CceReturnContractRspBO;
import com.tydic.contract.busi.ContractLegalReturnBusiService;
import com.tydic.contract.busi.bo.CceReturnContractBusiRspBO;
import com.tydic.contract.dao.ContractAcceptFailLogMapper;
import com.tydic.contract.dao.ContractAcceptLogMapper;
import com.tydic.contract.po.ContractAcceptFailLogPO;
import com.tydic.contract.po.ContractAcceptLogPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractLegalReturnAbilityService"})
public class ContractLegalReturnAbilityServiceImpl
implements ContractLegalReturnAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractLegalReturnAbilityServiceImpl.class);
    @Autowired
    private ContractLegalReturnBusiService contractLegalReturnBusiService;
    @Autowired
    private ContractAcceptLogMapper contractAcceptLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractAcceptFailLogMapper contractAcceptFailLogMapper;

    @PostMapping(value={"returnContract"})
    public CceReturnContractRspBO returnContract(@RequestBody CceReturnContractReqBO reqBO) {
        CceReturnContractReqBO cceReturnContractReqBO = new CceReturnContractReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)cceReturnContractReqBO);
        Date acceptTime = new Date();
        long start = System.currentTimeMillis();
        ContractAcceptLogPO contractAcceptLogPO = new ContractAcceptLogPO();
        contractAcceptLogPO.setId(this.uccBatchSequence.nextId());
        contractAcceptLogPO.setAcceptInfo(JSONObject.toJSONString((Object)reqBO));
        contractAcceptLogPO.setAcceptTime(acceptTime);
        CceReturnContractBusiRspBO cceReturnContractBusiRspBO = this.contractLegalReturnBusiService.cancelReturnContract(cceReturnContractReqBO);
        Date figureOutTime = new Date();
        long end = System.currentTimeMillis();
        contractAcceptLogPO.setFigureOutTime(figureOutTime);
        contractAcceptLogPO.setTimeSpent("\u8017\u65f6\uff1a" + (double)(end - start) / 1000.0);
        contractAcceptLogPO.setFigureOutInfo(cceReturnContractBusiRspBO.getRespDesc());
        if (reqBO.getAcceptLogType() != null && "2".equals(reqBO.getAcceptLogType().toString())) {
            contractAcceptLogPO.setType(4);
        } else {
            contractAcceptLogPO.setType(2);
        }
        this.contractAcceptLogMapper.insert(contractAcceptLogPO);
        if (!"0000".equals(cceReturnContractBusiRspBO.getRespCode())) {
            ContractAcceptFailLogPO contractAcceptFailLogPO = (ContractAcceptFailLogPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)contractAcceptLogPO), ContractAcceptFailLogPO.class);
            contractAcceptFailLogPO.setStatus(0);
            this.contractAcceptFailLogMapper.insert(contractAcceptFailLogPO);
        }
        return (CceReturnContractRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)cceReturnContractBusiRspBO)), CceReturnContractRspBO.class);
    }
}

