/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractStockChangePushWmsAbilityService;
import com.tydic.contract.ability.bo.ContractStockChangePushWmsAbilityReqBO;
import com.tydic.contract.ability.bo.ContractStockChangePushWmsAbilityRspBO;
import com.tydic.contract.ability.bo.ContractStockChangePushWmsBusiReqBO;
import com.tydic.contract.atom.InterFaceWmsPushWmsAtomService;
import com.tydic.contract.atom.bo.InterFaceWmsPushWmsAtomBO;
import com.tydic.contract.atom.bo.InterFaceWmsPushWmsAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceWmsPushWmsAtomRspBO;
import com.tydic.contract.busi.ContractStockChangePushWmsBusiService;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractStockChangeItemMapper;
import com.tydic.contract.dao.ContractPushLogMapper;
import com.tydic.contract.po.CContractStockChangeItemPO;
import com.tydic.contract.po.ContractPushLogPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractStockChangePushWmsAbilityService"})
public class ContractStockChangePushWmsAbilityServiceImpl
implements ContractStockChangePushWmsAbilityService {
    @Autowired
    private ContractStockChangePushWmsBusiService contractStockChangePushWmsBusiService;
    @Autowired
    private CContractStockChangeItemMapper cContractStockChangeItemMapper;
    @Autowired
    private InterFaceWmsPushWmsAtomService interFaceWmsPushWmsAtomService;
    @Autowired
    private ContractPushLogMapper contractPushLogMapper;

    @PostMapping(value={"dealPushWms"})
    public ContractStockChangePushWmsAbilityRspBO dealPushWms(@RequestBody ContractStockChangePushWmsAbilityReqBO reqBO) {
        List<CContractStockChangeItemPO> allChangeItemPOS;
        ContractStockChangePushWmsAbilityRspBO rspBO = new ContractStockChangePushWmsAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getContractId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[contractId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getTempId() == null) {
            throw new ZTBusinessException("\u5165\u53c2[tempId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Integer contractPushWmsStatus = null;
        String contractPushWmsRemark = null;
        String failContractPushWmsRemark = null;
        String successContractPushWmsRemark = null;
        CContractStockChangeItemPO searchPO = new CContractStockChangeItemPO();
        searchPO.setChangeId(reqBO.getTempId());
        if (reqBO.getOperateType() == null || reqBO.getOperateType() == 1) {
            // empty if block
        }
        if (reqBO.getOperateType() != null && reqBO.getOperateType() == 2) {
            searchPO.setPushWmsStatus(ContractConstant.ContractPushWmsStatus.FAIL);
        }
        if (!CollectionUtils.isEmpty(allChangeItemPOS = this.cContractStockChangeItemMapper.queryAll(searchPO))) {
            Integer okCount;
            ArrayList<CContractStockChangeItemPO> changeItemPOS = new ArrayList<CContractStockChangeItemPO>();
            ArrayList<Long> changeItemIdsList = new ArrayList<Long>();
            for (int count = 0; count < allChangeItemPOS.size(); ++count) {
                String pushWmsRemark;
                Integer pushWmsStatus;
                changeItemPOS.add(allChangeItemPOS.get(count));
                Boolean pushFlag = false;
                if (changeItemPOS.size() == 500) {
                    pushFlag = true;
                }
                if (count == allChangeItemPOS.size() - 1) {
                    pushFlag = true;
                }
                if (!pushFlag.booleanValue()) continue;
                try {
                    InterFaceWmsPushWmsAtomReqBO atomReqBO = new InterFaceWmsPushWmsAtomReqBO();
                    ArrayList<InterFaceWmsPushWmsAtomBO> date = new ArrayList<InterFaceWmsPushWmsAtomBO>();
                    for (CContractStockChangeItemPO changeItemPO : changeItemPOS) {
                        if (StringUtils.isEmpty((Object)changeItemPO.getMaterialCode()) || StringUtils.isEmpty((Object)changeItemPO.getSupplierCode()) || StringUtils.isEmpty((Object)changeItemPO.getSupplierName()) || StringUtils.isEmpty((Object)changeItemPO.getErpOrgId()) || StringUtils.isEmpty((Object)changeItemPO.getWarehouseCode()) || changeItemPO.getLimitNum() == null || changeItemPO.getSafeNum() == null) {
                            throw new ZTBusinessException("\u660e\u7ec6\u884c\u5fc5\u4f20\u5b57\u6bb5\u5b58\u5728\u63a7\u5236\uff0c\u8bf7\u7ef4\u62a4");
                        }
                        InterFaceWmsPushWmsAtomBO atomBO = new InterFaceWmsPushWmsAtomBO();
                        atomBO.setPurchaseAgreementId(reqBO.getContractId());
                        atomBO.setSupplierCode(changeItemPO.getSupplierCode());
                        atomBO.setSupplierName(changeItemPO.getSupplierName());
                        atomBO.setErpOrgId(changeItemPO.getErpOrgId());
                        atomBO.setWarehouseCode(changeItemPO.getWarehouseCode());
                        atomBO.setMatCode(changeItemPO.getMaterialCode());
                        atomBO.setMaxStockQty(changeItemPO.getLimitNum());
                        atomBO.setSafeStockQty(changeItemPO.getSafeNum());
                        date.add(atomBO);
                        changeItemIdsList.add(changeItemPO.getId());
                    }
                    atomReqBO.setDate(date);
                    InterFaceWmsPushWmsAtomRspBO atomRspBO = this.interFaceWmsPushWmsAtomService.pushWms(atomReqBO);
                    this.savePushLog(atomReqBO, atomRspBO);
                    if ("0000".equals(atomRspBO.getRespCode())) {
                        pushWmsStatus = ContractConstant.ContractPushWmsStatus.OK;
                        pushWmsRemark = atomRspBO.getPushRespStr();
                        successContractPushWmsRemark = atomRspBO.getPushRespStr();
                    } else {
                        pushWmsStatus = ContractConstant.ContractPushWmsStatus.FAIL;
                        pushWmsRemark = atomRspBO.getPushRespStr();
                        failContractPushWmsRemark = atomRspBO.getPushRespStr();
                    }
                }
                catch (Exception e) {
                    pushWmsStatus = ContractConstant.ContractPushWmsStatus.FAIL;
                    pushWmsRemark = e.getMessage();
                    failContractPushWmsRemark = e.getMessage();
                }
                ContractStockChangePushWmsBusiReqBO busiReqBO = new ContractStockChangePushWmsBusiReqBO();
                busiReqBO.setChangeItemIdsList(changeItemIdsList);
                busiReqBO.setChangeItemPushWmsStatus(pushWmsStatus);
                busiReqBO.setChangeItemPushWmsRemark(pushWmsRemark);
                this.contractStockChangePushWmsBusiService.dealPushWms(busiReqBO);
                changeItemPOS = new ArrayList();
                changeItemIdsList = new ArrayList();
            }
            Integer allCount = this.cContractStockChangeItemMapper.queryAllCount(reqBO.getTempId(), null);
            if (allCount.equals(okCount = this.cContractStockChangeItemMapper.queryAllCount(reqBO.getTempId(), ContractConstant.ContractPushWmsStatus.OK))) {
                contractPushWmsStatus = ContractConstant.ContractPushWmsStatus.OK;
                contractPushWmsRemark = successContractPushWmsRemark;
            } else {
                contractPushWmsStatus = ContractConstant.ContractPushWmsStatus.FAIL;
                contractPushWmsRemark = failContractPushWmsRemark;
            }
            ContractStockChangePushWmsBusiReqBO busiReqBO = new ContractStockChangePushWmsBusiReqBO();
            busiReqBO.setTempId(reqBO.getTempId());
            busiReqBO.setContractPushWmsStatus(contractPushWmsStatus);
            busiReqBO.setContractPushWmsRemark(contractPushWmsRemark);
            this.contractStockChangePushWmsBusiService.dealPushWms(busiReqBO);
        }
        return rspBO;
    }

    private void savePushLog(InterFaceWmsPushWmsAtomReqBO atomReqBO, InterFaceWmsPushWmsAtomRspBO atomRspBO) {
        ContractPushLogPO contractPushLogPO = new ContractPushLogPO();
        contractPushLogPO.setId(Sequence.getInstance().nextId());
        contractPushLogPO.setCreateTime(new Date());
        contractPushLogPO.setReqJson(JSONObject.toJSONString((Object)atomReqBO));
        contractPushLogPO.setRspJson(atomRspBO.getPushRespStr());
        contractPushLogPO.setType(ContractConstant.ContractPushLogType.PUSH_WMS);
        this.contractPushLogMapper.insert(contractPushLogPO);
    }
}

