/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.atom.ContractOrderCheckAtomService;
import com.tydic.contract.atom.ContractUpdateOrderStatusAtomService;
import com.tydic.contract.atom.bo.ContractDealerCheckAtomReqBO;
import com.tydic.contract.atom.bo.ContractOrderCheckAtomReqBO;
import com.tydic.contract.atom.bo.ContractOrderCheckAtomRspBO;
import com.tydic.contract.atom.bo.ContractUpdateOrderStatusAtomBO;
import com.tydic.contract.atom.bo.ContractUpdateOrderStatusAtomReqBO;
import com.tydic.contract.atom.bo.ContractUpdateOrderStatusAtomRspBO;
import com.tydic.contract.atom.bo.InterFaceContractErpUpdateAwardDealerAtomBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractOrderInfoMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractOrderInfoPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractOrderCheckAtomServiceImpl
implements ContractOrderCheckAtomService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private ContractUpdateOrderStatusAtomService contractUpdateOrderStatusAtomService;
    @Autowired
    private CContractOrderInfoMapper cContractOrderInfoMapper;

    @Override
    public ContractOrderCheckAtomRspBO contractOrderCheckOrderIds(ContractOrderCheckAtomReqBO reqBO) {
        List<ContractUpdateOrderStatusAtomBO> updateOrderStatusAtomBOS;
        ArrayList<Long> updateAwardIds;
        ContractOrderCheckAtomRspBO atomRspBO = new ContractOrderCheckAtomRspBO();
        atomRspBO.setRespCode("0000");
        atomRspBO.setRespDesc("\u6210\u529f");
        List<Object> alreadyIds = new ArrayList();
        ArrayList<Long> allIds = new ArrayList<Long>();
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(reqBO.getOrderIds()) && CollectionUtils.isEmpty(reqBO.getAllOrderIds())) {
            throw new ZTBusinessException("orderIds\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList updateBOS = new ArrayList();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(reqBO.getOrderIds())) {
            orderIds.addAll(reqBO.getOrderIds().stream().collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(orderIds) || !CollectionUtils.isEmpty(reqBO.getAllOrderIds())) {
            List<ContractInfoItemPO> itemPOS;
            ContractInfoItemPO seachPO = new ContractInfoItemPO();
            if (reqBO.getOperationType() == 1 || reqBO.getOperationType() == 2) {
                if (CollectionUtils.isEmpty(orderIds)) {
                    throw new ZTBusinessException("\u5408\u540c\u65b0\u589e\u548c\u5408\u540c\u53d8\u66f4\u65b0\u589e\u7684\u65f6\u5019\u6700\u7ec8\u6821\u9a8c\u7684orderIds\u4e0d\u80fd\u4e3a\u7a7a");
                }
                seachPO.setOrderIds(orderIds);
            }
            if (reqBO.getOperationType() == 3 || reqBO.getOperationType() == 4) {
                seachPO.setOrderIds(reqBO.getAllOrderIds());
            }
            if (reqBO.getOperationType() == 5) {
                seachPO.setOrderIds(reqBO.getAllOrderIds());
            }
            if (!CollectionUtils.isEmpty(itemPOS = this.contractInfoItemMapper.selectContractOrderIdByOrderIds(seachPO))) {
                itemPOS = itemPOS.stream().filter(e -> e.getOrderId() != null).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(itemPOS)) {
                Map<Long, List<ContractInfoItemPO>> relateIdMap = itemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getRelateId));
                Set<Long> alreadContractIds = relateIdMap.keySet();
                alreadyIds = itemPOS.stream().map(ContractInfoItemPO::getOrderId).collect(Collectors.toList());
                allIds = new ArrayList();
                deleteIds = new ArrayList();
                if (reqBO.getOperationType() == 1 || reqBO.getOperationType() == 2) {
                    List<Long> failOrderIds;
                    ContractInfoPO contractInfoPO;
                    if (reqBO.getContractId() == null) {
                        throw new ZTBusinessException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (reqBO.getContractType() == null && (contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId())) != null) {
                        reqBO.setContractType(contractInfoPO.getContractType());
                    }
                    if (!CollectionUtils.isEmpty(failOrderIds = itemPOS.stream().filter(e -> !e.getRelateId().equals(reqBO.getContractId()) && e.getContractType() != null && e.getContractType().equals(reqBO.getContractType())).map(ContractInfoItemPO::getOrderId).collect(Collectors.toList()))) {
                        atomRspBO.setFailOrderIds(failOrderIds);
                        atomRspBO.setRespDesc("\u672c\u6b21\u5408\u540c\u6240\u9009\u7684\u8ba2\u5355\u88ab\u5176\u5b83\u5408\u540c\u5df2\u7ecf\u5173\u8054\u5408\u540c,\u8ba2\u5355id\uff1a" + failOrderIds.toString());
                        CContractOrderInfoPO searchOrderInfoPO = new CContractOrderInfoPO();
                        searchOrderInfoPO.setOrderIds(failOrderIds);
                        List<CContractOrderInfoPO> orderInfoPOS = this.cContractOrderInfoMapper.getList(searchOrderInfoPO);
                        if (!CollectionUtils.isEmpty(orderInfoPOS)) {
                            List failCodes = orderInfoPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getOrderCode())).map(CContractOrderInfoPO::getOrderCode).collect(Collectors.toList());
                            atomRspBO.setRespDesc("\u672c\u6b21\u5408\u540c\u6240\u9009\u7684\u8ba2\u5355\u88ab\u5176\u5b83\u5408\u540c\u5df2\u7ecf\u5173\u8054\u5408\u540c,\u8ba2\u5355\uff1a" + failCodes);
                        }
                        atomRspBO.setRespCode("8888");
                        return atomRspBO;
                    }
                }
                if (reqBO.getOperationType() == 3 || reqBO.getOperationType() == 4) {
                    if (!CollectionUtils.isEmpty(orderIds)) {
                        for (Long orderId : orderIds) {
                            if (!alreadyIds.contains(orderId)) continue;
                            allIds.add(orderId);
                        }
                    }
                    if (!CollectionUtils.isEmpty(reqBO.getAllOrderIds())) {
                        for (Long allOrderId : reqBO.getAllOrderIds()) {
                            if (alreadyIds.contains(allOrderId)) continue;
                            deleteIds.add(allOrderId);
                        }
                    }
                }
                if (reqBO.getOperationType() == 5 && !CollectionUtils.isEmpty(reqBO.getAllOrderIds())) {
                    for (Long allOrderId : reqBO.getAllOrderIds()) {
                        if (alreadyIds.contains(allOrderId)) continue;
                        deleteIds.add(allOrderId);
                    }
                }
            } else if (reqBO.getOperationType() == 3 || reqBO.getOperationType() == 4 || reqBO.getOperationType() == 5) {
                deleteIds.addAll(reqBO.getAllOrderIds());
            }
        }
        ArrayList<ContractUpdateOrderStatusAtomBO> updateOrderBOS = new ArrayList<ContractUpdateOrderStatusAtomBO>();
        if (!CollectionUtils.isEmpty(deleteIds)) {
            updateAwardIds = new ArrayList<Long>();
            updateAwardIds.addAll(deleteIds.stream().collect(Collectors.toSet()));
            updateOrderStatusAtomBOS = ObjectUtil.isNotEmpty((Object)reqBO.getContractType()) && (ContractConstant.ContractType.PURCHASE_TRADE_ORDER_CONTRACT.equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_NO_TRADE_ORDER_CONTRACT.equals(reqBO.getContractType())) ? this.updateAll(updateAwardIds, "4") : this.updateAll(updateAwardIds, "2");
            updateOrderBOS.addAll(updateOrderStatusAtomBOS);
        }
        if (!CollectionUtils.isEmpty(allIds)) {
            updateAwardIds = new ArrayList();
            updateAwardIds.addAll(allIds.stream().collect(Collectors.toSet()));
            updateOrderStatusAtomBOS = ObjectUtil.isNotEmpty((Object)reqBO.getContractType()) && (ContractConstant.ContractType.PURCHASE_TRADE_ORDER_CONTRACT.equals(reqBO.getContractType()) || ContractConstant.ContractType.PURCHASE_NO_TRADE_ORDER_CONTRACT.equals(reqBO.getContractType())) ? this.updateAll(updateAwardIds, "3") : this.updateAll(updateAwardIds, "1");
            updateOrderBOS.addAll(updateOrderStatusAtomBOS);
        }
        if (!CollectionUtils.isEmpty(updateOrderBOS) && !CollectionUtils.isEmpty(updateOrderBOS)) {
            ContractUpdateOrderStatusAtomReqBO orderStatusAtomReqBO = new ContractUpdateOrderStatusAtomReqBO();
            orderStatusAtomReqBO.setUpdateBOS(updateOrderBOS);
            orderStatusAtomReqBO.setContractId(reqBO.getContractId());
            orderStatusAtomReqBO.setContractCode(reqBO.getContractCode());
            orderStatusAtomReqBO.setContractName(reqBO.getContractName());
            try {
                ContractUpdateOrderStatusAtomRspBO orderStatusAtomRspBO = this.contractUpdateOrderStatusAtomService.updateOrderStatus(orderStatusAtomReqBO);
                if (!"0000".equals(orderStatusAtomRspBO.getRespCode())) {
                    throw new ZTBusinessException("\u8ba2\u5355\u5360\u7528\u63a5\u53e3\u5931\u8d25\uff1a" + orderStatusAtomRspBO.getRespDesc());
                }
            }
            catch (Exception e2) {
                throw new ZTBusinessException(e2.getMessage());
            }
        }
        return atomRspBO;
    }

    private List<ContractUpdateOrderStatusAtomBO> updateAll(List<Long> orderIds, String type) {
        Set orderIdSet;
        ArrayList<ContractUpdateOrderStatusAtomBO> updateBOS = new ArrayList<ContractUpdateOrderStatusAtomBO>();
        if (!CollectionUtils.isEmpty(orderIds) && !CollectionUtils.isEmpty(orderIdSet = orderIds.stream().collect(Collectors.toSet()))) {
            for (Long s : orderIdSet) {
                ContractUpdateOrderStatusAtomBO atomBO = new ContractUpdateOrderStatusAtomBO();
                atomBO.setOrderId(s);
                atomBO.setType(type);
                updateBOS.add(atomBO);
            }
        }
        return updateBOS;
    }

    private List<InterFaceContractErpUpdateAwardDealerAtomBO> updateAwardDealer(ContractDealerCheckAtomReqBO reqBO) {
        Set awardIdSet;
        ArrayList<InterFaceContractErpUpdateAwardDealerAtomBO> updateBOS = new ArrayList<InterFaceContractErpUpdateAwardDealerAtomBO>();
        ContractInfoItemTmpPO seachItemTmpPO = new ContractInfoItemTmpPO();
        seachItemTmpPO.setRelateId(reqBO.getContractId());
        seachItemTmpPO.setDelFlag("0");
        List<ContractInfoItemTmpPO> list = this.contractInfoItemTmpMapper.getList(seachItemTmpPO);
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(awardIdSet = list.stream().filter(e -> !StringUtils.isEmpty((Object)e.getAwardId())).map(ContractInfoItemTmpPO::getAwardId).collect(Collectors.toSet()))) {
            for (String s : awardIdSet) {
                InterFaceContractErpUpdateAwardDealerAtomBO atomBO = new InterFaceContractErpUpdateAwardDealerAtomBO();
                atomBO.setAwardId(s);
                atomBO.setDealerFlag(reqBO.getDealerFlag());
                updateBOS.add(atomBO);
            }
        }
        return updateBOS;
    }
}

