/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.atom.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.atom.ContractSendNotificationExtAtomService;
import com.tydic.contract.atom.bo.ContractSendNotificationExtAtomReqBO;
import com.tydic.contract.atom.bo.ContractSendNotificationExtAtomRspBO;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.CharsetUtils;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ContractSendNotificationExtAtomServiceImpl
implements ContractSendNotificationExtAtomService {
    private static final Logger log = LoggerFactory.getLogger(ContractSendNotificationExtAtomServiceImpl.class);
    @Value(value="${notification_app_id:notification_app_id}")
    private String notificationAppId;
    @Value(value="${notification_app_url:notification_app_url}")
    private String notificationAppUrl;

    @Override
    public ContractSendNotificationExtAtomRspBO sendNotification(ContractSendNotificationExtAtomReqBO reqBO) {
        ContractSendNotificationExtAtomRspBO rspBO = new ContractSendNotificationExtAtomRspBO();
        for (Long receiveId : reqBO.getReceiveIds()) {
            HashMap<String, String> infoMap = new HashMap<String, String>();
            infoMap.put("sendid", reqBO.getUserId().toString());
            infoMap.put("recid", receiveId.toString());
            infoMap.put("appid", this.notificationAppId);
            infoMap.put("titel", reqBO.getTitel());
            infoMap.put("text", reqBO.getText());
            if (reqBO.getIsClearType() == null || reqBO.getIsClearType() != 1) {
                infoMap.put("type", "\u7ad9\u5185\u4fe1");
            }
            try {
                String result = ContractSendNotificationExtAtomServiceImpl.httpUploadSignature2(this.notificationAppUrl, infoMap);
                log.info("\u8c03\u7528\u53d1\u9001\u901a\u77e5\u51fa\u53c2\uff1a" + result);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                if (jsonObject.get((Object)"code").equals("0")) continue;
                throw new ZTBusinessException(jsonObject.getString("message"));
            }
            catch (IOException e) {
                throw new ZTBusinessException("\u53d1\u9001\u901a\u77e5\u5931\u8d25");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpUploadSignature2(String actionUrl, Map<String, String> infoMap) throws IOException {
        String charset = "utf-8";
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(actionUrl);
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(20000).setSocketTimeout(30000).setConnectTimeout(20000).build();
        httpPost.setConfig(requestConfig);
        String result = null;
        String boundary = "--------------4585696313564699";
        HashMap<String, StringBody> mapParam = new HashMap<String, StringBody>();
        for (String string : infoMap.keySet()) {
            mapParam.put(string, new StringBody(infoMap.get(string), Charset.forName("UTF-8")));
        }
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        for (Map.Entry entry : mapParam.entrySet()) {
            multipartEntityBuilder.addPart((String)entry.getKey(), (ContentBody)entry.getValue()).setCharset(CharsetUtils.get((String)"UTF-8"));
        }
        multipartEntityBuilder.setCharset(Charset.forName("UTF-8"));
        multipartEntityBuilder.setBoundary(boundary);
        HttpEntity httpEntity = multipartEntityBuilder.build();
        httpPost.setEntity(httpEntity);
        httpPost.setHeader("Content-Type", "multipart/form-data;boundary=" + boundary);
        try (CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = closeableHttpResponse.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                System.out.println("Response content: " + result);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return result;
    }
}

