/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractErpSyncAbilityReqBo;
import com.tydic.contract.ability.bo.ContractErpSyncAbilityRspBo;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.atom.InterFaceContractErpSyncService;
import com.tydic.contract.atom.bo.ErpSyncLineData;
import com.tydic.contract.atom.bo.InterFaceContractErpSyncReqBo;
import com.tydic.contract.atom.bo.InterFaceContractErpSyncReqDataBo;
import com.tydic.contract.atom.bo.InterFaceContractErpSyncRspBo;
import com.tydic.contract.atom.bo.InterFaceContractErpSyncRspDataBo;
import com.tydic.contract.busi.ContractDetailQueryBusiService;
import com.tydic.contract.busi.ContractErpSyncBusiService;
import com.tydic.contract.busi.ContractItemQueryBusiService;
import com.tydic.contract.busi.bo.ContractDetailQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractDetailQueryBusiRspBO;
import com.tydic.contract.busi.bo.ContractItemQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemQueryBusiRspBO;
import com.tydic.contract.dao.CContractErpSyncRecordMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractErpSyncRecordPO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.api.UmcMemDetailQueryAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractErpSyncBusiServiceImpl
implements ContractErpSyncBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractErpSyncBusiServiceImpl.class);
    @Autowired
    private ContractDetailQueryBusiService contractDetailQueryBusiService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private InterFaceContractErpSyncService interFaceContractErpSyncService;
    @Autowired
    private CContractErpSyncRecordMapper cContractErpSyncRecordMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService dycUmcEnterpriseOrgQryDetailService;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @Autowired
    private ContractItemQueryBusiService contractItemQueryBusiService;

    @Override
    public ContractErpSyncAbilityRspBo syncErp(ContractErpSyncAbilityReqBo reqBo) {
        ContractErpSyncAbilityRspBo rspBo = new ContractErpSyncAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBo.getContractIds())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u4f20\u5165\u5408\u540cID\u4e3a\u7a7a");
            return rspBo;
        }
        HashMap<String, String> headerIdAndContractCode = new HashMap<String, String>();
        ArrayList<String> success = new ArrayList<String>();
        HashMap fail = new HashMap();
        InterFaceContractErpSyncReqBo interFaceContractErpSyncReqBo = new InterFaceContractErpSyncReqBo();
        ArrayList<InterFaceContractErpSyncReqDataBo> interFaceContractErpSyncReqDataBos = new ArrayList<InterFaceContractErpSyncReqDataBo>();
        for (Long contractId : reqBo.getContractIds()) {
            ContractDetailQueryBusiReqBO contractDetailQueryBusiReqBO = new ContractDetailQueryBusiReqBO();
            contractDetailQueryBusiReqBO.setContractId(contractId);
            ContractDetailQueryBusiRspBO contractDetailQueryBusiRspBO = this.contractDetailQueryBusiService.contractDetailQuery(contractDetailQueryBusiReqBO);
            if (!"0".equals(contractDetailQueryBusiRspBO.getCode())) continue;
            InterFaceContractErpSyncReqDataBo interFaceContractErpSyncReqDataBo = new InterFaceContractErpSyncReqDataBo();
            interFaceContractErpSyncReqDataBo.setHEADER_UUID(contractDetailQueryBusiRspBO.getContractId().toString());
            interFaceContractErpSyncReqDataBo.setORG_ID(contractDetailQueryBusiRspBO.getBuyerNo());
            UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
            umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(contractDetailQueryBusiRspBO.getSupplierId());
            UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.dycUmcEnterpriseOrgQryDetailService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
            if (!"0000".equals(umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode())) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u4f9b\u5e94\u5546\u673a\u6784\u83b7\u53d6\u8be6\u60c5\u5931\u8d25");
                return rspBo;
            }
            interFaceContractErpSyncReqDataBo.setVENDOR_CODE(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode());
            interFaceContractErpSyncReqDataBo.setVENDOR_NAME(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgName());
            if (contractDetailQueryBusiRspBO.getSupplierAddressAlias() != null) {
                interFaceContractErpSyncReqDataBo.setB2BSITE_ID(contractDetailQueryBusiRspBO.getSupplierAddressAlias().toString());
            }
            UmcMemDetailQueryAbilityReqBO umcMemDetailQueryAbilityReqBO = new UmcMemDetailQueryAbilityReqBO();
            umcMemDetailQueryAbilityReqBO.setUserIdWeb(contractDetailQueryBusiRspBO.getCreateUserId());
            UmcMemDetailQueryAbilityRspBO umcMemDetailQueryAbilityRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(umcMemDetailQueryAbilityReqBO);
            UmcMemDetailInfoAbilityBO memDetailInfoBO = umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO();
            if (memDetailInfoBO.getAgentId() != null) {
                interFaceContractErpSyncReqDataBo.setAGENT_ID(memDetailInfoBO.getAgentId().toString());
            }
            interFaceContractErpSyncReqDataBo.setCURRENCY_CODE(contractDetailQueryBusiRspBO.getCurrency());
            interFaceContractErpSyncReqDataBo.setUSER_NAME(memDetailInfoBO.getAgentAccount());
            interFaceContractErpSyncReqDataBo.setDOC_TYPE("CONTRACT");
            interFaceContractErpSyncReqDataBo.setDOC_NUM(contractDetailQueryBusiRspBO.getContractCode());
            interFaceContractErpSyncReqDataBo.setAUTO_APPROVE("Y");
            interFaceContractErpSyncReqDataBo.setBILL_TO_LOC_ID(contractDetailQueryBusiRspBO.getAcceptOrgId());
            interFaceContractErpSyncReqDataBo.setATTRIBUTE15(contractDetailQueryBusiRspBO.getPurchaseTypeStr());
            interFaceContractErpSyncReqDataBo.setRATE(contractDetailQueryBusiRspBO.getExchangeRate());
            ArrayList<ErpSyncLineData> lineData = new ArrayList<ErpSyncLineData>();
            interFaceContractErpSyncReqDataBo.setLINE_DATA(lineData);
            ContractItemQueryBusiReqBO contractItemQueryBusiReqBO = new ContractItemQueryBusiReqBO();
            contractItemQueryBusiReqBO.setContractId(contractId);
            ContractItemQueryBusiRspBO contractItemQueryBusiRspBO = this.contractItemQueryBusiService.contractItemQuery(contractItemQueryBusiReqBO);
            if (!"0000".equals(contractItemQueryBusiRspBO.getRespCode())) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u83b7\u53d6\u5931\u8d25");
                return rspBo;
            }
            if (CollectionUtils.isEmpty((Collection)contractItemQueryBusiRspBO.getRows())) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u83b7\u53d6\u4e3a\u7a7a");
                return rspBo;
            }
            int i = 1;
            for (ContractItemAbilityBO contractItemAbilityBO : contractItemQueryBusiRspBO.getRows()) {
                ErpSyncLineData erpSyncLineData = new ErpSyncLineData();
                erpSyncLineData.setITEM_NO(contractItemAbilityBO.getMaterialCode());
                erpSyncLineData.setUNIT_OF_MEASURE(contractItemAbilityBO.getUnitName());
                erpSyncLineData.setNEED_BY_DATE(DateUtils.dateToStr((Date)new Date(System.currentTimeMillis() + -1702967296L)));
                erpSyncLineData.setQUANTITY(contractItemAbilityBO.getAmount().toString());
                erpSyncLineData.setUNIT_PRICE(contractItemAbilityBO.getNotIncludingTaxAmount().toString());
                erpSyncLineData.setUSER_NAME(memDetailInfoBO.getAgentAccount());
                erpSyncLineData.setLINE_NUM(String.valueOf(i));
                erpSyncLineData.setORGANIZATION_ID(contractItemAbilityBO.getErpOrgCode());
                erpSyncLineData.setITEM_DESC(contractItemAbilityBO.getMaterialDesc());
                erpSyncLineData.setTAXRATE(contractItemAbilityBO.getRate().toString());
                lineData.add(erpSyncLineData);
                ++i;
            }
            headerIdAndContractCode.put(contractDetailQueryBusiRspBO.getContractId().toString(), contractDetailQueryBusiRspBO.getContractCode());
            interFaceContractErpSyncReqDataBos.add(interFaceContractErpSyncReqDataBo);
        }
        interFaceContractErpSyncReqBo.setHEADER_DATA(interFaceContractErpSyncReqDataBos);
        interFaceContractErpSyncReqBo.setPBATCH_ID(String.valueOf(Sequence.getInstance().nextId()));
        InterFaceContractErpSyncRspBo interFaceContractErpSyncRspBo = this.interFaceContractErpSyncService.erpSync(interFaceContractErpSyncReqBo);
        BeanUtils.copyProperties((Object)((Object)interFaceContractErpSyncRspBo), (Object)rspBo);
        ArrayList<CContractErpSyncRecordPO> cContractErpSyncRecordPOS = new ArrayList<CContractErpSyncRecordPO>();
        if ("0000".equals(interFaceContractErpSyncRspBo.getRespCode())) {
            for (InterFaceContractErpSyncRspDataBo interFaceContractErpSyncRspDataBo : interFaceContractErpSyncRspBo.getDATA()) {
                if (!headerIdAndContractCode.containsKey(interFaceContractErpSyncRspDataBo.getHEADER_UUID())) continue;
                CContractErpSyncRecordPO cContractErpSyncRecordPO = new CContractErpSyncRecordPO();
                if ("S".equals(interFaceContractErpSyncRspDataBo.getRETURN_STATUS())) {
                    success.add((String)headerIdAndContractCode.get(interFaceContractErpSyncRspDataBo.getHEADER_UUID()));
                    cContractErpSyncRecordPO.setSyncStatus(1);
                } else {
                    fail.put(headerIdAndContractCode.get(interFaceContractErpSyncRspDataBo.getHEADER_UUID()), interFaceContractErpSyncRspDataBo.getRETURN_MSG());
                    cContractErpSyncRecordPO.setSyncStatus(0);
                }
                cContractErpSyncRecordPO.setId(Sequence.getInstance().nextId());
                cContractErpSyncRecordPO.setRelateId(Long.valueOf(interFaceContractErpSyncRspDataBo.getHEADER_UUID()));
                cContractErpSyncRecordPO.setSyncMsg(interFaceContractErpSyncRspDataBo.getRETURN_MSG());
                cContractErpSyncRecordPO.setCreateTime(new Date());
                cContractErpSyncRecordPOS.add(cContractErpSyncRecordPO);
            }
        }
        if (!CollectionUtils.isEmpty(success)) {
            this.contractInfoMapper.updateErpSyncStatusByCodes(success, Integer.valueOf("1"));
        }
        if (!CollectionUtils.isEmpty(cContractErpSyncRecordPOS)) {
            this.cContractErpSyncRecordMapper.insertBatch(cContractErpSyncRecordPOS);
        }
        if (!CollectionUtils.isEmpty(fail)) {
            String failMsg = "";
            for (Map.Entry each : fail.entrySet()) {
                failMsg = failMsg + "\u5408\u540c\u7f16\u53f7\uff1a" + (String)each.getKey() + "\u540c\u6b65\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + (String)each.getValue() + ";\n";
            }
            rspBo.setRespDesc(failMsg);
            rspBo.setRespCode("8888");
        }
        return rspBo;
    }
}

