/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.fadada.sdk.client.FddClientBase;
import com.fadada.sdk.client.request.ExtsignReq;
import com.fadada.sdk.util.http.HttpsUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.busi.ContractFddSignBusiService;
import com.tydic.contract.busi.bo.ContractFddSignBusiReqBO;
import com.tydic.contract.busi.bo.ContractFddSignBusiRspBO;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractPo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ContractFddSignBusiServiceImpl
implements ContractFddSignBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractFddSignBusiServiceImpl.class);
    private static final String APP_ID = "405123";
    private static final String APP_SECRET = "4tnfcegCkIQMisikklw3aQXX";
    private static final String V = "2.0";
    private static final String HOST = "https://testapi.fadada.com:8443/api/";
    private static final String NOTICE = "/OSN/api/fddNotice/v1";
    @Value(value="${ESB_ACCESS_IP}")
    private String esbAddressId;
    @Autowired
    private ContractMapper contractMapper;

    @Override
    public ContractFddSignBusiRspBO dealContractSign(ContractFddSignBusiReqBO reqBO) {
        ContractPo contractPo = this.contractMapper.selectByPrimaryKey(reqBO.getContractId());
        if (contractPo == null) {
            throw new ZTBusinessException("\u6839\u636e\u5408\u540cid\u6ca1\u6709\u67e5\u8be2\u5230\u5408\u540c\u6570\u636e\uff1a\u8bf7\u4f20\u5165\u6b63\u786e\u7684contractId");
        }
        long flowId = Sequence.getInstance().nextId();
        FddClientBase base = new FddClientBase(APP_ID, APP_SECRET, V, HOST);
        String contract_id = String.valueOf(flowId);
        String doc_title = "\u5408\u540c.pdf";
        String doc_url = this.getDocUrl(contractPo);
        String doc_type = ".pdf";
        String result = base.invokeUploadDocs(contract_id, doc_title, null, doc_url, doc_type);
        log.info("\u5408\u540c\u4e0a\u4f20\u7ed3\u679c\uff1a" + result);
        String data = JSON.parseObject((String)result).getString("code");
        if (null != data) {
            if (data.equals("2002")) {
                return this.sign(reqBO, flowId, contractPo);
            }
            if (!data.equals("1000") && !data.equals("2002")) {
                throw new ZTBusinessException("\u5408\u540c\u4e0a\u4f20\u5931\u8d25...");
            }
        }
        return this.sign(reqBO, flowId, contractPo);
    }

    private ContractFddSignBusiRspBO sign(ContractFddSignBusiReqBO reqBO, Long flowId, ContractPo contractPo) {
        FddClientBase base = new FddClientBase(APP_ID, APP_SECRET, V, HOST);
        ExtsignReq req = new ExtsignReq();
        req.setCustomer_id(reqBO.getCustomerId());
        req.setTransaction_id(String.valueOf(flowId));
        req.setContract_id(String.valueOf(flowId));
        req.setDoc_title("\u5408\u540c");
        req.setReturn_url("https://www.baidu.com/");
        req.setNotify_url(this.esbAddressId + NOTICE);
        String sign_url = base.invokeExtSign(req);
        log.info("\u7b7e\u7f72\u9875\u9762url\uff1a" + sign_url);
        this.changeContractInfo(reqBO, flowId, contractPo);
        ContractFddSignBusiRspBO rspBO = new ContractFddSignBusiRspBO();
        rspBO.setSignUrl(sign_url);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6cd5\u5927\u5927\u53d1\u8d77\u7b7e\u7ae0\u6210\u529f");
        return rspBO;
    }

    private String getDocUrl(ContractPo contractPo) {
        if (ObjectUtils.isEmpty((Object)contractPo.getContractDocUrl())) {
            throw new ZTBusinessException("\u5408\u540cdocUrl\u4e3a\u7a7a");
        }
        return contractPo.getContractDocUrl();
    }

    private String getTransactionId() {
        String timeStamp = HttpsUtil.getTimeStamp();
        String open_id = "TRAN_" + timeStamp;
        log.info("\u6d41\u6c34\u53f7\uff1a" + open_id);
        return open_id;
    }

    private void changeContractInfo(ContractFddSignBusiReqBO reqBO, Long flowId, ContractPo contractPo) {
        int i;
        ContractPo updateContractPo = new ContractPo();
        updateContractPo.setContractId(reqBO.getContractId());
        updateContractPo.setExternalSignSysFlowId(String.valueOf(flowId));
        if (contractPo.getSignStatus() == 0) {
            log.info("\u5408\u540c\u7b7e\u7ae0-\u6807\u8bc6\u54ea\u4e00\u65b9\u5728\u7b7e\u7ea6\u5408\u540c");
            updateContractPo.setSignFlag(reqBO.getContractSignOrder());
        }
        if ((i = this.contractMapper.updateByPrimaryKeySelective(updateContractPo)) != 1) {
            throw new ZTBusinessException("\u5408\u540c\u6570\u636e\u66f4\u65b0\u5931\u8d25");
        }
    }
}

