/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcAddExPressRelationChangeAbilityService;
import com.tydic.cfc.ability.api.CfcExpressRelationBatchInsertAbilityService;
import com.tydic.cfc.ability.api.CfcTackleChangeExpressAbilityService;
import com.tydic.cfc.ability.bo.CfcAddExPressRelationChangeAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcExpressRelationBatchInsertBO;
import com.tydic.cfc.ability.bo.CfcTackleChangeExpressAbilityReqBO;
import com.tydic.contract.ability.bo.CContractOrderInfoBO;
import com.tydic.contract.ability.bo.ContractHtAddHtPayAbilityBO;
import com.tydic.contract.ability.bo.ContractHtAddInfoAbilityBO;
import com.tydic.contract.ability.bo.ContractHtAddInfoItemAbilityBO;
import com.tydic.contract.ability.bo.ContractHtAddOrderInfoAbilityBO;
import com.tydic.contract.ability.bo.ContractHtChangeAddAbilityReqBO;
import com.tydic.contract.ability.bo.ContractHtChangeAddAbilityRspBO;
import com.tydic.contract.ability.bo.ContractHtSettlementDetailAbilityBO;
import com.tydic.contract.atom.ContractPurchaseSyncSaleContractAtomiService;
import com.tydic.contract.busi.ContractHtChangeAddBusiService;
import com.tydic.contract.busi.bo.ContractPurchaseSyncSaleContractBusiReqBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.CContractOrderInfoMapper;
import com.tydic.contract.dao.ContractAccessoryMapper;
import com.tydic.contract.dao.ContractHtSettlementDetailMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractSettlementDetailMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.CContractOrderInfoPO;
import com.tydic.contract.po.ContractAccessoryPo;
import com.tydic.contract.po.ContractHtSettlementDetailPO;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractSettlementDetailPO;
import com.tydic.contract.utils.MoneyUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractHtChangeAddBusiServiceImpl
implements ContractHtChangeAddBusiService {
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractAccessoryMapper contractAccessoryMapper;
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;
    @Autowired
    private CfcTackleChangeExpressAbilityService cfcTackleChangeExpressAbilityService;
    @Autowired
    private CfcExpressRelationBatchInsertAbilityService cfcExpressRelationBatchInsertAbilityService;
    @Autowired
    CfcAddExPressRelationChangeAbilityService cfcAddExPressRelationChangeAbilityService;
    @Autowired
    private ContractSettlementDetailMapper contractSettlementDetailMapper;
    @Autowired
    private CContractOrderInfoMapper cContractOrderInfoMapper;
    @Autowired
    private ContractHtSettlementDetailMapper contractHtSettlementDetailMapper;
    @Autowired
    private ContractPurchaseSyncSaleContractAtomiService contractPurchaseSyncSaleContractAtomiService;

    @Override
    public ContractHtChangeAddAbilityRspBO addHtChange(ContractHtChangeAddAbilityReqBO reqBO) {
        ContractInfoPO updatePO;
        this.checkReqBO(reqBO);
        ContractInfoPO searchInfoPO = new ContractInfoPO();
        searchInfoPO.setOutContractId(reqBO.getInfoBO().getOutContractId());
        List<ContractInfoPO> infoPOS = this.contractInfoMapper.getList(searchInfoPO);
        if (CollectionUtils.isEmpty(infoPOS)) {
            throw new ZTBusinessException("\u539f\u5408\u540c\u4e0d\u5b58\u5728");
        }
        ContractInfoPO contractInfoPO = infoPOS.get(0);
        long updateApplyId = this.uccBatchSequence.nextId();
        Date nowDate = new Date();
        if ("1".equals(reqBO.getChangeStatus())) {
            updatePO = new ContractInfoPO();
            updatePO.setContractId(contractInfoPO.getContractId());
            updatePO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY);
            updatePO.setUpdateTime(nowDate);
            this.contractInfoMapper.updateByPrimaryKeySelective(updatePO);
        } else if ("3".equals(reqBO.getChangeStatus())) {
            updatePO = new ContractInfoPO();
            updatePO.setContractId(contractInfoPO.getContractId());
            updatePO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            updatePO.setUpdateTime(nowDate);
            this.contractInfoMapper.updateByPrimaryKeySelective(updatePO);
        } else if ("2".equals(reqBO.getChangeStatus())) {
            Set orderIdSet;
            int result;
            this.buildSettlementDetailBOS(reqBO);
            ContractInfoChangePO addChangePO = new ContractInfoChangePO();
            addChangePO.setUpdateApplyId(updateApplyId);
            addChangePO.setOutChangeId(reqBO.getOutChangeId());
            addChangePO.setContractId(contractInfoPO.getContractId());
            addChangePO.setContractCode(contractInfoPO.getContractCode());
            addChangePO.setModifyStatus(ContractConstant.ModifyStatus.MODIFY_STATUS_EFFECT);
            addChangePO.setUpdateApplyTime(nowDate);
            addChangePO.setCreateTime(nowDate);
            this.contractInfoChangeMapper.insertSelective(addChangePO);
            ContractHtAddInfoAbilityBO infoBO = reqBO.getInfoBO();
            ContractInfoPO updatePO2 = this.buildUpdate(infoBO, contractInfoPO);
            if (ContractConstant.UpdateApplyType.END_CONTRACT.equals(reqBO.getUpdateApplyType())) {
                updatePO2.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER);
            } else {
                updatePO2.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            }
            updatePO2.setUpdateTime(nowDate);
            ContractAccessoryPo deletePO = new ContractAccessoryPo();
            deletePO.setRelateId(updatePO2.getContractId());
            this.contractAccessoryMapper.deleteByCondition(deletePO);
            List<ContractAccessoryPo> accessoryList = this.buildAccessoryList(reqBO, contractInfoPO);
            if (!CollectionUtils.isEmpty(accessoryList) && (result = this.contractAccessoryMapper.insertBatch(accessoryList)) < 1) {
                throw new ZTBusinessException("\u5408\u540c\u9644\u4ef6\u6570\u636e\u65b0\u589e\u5931\u8d25");
            }
            if (reqBO.getExtBO() != null) {
                CContractInfoExtPO selectPO = new CContractInfoExtPO();
                selectPO.setRelateId(updatePO2.getContractId());
                CContractInfoExtPO contractInfoExtPO = this.cContractInfoExtMapper.getModelBy(selectPO);
                if (contractInfoExtPO != null) {
                    CContractInfoExtPO updateExtPo = new CContractInfoExtPO();
                    updateExtPo.setRelateId(updatePO2.getContractId());
                    CContractInfoExtPO wherePo = new CContractInfoExtPO();
                    wherePo.setId(contractInfoExtPO.getId());
                    if (!StringUtils.isEmpty((Object)reqBO.getExtBO().getPushMdm())) {
                        updateExtPo.setPushMdm(reqBO.getExtBO().getPushMdm());
                    }
                    this.cContractInfoExtMapper.updateBy(updateExtPo, wherePo);
                }
            }
            ArrayList<CContractOrderInfoBO> cContractOrderInfoList = new ArrayList<CContractOrderInfoBO>();
            if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderInfoBOS()) && !CollectionUtils.isEmpty(orderIdSet = reqBO.getOrderInfoBOS().stream().filter(e -> e.getOrderId() != null).map(ContractHtAddOrderInfoAbilityBO::getOrderId).collect(Collectors.toSet()))) {
                CContractOrderInfoPO searchPO = new CContractOrderInfoPO();
                searchPO.setOrderIds(new ArrayList<Long>(orderIdSet));
                List<CContractOrderInfoPO> orderInfoPOS = this.cContractOrderInfoMapper.getList(searchPO);
                List orderList = new ArrayList();
                if (!CollectionUtils.isEmpty(orderInfoPOS)) {
                    orderList = orderInfoPOS.stream().map(CContractOrderInfoPO::getOrderId).collect(Collectors.toList());
                }
                for (ContractHtAddOrderInfoAbilityBO orderInfoBO : reqBO.getOrderInfoBOS()) {
                    if (orderInfoBO.getOrderId() == null || orderList.contains(orderInfoBO.getOrderId())) continue;
                    CContractOrderInfoBO contractOrderInfoBO = (CContractOrderInfoBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)orderInfoBO), CContractOrderInfoBO.class);
                    cContractOrderInfoList.add(contractOrderInfoBO);
                }
            }
            if (!CollectionUtils.isEmpty(cContractOrderInfoList)) {
                this.cContractOrderInfoMapper.insertOrderList(cContractOrderInfoList);
            }
            List<ContractSettlementDetailPO> newSettlementPOS = this.buildSettlement(reqBO, contractInfoPO);
            ContractSettlementDetailPO deleteSettlementPO = new ContractSettlementDetailPO();
            deleteSettlementPO.setRelateId(contractInfoPO.getContractId());
            this.contractSettlementDetailMapper.deleteBy(deleteSettlementPO);
            if (!CollectionUtils.isEmpty(newSettlementPOS)) {
                this.contractSettlementDetailMapper.insertBatch(newSettlementPOS);
            }
            this.contractHtSettlementDetailMapper.deleteByRelateId(contractInfoPO.getContractId());
            if (!CollectionUtils.isEmpty((Collection)reqBO.getHtPayDetailBOS())) {
                List detailPOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getHtPayDetailBOS()), ContractHtSettlementDetailPO.class);
                for (ContractHtSettlementDetailPO detailPO : detailPOS) {
                    detailPO.setId(Sequence.getInstance().nextId());
                    detailPO.setRelateId(contractInfoPO.getContractId());
                    detailPO.setOutRelateId(reqBO.getInfoBO().getOutContractId());
                }
                this.contractHtSettlementDetailMapper.insertBatch(detailPOS);
            }
            ArrayList<ContractInfoItemPO> addItemPOS = new ArrayList<ContractInfoItemPO>();
            ArrayList<ContractInfoItemPO> updateItemPOS = new ArrayList<ContractInfoItemPO>();
            if (!CollectionUtils.isEmpty((Collection)reqBO.getItemBOS())) {
                List<ContractInfoItemPO> oldItemPOS = this.contractInfoItemMapper.getItemsByRelId(contractInfoPO.getContractId());
                Map<Object, Object> outItemIdMap = new HashMap();
                if (!CollectionUtils.isEmpty(oldItemPOS)) {
                    outItemIdMap = oldItemPOS.stream().collect(Collectors.toMap(ContractInfoItemPO::getOutItemId, o -> o));
                }
                for (ContractHtAddInfoItemAbilityBO itemBO : reqBO.getItemBOS()) {
                    if (outItemIdMap.containsKey(itemBO.getOutItemId())) {
                        ContractInfoItemPO oldItemPO;
                        ContractInfoItemPO updateItemPO = oldItemPO = (ContractInfoItemPO)outItemIdMap.get(itemBO.getOutItemId());
                        updateItemPO.setItemId(oldItemPO.getItemId());
                        updateItemPO.setAmount(itemBO.getAmount());
                        updateItemPO.setTaxUnitPrice(itemBO.getTaxUnitPrice());
                        if (updateItemPO.getRate() != null && updateItemPO.getTaxUnitPrice() != null) {
                            BigDecimal tax = new BigDecimal(String.valueOf(1.0f + (float)updateItemPO.getRate().intValue() / 100.0f));
                            updateItemPO.setUnitPriceExcludingTax(updateItemPO.getTaxUnitPrice().divide(tax, 8, 4).multiply(new BigDecimal("1")).setScale(8, 4));
                            if (updateItemPO.getAmount() != null) {
                                updateItemPO.setTaxAmount(updateItemPO.getTaxUnitPrice().multiply(updateItemPO.getAmount()).setScale(2, 4));
                                updateItemPO.setNotIncludingTaxAmount(updateItemPO.getUnitPriceExcludingTax().multiply(updateItemPO.getAmount()).setScale(2, 4));
                                updateItemPO.setTax(updateItemPO.getTaxAmount().subtract(updateItemPO.getNotIncludingTaxAmount()).setScale(2, 4));
                            }
                        }
                        updateItemPO.setFactoryPrice(itemBO.getFactoryPrice());
                        updateItemPO.setAddRate(itemBO.getAddRate());
                        updateItemPO.setOrderDeliveryDate(itemBO.getOrderDeliveryDate());
                        updateItemPO.setDeliveryDateDesc(itemBO.getDeliveryDateDesc());
                        updateItemPO.setMetalContent(itemBO.getMetalContent());
                        updateItemPO.setSaleStatus(itemBO.getSaleStatus());
                        updateItemPO.setSaleAmount(itemBO.getSaleAmount());
                        updateItemPO.setTaxCatalog(itemBO.getTaxCatalog());
                        updateItemPO.setQuoteRate(itemBO.getQuoteRate());
                        updateItemPO.setGuaranteePeriod(itemBO.getGuaranteePeriod());
                        updateItemPO.setSupplyCycle(itemBO.getSupplyCycle());
                        updateItemPOS.add(updateItemPO);
                        continue;
                    }
                    ContractInfoItemPO infoItemPO = (ContractInfoItemPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)itemBO), ContractInfoItemPO.class);
                    infoItemPO.setItemId(Sequence.getInstance().nextId());
                    infoItemPO.setRelateId(contractInfoPO.getContractId());
                    infoItemPO.setContractCode(infoBO.getContractCode());
                    if (infoItemPO.getRate() != null && infoItemPO.getTaxUnitPrice() != null) {
                        BigDecimal tax = new BigDecimal(String.valueOf(1.0f + (float)infoItemPO.getRate().intValue() / 100.0f));
                        infoItemPO.setUnitPriceExcludingTax(infoItemPO.getTaxUnitPrice().divide(tax, 8, 4).multiply(new BigDecimal("1")).setScale(8, 4));
                        if (infoItemPO.getAmount() != null) {
                            infoItemPO.setTaxAmount(infoItemPO.getTaxUnitPrice().multiply(infoItemPO.getAmount()).setScale(2, 4));
                            infoItemPO.setNotIncludingTaxAmount(infoItemPO.getUnitPriceExcludingTax().multiply(infoItemPO.getAmount()).setScale(2, 4));
                            infoItemPO.setTax(infoItemPO.getTaxAmount().subtract(infoItemPO.getNotIncludingTaxAmount()).setScale(2, 4));
                            infoItemPO.setMaterialName(itemBO.getMaterialLongName());
                            infoItemPO.setMaterialDesc(itemBO.getMaterialLongName());
                        }
                    }
                    infoItemPO.setBidderAmount(infoItemPO.getTaxUnitPrice());
                    addItemPOS.add(infoItemPO);
                }
            }
            if (!CollectionUtils.isEmpty(addItemPOS)) {
                this.contractInfoItemMapper.insertBatch(addItemPOS);
            }
            if (!CollectionUtils.isEmpty(updateItemPOS)) {
                this.contractInfoItemMapper.htInfoChangeUpdateBatch(updateItemPOS);
            }
            if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractInfoPO.getContractType())) {
                List<ContractInfoItemPO> itemPOS = this.contractInfoItemMapper.getItemsByRelId(contractInfoPO.getContractId());
                BigDecimal taxAmountTotal = new BigDecimal(0);
                BigDecimal taxTotal = new BigDecimal(0);
                BigDecimal notIncludingTaxAmountTotal = new BigDecimal(0);
                for (ContractInfoItemPO contractInfoItemPO : itemPOS) {
                    if (contractInfoItemPO.getTaxAmount() != null) {
                        taxAmountTotal = taxAmountTotal.add(contractInfoItemPO.getTaxAmount().setScale(2, 4).stripTrailingZeros());
                    }
                    if (contractInfoItemPO.getNotIncludingTaxAmount() != null) {
                        notIncludingTaxAmountTotal = notIncludingTaxAmountTotal.add(contractInfoItemPO.getNotIncludingTaxAmount().setScale(2, 4).stripTrailingZeros());
                    }
                    if (contractInfoItemPO.getTax() == null) continue;
                    taxTotal = taxTotal.add(contractInfoItemPO.getTax().setScale(2, 4).stripTrailingZeros());
                }
                if (!StringUtils.isEmpty((Object)contractInfoPO.getOrgTaxFlag())) {
                    if ("1".equals(contractInfoPO.getOrgTaxFlag())) {
                        updatePO2.setDiscussAmount(MoneyUtils.yuanToHaoToLong(taxAmountTotal));
                    } else {
                        updatePO2.setDiscussAmount(MoneyUtils.yuanToHaoToLong(notIncludingTaxAmountTotal));
                    }
                } else {
                    updatePO2.setDiscussAmount(MoneyUtils.yuanToHaoToLong(notIncludingTaxAmountTotal));
                }
            }
            this.contractInfoMapper.updateByPrimaryKeySelective(updatePO2);
            if (!CollectionUtils.isEmpty((Collection)reqBO.getExpressBOS())) {
                this.saveExpressRelation(addChangePO, reqBO);
            }
            this.delexpressRelation(addChangePO);
        } else {
            throw new ZTBusinessException("\u53d8\u66f4\u72b6\u6001\u679a\u4e3e\u503c\u4e0d\u5408\u6cd5");
        }
        ContractHtChangeAddAbilityRspBO rspBO = new ContractHtChangeAddAbilityRspBO();
        if (ContractConstant.ContractType.PURCHASE_CONTRACT.equals(contractInfoPO.getContractType())) {
            ContractPurchaseSyncSaleContractBusiReqBO syncSaleContractBusiReqBO;
            if ("1".equals(reqBO.getChangeStatus())) {
                syncSaleContractBusiReqBO = new ContractPurchaseSyncSaleContractBusiReqBO();
                syncSaleContractBusiReqBO.setContractId(contractInfoPO.getContractId());
                syncSaleContractBusiReqBO.setOperationType(1);
                this.contractPurchaseSyncSaleContractAtomiService.purchaseSyncSaleContract(syncSaleContractBusiReqBO);
            } else if ("3".equals(reqBO.getChangeStatus())) {
                syncSaleContractBusiReqBO = new ContractPurchaseSyncSaleContractBusiReqBO();
                syncSaleContractBusiReqBO.setContractId(contractInfoPO.getContractId());
                syncSaleContractBusiReqBO.setOperationType(3);
                this.contractPurchaseSyncSaleContractAtomiService.purchaseSyncSaleContract(syncSaleContractBusiReqBO);
            } else if ("2".equals(reqBO.getChangeStatus())) {
                rspBO.setOperationType(Integer.valueOf(2));
            }
        }
        rspBO.setContractId(contractInfoPO.getContractId());
        rspBO.setIsFz(contractInfoPO.getIsFz());
        rspBO.setUpdateApplyId(Long.valueOf(updateApplyId));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkReqBO(ContractHtChangeAddAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getOutChangeId())) {
            throw new ZTBusinessException("\u5916\u90e8\u53d8\u66f4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getUpdateApplyType() == null) {
            throw new ZTBusinessException("\u53d8\u66f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getChangeStatus())) {
            throw new ZTBusinessException("\u53d8\u66f4\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInfoBO() == null) {
            throw new ZTBusinessException("\u53d8\u66f4\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getInfoBO().getOutContractId())) {
            throw new ZTBusinessException("\u5916\u90e8\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getInfoBO().getOutContractUuId())) {
            throw new ZTBusinessException("\u5408\u540c\u7cfb\u7edfUUID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("2".equals(reqBO.getChangeStatus())) {
            if (!CollectionUtils.isEmpty((Collection)reqBO.getItemBOS())) {
                HashSet<String> outItemIdSet = new HashSet<String>();
                for (ContractHtAddInfoItemAbilityBO itemBO : reqBO.getItemBOS()) {
                    if (StringUtils.isEmpty((Object)itemBO.getOutItemId())) {
                        throw new ZTBusinessException("\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    outItemIdSet.add(itemBO.getOutItemId());
                }
                if (outItemIdSet.size() != reqBO.getItemBOS().size()) {
                    throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u884cid\u4e0d\u80fd\u91cd\u590d");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
                reqBO.getAccessoryList().forEach(e -> {
                    if (StringUtils.isEmpty((Object)e.getAcceessoryName())) {
                        throw new ZTBusinessException("\u9644\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isEmpty((Object)e.getAcceessoryUrl())) {
                        throw new ZTBusinessException("\u9644\u4ef6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (e.getRelateType() == null) {
                        throw new ZTBusinessException("\u9644\u4ef6\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getExpressBOS())) {
                reqBO.getExpressBOS().forEach(e -> {
                    if (e.getExpressId() == null) {
                        throw new ZTBusinessException("\u516c\u5f0fID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            }
            if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderInfoBOS())) {
                reqBO.getOrderInfoBOS().forEach(e -> {
                    if (e.getOrderId() == null) {
                        throw new ZTBusinessException("\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            }
        }
    }

    private void buildSettlementDetailBOS(ContractHtChangeAddAbilityReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getHtPayDetailBOS())) {
            reqBO.getInfoBO().setPayType(ContractConstant.PayType.PHASED_PAYMENT_CODE);
            ArrayList<ContractHtSettlementDetailAbilityBO> settlementDetailBOS = new ArrayList<ContractHtSettlementDetailAbilityBO>();
            for (ContractHtAddHtPayAbilityBO htPayDetailBO : reqBO.getHtPayDetailBOS()) {
                if (StringUtils.isEmpty((Object)htPayDetailBO.getPanelPointCode())) {
                    reqBO.getInfoBO().setPayType(ContractConstant.PayType.NO_HAVE_PAY);
                    settlementDetailBOS = new ArrayList();
                    break;
                }
                ContractHtSettlementDetailAbilityBO settlementDetailBO = new ContractHtSettlementDetailAbilityBO();
                settlementDetailBO.setDays(htPayDetailBO.getDays());
                settlementDetailBO.setPayPercent(htPayDetailBO.getPayPercent());
                settlementDetailBO.setExtField1("1");
                settlementDetailBO.setPaymentType(htPayDetailBO.getPaymentType());
                settlementDetailBO.setPlanAmount(htPayDetailBO.getPlanAmount());
                settlementDetailBO.setHtPanelPointCode(htPayDetailBO.getPanelPointCode());
                settlementDetailBO.setHtPanelPointName(htPayDetailBO.getPanelPointName());
                if (!StringUtils.isEmpty((Object)htPayDetailBO.getPeriod())) {
                    try {
                        Integer period = Integer.valueOf(htPayDetailBO.getPeriod());
                        settlementDetailBO.setSortNum(period);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ("1".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.PRE_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("1");
                    settlementDetailBO.setPanelPointName("\u4e0b\u5355\u9884\u4ed8");
                }
                if ("2".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.PRE_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("1");
                    settlementDetailBO.setPanelPointName("\u4e0b\u5355\u9884\u4ed8");
                }
                if ("3".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.PRE_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("1");
                    settlementDetailBO.setPanelPointName("\u4e0b\u5355\u9884\u4ed8");
                    reqBO.getInfoBO().setPayType(ContractConstant.PayType.NO_HAVE_PAY);
                    settlementDetailBOS = new ArrayList();
                    break;
                }
                if ("4".equals(htPayDetailBO.getPanelPointCode())) {
                    if ("YINGFK".equals(htPayDetailBO.getPaymentType())) {
                        settlementDetailBO.setMoneyType(ContractConstant.MoneyType.ACCOUNT_PAY_CODE);
                        settlementDetailBO.setPanelPointCode("6");
                        settlementDetailBO.setPanelPointName("\u5230\u8d27\u4e14\u6536\u5230\u53d1\u7968");
                    } else {
                        settlementDetailBO.setMoneyType(ContractConstant.MoneyType.PRE_PAY_CODE);
                        settlementDetailBO.setPanelPointCode("2");
                        settlementDetailBO.setPanelPointName("\u5230\u8d27\u9884\u4ed8");
                    }
                }
                if ("5".equals(htPayDetailBO.getPanelPointCode())) {
                    settlementDetailBO.setMoneyType(ContractConstant.MoneyType.ACCOUNT_PAY_CODE);
                    settlementDetailBO.setPanelPointCode("4");
                    settlementDetailBO.setPanelPointName("\u9a8c\u6536\u4e14\u6536\u5230\u53d1\u7968");
                }
                if ("6".equals(htPayDetailBO.getPanelPointCode()) || "7".equals(htPayDetailBO.getPanelPointCode())) {
                    if (StringUtils.isEmpty((Object)reqBO.getInfoBO().getAfterGoodsArrive()) && StringUtils.isEmpty((Object)reqBO.getInfoBO().getAfterReceiptIssuance())) {
                        throw new ZTBusinessException("panelPointCode\u679a\u4e3e\u503c\u4e3a6\u62167\u65f6\uff0cafterGoodsArrive\u6216afterReceiptIssuance\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
                    }
                    if (!StringUtils.isEmpty((Object)reqBO.getInfoBO().getAfterGoodsArrive())) {
                        settlementDetailBO.setMoneyType(ContractConstant.MoneyType.GUARANTEE_PAY_CODE);
                        settlementDetailBO.setPanelPointCode("4");
                        settlementDetailBO.setPanelPointName("\u9a8c\u6536\u4e14\u6536\u5230\u53d1\u7968");
                        try {
                            settlementDetailBO.setDays(Integer.valueOf(reqBO.getInfoBO().getAfterGoodsArrive()));
                        }
                        catch (Exception exception) {}
                    } else {
                        settlementDetailBO.setMoneyType(ContractConstant.MoneyType.GUARANTEE_PAY_CODE);
                        settlementDetailBO.setPanelPointCode("6");
                        settlementDetailBO.setPanelPointName("\u5230\u8d27\u4e14\u6536\u5230\u53d1\u7968");
                        try {
                            settlementDetailBO.setDays(Integer.valueOf(reqBO.getInfoBO().getAfterReceiptIssuance()));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                settlementDetailBOS.add(settlementDetailBO);
            }
            reqBO.setSettlementDetailBOS(settlementDetailBOS);
        } else {
            ArrayList settlementDetailBOS = new ArrayList();
            reqBO.getInfoBO().setPayType(ContractConstant.PayType.NO_HAVE_PAY);
            settlementDetailBOS = new ArrayList();
            reqBO.setSettlementDetailBOS(settlementDetailBOS);
        }
    }

    private List<ContractSettlementDetailPO> buildSettlement(ContractHtChangeAddAbilityReqBO reqBO, ContractInfoPO contractInfoPO) {
        ContractSettlementDetailPO searchSettlementPO = new ContractSettlementDetailPO();
        searchSettlementPO.setRelateId(contractInfoPO.getContractId());
        List<ContractSettlementDetailPO> oldSettlementPOS = this.contractSettlementDetailMapper.getList(searchSettlementPO);
        HashMap oldValueKeyMap = new HashMap();
        HashMap oldValueKeyPOMap = new HashMap();
        if (!CollectionUtils.isEmpty(oldSettlementPOS)) {
            for (ContractSettlementDetailPO oldSettlementPO : oldSettlementPOS) {
                StringBuilder valueKey = new StringBuilder();
                valueKey.append("moneyType-");
                valueKey.append(oldSettlementPO.getMoneyType());
                valueKey.append("-panelPointCode-");
                valueKey.append(oldSettlementPO.getPanelPointCode());
                valueKey.append("-days-");
                valueKey.append(oldSettlementPO.getDays());
                valueKey.append("-payPercent-");
                valueKey.append(oldSettlementPO.getPayPercent());
                valueKey.append("-extField1-");
                valueKey.append(oldSettlementPO.getExtField1());
                if (!oldValueKeyMap.containsKey(valueKey.toString())) {
                    ArrayList<ContractSettlementDetailPO> poList = new ArrayList<ContractSettlementDetailPO>();
                    poList.add(oldSettlementPO);
                    oldValueKeyMap.put(valueKey.toString(), poList);
                } else {
                    ((List)oldValueKeyMap.get(valueKey.toString())).add(oldSettlementPO);
                }
                StringBuilder valueKeyPO = new StringBuilder();
                valueKeyPO.append("moneyType-");
                valueKeyPO.append(oldSettlementPO.getMoneyType());
                valueKeyPO.append("-panelPointCode-");
                valueKeyPO.append(oldSettlementPO.getPanelPointCode());
                valueKeyPO.append("-extField1-");
                valueKeyPO.append(oldSettlementPO.getExtField1());
                if (!oldValueKeyPOMap.containsKey(valueKeyPO.toString())) {
                    ArrayList<ContractSettlementDetailPO> poList = new ArrayList<ContractSettlementDetailPO>();
                    poList.add(oldSettlementPO);
                    oldValueKeyPOMap.put(valueKeyPO.toString(), poList);
                    continue;
                }
                ((List)oldValueKeyPOMap.get(valueKeyPO.toString())).add(oldSettlementPO);
            }
        }
        ArrayList<ContractSettlementDetailPO> newSettlementPOS = new ArrayList<ContractSettlementDetailPO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSettlementDetailBOS())) {
            if (CollectionUtils.isEmpty(oldSettlementPOS)) {
                List detailPOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getSettlementDetailBOS()), ContractSettlementDetailPO.class);
                for (Object detailPO : detailPOS) {
                    ((ContractSettlementDetailPO)detailPO).setId(Sequence.getInstance().nextId());
                    ((ContractSettlementDetailPO)detailPO).setRelateId(contractInfoPO.getContractId());
                }
                newSettlementPOS.addAll(detailPOS);
            } else {
                HashMap newValueKeyMap = new HashMap();
                List newDetailPOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getSettlementDetailBOS()), ContractSettlementDetailPO.class);
                for (Object newDetailPO : newDetailPOS) {
                    ((ContractSettlementDetailPO)newDetailPO).setRelateId(contractInfoPO.getContractId());
                    StringBuilder valueKey = new StringBuilder();
                    valueKey.append("moneyType-");
                    valueKey.append(((ContractSettlementDetailPO)newDetailPO).getMoneyType());
                    valueKey.append("-panelPointCode-");
                    valueKey.append(((ContractSettlementDetailPO)newDetailPO).getPanelPointCode());
                    valueKey.append("-days-");
                    valueKey.append(((ContractSettlementDetailPO)newDetailPO).getDays());
                    valueKey.append("-payPercent-");
                    valueKey.append(((ContractSettlementDetailPO)newDetailPO).getPayPercent());
                    valueKey.append("-extField1-");
                    valueKey.append(((ContractSettlementDetailPO)newDetailPO).getExtField1());
                    if (!newValueKeyMap.containsKey(valueKey.toString())) {
                        ArrayList<Object> poList = new ArrayList<Object>();
                        poList.add(newDetailPO);
                        newValueKeyMap.put(valueKey.toString(), poList);
                        continue;
                    }
                    ((List)newValueKeyMap.get(valueKey.toString())).add(newDetailPO);
                }
                Boolean isChange = false;
                for (String newValueKey : newValueKeyMap.keySet()) {
                    if (oldValueKeyMap.containsKey(newValueKey)) {
                        int newSize;
                        int oldSize = ((List)oldValueKeyMap.get(newValueKey)).size();
                        if (oldSize == (newSize = ((List)newValueKeyMap.get(newValueKey)).size())) continue;
                        isChange = true;
                        break;
                    }
                    isChange = true;
                    break;
                }
                if (isChange.booleanValue()) {
                    StringBuilder newValueKey;
                    ArrayList<Long> areadyIdList = new ArrayList<Long>();
                    ArrayList<Long> addIdList = new ArrayList<Long>();
                    ArrayList<Long> updateIdList = new ArrayList<Long>();
                    for (ContractSettlementDetailPO newDetailPO : newDetailPOS) {
                        newDetailPO.setRelateId(contractInfoPO.getContractId());
                        newValueKey = new StringBuilder();
                        newValueKey.append("moneyType-");
                        newValueKey.append(newDetailPO.getMoneyType());
                        newValueKey.append("-panelPointCode-");
                        newValueKey.append(newDetailPO.getPanelPointCode());
                        newValueKey.append("-days-");
                        newValueKey.append(newDetailPO.getDays());
                        newValueKey.append("-payPercent-");
                        newValueKey.append(newDetailPO.getPayPercent());
                        newValueKey.append("-extField1-");
                        newValueKey.append(newDetailPO.getExtField1());
                        if (!oldValueKeyMap.containsKey(newValueKey.toString())) continue;
                        for (ContractSettlementDetailPO oldPO : (List)oldValueKeyMap.get(newValueKey.toString())) {
                            if (areadyIdList.contains(oldPO.getId())) continue;
                            newDetailPO.setId(oldPO.getId());
                            areadyIdList.add(oldPO.getId());
                        }
                    }
                    for (ContractSettlementDetailPO newDetailPO : newDetailPOS) {
                        newDetailPO.setRelateId(contractInfoPO.getContractId());
                        newValueKey = new StringBuilder();
                        newValueKey.append("moneyType-");
                        newValueKey.append(newDetailPO.getMoneyType());
                        newValueKey.append("-panelPointCode-");
                        newValueKey.append(newDetailPO.getPanelPointCode());
                        newValueKey.append("-days-");
                        newValueKey.append(newDetailPO.getDays());
                        newValueKey.append("-payPercent-");
                        newValueKey.append(newDetailPO.getPayPercent());
                        newValueKey.append("-extField1-");
                        newValueKey.append(newDetailPO.getExtField1());
                        if (newDetailPO.getId() == null) {
                            newValueKey = new StringBuilder();
                            newValueKey.append("moneyType-");
                            newValueKey.append(newDetailPO.getMoneyType());
                            newValueKey.append("-panelPointCode-");
                            newValueKey.append(newDetailPO.getPanelPointCode());
                            newValueKey.append("-extField1-");
                            newValueKey.append(newDetailPO.getExtField1());
                            if (oldValueKeyPOMap.containsKey(newValueKey.toString())) {
                                for (ContractSettlementDetailPO oldPO : (List)oldValueKeyPOMap.get(newValueKey.toString())) {
                                    if (areadyIdList.contains(oldPO.getId())) continue;
                                    newDetailPO.setId(oldPO.getId());
                                    areadyIdList.add(oldPO.getId());
                                    updateIdList.add(oldPO.getId());
                                }
                            }
                        }
                        if (newDetailPO.getId() == null) {
                            newDetailPO.setId(Sequence.getInstance().nextId());
                            addIdList.add(newDetailPO.getId());
                        }
                        newSettlementPOS.add(newDetailPO);
                    }
                } else {
                    newSettlementPOS.addAll(oldSettlementPOS);
                }
            }
        }
        return newSettlementPOS;
    }

    private ContractInfoPO buildUpdate(ContractHtAddInfoAbilityBO infoBO, ContractInfoPO contractInfoPO) {
        ContractInfoPO updatePO = new ContractInfoPO();
        updatePO.setOutContractUuId(infoBO.getOutContractUuId());
        updatePO.setContractId(contractInfoPO.getContractId());
        updatePO.setContractName(infoBO.getContractName());
        if (!StringUtils.isEmpty((Object)infoBO.getSupplierAddress())) {
            updatePO.setSupplierAddress(infoBO.getSupplierAddress());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getSupplierAddressAliasId())) {
            updatePO.setSupplierAddressAliasId(infoBO.getSupplierAddressAliasId());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getSupplierAddressAlias())) {
            updatePO.setSupplierAddressAlias(infoBO.getSupplierAddressAlias());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getSupplierAuthorizedAgent())) {
            updatePO.setSupplierAuthorizedAgent(infoBO.getSupplierAuthorizedAgent());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getSupplierPhone())) {
            updatePO.setSupplierPhone(infoBO.getSupplierPhone());
        }
        if (infoBO.getContractAmount() != null) {
            updatePO.setContractAmount(MoneyUtils.yuanToHaoToLong(infoBO.getContractAmount()));
        }
        if (infoBO.getAmountLimit() != null) {
            updatePO.setAmountLimit(MoneyUtils.yuanToHaoToLong(infoBO.getAmountLimit()));
            if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(infoBO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(infoBO.getContractType())) {
                updatePO.setDiscussAmount(updatePO.getAmountLimit());
            }
        }
        if (infoBO.getContractAmountExcludingTax() != null) {
            updatePO.setContractAmountExcludingTax(MoneyUtils.yuanToHaoToLong(infoBO.getContractAmountExcludingTax()));
        }
        if (infoBO.getContractAmount() != null && infoBO.getContractAmountExcludingTax() != null) {
            BigDecimal contractTax = infoBO.getContractAmount().subtract(infoBO.getContractAmountExcludingTax());
            updatePO.setContractTax(MoneyUtils.yuanToHaoToLong(contractTax));
        }
        updatePO.setContractValidTime(infoBO.getContractEndDate());
        updatePO.setEffectiveDate(infoBO.getContractEffectiveDate());
        if (!StringUtils.isEmpty((Object)infoBO.getCurrency())) {
            updatePO.setCurrency(infoBO.getCurrency());
        }
        updatePO.setExchangeRate(infoBO.getExchangeRate());
        updatePO.setToCurrency(infoBO.getToCurrency());
        updatePO.setConversionDate(infoBO.getConversionDate());
        updatePO.setConversionType(infoBO.getConversionType());
        updatePO.setPayType(infoBO.getPayType());
        updatePO.setExpectSettle(infoBO.getExpectSettle());
        updatePO.setSettleDay(infoBO.getSettleDay());
        updatePO.setPayNodeRuleAllow(infoBO.getPayNodeRuleAllow());
        updatePO.setPurchaseType(infoBO.getPurchaseType());
        updatePO.setContractEndDate(infoBO.getContractEndDate());
        updatePO.setContractDocName(infoBO.getContractDocName());
        updatePO.setContractDocUrl(infoBO.getContractDocUrl());
        updatePO.setCPayType(infoBO.getCPayType());
        updatePO.setCPrePay(infoBO.getCPrePay());
        updatePO.setCDeliveryPay(infoBO.getCDeliveryPay());
        updatePO.setCInvoicePay(infoBO.getCInvoicePay());
        updatePO.setCQuaAmount(infoBO.getCQuaAmount());
        updatePO.setCExpectSettle(infoBO.getCExpectSettle());
        updatePO.setCSettleDay(infoBO.getCSettleDay());
        updatePO.setCPayNodeRuleAllow(infoBO.getCPayNodeRuleAllow());
        updatePO.setAdjustPrice(infoBO.getAdjustPrice());
        if (!StringUtils.isEmpty((Object)infoBO.getBuyerLinkmanPhone())) {
            updatePO.setBuyerLinkmanPhone(infoBO.getBuyerLinkmanPhone());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getSupplierLinkMan())) {
            updatePO.setSupplierLinkMan(infoBO.getSupplierLinkMan());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getSupplierLinkmanPhone())) {
            updatePO.setSupplierLinkmanPhone(infoBO.getSupplierLinkmanPhone());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getThirdAuthorizedAgent())) {
            updatePO.setThirdAuthorizedAgent(infoBO.getThirdAuthorizedAgent());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getThirdUniAddress())) {
            updatePO.setThirdUniAddress(infoBO.getThirdUniAddress());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getThirdPost())) {
            updatePO.setThirdPost(infoBO.getThirdPost());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getThirdEmail())) {
            updatePO.setThirdEmail(infoBO.getThirdEmail());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getThirdPhone())) {
            updatePO.setThirdPhone(infoBO.getThirdPhone());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getThirdFax())) {
            updatePO.setThirdFax(infoBO.getThirdFax());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getThirdBankName())) {
            updatePO.setThirdBankName(infoBO.getThirdBankName());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getThirdBankSubName())) {
            updatePO.setThirdBankSubName(infoBO.getThirdBankSubName());
        }
        if (!StringUtils.isEmpty((Object)infoBO.getThirdAccount())) {
            updatePO.setThirdAccount(infoBO.getThirdAccount());
        }
        return updatePO;
    }

    private List<ContractAccessoryPo> buildAccessoryList(ContractHtChangeAddAbilityReqBO reqBO, ContractInfoPO contractInfoPO) {
        ArrayList<ContractAccessoryPo> accessoryList = new ArrayList<ContractAccessoryPo>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAccessoryList())) {
            String jsonString = JSON.toJSONString((Object)reqBO.getAccessoryList());
            List list = JSONArray.parseArray((String)jsonString).toJavaList(ContractAccessoryPo.class);
            for (ContractAccessoryPo contractAccessoryPo : list) {
                contractAccessoryPo.setAcceessoryId(Sequence.getInstance().nextId());
                contractAccessoryPo.setRelateId(contractInfoPO.getContractId());
                contractAccessoryPo.setRelateCode(contractInfoPO.getContractCode());
                contractAccessoryPo.setCreateUserId(contractInfoPO.getCreateUserId());
                contractAccessoryPo.setCreateUserName(contractInfoPO.getCreateUserName());
                contractAccessoryPo.setCreateTime(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                if (ContractConstant.RelateType.RELATE_TYPE_MODIFY_APPLY.equals(contractAccessoryPo.getRelateType())) {
                    contractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT);
                }
                if (ContractConstant.RelateType.RELATE_TYPE_MODIFY_APPLY_BASIC.equals(contractAccessoryPo.getRelateType())) {
                    contractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT_BASIC);
                }
                if (ContractConstant.RelateType.RELATE_TYPE_MODIFY_APPLY_FW.equals(contractAccessoryPo.getRelateType())) {
                    contractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT_FW);
                }
                if (ContractConstant.RelateType.RELATE_TYPE_MODIFY_APPLY_SUPPLIER.equals(contractAccessoryPo.getRelateType())) {
                    contractAccessoryPo.setRelateType(ContractConstant.RelateType.RELATE_TYPE_CONTRACT_SUPPLIER);
                }
                accessoryList.add(contractAccessoryPo);
            }
        }
        return accessoryList;
    }

    private void saveExpressRelation(ContractInfoChangePO addChangePO, ContractHtChangeAddAbilityReqBO reqBO) {
        if (!CollectionUtils.isEmpty((Collection)reqBO.getExpressBOS())) {
            Long updateApplyId = addChangePO.getUpdateApplyId();
            String updateApplyCode = addChangePO.getUpdateApplyCode();
            Long objId = null;
            String objCode = null;
            Integer type = 1;
            objId = addChangePO.getContractId();
            objCode = addChangePO.getContractCode();
            List cfcExpressRelationBatchInsertBOS = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getExpressBOS()), CfcExpressRelationBatchInsertBO.class);
            CfcAddExPressRelationChangeAbilityReqBO reqBO1 = new CfcAddExPressRelationChangeAbilityReqBO();
            reqBO1 = (CfcAddExPressRelationChangeAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), CfcAddExPressRelationChangeAbilityReqBO.class);
            reqBO1.setExpressRelationList(cfcExpressRelationBatchInsertBOS);
            reqBO1.setObjId(objId);
            reqBO1.setObjNo(objCode);
            reqBO1.setUpdateApplyCode(updateApplyCode);
            reqBO1.setUpdateApplyId(updateApplyId);
            reqBO1.setSuitType(type);
            this.cfcAddExPressRelationChangeAbilityService.addExPressRelationChange(reqBO1);
        }
    }

    public void delexpressRelation(ContractInfoChangePO contractInfoChangePO) {
        CfcTackleChangeExpressAbilityReqBO abilityReqBO = new CfcTackleChangeExpressAbilityReqBO();
        abilityReqBO.setObjCode(contractInfoChangePO.getContractCode());
        abilityReqBO.setObjId(contractInfoChangePO.getContractId());
        abilityReqBO.setSuitType(Integer.valueOf(1));
        abilityReqBO.setUpdateApplyId(contractInfoChangePO.getUpdateApplyId());
        this.cfcTackleChangeExpressAbilityService.tackleChangeExpress(abilityReqBO);
    }
}

