/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQryComparePriceAbilityService;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.ability.bo.ContractQryComparePriceAbilityBO;
import com.tydic.contract.ability.bo.ContractQryComparePriceAbilityQryBO;
import com.tydic.contract.ability.bo.ContractQryComparePriceAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryComparePriceAbilityRspBO;
import com.tydic.contract.atom.InterFaceContractGetCanOrderNumAtomService;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomReqBO;
import com.tydic.contract.atom.bo.InterFaceContractGetCanOrderNumAtomRspBO;
import com.tydic.contract.busi.ContractItemQueryBusiService;
import com.tydic.contract.busi.bo.ContractItemQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemQueryBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoItemLogMapper;
import com.tydic.contract.dao.CContractOrderInfoMapper;
import com.tydic.contract.dao.CRelBuySaleContractMapper;
import com.tydic.contract.dao.ContractInfoChangeMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoItemTmpMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.po.CContractInfoItemCompareVO;
import com.tydic.contract.po.CContractInfoItemLogPO;
import com.tydic.contract.po.CContractOrderInfoPO;
import com.tydic.contract.po.ContractInfoChangePO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemTmpPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractItemCanBuyListQryPO;
import com.tydic.contract.po.ContractOrderPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.DycUmcQueryBuyerPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionRspBo;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractItemQueryBusiServiceImpl
implements ContractItemQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractItemQueryBusiServiceImpl.class);
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoItemTmpMapper contractInfoItemTmpMapper;
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private CContractInfoItemLogMapper cContractInfoItemLogMapper;
    @Autowired
    private CRelBuySaleContractMapper cRelBuySaleContractMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoChangeMapper contractInfoChangeMapper;
    @Autowired
    private InterFaceContractGetCanOrderNumAtomService interFaceContractGetCanOrderNumAtomService;
    @Autowired
    private CContractOrderInfoMapper cContractOrderInfoMapper;
    @Value(value="${DEVELOP_COMPANY_DEPARTMENT}")
    private String developCompanyDepartment;
    @Autowired
    private DycUmcQueryBuyerPermissionService dycUmcQueryBuyerPermissionService;
    @Autowired
    private ContractQryComparePriceAbilityService contractQryComparePriceAbilityService;
    @Value(value="${ORDER_QRY:1}")
    private String orderQry;

    @Override
    public ContractItemQueryBusiRspBO contractItemQuery(ContractItemQueryBusiReqBO reqBO) {
        ContractItemQueryBusiRspBO contractItemQueryBusiRspBO = new ContractItemQueryBusiRspBO();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getContractCode()) && reqBO.getContractId() == null) {
            contractItemQueryBusiRspBO.setRespCode("8888");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u7f16\u7f16\u7801\u5408\u540cID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemMapper.selectByRelateCode(reqBO.getContractCode(), reqBO.getContractId(), reqBO.getContractItemBOList()));
        List contractItemPoList = page.getResult();
        log.info("\u5408\u540c\u660e\u7ec6\u67e5\u8be2" + page.toString());
        contractItemQueryBusiRspBO.setPageNo(page.getPageNum());
        contractItemQueryBusiRspBO.setRecordsTotal(Integer.parseInt(String.valueOf(page.getTotal())));
        contractItemQueryBusiRspBO.setTotal(page.getPages());
        if (!(contractItemPoList != null && contractItemPoList.size() >= 1 || reqBO.getPageSize().equals(-1))) {
            contractItemQueryBusiRspBO.setRespCode("8888");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        BigDecimal taxAmountTotal = new BigDecimal(0);
        BigDecimal notIncludingTaxAmountTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);
        List<ContractInfoItemPO> contractItemPoList1 = this.contractInfoItemMapper.selectByRelateCode(reqBO.getContractCode(), reqBO.getContractId(), reqBO.getContractItemBOList());
        if ((contractItemPoList1 == null || contractItemPoList1.size() < 1) && reqBO.getPageSize().equals(-1)) {
            contractItemQueryBusiRspBO.setRespCode("8888");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        for (ContractInfoItemPO po : contractItemPoList1) {
            if (po.getTaxAmount() != null) {
                taxAmountTotal = taxAmountTotal.add(MoneyUtils.haoToYuan(po.getTaxAmount()));
            }
            if (po.getNotIncludingTaxAmount() != null) {
                notIncludingTaxAmountTotal = notIncludingTaxAmountTotal.add(MoneyUtils.haoToYuan(po.getNotIncludingTaxAmount()));
            }
            if (po.getTax() == null) continue;
            taxTotal = taxTotal.add(MoneyUtils.haoToYuan(po.getTax()));
        }
        contractItemQueryBusiRspBO.setTaxAmountTotal(taxAmountTotal);
        contractItemQueryBusiRspBO.setTaxTotal(taxTotal);
        contractItemQueryBusiRspBO.setNotIncludingTaxAmountTotal(notIncludingTaxAmountTotal);
        List<ContractItemAbilityBO> contractItemBusiBOList = !reqBO.getPageSize().equals(-1) ? this.BoParse(contractItemPoList) : this.BoParse(contractItemPoList1);
        this.translate(contractItemBusiBOList);
        contractItemQueryBusiRspBO.setRows(contractItemBusiBOList);
        if (!CollectionUtils.isEmpty((Collection)contractItemQueryBusiRspBO.getRows())) {
            contractItemQueryBusiRspBO.getRows().forEach(each -> {
                if (each.getTaxUnitPrice() != null) {
                    each.setTaxUnitPrice(each.getTaxUnitPrice().setScale(8, 4).stripTrailingZeros());
                }
                if (each.getUnitPriceExcludingTax() != null) {
                    each.setUnitPriceExcludingTax(each.getUnitPriceExcludingTax().setScale(8, 4).stripTrailingZeros());
                }
                if (each.getUnitPrice() != null) {
                    each.setUnitPrice(each.getUnitPrice().setScale(8, 4).stripTrailingZeros());
                }
                if (each.getTaxAmount() != null) {
                    each.setTaxAmount(each.getTaxAmount().setScale(2, 4).stripTrailingZeros());
                }
                if (each.getNotIncludingTaxAmount() != null) {
                    each.setNotIncludingTaxAmount(each.getNotIncludingTaxAmount().setScale(2, 4).stripTrailingZeros());
                }
                if (each.getTax() != null) {
                    each.setTax(each.getTax().setScale(2, 4).stripTrailingZeros());
                }
            });
        }
        contractItemQueryBusiRspBO.setRespCode("0000");
        contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return contractItemQueryBusiRspBO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ContractItemQueryBusiRspBO contractItemQueryTemp(ContractItemQueryBusiReqBO reqBO) {
        ContractInfoPO contract;
        List<ContractOrderPo> contractOrderPos;
        List<ContractInfoItemPO> relPurchasecontractInfoItemPOS;
        List<ContractInfoItemPO> purchaseContractInfoItemPOS;
        ContractItemQueryBusiRspBO contractItemQueryBusiRspBO = new ContractItemQueryBusiRspBO();
        if (reqBO.getContractId() == null) {
            contractItemQueryBusiRspBO.setRespCode("8888");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        ContractInfoItemTmpPO tmpPO = new ContractInfoItemTmpPO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)tmpPO);
        tmpPO.setRelateId(reqBO.getContractId());
        tmpPO.setRelateCode(null);
        Page page = null;
        if (reqBO.getIsWaitOrderQry() != null && reqBO.getIsWaitOrderQry() == 1) {
            ContractItemCanBuyListQryPO seachPO = new ContractItemCanBuyListQryPO();
            seachPO.setContractStatus(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
            seachPO.setContractId(reqBO.getContractId());
            ArrayList<Long> orgIdList = new ArrayList<Long>();
            if (!StringUtils.isEmpty((Object)this.developCompanyDepartment)) {
                if (this.developCompanyDepartment.contains(",")) {
                    String[] split;
                    for (String s : split = this.developCompanyDepartment.split(",")) {
                        try {
                            orgIdList.add(Long.valueOf(s));
                        }
                        catch (Exception e2) {
                            log.error("\u8f6c\u6362\u673a\u6784id\u51fa\u73b0\u5f02\u5e38\uff0c\u673a\u6784id\uff1a" + s);
                        }
                    }
                } else {
                    try {
                        orgIdList.add(Long.valueOf(this.developCompanyDepartment));
                    }
                    catch (Exception e3) {
                        log.error("\u8f6c\u6362\u673a\u6784id\u51fa\u73b0\u5f02\u5e38\uff0c\u673a\u6784id\uff1a" + this.developCompanyDepartment);
                    }
                }
            }
            if (orgIdList.contains(reqBO.getOrgId())) {
                seachPO.setContractTypes(Lists.newArrayList((Object[])new Integer[]{ContractConstant.ContractType.DEVELOPMENT_CONTRACT, ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT}));
                seachPO.setCreateUserId(reqBO.getUserId());
            } else {
                List<String> buyerNos;
                seachPO.setContractType(ContractConstant.ContractType.SALE_CONTRACT);
                seachPO.setAwardEmployeeNumber(reqBO.getOccupation());
                DycUmcQueryBuyerPermissionReqBo dycUmcQueryBuyerPermissionReqBo = new DycUmcQueryBuyerPermissionReqBo();
                dycUmcQueryBuyerPermissionReqBo.setErpCode(reqBO.getOccupation());
                DycUmcQueryBuyerPermissionRspBo dycUmcQueryBuyerPermissionRspBo = this.dycUmcQueryBuyerPermissionService.queryBuyerPermission(dycUmcQueryBuyerPermissionReqBo);
                if (!"0000".equals(dycUmcQueryBuyerPermissionRspBo.getRespCode())) throw new ZTBusinessException(dycUmcQueryBuyerPermissionRspBo.getRespDesc());
                if (!CollectionUtils.isEmpty((Collection)dycUmcQueryBuyerPermissionRspBo.getRows())) {
                    buyerNos = dycUmcQueryBuyerPermissionRspBo.getRows().stream().filter(e -> !StringUtils.isEmpty((Object)e.getOrgCode())).map(e -> e.getOrgCode()).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(buyerNos)) {
                        contractItemQueryBusiRspBO.setRespCode("0000");
                        contractItemQueryBusiRspBO.setRespDesc("\u6ca1\u6709\u4e70\u53d7\u4eba\u6743\u9650");
                        contractItemQueryBusiRspBO.setRows(new ArrayList());
                        return contractItemQueryBusiRspBO;
                    }
                } else {
                    contractItemQueryBusiRspBO.setRespCode("0000");
                    contractItemQueryBusiRspBO.setRespDesc("\u6ca1\u6709\u4e70\u53d7\u4eba\u6743\u9650");
                    contractItemQueryBusiRspBO.setRows(new ArrayList());
                    return contractItemQueryBusiRspBO;
                }
                seachPO.setBuyerNos(buyerNos);
                log.info("\u4e70\u53d7\u4eba" + buyerNos);
                ArrayList<Integer> contractTypes = new ArrayList<Integer>();
                contractTypes.add(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT);
                seachPO.setContractTypes(contractTypes);
                seachPO.setIsDevelopCompanyDepartment(1);
            }
            page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemTmpMapper.selectItemCanBuyList2(seachPO));
        } else {
            page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemTmpMapper.contractItemQuery(tmpPO, reqBO.getContractItemBOList()));
        }
        List contractItemTmpPoList = page.getResult();
        log.info("\u5408\u540c\u660e\u7ec6\u67e5\u8be2" + page.toString());
        contractItemQueryBusiRspBO.setPageNo(page.getPageNum());
        contractItemQueryBusiRspBO.setRecordsTotal(Integer.parseInt(String.valueOf(page.getTotal())));
        contractItemQueryBusiRspBO.setTotal(page.getPages());
        if (!(contractItemTmpPoList != null && contractItemTmpPoList.size() >= 1 || reqBO.getPageSize().equals(-1))) {
            contractItemQueryBusiRspBO.setRespCode("0000");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        List<Long> orderIds = contractItemTmpPoList.stream().map(ContractInfoItemTmpPO::getOrderId).collect(Collectors.toList());
        CContractOrderInfoPO record = new CContractOrderInfoPO();
        if (!CollectionUtils.isEmpty(orderIds)) {
            record.setOrderIds(orderIds);
            List<CContractOrderInfoPO> orderInfoPOS = this.cContractOrderInfoMapper.getList(record);
            if (!CollectionUtils.isEmpty(orderInfoPOS)) {
                List contractItemAbilityBOS = JSONArray.parseArray((String)JSON.toJSONString(orderInfoPOS)).toJavaList(ContractItemAbilityBO.class);
                contractItemQueryBusiRspBO.setRows(contractItemAbilityBOS);
            }
        }
        List<Long> itemIds = contractItemTmpPoList.stream().map(ContractInfoItemTmpPO::getItemId).collect(Collectors.toList());
        List<Long> relateItemIds = contractItemTmpPoList.stream().filter(e -> e.getRelateItemId() != null).map(ContractInfoItemTmpPO::getRelateItemId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(relateItemIds) && !CollectionUtils.isEmpty(purchaseContractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(relateItemIds))) {
            Map<Long, List<ContractInfoItemPO>> relateItemIdMap = purchaseContractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getItemId));
            contractItemTmpPoList.forEach(e -> {
                if (e.getRelateItemId() != null && !CollectionUtils.isEmpty((Collection)((Collection)relateItemIdMap.get(e.getRelateItemId())))) {
                    ContractInfoItemPO contractInfoItemPO = (ContractInfoItemPO)((List)relateItemIdMap.get(e.getRelateItemId())).get(0);
                    e.setPurchaseAmount(contractInfoItemPO.getAmount());
                    e.setPurchaseTaxUnitPrice(contractInfoItemPO.getTaxUnitPrice());
                }
            });
        }
        if (!CollectionUtils.isEmpty(itemIds) && !CollectionUtils.isEmpty(relPurchasecontractInfoItemPOS = this.contractInfoItemMapper.selectRelateListByItemIds(itemIds))) {
            Map<Long, List<ContractInfoItemPO>> relateItemIdMap = relPurchasecontractInfoItemPOS.stream().collect(Collectors.groupingBy(ContractInfoItemPO::getItemId));
            contractItemTmpPoList.forEach(e -> {
                if (!CollectionUtils.isEmpty((Collection)((Collection)relateItemIdMap.get(e.getItemId())))) {
                    ContractInfoItemPO contractInfoItemPO = (ContractInfoItemPO)((List)relateItemIdMap.get(e.getItemId())).get(0);
                    e.setPurchaseAmount(contractInfoItemPO.getAmount());
                    e.setPurchaseTaxUnitPrice(contractInfoItemPO.getTaxUnitPrice());
                }
            });
        }
        CContractInfoItemLogPO seachPO = new CContractInfoItemLogPO();
        seachPO.setRelateId(((ContractInfoItemTmpPO)contractItemTmpPoList.get(0)).getRelateId());
        seachPO.setItemIds(itemIds);
        List<CContractInfoItemLogPO> infoItemLogMapperList = this.cContractInfoItemLogMapper.getList(seachPO);
        if (CollectionUtils.isEmpty(infoItemLogMapperList)) {
            contractItemTmpPoList.forEach(e -> e.setIsUpdateItemStatus(2));
        } else {
            Map<Long, List<CContractInfoItemLogPO>> itemIdLogMap = infoItemLogMapperList.stream().collect(Collectors.groupingBy(CContractInfoItemLogPO::getItemId));
            contractItemTmpPoList.forEach(e -> {
                if (itemIdLogMap.containsKey(e.getItemId())) {
                    e.setIsUpdateItemStatus(1);
                    boolean updateStatus = false;
                    CContractInfoItemLogPO oldItemPO = (CContractInfoItemLogPO)((List)itemIdLogMap.get(e.getItemId())).get(0);
                    CContractInfoItemCompareVO oldVO = new CContractInfoItemCompareVO();
                    BeanUtils.copyProperties((Object)oldItemPO, (Object)oldVO);
                    CContractInfoItemCompareVO newVO = new CContractInfoItemCompareVO();
                    BeanUtils.copyProperties((Object)e, (Object)newVO);
                    Field[] declaredFields2 = oldVO.getClass().getDeclaredFields();
                    Field[] declaredFields23 = newVO.getClass().getDeclaredFields();
                    ArrayList<String> updateFields = new ArrayList<String>();
                    HashMap<String, String> beginUpdateInfo = new HashMap<String, String>();
                    try {
                        for (int i = 0; i < declaredFields2.length; ++i) {
                            declaredFields2[i].setAccessible(true);
                            declaredFields23[i].setAccessible(true);
                            if (declaredFields2[i].get(oldVO) != null && declaredFields23[i].get(newVO) != null) {
                                if (declaredFields2[i].get(oldVO).equals(declaredFields23[i].get(newVO))) continue;
                                updateFields.add(declaredFields2[i].getName());
                                beginUpdateInfo.put(declaredFields2[i].getName(), declaredFields2[i].get(oldVO).toString());
                                continue;
                            }
                            if (declaredFields2[i].get(oldVO) == null && declaredFields23[i].get(newVO) != null) {
                                updateFields.add(declaredFields2[i].getName());
                                beginUpdateInfo.put(declaredFields2[i].getName(), declaredFields2[i].get(oldVO).toString());
                                continue;
                            }
                            if (declaredFields2[i].get(oldVO) == null || declaredFields23[i].get(newVO) != null) continue;
                            updateFields.add(declaredFields2[i].getName());
                            beginUpdateInfo.put(declaredFields2[i].getName(), declaredFields2[i].get(oldVO).toString());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new ZTBusinessException("\u6bd4\u8f83\u53d8\u66f4\u7684\u5185\u5bb9\u5931\u8d25");
                    }
                    if (CollectionUtils.isEmpty(updateFields)) {
                        e.setIsUpdateItemStatus(0);
                    } else {
                        e.setUpdateFields(updateFields);
                        e.setBeginUpdateInfo(beginUpdateInfo);
                    }
                } else {
                    e.setIsUpdateItemStatus(2);
                }
            });
        }
        if (!CollectionUtils.isEmpty(itemIds) && !CollectionUtils.isEmpty(contractOrderPos = this.contractOrderMapper.selectListByItemIds(itemIds))) {
            Map<Long, List<ContractOrderPo>> itemIdMap = contractOrderPos.stream().collect(Collectors.groupingBy(ContractOrderPo::getItemId));
            contractItemTmpPoList.forEach(e -> {
                if (!CollectionUtils.isEmpty((Collection)((Collection)itemIdMap.get(e.getItemId())))) {
                    ContractOrderPo contractOrderPo = (ContractOrderPo)((List)itemIdMap.get(e.getItemId())).get(0);
                    e.setOrderNum(contractOrderPo.getSumDoOrderNum());
                } else {
                    e.setOrderNum(BigDecimal.ZERO);
                }
            });
        }
        if (!CollectionUtils.isEmpty(itemIds) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getAuthToken())) {
            List<ContractInfoItemPO> contractInfoItemPOS;
            Map<Object, Object> itemAmountMap = new HashMap();
            if (!CollectionUtils.isEmpty(itemIds) && !CollectionUtils.isEmpty(contractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(itemIds))) {
                contractInfoItemPOS.stream().forEach(e -> {
                    if (null == e.getAmount()) {
                        e.setAmount(new BigDecimal("0"));
                    }
                });
                itemAmountMap = contractInfoItemPOS.stream().collect(Collectors.toMap(a -> a.getItemId(), b -> b.getAmount(), (first, second) -> first));
            }
            String materialSource = null;
            Long relateId = ((ContractInfoItemTmpPO)contractItemTmpPoList.get(0)).getRelateId();
            ContractInfoPO contractInfoPO = this.contractInfoMapper.selectByPrimaryKey(relateId);
            if (contractInfoPO == null) {
                List<ContractInfoChangePO> contractInfoChangePOS = this.contractInfoChangeMapper.selectByContractId(relateId);
                if (!CollectionUtils.isEmpty(contractInfoChangePOS)) {
                    materialSource = contractInfoChangePOS.get(0).getMaterialSource();
                }
            } else {
                materialSource = contractInfoPO.getMaterialSource();
            }
            ArrayList orderItem = new ArrayList();
            if (!StringUtils.isEmpty((Object)materialSource)) {
                for (ContractInfoItemTmpPO e4 : contractItemTmpPoList) {
                    if (StringUtils.isEmpty((Object)e4.getAwardNumId())) continue;
                    InterFaceContractGetCanOrderNumAtomBO interFaceContractGetCanOrderNumAtomBO = new InterFaceContractGetCanOrderNumAtomBO();
                    interFaceContractGetCanOrderNumAtomBO.setType(Integer.valueOf(materialSource));
                    interFaceContractGetCanOrderNumAtomBO.setQueryType(ObjectUtils.isEmpty((Object)contractInfoPO) ? null : contractInfoPO.getDbType());
                    interFaceContractGetCanOrderNumAtomBO.setGoodTypeId(e4.getAwardNumId());
                    orderItem.add(interFaceContractGetCanOrderNumAtomBO);
                }
            }
            if (!CollectionUtils.isEmpty((Collection)orderItem)) {
                InterFaceContractGetCanOrderNumAtomReqBO interFaceContractGetCanOrderNumAtomReqBO = new InterFaceContractGetCanOrderNumAtomReqBO();
                interFaceContractGetCanOrderNumAtomReqBO.setOrderItem(orderItem);
                interFaceContractGetCanOrderNumAtomReqBO.setToken(reqBO.getAuthToken());
                interFaceContractGetCanOrderNumAtomReqBO.setTypeAmount(0);
                InterFaceContractGetCanOrderNumAtomRspBO interFaceContractGetCanOrderNumAtomRspBO = this.interFaceContractGetCanOrderNumAtomService.getCanOrderNum(interFaceContractGetCanOrderNumAtomReqBO);
                if ("0000".equals(interFaceContractGetCanOrderNumAtomRspBO.getRespCode()) && !CollectionUtils.isEmpty(interFaceContractGetCanOrderNumAtomRspBO.getOrderItem())) {
                    Map<String, BigDecimal> resultAwardNumIdAndCount = interFaceContractGetCanOrderNumAtomRspBO.getOrderItem().stream().collect(Collectors.toMap(a -> a.getGoodTypeId(), b -> b.getOrderNum(), (first, second) -> first));
                    for (ContractInfoItemTmpPO contractInfoItemTmpPO : contractItemTmpPoList) {
                        if (StringUtils.isEmpty((Object)contractInfoItemTmpPO.getAwardNumId()) || !resultAwardNumIdAndCount.containsKey(contractInfoItemTmpPO.getAwardNumId())) continue;
                        BigDecimal amount = (BigDecimal)itemAmountMap.get(contractInfoItemTmpPO.getItemId());
                        if (amount != null) {
                            contractInfoItemTmpPO.setItemNum(resultAwardNumIdAndCount.get(contractInfoItemTmpPO.getAwardNumId()).doubleValue() + amount.doubleValue());
                            continue;
                        }
                        contractInfoItemTmpPO.setItemNum(resultAwardNumIdAndCount.get(contractInfoItemTmpPO.getAwardNumId()).doubleValue());
                    }
                }
            }
        }
        BigDecimal taxAmountTotal = new BigDecimal(0);
        BigDecimal notIncludingTaxAmountTotal = new BigDecimal(0);
        BigDecimal taxTotal = new BigDecimal(0);
        List<ContractInfoItemTmpPO> contractItemTmpPoList1 = this.contractInfoItemTmpMapper.contractItemQuery(tmpPO, reqBO.getContractItemBOList());
        if ((contractItemTmpPoList1 == null || contractItemTmpPoList1.size() < 1) && reqBO.getPageSize().equals(-1)) {
            contractItemQueryBusiRspBO.setRespCode("0000");
            contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return contractItemQueryBusiRspBO;
        }
        for (ContractInfoItemTmpPO po : contractItemTmpPoList1) {
            if (po.getTaxAmount() != null) {
                taxAmountTotal = taxAmountTotal.add(po.getTaxAmount().setScale(2, 4).stripTrailingZeros());
            }
            if (po.getNotIncludingTaxAmount() != null) {
                notIncludingTaxAmountTotal = notIncludingTaxAmountTotal.add(po.getNotIncludingTaxAmount().setScale(2, 4).stripTrailingZeros());
            }
            if (po.getTax() == null) continue;
            taxTotal = taxTotal.add(po.getTax().setScale(2, 4).stripTrailingZeros());
        }
        contractItemQueryBusiRspBO.setTaxAmountTotal(taxAmountTotal);
        contractItemQueryBusiRspBO.setTaxTotal(taxTotal);
        contractItemQueryBusiRspBO.setNotIncludingTaxAmountTotal(notIncludingTaxAmountTotal);
        List<ContractItemAbilityBO> contractItemBusiBOList = !reqBO.getPageSize().equals(-1) ? this.BoTmpParse(contractItemTmpPoList) : this.BoTmpParse(contractItemTmpPoList1);
        this.translate(contractItemBusiBOList);
        if (reqBO.getIsWaitOrderQry() == null || reqBO.getIsWaitOrderQry() != 1) {
            try {
                this.qryPriceCategorie(contractItemBusiBOList);
            }
            catch (Exception e5) {
                throw new ZTBusinessException("\u5bf9\u6bd4\u5355\u4ef7\u67e5\u8be2\u5f02\u5e38" + e5.getMessage());
            }
        }
        if (!CollectionUtils.isEmpty(contractItemBusiBOList)) {
            contractItemBusiBOList.forEach(each -> {
                if (each.getTaxUnitPrice() != null) {
                    each.setTaxUnitPrice(Convert.toBigDecimal((Object)each.getTaxUnitPrice().setScale(8, 4).toPlainString()));
                }
                if (each.getUnitPriceExcludingTax() != null) {
                    each.setUnitPriceExcludingTax(Convert.toBigDecimal((Object)each.getUnitPriceExcludingTax().setScale(8, 4).toPlainString()));
                }
                if (each.getUnitPrice() != null) {
                    each.setUnitPrice(each.getUnitPrice().setScale(8, 4).stripTrailingZeros());
                }
                if (each.getTaxAmount() != null) {
                    each.setTaxAmount(Convert.toBigDecimal((Object)each.getTaxAmount().setScale(2, 4).toPlainString()));
                }
                if (each.getNotIncludingTaxAmount() != null) {
                    each.setNotIncludingTaxAmount(Convert.toBigDecimal((Object)each.getNotIncludingTaxAmount().setScale(2, 4).toPlainString()));
                }
                if (each.getTax() != null) {
                    each.setTax(each.getTax().setScale(2, 4).stripTrailingZeros());
                }
            });
        }
        if ((contract = this.contractInfoMapper.selectByPrimaryKey(reqBO.getContractId())) != null) {
            contractItemQueryBusiRspBO.setAgreementVersion(contract.getAgreementVersion());
        }
        contractItemQueryBusiRspBO.setRows(contractItemBusiBOList);
        contractItemQueryBusiRspBO.setRespCode("0000");
        contractItemQueryBusiRspBO.setRespDesc("\u5408\u540c\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u6210\u529f\uff01");
        return contractItemQueryBusiRspBO;
    }

    public void translate(List<ContractItemAbilityBO> contractItemBusiBOList) {
        for (ContractItemAbilityBO contractItemAbilityBO : contractItemBusiBOList) {
            if (contractItemAbilityBO.getPriceCategories() != null) {
                contractItemAbilityBO.setPriceCategoriesStr(ContractTransFieldUtil.transPriceCategories(contractItemAbilityBO.getPriceCategories()));
            }
            if (contractItemAbilityBO.getFactoryPrice() == null) continue;
            contractItemAbilityBO.setFactoryPriceStr(ContractTransFieldUtil.transFactoryPrice(contractItemAbilityBO.getFactoryPrice()));
        }
    }

    public void qryPriceCategorie(List<ContractItemAbilityBO> contractItemBusiBOList) {
        if (!CollectionUtils.isEmpty(contractItemBusiBOList)) {
            ArrayList<ContractQryComparePriceAbilityQryBO> qryBOS = new ArrayList<ContractQryComparePriceAbilityQryBO>();
            ContractQryComparePriceAbilityReqBO priceAbilityReqBO = new ContractQryComparePriceAbilityReqBO();
            priceAbilityReqBO.setIsChangeQry(Integer.valueOf(1));
            priceAbilityReqBO.setQryBOS(qryBOS);
            for (ContractItemAbilityBO bo : contractItemBusiBOList) {
                ContractQryComparePriceAbilityQryBO qryBO = new ContractQryComparePriceAbilityQryBO();
                if (ContractConstant.PriceCategoriesType.CONTRACT_PRICE.equals(bo.getPriceCategories())) {
                    qryBO.setItemId(bo.getItemId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.DEF_AGR_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (ContractConstant.PriceCategoriesType.AVERAGE_PRICE.equals(bo.getPriceCategories())) {
                    qryBO.setItemId(bo.getItemId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setAwardNumId(bo.getAwardNumId());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.AVERAGE_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (ContractConstant.PriceCategoriesType.COUNTERPARTY_QUOTATION.equals(bo.getPriceCategories())) {
                    qryBO.setItemId(bo.getItemId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setAwardNumId(bo.getAwardNumId());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.QOTP_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (ContractConstant.PriceCategoriesType.BUDGET_PRICE.equals(bo.getPriceCategories())) {
                    qryBO.setItemId(bo.getItemId());
                    qryBO.setMaterialCode(bo.getMaterialCode());
                    qryBO.setAwardNumId(bo.getAwardNumId());
                    qryBO.setPlanItemId(bo.getPlanItemId());
                    qryBO.setQryCategory(ContractConstant.ComparePriceType.BUDGET_PRICE);
                    qryBOS.add(qryBO);
                    continue;
                }
                if (!Objects.equals("\u6307\u5bfc\u4ef7", bo.getPriceCategories())) continue;
                bo.setUnitPrice(BigDecimal.ZERO);
            }
            if (!CollectionUtils.isEmpty(qryBOS)) {
                ContractQryComparePriceAbilityRspBO contractQryComparePriceAbilityRspBO;
                priceAbilityReqBO.setIsBackEndQryItem(Integer.valueOf(1));
                if ("1".equals(this.orderQry) && "0000".equals((contractQryComparePriceAbilityRspBO = this.contractQryComparePriceAbilityService.qryComparePrice(priceAbilityReqBO)).getRespCode()) && !CollectionUtils.isEmpty((Collection)contractQryComparePriceAbilityRspBO.getPriceAbilityBOS())) {
                    Map<Long, BigDecimal> itemIdMap = contractQryComparePriceAbilityRspBO.getPriceAbilityBOS().stream().collect(Collectors.toMap(ContractQryComparePriceAbilityBO::getItemId, ContractQryComparePriceAbilityBO::getPrice));
                    for (ContractItemAbilityBO bo : contractItemBusiBOList) {
                        if (!ContractConstant.PriceCategoriesType.CONTRACT_PRICE.equals(bo.getPriceCategories()) && !ContractConstant.PriceCategoriesType.AVERAGE_PRICE.equals(bo.getPriceCategories()) && !ContractConstant.PriceCategoriesType.COUNTERPARTY_QUOTATION.equals(bo.getPriceCategories()) && !ContractConstant.PriceCategoriesType.BUDGET_PRICE.equals(bo.getPriceCategories()) || !itemIdMap.keySet().contains(bo.getItemId())) continue;
                        bo.setUnitPrice(itemIdMap.get(bo.getItemId()));
                    }
                }
            }
        }
    }

    public List<ContractItemAbilityBO> BoParse(List<ContractInfoItemPO> contractItemPoList) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List<ContractItemAbilityBO> contractItemBusiBOList = contractItemPoList.stream().map(contractPOTemp -> {
            ContractItemAbilityBO contractItemBusiBOTemp = new ContractItemAbilityBO();
            String jsonString = JSON.toJSONString((Object)contractPOTemp);
            contractItemBusiBOTemp = (ContractItemAbilityBO)JSON.parseObject((String)jsonString, ContractItemAbilityBO.class);
            if (contractPOTemp.getNeedArriveTime() != null) {
                contractItemBusiBOTemp.setNeedArriveTime(sdf.format(contractPOTemp.getNeedArriveTime()));
            }
            return contractItemBusiBOTemp;
        }).collect(Collectors.toList());
        return contractItemBusiBOList;
    }

    public List<ContractItemAbilityBO> BoTmpParse(List<ContractInfoItemTmpPO> contractItemPoList) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List<ContractItemAbilityBO> contractItemBusiBOList = contractItemPoList.stream().map(contractPOTemp -> {
            ContractItemAbilityBO contractItemBusiBOTemp = new ContractItemAbilityBO();
            String jsonString = JSON.toJSONString((Object)contractPOTemp);
            contractItemBusiBOTemp = (ContractItemAbilityBO)JSON.parseObject((String)jsonString, ContractItemAbilityBO.class);
            if (contractPOTemp.getNeedArriveTime() != null) {
                contractItemBusiBOTemp.setNeedArriveTime(sdf.format(contractPOTemp.getNeedArriveTime()));
            }
            return contractItemBusiBOTemp;
        }).collect(Collectors.toList());
        return contractItemBusiBOList;
    }
}

