/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.bo.ContractPlanMatchingAgreementItemBO;
import com.tydic.contract.busi.ContractPlanMatchingAgreementItemQryListBusiService;
import com.tydic.contract.busi.bo.ContractPlanMatchingAgreementItemQryListBusiReqBO;
import com.tydic.contract.busi.bo.ContractPlanMatchingAgreementItemQryListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.po.ContractItemCanBuyListQryPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.umc.general.ability.api.UmcEntityOrgBuyerQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcEntityOrgBuyerQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEntityOrgBuyerQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractPlanMatchingAgreementItemQryListBusiServiceImpl
implements ContractPlanMatchingAgreementItemQryListBusiService {
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private UmcEntityOrgBuyerQryAbilityService umcEntityOrgBuyerQryAbilityService;

    @Override
    public ContractPlanMatchingAgreementItemQryListBusiRspBO qryAgreementItemList(ContractPlanMatchingAgreementItemQryListBusiReqBO reqBO) {
        ContractPlanMatchingAgreementItemQryListBusiRspBO rspBO = new ContractPlanMatchingAgreementItemQryListBusiRspBO();
        UmcEntityOrgBuyerQryAbilityReqBO umcEntityOrgBuyerQryAbilityReqBO = new UmcEntityOrgBuyerQryAbilityReqBO();
        umcEntityOrgBuyerQryAbilityReqBO.setErpOrgCode(reqBO.getErpOrgId());
        UmcEntityOrgBuyerQryAbilityRspBO umcEntityOrgBuyerQryAbilityRspBO = this.umcEntityOrgBuyerQryAbilityService.qryBuyer(umcEntityOrgBuyerQryAbilityReqBO);
        if ("0000".equals(umcEntityOrgBuyerQryAbilityRspBO.getRespCode())) {
            if (CollectionUtils.isEmpty((Collection)umcEntityOrgBuyerQryAbilityRspBO.getOrgCodes())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u5e93\u5b58\u7ec4\u7ec7\u67e5\u8be2\u4e70\u53d7\u4eba\u4e3a\u7a7a!");
                rspBO.setRows(null);
                rspBO.setPageNo(1);
                rspBO.setTotal(0);
                rspBO.setRecordsTotal(0);
                return rspBO;
            }
            List codes = umcEntityOrgBuyerQryAbilityRspBO.getOrgCodes();
            ContractItemCanBuyListQryPO qryPO = new ContractItemCanBuyListQryPO();
            qryPO.setMaterialCode(reqBO.getMaterialCode());
            ArrayList<Integer> contractTypes = new ArrayList<Integer>();
            contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
            contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
            qryPO.setContractTypes(contractTypes);
            qryPO.setBuyerNos(codes);
            qryPO.setSearchDate(new Date());
            qryPO.setVendorStatus(1);
            qryPO.setIsJy(0);
            Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoItemMapper.qryItemByErpOrgCode(qryPO));
            List result = page.getResult();
            List itemBOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)result)).toJavaList(ContractPlanMatchingAgreementItemBO.class);
            for (ContractPlanMatchingAgreementItemBO itemBO : itemBOList) {
                if (itemBO.getContractStatus() != null) {
                    itemBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(itemBO.getContractStatus()));
                }
                if (itemBO.getAmount() == null) {
                    itemBO.setAmount(BigDecimal.ZERO);
                }
                if (itemBO.getOrderNum() != null) continue;
                itemBO.setOrderNum(BigDecimal.ZERO);
            }
            rspBO.setRows(itemBOList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u6210\u529f");
            rspBO.setPageNo(page.getPageNum());
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
            return rspBO;
        }
        throw new ZTBusinessException("\u5e93\u5b58\u7ec4\u7ec7\u67e5\u8be2\u4e70\u53d7\u4eba\u5931\u8d25" + umcEntityOrgBuyerQryAbilityRspBO.getRespDesc());
    }
}

