/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.contract.ability.bo.ContractListBO;
import com.tydic.contract.busi.ContractQryListBusiService;
import com.tydic.contract.busi.bo.ContractQryListBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryListBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractMapper;
import com.tydic.contract.po.ContractPo;
import com.tydic.contract.po.OrderContractPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractQryListBusiServiceImpl
implements ContractQryListBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryListBusiServiceImpl.class);
    @Autowired
    private ContractMapper contractMapper;

    @Override
    public ContractQryListBusiRspBO qryContractList(ContractQryListBusiReqBO reqBO) {
        ContractQryListBusiRspBO rspBO = new ContractQryListBusiRspBO();
        if (reqBO.getContractType().equals(ContractConstant.ContractType.ORDER_CONTRACT_TYPE)) {
            OrderContractPo queryOrderContractPo = new OrderContractPo();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryOrderContractPo);
            queryOrderContractPo.setContractSignDateEnd(DateTimeUtils.Date2String(queryOrderContractPo.getContractSignDateEnd()));
            queryOrderContractPo.setContractSignDateStart(DateTimeUtils.Date2String(queryOrderContractPo.getContractSignDateStart()));
            queryOrderContractPo.setNeedArriveTimeStart(DateTimeUtils.Date2String(queryOrderContractPo.getNeedArriveTimeStart()));
            queryOrderContractPo.setNeedArriveTimeEnd(DateTimeUtils.Date2String(queryOrderContractPo.getNeedArriveTimeEnd()));
            if (queryOrderContractPo.getContractAmountMax() != null) {
                queryOrderContractPo.setContractAmountMax(queryOrderContractPo.getContractAmountMax() * 10000L);
            }
            if (queryOrderContractPo.getContractAmountMin() != null) {
                queryOrderContractPo.setContractAmountMin(queryOrderContractPo.getContractAmountMin() * 10000L);
            }
            log.info("\u5408\u540c\u5f00\u59cb\u65f6\u95f4\uff1a" + queryOrderContractPo.getContractSignDateStart() + "\u7ed3\u675f\u65f6\u95f4\uff1a" + queryOrderContractPo.getContractSignDateEnd());
            log.info("\u5408\u540c\u8981\u6c42\u5230\u8d27\u65e5\u671f\u5f00\u59cb\uff1a" + queryOrderContractPo.getNeedArriveTimeStart() + "\u5408\u540c\u8981\u6c42\u5230\u8d27\u65e5\u671f\u7ed3\u675f\uff1a" + queryOrderContractPo.getNeedArriveTimeEnd());
            Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractMapper.qryByConditionForOrder(queryOrderContractPo));
            List<ContractListBO> rows = this.transOrderContractResult(page.getResult());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u5217\u8868\u67e5\u8be2\u6210\u529f");
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNum());
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
            return rspBO;
        }
        if (reqBO.getContractType().equals(ContractConstant.ContractType.UNIT_AGREE_CONTRACT_TYPE) || reqBO.getContractType().equals(ContractConstant.ContractType.PLATFORM_AGREE_CONTRACT_TYPE) || reqBO.getContractType().equals(ContractConstant.ContractType.ENTER_CONTRACT_TYPE)) {
            ContractPo queryAgrContractPo = new ContractPo();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)queryAgrContractPo);
            queryAgrContractPo.setContractSignDateEnd(DateTimeUtils.Date2String(queryAgrContractPo.getContractSignDateEnd()));
            queryAgrContractPo.setContractSignDateStart(DateTimeUtils.Date2String(queryAgrContractPo.getContractSignDateStart()));
            queryAgrContractPo.setContractEndDateEnd(DateTimeUtils.Date2String(queryAgrContractPo.getContractEndDateEnd()));
            Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractMapper.qryByCondition(queryAgrContractPo));
            List<ContractListBO> rows = this.transAgrAndEnterContractResult(page.getResult());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5408\u540c\u5217\u8868\u67e5\u8be2\u6210\u529f");
            rspBO.setRows(rows);
            rspBO.setPageNo(page.getPageNum());
            rspBO.setTotal(page.getPages());
            rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
            return rspBO;
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc("\u5408\u540c\u7c7b\u578b\u5165\u53c2\u5f02\u5e38");
        return rspBO;
    }

    private List<ContractListBO> transAgrAndEnterContractResult(List<ContractPo> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractListBO.class);
        for (ContractListBO contractListBO : rows) {
            contractListBO.setContractSignDate(DateTimeUtils.Time2Date(contractListBO.getContractSignDate()));
            contractListBO.setNeedArriveTime(DateTimeUtils.Time2Date(contractListBO.getNeedArriveTime()));
            contractListBO.setContractEndDate(DateTimeUtils.Time2Date(contractListBO.getContractEndDate()));
            if (contractListBO.getContractStatus() != null) {
                contractListBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
            }
            if (contractListBO.getContractType() != null) {
                contractListBO.setContractTypeStr(ContractTransFieldUtil.transContractType(contractListBO.getContractType()));
            }
            if (contractListBO.getPayType() != null) {
                contractListBO.setPayTypeStr(ContractTransFieldUtil.transPayType(contractListBO.getPayType()));
            }
            if (contractListBO.getExpectSettle() != null) {
                contractListBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(contractListBO.getExpectSettle()));
            }
            if (contractListBO.getSsBusiWay() != null) {
                contractListBO.setSsBusiWayStr(ContractTransFieldUtil.transSsBusiWay(contractListBO.getSsBusiWay()));
            }
            if (contractListBO.getOrgType() != null) {
                contractListBO.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(contractListBO.getOrgType()));
            }
            try {
                contractListBO.setContractAmountMoney(MoneyUtils.Long2BigDecimal((Long)contractListBO.getContractAmount()));
            }
            catch (Exception e) {
                log.error("\u91d1\u94b1\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        return rows;
    }

    private List<ContractListBO> transOrderContractResult(List<OrderContractPo> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractListBO.class);
        for (ContractListBO contractListBO : rows) {
            contractListBO.setContractSignDate(DateTimeUtils.Time2Date(contractListBO.getContractSignDate()));
            contractListBO.setNeedArriveTime(DateTimeUtils.Time2Date(contractListBO.getNeedArriveTime()));
            contractListBO.setContractEndDate(DateTimeUtils.Time2Date(contractListBO.getContractEndDate()));
            if (contractListBO.getContractStatus() != null) {
                contractListBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListBO.getContractStatus()));
            }
            if (contractListBO.getOrderSource() != null) {
                contractListBO.setOrderSourceStr(ContractTransFieldUtil.transOrderSource(contractListBO.getOrderSource()));
            }
            if (contractListBO.getPayType() != null) {
                contractListBO.setPayTypeStr(ContractTransFieldUtil.transPayType(contractListBO.getPayType()));
            }
            if (contractListBO.getExpectSettle() != null) {
                contractListBO.setExpectSettleStr(ContractTransFieldUtil.transExpectSettle(contractListBO.getExpectSettle()));
            }
            if (contractListBO.getContractType() != null) {
                contractListBO.setContractTypeStr(ContractTransFieldUtil.transContractType(contractListBO.getContractType()));
            }
            if (contractListBO.getSupplierType() != null) {
                contractListBO.setSupplierTypeStr(ContractTransFieldUtil.transSupplierType(contractListBO.getSupplierType()));
            }
            if (contractListBO.getOrgType() != null) {
                contractListBO.setOrgTypeStr(ContractTransFieldUtil.transContractOrgType(contractListBO.getOrgType()));
            }
            try {
                contractListBO.setContractAmountMoney(MoneyUtils.Long2BigDecimal((Long)contractListBO.getContractAmount()));
            }
            catch (Exception e) {
                log.error("\u91d1\u94b1\u8f6c\u6362\u51fa\u9519\uff1a" + e.getMessage());
            }
        }
        return rows;
    }
}

