/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.bo.ContractTemplateApplyOrgInfoBO;
import com.tydic.contract.ability.bo.ContractTemplateTermParamBo;
import com.tydic.contract.ability.bo.ContractTermsInfoBO;
import com.tydic.contract.busi.QueryContractTemplateDetailsBusiService;
import com.tydic.contract.busi.bo.QueryContractTemplateDetailsBusiReqBO;
import com.tydic.contract.busi.bo.QueryContractTemplateDetailsBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractTemplateTermParamItemMapper;
import com.tydic.contract.dao.CContractTemplateTermParamMapper;
import com.tydic.contract.dao.ContractTemplateApplyUnitMapper;
import com.tydic.contract.dao.ContractTemplateMapper;
import com.tydic.contract.dao.ContractTermsMapper;
import com.tydic.contract.po.CContractTemplateTermParamItemPO;
import com.tydic.contract.po.CContractTemplateTermParamPO;
import com.tydic.contract.po.ContractTemplateApplyUnitPo;
import com.tydic.contract.po.ContractTemplatePo;
import com.tydic.contract.po.ContractTermsPo;
import com.tydic.contract.utils.ContractTransFieldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryContractTemplateDetailsBusiServiceImpl
implements QueryContractTemplateDetailsBusiService {
    @Autowired
    private ContractTemplateMapper contractTemplateMapper;
    @Autowired
    private ContractTemplateApplyUnitMapper contractTemplateApplyUnitMapper;
    @Autowired
    private CContractTemplateTermParamMapper contractTemplateTermParamMapper;
    @Autowired
    private ContractTermsMapper contractTermsMapper;
    @Autowired
    private CContractTemplateTermParamItemMapper contractTemplateTermParamItemMapper;

    @Override
    public QueryContractTemplateDetailsBusiRspBO queryContractTemplateDetails(QueryContractTemplateDetailsBusiReqBO reqBO) {
        QueryContractTemplateDetailsBusiRspBO rspBO = new QueryContractTemplateDetailsBusiRspBO();
        ContractTemplatePo contractTemplatePo = this.contractTemplateMapper.selectByPrimaryKey(reqBO.getTemplateId());
        if (contractTemplatePo != null) {
            rspBO = (QueryContractTemplateDetailsBusiRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)contractTemplatePo), QueryContractTemplateDetailsBusiRspBO.class));
            if (StringUtils.isNotEmpty((CharSequence)rspBO.getOrgType())) {
                rspBO.setOrgTypeStr(ContractTransFieldUtil.transOrgType(rspBO.getOrgType()));
            }
            if (rspBO.getTemplateType() != null) {
                rspBO.setTemplateTypeStr(ContractTransFieldUtil.transTemplateType(rspBO.getTemplateType()));
            }
            if (rspBO.getPurpose() != null) {
                rspBO.setPurposeStr(ContractTransFieldUtil.transContractTemplatePurpose(rspBO.getPurpose()));
            }
            if (rspBO.getPertainLevel() != null) {
                rspBO.setPertainLevelStr(ContractConstant.PertainLevelEnum.getValueByCode(rspBO.getPertainLevel()));
            }
            if (rspBO.getPertainBusinessCategory() != null) {
                if (rspBO.getPertainLevel() != null && rspBO.getPertainLevel().equals(2)) {
                    rspBO.setPertainBusinessCategoryStr(ContractConstant.PertainLevelByEnterpriseEnum.getValueByCode(rspBO.getPertainBusinessCategory()));
                } else {
                    rspBO.setPertainBusinessCategoryStr(ContractConstant.ContractModelBusinessCategoryEnum.getValueByCode(rspBO.getPertainBusinessCategory()));
                }
            }
            ContractTemplateApplyUnitPo po = new ContractTemplateApplyUnitPo();
            po.setTemplateCode(contractTemplatePo.getTemplateCode());
            List<ContractTemplateApplyUnitPo> templateApplyUnitPos = this.contractTemplateApplyUnitMapper.qryByCondition(po);
            if (!CollectionUtils.isEmpty(templateApplyUnitPos)) {
                List applyOrgInfoBOS = JSONObject.parseArray((String)JSONObject.toJSONString(templateApplyUnitPos)).toJavaList(ContractTemplateApplyOrgInfoBO.class);
                rspBO.setOrgInfos(applyOrgInfoBOS);
            }
            CContractTemplateTermParamPO termParamPo = new CContractTemplateTermParamPO();
            termParamPo.setTemplateId(contractTemplatePo.getTemplateId());
            List<CContractTemplateTermParamPO> termParamPOS = this.contractTemplateTermParamMapper.getList(termParamPo);
            if (!CollectionUtils.isEmpty(termParamPOS)) {
                List<ContractTemplateTermParamBo> termParamBos = termParamPOS.stream().map(e -> {
                    ContractTemplateTermParamBo paramBo = new ContractTemplateTermParamBo();
                    BeanUtils.copyProperties((Object)e, (Object)paramBo);
                    CContractTemplateTermParamItemPO itemPo = new CContractTemplateTermParamItemPO();
                    itemPo.setTemplateTermParamId(e.getTemplateTermParamId());
                    List<CContractTemplateTermParamItemPO> list = this.contractTemplateTermParamItemMapper.getList(itemPo);
                    if (!CollectionUtils.isEmpty(list)) {
                        List collect = list.stream().map(CContractTemplateTermParamItemPO::getTermId).collect(Collectors.toList());
                        paramBo.setTermIds(collect);
                    }
                    if (!CollectionUtils.isEmpty(list) && list.size() == 1) {
                        paramBo.setTermsInfoBOS(this.qryTremsInfo(list.get(0).getTermId()));
                    }
                    return paramBo;
                }).collect(Collectors.toList());
                rspBO.setTermParamInfo(termParamBos);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u6a21\u677f\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        return rspBO;
    }

    public List<ContractTermsInfoBO> qryTremsInfo(Long termId) {
        ArrayList<Long> termIds = new ArrayList<Long>();
        termIds.add(termId);
        List<ContractTermsPo> contractTermsPos = this.contractTermsMapper.qryListByTermIds(termIds);
        if (!CollectionUtils.isEmpty(contractTermsPos)) {
            String resultJsonStr = JSON.toJSONString(contractTermsPos);
            List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractTermsInfoBO.class);
            return rows;
        }
        return null;
    }
}

