/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl.finance;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.finance.ContractSyncSettlementItemBO;
import com.tydic.contract.ability.enums.ContractObjectTypeEnum;
import com.tydic.contract.busi.bo.finance.ContractSyncSettlementBusiReqBO;
import com.tydic.contract.busi.bo.finance.ContractSyncSettlementBusiRspBO;
import com.tydic.contract.busi.finance.ContractSyncSettlementBusiService;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.CContractRelInfoMapper;
import com.tydic.contract.dao.CContractRelItemMapper;
import com.tydic.contract.dao.ContractSettlementDetailMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.CContractRelInfoPO;
import com.tydic.contract.po.CContractRelItemPO;
import com.tydic.contract.po.ContractSettlementDetailPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ContractSyncSettlementBusiServiceImpl
implements ContractSyncSettlementBusiService {
    @Resource
    private CContractInfoExtMapper cContractInfoExtMapper;
    @Resource
    private CContractRelInfoMapper cContractRelInfoMapper;
    @Resource
    private CContractRelItemMapper cContractRelItemMapper;
    @Resource
    private ContractSettlementDetailMapper contractSettlementDetailMapper;

    @Override
    public ContractSyncSettlementBusiRspBO modifySettlement(ContractSyncSettlementBusiReqBO reqBO) {
        Set<Object> addContractIds = new HashSet();
        Set<Object> deleteContractIds = new HashSet();
        if (!CollectionUtils.isEmpty(reqBO.getAddList())) {
            CContractRelInfoPO contractRelInfoPO = new CContractRelInfoPO();
            contractRelInfoPO.setObjectId(reqBO.getObjectId());
            List<CContractRelInfoPO> contractRelInfos = this.cContractRelInfoMapper.getList(contractRelInfoPO);
            if (!CollectionUtils.isEmpty(contractRelInfos)) {
                throw new ZTBusinessException("\u5b58\u5728\u91cd\u590d\u5360\u7528\u5408\u540c\uff0c\u5355\u636eID\uff1a" + reqBO.getObjectId());
            }
            addContractIds = reqBO.getAddList().stream().map(ContractSyncSettlementItemBO::getContractId).collect(Collectors.toSet());
            ArrayList<CContractRelInfoPO> contractRelInfoPOList = new ArrayList<CContractRelInfoPO>();
            ArrayList<CContractRelItemPO> relItemPOList = new ArrayList<CContractRelItemPO>();
            addContractIds.forEach(e -> {
                CContractRelInfoPO cContractRelInfoPO = new CContractRelInfoPO();
                cContractRelInfoPO.setId(Sequence.getInstance().nextId());
                cContractRelInfoPO.setContractId((Long)e);
                cContractRelInfoPO.setObjectId(reqBO.getObjectId());
                cContractRelInfoPO.setObjectType(reqBO.getObjectType());
                cContractRelInfoPO.setCreateUserId(reqBO.getUserId());
                cContractRelInfoPO.setCreateTime(new Date());
                contractRelInfoPOList.add(cContractRelInfoPO);
            });
            Map<Long, Long> relInfoMap = contractRelInfoPOList.stream().collect(Collectors.toMap(CContractRelInfoPO::getContractId, CContractRelInfoPO::getId, (k1, k2) -> k1));
            reqBO.getAddList().forEach(item -> {
                CContractRelItemPO contractRelItemPO = (CContractRelItemPO)JSON.parseObject((String)JSON.toJSONString((Object)item), CContractRelItemPO.class);
                contractRelItemPO.setId(Sequence.getInstance().nextId());
                contractRelItemPO.setObjectId(reqBO.getObjectId());
                if (!CollectionUtils.isEmpty((Map)relInfoMap) && relInfoMap.containsKey(item.getContractId())) {
                    contractRelItemPO.setRelId((Long)relInfoMap.get(item.getContractId()));
                }
                relItemPOList.add(contractRelItemPO);
            });
            if (!CollectionUtils.isEmpty(contractRelInfoPOList)) {
                this.cContractRelInfoMapper.insertBatch(contractRelInfoPOList);
            }
            if (!CollectionUtils.isEmpty(relItemPOList)) {
                this.cContractRelItemMapper.insertBatch(relItemPOList);
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getDeleteList())) {
            deleteContractIds = reqBO.getDeleteList().stream().map(ContractSyncSettlementItemBO::getContractId).collect(Collectors.toSet());
            CContractRelInfoPO cContractRelInfoPO = new CContractRelInfoPO();
            cContractRelInfoPO.setObjectId(reqBO.getObjectId());
            this.cContractRelInfoMapper.deleteByCondition(cContractRelInfoPO);
            CContractRelItemPO contractRelItemPO = new CContractRelItemPO();
            contractRelItemPO.setObjectId(reqBO.getObjectId());
            this.cContractRelItemMapper.deleteByCondition(contractRelItemPO);
        }
        HashSet<Long> contractIds = new HashSet<Long>();
        contractIds.addAll(addContractIds);
        contractIds.addAll(deleteContractIds);
        CContractInfoExtPO cContractInfoExtPO = new CContractInfoExtPO();
        cContractInfoExtPO.setRelateIds(new ArrayList<Long>(contractIds));
        List<CContractInfoExtPO> contractInfoExtPOList = this.cContractInfoExtMapper.qrySettleAmt(cContractInfoExtPO);
        if (CollectionUtils.isEmpty(contractInfoExtPOList) || contractInfoExtPOList.size() != addContractIds.size() && contractInfoExtPOList.size() != deleteContractIds.size()) {
            throw new ZTBusinessException("\u5b58\u5728\u65e0\u6548\u7684\u5408\u540cid!");
        }
        List<CContractInfoExtPO> cContractInfoExtPOList = this.handleSettleInfo(reqBO, contractInfoExtPOList, contractIds);
        if (!CollectionUtils.isEmpty(cContractInfoExtPOList)) {
            this.cContractInfoExtMapper.updateBatch(cContractInfoExtPOList);
        }
        ContractSyncSettlementBusiRspBO rspBO = new ContractSyncSettlementBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<CContractInfoExtPO> handleSettleInfo(ContractSyncSettlementBusiReqBO reqBO, List<CContractInfoExtPO> contractInfoExtPOList, Set<Long> contractIds) {
        ArrayList<CContractInfoExtPO> cContractInfoExtPOList = new ArrayList<CContractInfoExtPO>();
        Map contractInfoExtPOMap = contractInfoExtPOList.stream().collect(Collectors.toMap(CContractInfoExtPO::getRelateId, Function.identity(), (k1, k2) -> k1));
        if (ContractObjectTypeEnum.PRE_PAY.getCode().equals(reqBO.getObjectType())) {
            if (!CollectionUtils.isEmpty(reqBO.getAddList())) {
                List<Long> ids = reqBO.getAddList().stream().map(ContractSyncSettlementItemBO::getPayDetailId).collect(Collectors.toList());
                ContractSettlementDetailPO contractSettlementDetailPO = new ContractSettlementDetailPO();
                contractSettlementDetailPO.setIds(ids);
                contractSettlementDetailPO.setMoneyType(ContractConstant.MoneyType.PRE_PAY_CODE);
                List<ContractSettlementDetailPO> settlementDetailPOList = this.contractSettlementDetailMapper.getPrePercentByList(contractSettlementDetailPO);
                if (CollectionUtils.isEmpty(settlementDetailPOList) || settlementDetailPOList.size() != contractIds.size()) {
                    throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u9884\u4ed8\u6b3e\u652f\u4ed8\u8282\u70b9\u4fe1\u606f,\u4e0d\u5141\u8bb8\u53d1\u8d77\u9884\u4ed8\u6b3e!");
                }
                Map<Long, BigDecimal> settlementDetailMap = settlementDetailPOList.stream().collect(Collectors.toMap(ContractSettlementDetailPO::getRelateId, ContractSettlementDetailPO::getPayPercent, (k1, k2) -> k1));
                reqBO.getAddList().forEach(e -> {
                    if (CollectionUtils.isEmpty((Map)contractInfoExtPOMap) || !contractInfoExtPOMap.containsKey(e.getContractId())) {
                        throw new ZTBusinessException("\u5b58\u5728\u65e0\u6548\u7684\u5408\u540cid!");
                    }
                    if (CollectionUtils.isEmpty((Map)settlementDetailMap) || !settlementDetailMap.containsKey(e.getContractId())) {
                        throw new ZTBusinessException("\u5b58\u5728\u5408\u540c\u672a\u67e5\u8be2\u5230\u9884\u4ed8\u6b3e\u652f\u4ed8\u8282\u70b9\u4fe1\u606f,\u4e0d\u5141\u8bb8\u53d1\u8d77\u9884\u4ed8\u6b3e\uff0c \u5408\u540cID\uff1a" + e.getContractId());
                    }
                    CContractInfoExtPO contractInfoExtPO = (CContractInfoExtPO)contractInfoExtPOMap.get(e.getContractId());
                    BigDecimal preAmt = contractInfoExtPO.getContractAmount().multiply(((BigDecimal)settlementDetailMap.get(e.getContractId())).divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
                    contractInfoExtPO.setRelateId(e.getContractId());
                    contractInfoExtPO.setTotalLeavePaidPreAmt(Objects.isNull(contractInfoExtPO.getTotalLeavePaidPreAmt()) ? preAmt.subtract(e.getAmt()) : contractInfoExtPO.getTotalLeavePaidPreAmt().subtract(e.getAmt()));
                    contractInfoExtPO.setTotalPaidPreAmt(Objects.isNull(contractInfoExtPO.getTotalPaidPreAmt()) ? e.getAmt() : contractInfoExtPO.getTotalPaidPreAmt().add(e.getAmt()));
                    if (contractInfoExtPO.getTotalLeavePaidPreAmt().compareTo(BigDecimal.ZERO) < 0) {
                        throw new ZTBusinessException("\u5408\u540c\u5269\u4f59\u9884\u4ed8\u6b3e\u91d1\u989d\u4e0d\u8db3\uff0c\u5408\u540cID:" + e.getContractId());
                    }
                    cContractInfoExtPOList.add(contractInfoExtPO);
                });
            }
            if (!CollectionUtils.isEmpty(reqBO.getDeleteList())) {
                reqBO.getDeleteList().forEach(e -> {
                    if (CollectionUtils.isEmpty((Map)contractInfoExtPOMap) || !contractInfoExtPOMap.containsKey(e.getContractId())) {
                        throw new ZTBusinessException("\u5b58\u5728\u65e0\u6548\u7684\u5408\u540cid!");
                    }
                    CContractInfoExtPO contractInfoExtPO = (CContractInfoExtPO)contractInfoExtPOMap.get(e.getContractId());
                    if (Objects.isNull(contractInfoExtPO.getTotalPaidPreAmt()) || Objects.isNull(contractInfoExtPO.getTotalLeavePaidPreAmt()) || contractInfoExtPO.getTotalPaidPreAmt().compareTo(e.getAmt()) < 0) {
                        throw new ZTBusinessException("\u5408\u540c\u5df2\u5f00\u7968\u91d1\u989d\u4e0d\u8db3\uff0c\u5408\u540cID:" + e.getContractId());
                    }
                    contractInfoExtPO.setRelateId(e.getContractId());
                    contractInfoExtPO.setTotalLeavePaidPreAmt(contractInfoExtPO.getTotalLeavePaidPreAmt().add(e.getAmt()));
                    contractInfoExtPO.setTotalPaidPreAmt(contractInfoExtPO.getTotalPaidPreAmt().subtract(e.getAmt()));
                    cContractInfoExtPOList.add(contractInfoExtPO);
                });
            }
        } else {
            if (!CollectionUtils.isEmpty(reqBO.getAddList())) {
                reqBO.getAddList().forEach(e -> {
                    if (CollectionUtils.isEmpty((Map)contractInfoExtPOMap) || !contractInfoExtPOMap.containsKey(e.getContractId())) {
                        throw new ZTBusinessException("\u5b58\u5728\u65e0\u6548\u7684\u5408\u540cid!");
                    }
                    CContractInfoExtPO contractInfoExtPO = (CContractInfoExtPO)contractInfoExtPOMap.get(e.getContractId());
                    contractInfoExtPO.setRelateId(e.getContractId());
                    contractInfoExtPO.setTotalInvoicedAmt(Objects.isNull(contractInfoExtPO.getTotalInvoicedAmt()) ? e.getAmt() : contractInfoExtPO.getTotalInvoicedAmt().add(e.getAmt()));
                    contractInfoExtPO.setTotalLeaveInvoiceAmt(Objects.isNull(contractInfoExtPO.getTotalLeaveInvoiceAmt()) ? contractInfoExtPO.getContractAmount().subtract(e.getAmt()) : contractInfoExtPO.getTotalLeaveInvoiceAmt().subtract(e.getAmt()));
                    if (contractInfoExtPO.getTotalLeaveInvoiceAmt().compareTo(BigDecimal.ZERO) < 0) {
                        throw new ZTBusinessException("\u5408\u540c\u5269\u4f59\u5f00\u7968\u91d1\u989d\u4e0d\u8db3\uff0c\u5408\u540cID:" + e.getContractId());
                    }
                    cContractInfoExtPOList.add(contractInfoExtPO);
                });
            }
            if (!CollectionUtils.isEmpty(reqBO.getDeleteList())) {
                reqBO.getDeleteList().forEach(e -> {
                    if (CollectionUtils.isEmpty((Map)contractInfoExtPOMap) || !contractInfoExtPOMap.containsKey(e.getContractId())) {
                        throw new ZTBusinessException("\u5b58\u5728\u65e0\u6548\u7684\u5408\u540cid!");
                    }
                    CContractInfoExtPO contractInfoExtPO = (CContractInfoExtPO)contractInfoExtPOMap.get(e.getContractId());
                    if (Objects.isNull(contractInfoExtPO.getTotalInvoicedAmt()) || Objects.isNull(contractInfoExtPO.getTotalLeaveInvoiceAmt()) || contractInfoExtPO.getTotalInvoicedAmt().compareTo(e.getAmt()) < 0) {
                        throw new ZTBusinessException("\u5408\u540c\u5df2\u5f00\u7968\u91d1\u989d\u4e0d\u8db3\uff0c\u5408\u540cID:" + e.getContractId());
                    }
                    contractInfoExtPO.setRelateId(e.getContractId());
                    contractInfoExtPO.setTotalInvoicedAmt(contractInfoExtPO.getTotalInvoicedAmt().subtract(e.getAmt()));
                    contractInfoExtPO.setTotalLeaveInvoiceAmt(contractInfoExtPO.getTotalLeaveInvoiceAmt().add(e.getAmt()));
                    cContractInfoExtPOList.add(contractInfoExtPO);
                });
            }
        }
        return cContractInfoExtPOList;
    }
}

