/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.utils;

import com.tydic.contract.constant.ContractConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class ContractTransFieldUtil {
    public static BigDecimal transContractAmount(Long contractAmount) {
        return new BigDecimal(contractAmount).divide(new BigDecimal("10000"), 2, RoundingMode.HALF_UP);
    }

    public static BigDecimal transUnitPrice(Long unitPrice) {
        return new BigDecimal(unitPrice / 10000L);
    }

    public static BigDecimal transTotalAmount(Long totalAmount) {
        return new BigDecimal(totalAmount / 10000L);
    }

    public static String transServiceFeeType(Integer serviceFeeType) {
        if (serviceFeeType.equals(ContractConstant.ServiceFeeType.SERVICE_FEE_TYPE_MONTHLY)) {
            return "\u6708\u7ed3";
        }
        if (serviceFeeType.equals(ContractConstant.ServiceFeeType.SERVICE_FEE_TYPE_REAL_TIME)) {
            return "\u5b9e\u65f6\u6263\u9664";
        }
        return "\u9519\u8bef\u7684\u6210\u4ea4\u670d\u52a1\u8d39\u7ed3\u7b97\u65b9\u5f0f";
    }

    public static String transTermType(Integer termType) {
        if (termType.equals(ContractConstant.TermType.TERM_TYPE_AGREE_CODE)) {
            return "\u534f\u8bae\u5408\u540c";
        }
        if (termType.equals(ContractConstant.TermType.TERM_TYPE_ENTRY_CODE)) {
            return "\u5165\u9a7b\u5408\u540c";
        }
        if (termType.equals(ContractConstant.TermType.TERM_TYPE_ORDER_CODE)) {
            return "\u8ba2\u5355\u5408\u540c";
        }
        return "\u9519\u8bef\u7684\u6761\u6b3e\u7c7b\u578b";
    }

    public static String transTemplateType(Integer templateType) {
        if (templateType.equals(ContractConstant.TemplateType.TERM_TYPE_AGREE_CODE)) {
            return "\u534f\u8bae\u5408\u540c";
        }
        if (templateType.equals(ContractConstant.TemplateType.TERM_TYPE_ENTRY_CODE)) {
            return "\u5165\u9a7b\u5408\u540c";
        }
        if (templateType.equals(ContractConstant.TemplateType.TERM_TYPE_ORDER_CODE)) {
            return "\u8ba2\u5355\u5408\u540c";
        }
        return "\u9519\u8bef\u7684\u6a21\u677f\u7c7b\u578b";
    }

    public static String transChargeLadderRateFee(Integer chargeLadderRateFee) {
        if (chargeLadderRateFee.equals(ContractConstant.ChargeLadderRateFee.NO_CODE)) {
            return "\u4e0d\u6536\u53d6";
        }
        if (chargeLadderRateFee.equals(ContractConstant.ChargeLadderRateFee.YES_CODE)) {
            return "\u6536\u53d6";
        }
        return "\u9519\u8bef\u7684\u662f\u5426\u6536\u53d6\u5e74\u7ec8\u9636\u68af\u8d39\u7387\u670d\u52a1\u8d39";
    }

    public static String transChargeSaleCategoryFeeNode(Integer chargeSaleCategoryFeeNode) {
        if (chargeSaleCategoryFeeNode.equals(ContractConstant.ChargeSaleCategoryFeeNode.ORDER_COLLECTION_CODE)) {
            return "\u4e0b\u5355\u6536\u53d6";
        }
        if (chargeSaleCategoryFeeNode.equals(ContractConstant.ChargeSaleCategoryFeeNode.REMITTANCE_COLLECTION_CODE)) {
            return "\u6c47\u6b3e\u6536\u53d6";
        }
        return "\u9519\u8bef\u7684\u9500\u552e\u54c1\u7c7b\u670d\u52a1\u8d39\u6536\u53d6\u8282\u70b9";
    }

    public static String transChargeSaleCategoryFee(Integer chargeSaleCategoryFee) {
        if (chargeSaleCategoryFee.equals(ContractConstant.ChargeSaleCategoryFee.NO_CODE)) {
            return "\u4e0d\u6536\u53d6";
        }
        if (chargeSaleCategoryFee.equals(ContractConstant.ChargeSaleCategoryFee.YES_CODE)) {
            return "\u6536\u53d6";
        }
        return "\u9519\u8bef\u7684\u662f\u5426\u6536\u53d6\u9500\u552e\u54c1\u7c7b\u670d\u52a1\u8d39";
    }

    public static String transModifyStatus(Integer modifyStatus) {
        if (modifyStatus.equals(ContractConstant.ModifyStatus.MODIFY_STATUS_DRAFT)) {
            return "\u8349\u7a3f";
        }
        if (modifyStatus.equals(ContractConstant.ModifyStatus.MODIFY_STATUS_EXAMINE)) {
            return "\u5ba1\u6838\u4e2d";
        }
        if (modifyStatus.equals(ContractConstant.ModifyStatus.MODIFY_STATUS_APPROVED)) {
            return "\u5ba1\u6838\u901a\u8fc7";
        }
        if (modifyStatus.equals(ContractConstant.ModifyStatus.MODIFY_STATUS_REJECT)) {
            return "\u5ba1\u6279\u62d2\u7edd";
        }
        if (modifyStatus.equals(ContractConstant.ModifyStatus.MODIFY_STATUS_IN_CONFIRM)) {
            return "\u786e\u8ba4\u4e2d";
        }
        if (modifyStatus.equals(ContractConstant.ModifyStatus.MODIFY_STATUS_IN_NEGOTIATION)) {
            return "\u534f\u5546\u4e2d";
        }
        if (modifyStatus.equals(ContractConstant.ModifyStatus.MODIFY_STATUS_EFFECT)) {
            return "\u5df2\u751f\u6548";
        }
        if (modifyStatus.equals(ContractConstant.ModifyStatus.MODIFY_STATUS__PENDING_PUSH_LEGAL)) {
            return "\u5f85\u63a8\u9001\u6cd5\u52a1";
        }
        if (modifyStatus.equals(ContractConstant.ModifyStatus.MODIFY_STATUS_PENDING_PUSH_LEGAL_RETURN)) {
            return "\u6cd5\u52a1\u9000\u56de";
        }
        return "\u9519\u8bef\u7684\u53d8\u66f4\u7533\u8bf7\u72b6\u6001";
    }

    public static String transContractType(Integer contractType) {
        if (contractType.equals(ContractConstant.ContractType.UNIT_AGREE_CONTRACT_TYPE)) {
            return " \u5355\u4f4d\u534f\u8bae\u5408\u540c";
        }
        if (contractType.equals(ContractConstant.ContractType.PLATFORM_AGREE_CONTRACT_TYPE)) {
            return "\u5e73\u53f0\u534f\u8bae\u5408\u540c";
        }
        if (contractType.equals(ContractConstant.ContractType.ORDER_CONTRACT_TYPE)) {
            return "\u8ba2\u5355\u5408\u540c";
        }
        if (contractType.equals(ContractConstant.ContractType.ENTER_CONTRACT_TYPE)) {
            return "\u5165\u9a7b\u5408\u540c";
        }
        if (contractType.equals(ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        }
        if (contractType.equals(ContractConstant.ContractType.SPOT_CONTRACT)) {
            return "\u73b0\u8d27\u5408\u540c";
        }
        if (contractType.equals(ContractConstant.ContractType.PURCHASE_CONTRACT)) {
            return "\u91c7\u8d2d\u5408\u540c";
        }
        if (contractType.equals(ContractConstant.ContractType.SALE_CONTRACT)) {
            return "\u9500\u552e\u5408\u540c";
        }
        if (contractType.equals(ContractConstant.ContractType.DEVELOPMENT_CONTRACT)) {
            return "\u73b0\u8d27\u5408\u540c\uff08\u5f00\u53d1\u81ea\u91c7\uff09";
        }
        if (contractType.equals(ContractConstant.ContractType.ORDER_CONTRACT)) {
            return "\u9500\u552e\u8ba2\u5355\u5408\u540c";
        }
        if (contractType.equals(ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT)) {
            return "\u91c7\u8d2d\u8ba2\u5355\u5408\u540c\uff08\u8d38\u6613\uff09";
        }
        if (contractType.equals(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5bc4\u552e\uff09";
        }
        if (contractType.equals(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        }
        if (contractType.equals(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT)) {
            return "\u91c7\u8d2d\u6807\u51c6\u5408\u540c";
        }
        if (contractType.equals(ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT)) {
            return "\u91c7\u8d2d\u8ba2\u5355\u5408\u540c\uff08\u975e\u8d38\u6613\uff09";
        }
        if (contractType.equals(ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5f00\u53d1\u81ea\u91c7\uff09";
        }
        if (contractType.equals(ContractConstant.ContractType.OTHER_LONG_TERM_PRICING_CONTRACT)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        }
        if (contractType.equals(ContractConstant.ContractType.OTHER_PROMPT_CONTRACT)) {
            return "\u73b0\u8d27\u5408\u540c";
        }
        if (ContractConstant.ContractType.PURCHASE_TRADE_ORDER_CONTRACT.equals(contractType)) {
            return "\u91c7\u8d2d\u8ba2\u5355\u5408\u540c";
        }
        if (ContractConstant.ContractType.PURCHASE_NO_TRADE_ORDER_CONTRACT.equals(contractType)) {
            return "\u91c7\u8d2d\u8ba2\u5355\u5408\u540c";
        }
        if (ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT.equals(contractType)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        }
        if (ContractConstant.ContractType.FUNCTION_SPOTS_CONTRACT.equals(contractType)) {
            return "\u73b0\u8d27\u5408\u540c";
        }
        return "\u9519\u8bef\u7684\u5408\u540c\u7c7b\u578b";
    }

    public static String transAdjustPriceType(Integer adjustPrice) {
        if (adjustPrice.equals(0)) {
            return "\u65e0";
        }
        if (adjustPrice.equals(1)) {
            return "\u4e8b\u524d\u8c03\u4ef7";
        }
        if (adjustPrice.equals(2)) {
            return "\u4e8b\u4e2d\u8c03\u4ef7";
        }
        return null;
    }

    public static String transContractApprovalResult(Integer contractApprovalResult) {
        if (contractApprovalResult.equals(ContractConstant.ContractApprovalResult.APPROVAL_RESULT_YES)) {
            return "\u901a\u8fc7";
        }
        if (contractApprovalResult.equals(ContractConstant.ContractApprovalResult.APPROVAL_RESULT_NO)) {
            return "\u9a73\u56de";
        }
        return "\u9519\u8bef\u7684\u5ba1\u6279\u7ed3\u679c";
    }

    public static String transExpectSettle(Integer expectSettle) {
        if (expectSettle.equals(ContractConstant.ExpectSettle.EXPECT_SETTLE_YES_CODE)) {
            return "\u6307\u5b9a\u7ed3\u7b97\u65e5";
        }
        if (expectSettle.equals(ContractConstant.ExpectSettle.EXPECT_SETTLE_NO_CODE)) {
            return "\u4e0d\u6307\u5b9a\u7ed3\u7b97\u65e5";
        }
        return "\u9519\u8bef\u7684\u671f\u671b\u7ed3\u7b97\u65b9\u5f0f";
    }

    public static String transPayType(Integer payType) {
        if (payType.equals(ContractConstant.PayType.ACCOUNTING_PERIOD_CODE)) {
            return "\u8d26\u671f\u652f\u4ed8";
        }
        if (payType.equals(ContractConstant.PayType.PHASED_PAYMENT_CODE)) {
            return "\u5206\u9636\u6bb5\u652f\u4ed8";
        }
        if (payType.equals(ContractConstant.PayType.PRE_PAY_CODE)) {
            return "\u9884\u4ed8\u6b3e\u652f\u4ed8";
        }
        if (payType.equals(ContractConstant.PayType.NO_HAVE_PAY)) {
            return "\u5176\u4ed6";
        }
        if (payType.equals(ContractConstant.PayType.ADVANCE_PAY_CODE)) {
            return "\u9884\u5b58\u6b3e\u652f\u4ed8";
        }
        return "\u9519\u8bef\u7684\u4ed8\u6b3e\u65b9\u5f0f";
    }

    public static String transOrderContractPayType(Integer payType) {
        if (payType.equals(ContractConstant.OrderContractPayType.ALI_PAY_PHONE_CODE)) {
            return "\u652f\u4ed8\u5b9d\u626b\u7801\u652f\u4ed8";
        }
        if (payType.equals(ContractConstant.OrderContractPayType.ALI_PAY_COMPUTER_CODE)) {
            return "\u652f\u4ed8\u5b9d\u7535\u8111\u7f51\u7ad9\u652f\u4ed8";
        }
        if (payType.equals(ContractConstant.OrderContractPayType.WECHAT_PAY_SCAN_CODE)) {
            return "\u5fae\u4fe1\u626b\u7801\u652f\u4ed8";
        }
        if (payType.equals(ContractConstant.OrderContractPayType.WECHAT_PAY_MINIPROGRAM_CODE)) {
            return "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8";
        }
        if (payType.equals(ContractConstant.OrderContractPayType.OFFLINE_PAY_CODE)) {
            return "\u7ebf\u4e0b\u652f\u4ed8";
        }
        return "\u9519\u8bef\u7684\u652f\u4ed8\u65b9\u5f0f";
    }

    public static String transContractStatus(Integer contractStatus) {
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_DRAFT)) {
            return "\u8349\u7a3f";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_APPROVAL)) {
            return "\u5ba1\u6279\u4e2d";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_APPROVAL)) {
            return "\u5ba1\u6279\u901a\u8fc7";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_REJECT)) {
            return "\u5ba1\u6279\u62d2\u7edd";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPLY)) {
            return "\u53d8\u66f4\u7533\u8bf7\u4e2d";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_PRODUCER_SIGN_)) {
            return "\u751f\u6210\u65b9\u5f85\u7b7e\u7ae0";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_UNDER_SIGNATORIES_SIGN_)) {
            return "\u7b7e\u8ba2\u65b9\u5f85\u7b7e\u7ae0";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT)) {
            return "\u5df2\u751f\u6548";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER)) {
            return "\u5df2\u5931\u6548";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_HIS)) {
            return "\u5386\u53f2\u7248\u672c";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_ABOLISH)) {
            return "\u5df2\u5e9f\u6b62";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_WAIT_FOR_SIGN)) {
            return "\u5f85\u7b7e\u7ae0";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_IN_CONFIRM)) {
            return "\u786e\u8ba4\u4e2d";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_IN_NEGOTIATION)) {
            return "\u534f\u5546\u4e2d";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_EXECUTED)) {
            return "\u5df2\u6267\u884c";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_FREEZE)) {
            return "\u51bb\u7ed3";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_PENDING_SUBMISSION)) {
            return "\u5f85\u63d0\u4ea4\u751f\u6548";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_FIRST_PARTY_WAIT_SIGNATURE)) {
            return "\u7532\u65b9\u5f85\u7b7e\u7ae0";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_SECOND_PARTY_WAIT_SIGNATURE)) {
            return "\u4e59\u65b9\u5f85\u7b7e\u7ae0";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_PENDING_PUSH_LEGAL)) {
            return "\u5f85\u63a8\u9001\u6cd5\u52a1";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_PENDING_PUSH_LEGAL_RETURN)) {
            return "\u6cd5\u52a1\u9000\u56de";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_STATUS_CHANGE_APPROVAL_OK)) {
            return "\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7";
        }
        if (contractStatus.equals(ContractConstant.ContractStatus.CONTRACT_THIRD_PARTY_WAIT_SIGNATURE)) {
            return "\u4e19\u65b9\u5f85\u7b7e\u7ae0";
        }
        return "\u9519\u8bef\u7684\u5408\u540c\u72b6\u6001";
    }

    public static String transOrderSource(Integer orderSource) {
        if (orderSource.equals(ContractConstant.OrderSource.ORDER_SOURCE_NO_AGREE)) {
            return "\u65e0\u534f\u8bae\u8ba2\u5355";
        }
        return "\u9519\u8bef\u7684\u8ba2\u5355\u7c7b\u578b";
    }

    public static String transSupplierType(Integer supplierType) {
        if (supplierType.equals(ContractConstant.SupplyType.SUPPLIER_CODE)) {
            return "\u4f9b\u5e94\u5546";
        }
        if (supplierType.equals(ContractConstant.SupplyType.PURCHASER_CODE)) {
            return "\u91c7\u8d2d\u5546";
        }
        if (supplierType.equals(ContractConstant.SupplyType.SUPPLIER_PURCHASER_CODE)) {
            return "\u4f9b\u5e94\u5546+\u91c7\u8d2d\u5546";
        }
        return "\u9519\u8bef\u7684\u5ba2\u5546\u7c7b\u578b";
    }

    public static String transContractOrgType(Integer orgType) {
        if (ContractConstant.ContractOrgType.EXT_ENTERPRISE_CODE.equals(orgType)) {
            return "\u5916\u90e8\u4f01\u4e1a";
        }
        if (Objects.equals("2", orgType)) {
            return "\u5916\u90e8\u4e2a\u4eba";
        }
        return "\u9519\u8bef\u7684\u7ed3\u6784\u7c7b\u522b,";
    }

    public static String transOrgType(String orgType) {
        String[] split;
        String orgTypeStr = "";
        for (String orgTypeTemp : split = orgType.split(",")) {
            orgTypeStr = "1".equals(orgTypeTemp) ? orgTypeStr + "\u5916\u90e8\u4f01\u4e1a" + "," : ("2".equals(orgTypeTemp) ? orgTypeStr + "\u5916\u90e8\u4e2a\u4eba" + "," : orgTypeStr + "\u9519\u8bef\u7684\u7ed3\u6784\u7c7b\u522b,");
        }
        return orgTypeStr.substring(0, orgTypeStr.length() - 1);
    }

    public static String transSsBusiWay(Integer ssBusiWay) {
        if (ssBusiWay.equals(ContractConstant.SsBusiWay.SS_BUSI_WAY_ZTB)) {
            return "\u62db\u6295\u6807";
        }
        if (ssBusiWay.equals(ContractConstant.SsBusiWay.SS_BUSI_WAY_XBJ)) {
            return "\u8be2\u6bd4\u4ef7";
        }
        if (ssBusiWay.equals(ContractConstant.SsBusiWay.SS_BUSI_WAY_JJ)) {
            return "\u7ade\u4ef7";
        }
        if (ssBusiWay.equals(ContractConstant.SsBusiWay.SS_BUSI_WAY_WLY)) {
            return "\u65e0\u6765\u6e90";
        }
        return "\u9519\u8bef\u7684\u5bfb\u6e90\u65b9\u5f0f";
    }

    public static String transContractBussNode(Integer bussNode) {
        if (bussNode.equals(ContractConstant.BussNode.ORDER_RECEIPT_CODE)) {
            return "\u8ba2\u5355\u6536\u7968";
        }
        if (bussNode.equals(ContractConstant.BussNode.ORDER_CHECK_CODE)) {
            return "\u8ba2\u5355/\u9a8c\u6536\u5355\u9a8c\u6536";
        }
        if (bussNode.equals(ContractConstant.BussNode.ORDER_ARRIVE_CODE)) {
            return "\u8ba2\u5355/\u53d1\u8d27\u5355\u5230\u8d27";
        }
        if (bussNode.equals(ContractConstant.BussNode.INVOICE_ON_ACCOUNT_CODE)) {
            return "\u53d1\u7968\u6302\u8d26";
        }
        return "\u9519\u8bef\u7684\u53ef\u9009\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\u65b9\u5f0f";
    }

    public static String transContractPurchaseType(Integer purchaseType) {
        if (ContractConstant.ContractPurchaseType.PUBLIC_BIDDING_CODE.equals(purchaseType)) {
            return "\u516c\u5f00\u62db\u6807";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.INVITATION_TO_BID_CODE)) {
            return "\u9080\u8bf7\u62db\u6807";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.PUBLIC_INQUIRY_CODE)) {
            return "\u516c\u5f00\u8be2\u6bd4";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.DIRECTIONAL_INQUIRY_CODE)) {
            return "\u9080\u8bf7\u8be2\u6bd4";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.OPEN_OUTCRY_CODE)) {
            return "\u516c\u5f00\u7ade\u4ef7";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.DIRECTIONAL_BIDDING_CODE)) {
            return "\u9080\u8bf7\u7ade\u4ef7";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.COMPETITIVE_NEGOTIATION_CODE)) {
            return "\u516c\u5f00\u7ade\u8c08";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.SINGLE_SOURCE_CODE)) {
            return "\u9080\u8bf7\u7ade\u8c08";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.FIXED_PRICE_CODE)) {
            return "\u5355\u4e00\u6765\u6e90";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.DS_CG_CODE)) {
            return "\u76f4\u63a5\u91c7\u8d2d";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.XY_CAI_CODE)) {
            return "\u76f4\u63a5\u91c7\u8d2d(\u6267\u884c\u534f\u8bae)";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.DSDJ_CAI_CODE)) {
            return "\u76f4\u63a5\u91c7\u8d2d(\u5b9a\u5546\u5b9a\u4ef7)";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.GKPT)) {
            return "\u516c\u5f00\u8c08\u5224";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.YQTP)) {
            return "\u9080\u8bf7\u8c08\u5224";
        }
        if (purchaseType.equals(ContractConstant.ContractPurchaseType.ZJCG)) {
            return "\u76f4\u63a5\u91c7\u8d2d";
        }
        return "\u9519\u8bef\u7684\u7ed3\u6784\u7c7b\u522b";
    }

    public static String transContractErpSyncStauts(String erpSyncStauts) {
        if ("0".equals(erpSyncStauts)) {
            return "\u5f85\u540c\u6b65";
        }
        if (erpSyncStauts.equals("1")) {
            return "\u540c\u6b65\u6210\u529f";
        }
        if (erpSyncStauts.equals("2")) {
            return "\u540c\u6b65\u5931\u8d25";
        }
        return "\u9519\u8bef\u7684\u7ed3\u6784\u7c7b\u522b,";
    }

    public static String transContractCategory(Integer contractCategory) {
        if (contractCategory.equals(ContractConstant.ContractCategory.FRAMEWORK_AGREEMENT_CONSIGNMENT)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5bc4\u552e\uff09";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.FRAMEWORK_AGREEMENT_PRICE)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7)";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.SPOT_CONTRACT)) {
            return "\u73b0\u8d27\u5408\u540c\uff08\u81ea\u8425-\u96c6\u91c7\u8ba1\u5212\uff09";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.DEVELOPMENT_CONTRACT)) {
            return "\u73b0\u8d27\u5408\u540c\uff08\u5f00\u53d1\u81ea\u91c7\uff09";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.FRAME_AGR_SELF_EXPLOITATION_CONTRACT)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5f00\u53d1\u81ea\u91c7\uff09";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.OTHER_LONG_TERM_PRICING_CONTRACT)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.OTHER_PROMPT_CONTRACT)) {
            return "\u73b0\u8d27\u5408\u540c";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.PURCHASE_SPOT_CONTRACT)) {
            return "\u91c7\u8d2d\u73b0\u8d27\u5408\u540c(\u91c7\u8d2d\u6807\u51c6\u5408\u540c)";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.FUNCTION_SPOTS_CONTRACT)) {
            return "\u804c\u80fd\u5408\u540c(\u73b0\u8d27\u5408\u540c)";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5bc4\u552e\uff09";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.PURCHASE_LONG_TERM_PRICING_CONTRACT)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT)) {
            return "\u804c\u80fd\u5408\u540c-\u6846\u67b6\u534f\u8bae\uff08\u5b9a\u4ef7\uff09";
        }
        if (contractCategory.equals(ContractConstant.ContractCategory.PURCHASE_ORDER_CONTRACT)) {
            return "\u91c7\u8d2d\u8ba2\u5355\u5408\u540c\uff08\u8d38\u6613\uff09";
        }
        return "\u9519\u8bef\u7684\u5408\u540c\u7c7b\u522b";
    }

    public static String transContractMaterialSource(String materialSource) {
        if ("1".equals(materialSource)) {
            return "\u8be2\u6bd4\u7ed3\u679c";
        }
        if (materialSource.equals("2")) {
            return "\u5b9a\u6807\u62a5\u544a";
        }
        if (materialSource.equals("3")) {
            return "\u624b\u5de5\u5f55\u5165";
        }
        if (materialSource.equals("4")) {
            return "\u5185\u90e8\u8d38\u6613";
        }
        if (materialSource.equals("5")) {
            return "\u91c7\u8d2d\u8ba2\u5355";
        }
        if (materialSource.equals("6")) {
            return "ERP\u521d\u59cb\u5316";
        }
        if (materialSource.equals("7")) {
            return "\u534f\u8bae\u65b9\u6848";
        }
        if (materialSource.equals("8")) {
            return "\u5b9a\u5546\u5b9a\u4ef7\u65b9\u6848";
        }
        if (materialSource.equals("9")) {
            return "\u96c6\u91c7\u5206\u7b7e\u534f\u8bae";
        }
        return "\u9519\u8bef\u7684\u7ed3\u6784\u7c7b\u522b,";
    }

    public static String transContractOrgType(String orgType) {
        if ("1".equals(orgType)) {
            return "\u6709\u9650\u8d23\u4efb\u516c\u53f8";
        }
        if (orgType.equals("2")) {
            return "\u80a1\u4efd\u8d23\u4efb\u516c\u53f8";
        }
        if (orgType.equals("3")) {
            return "\u56fd\u6709\u72ec\u8d44\u4f01\u4e1a";
        }
        if (orgType.equals("4")) {
            return "\u4e2a\u4eba\u72ec\u8d44\u4f01\u4e1a";
        }
        if (orgType.equals("5")) {
            return "\u5408\u4f19\u4f01\u4e1a";
        }
        if (orgType.equals("6")) {
            return "\u4e2a\u4f53\u5de5\u5546\u6237";
        }
        return "\u9519\u8bef\u7684\u7ed3\u6784\u7c7b\u522b,";
    }

    public static String transBusinessType(Integer businessType) {
        if (businessType.equals(ContractConstant.BusinessType.PROCUREMENT)) {
            return "\u91c7\u8d2d";
        }
        if (businessType.equals(ContractConstant.BusinessType.SALES)) {
            return "\u670d\u52a1";
        }
        if (businessType.equals(ContractConstant.BusinessType.AGENT)) {
            return "\u8fdb\u53e3\u4ee3\u7406";
        }
        if (businessType.equals(ContractConstant.BusinessType.SALE)) {
            return "\u9500\u552e";
        }
        if (businessType.equals(ContractConstant.BusinessType.COLLECTIVE_PURCHASE_SELF)) {
            return "\u96c6\u91c7\u81ea\u8425";
        }
        if (businessType.equals(ContractConstant.BusinessType.IMPORT_SELF)) {
            return "\u8fdb\u53e3\u81ea\u8425";
        }
        if (businessType.equals(ContractConstant.BusinessType.SELF_PURCHASE)) {
            return "\u81ea\u9700\u91c7\u8d2d";
        }
        if (businessType.equals(ContractConstant.BusinessType.TRIPARTITE_INTERNAL_AGENCY)) {
            return "\u4e09\u65b9-\u5185\u8d38\u4ee3\u7406";
        }
        if (businessType.equals(ContractConstant.BusinessType.TRIPARTITE_OTHER)) {
            return "\u4e09\u65b9-\u5176\u4ed6";
        }
        if (businessType.equals(ContractConstant.BusinessType.TALK_SIGN_SEPARATELY)) {
            return "\u7edf\u8c08\u5206\u7b7e";
        }
        if (businessType.equals(ContractConstant.BusinessType.NIENTE)) {
            return "\u5176\u4ed6";
        }
        if (businessType.equals(ContractConstant.BusinessType.AGENT_PURCHASE)) {
            return "\u96c6\u91c7\u5206\u7b7e";
        }
        if (businessType.equals(ContractConstant.BusinessType.ENTRUSTED_BIDDING)) {
            return "\u59d4\u6258\u62db\u6807(\u670d\u52a1)";
        }
        if (businessType.equals(ContractConstant.BusinessType.ENTRUSTED_TRZ)) {
            return "\u6295\u878d\u8d44\u7c7b";
        }
        if (businessType.equals(ContractConstant.BusinessType.ENTRUSTED_YC)) {
            return "\u96c6\u91c7\u81ea\u8425-\u4e91\u4ed3";
        }
        return "\u9519\u8bef\u7684\u4e1a\u52a1\u7c7b\u578b";
    }

    public static String transIsNewSupplier(Integer isNewSupplier) {
        if (isNewSupplier.equals(ContractConstant.IsNewSupplier.YES)) {
            return "\u662f";
        }
        if (isNewSupplier.equals(ContractConstant.IsNewSupplier.NO)) {
            return "\u5426";
        }
        return "\u9519\u8bef\u7684\u662f\u5426\u65b0\u4f9b\u5e94\u5546\u7c7b\u578b";
    }

    public static String transIsNewBrand(Integer isNewBrand) {
        if (isNewBrand.equals(ContractConstant.IsNewBrand.YES)) {
            return "\u6709";
        }
        if (isNewBrand.equals(ContractConstant.IsNewBrand.NO)) {
            return "\u65e0";
        }
        return "\u9519\u8bef\u7684\u662f\u5426\u65b0\u4f9b\u5e94\u5546\u7c7b\u578b";
    }

    public static String transCommunicationType(String communicationType) {
        if (communicationType.equals("1")) {
            return "\u7535\u8bdd";
        }
        if (communicationType.equals("2")) {
            return "\u4f20\u771f";
        }
        if (communicationType.equals("3")) {
            return "\u7535\u5b50\u90ae\u7bb1";
        }
        if (communicationType.equals("4")) {
            return "\u4fe1\u51fd";
        }
        if (communicationType.equals("5")) {
            return "\u9762\u8c08";
        }
        return "\u9519\u8bef\u7684\u4ea4\u6d41\u65b9\u5f0f\u7c7b\u578b";
    }

    public static String transPriceCategories(Integer priceCategories) {
        if (priceCategories.equals(ContractConstant.PriceCategoriesType.CONTRACT_PRICE)) {
            return "\u534f\u8bae\u4ef7";
        }
        if (priceCategories.equals(ContractConstant.PriceCategoriesType.GUIDED)) {
            return "\u6307\u5bfc\u4ef7";
        }
        if (priceCategories.equals(ContractConstant.PriceCategoriesType.AVERAGE_PRICE)) {
            return "\u5e73\u5747\u62a5\u4ef7";
        }
        if (priceCategories.equals(ContractConstant.PriceCategoriesType.COUNTERPARTY_QUOTATION)) {
            return "\u6210\u4ea4\u65b9\u62a5\u4ef7";
        }
        if (priceCategories.equals(ContractConstant.PriceCategoriesType.BUDGET_PRICE)) {
            return "\u9884\u7b97\u4ef7";
        }
        if (priceCategories.equals(ContractConstant.PriceCategoriesType.OTHER)) {
            return "\u5176\u4ed6";
        }
        return "\u9519\u8bef\u7684\u6bd4\u4ef7\u7c7b\u522b\u7c7b\u578b";
    }

    public static Integer transPriceCategories(String priceCategories) {
        if (StringUtils.isEmpty((Object)priceCategories)) {
            return null;
        }
        if (priceCategories.equals("\u534f\u8bae\u4ef7")) {
            return ContractConstant.PriceCategoriesType.CONTRACT_PRICE;
        }
        if (priceCategories.equals("\u6307\u5bfc\u4ef7")) {
            return ContractConstant.PriceCategoriesType.GUIDED;
        }
        if (priceCategories.equals("\u5e73\u5747\u62a5\u4ef7")) {
            return ContractConstant.PriceCategoriesType.AVERAGE_PRICE;
        }
        if (priceCategories.equals("\u6210\u4ea4\u65b9\u62a5\u4ef7")) {
            return ContractConstant.PriceCategoriesType.COUNTERPARTY_QUOTATION;
        }
        if (priceCategories.equals("\u9884\u7b97\u4ef7")) {
            return ContractConstant.PriceCategoriesType.BUDGET_PRICE;
        }
        if (priceCategories.equals("\u5176\u4ed6")) {
            return ContractConstant.PriceCategoriesType.OTHER;
        }
        return null;
    }

    public static String transFactoryPrice(Integer factoryPrice) {
        if (factoryPrice.equals(ContractConstant.FactoryPrice.ARRIVE_PRICE)) {
            return "\u5230\u5382\u4ef7";
        }
        if (factoryPrice.equals(ContractConstant.FactoryPrice.OUT_PRICE)) {
            return "\u51fa\u5382\u4ef7";
        }
        return "\u9519\u8bef\u7684\u5230/\u51fa\u5382\u4ef7\u7c7b\u578b";
    }

    public static Integer transFactoryPrice(String factoryPrice) {
        if (StringUtils.isEmpty((Object)factoryPrice)) {
            return null;
        }
        if ("\u5230\u5382\u4ef7".equals(factoryPrice)) {
            return ContractConstant.FactoryPrice.ARRIVE_PRICE;
        }
        if ("\u51fa\u5382\u4ef7".equals(factoryPrice)) {
            return ContractConstant.FactoryPrice.OUT_PRICE;
        }
        return null;
    }

    public static String transPayNodeRuleAllow(Integer payNodeRuleAllow) {
        if (ContractConstant.PayNodeRuleAllow.ORDER_TICKET.equals(payNodeRuleAllow)) {
            return "\u8ba2\u5355\u6536\u7968";
        }
        if (ContractConstant.PayNodeRuleAllow.ORDER_ACCEPTANCE.equals(payNodeRuleAllow)) {
            return "\u8ba2\u5355/\u9a8c\u6536\u5355\u9a8c\u6536";
        }
        if (ContractConstant.PayNodeRuleAllow.ORDER_INVOICE.equals(payNodeRuleAllow)) {
            return "\u8ba2\u5355/\u53d1\u8d27\u5355\u5230\u8d27";
        }
        if (ContractConstant.PayNodeRuleAllow.PAYMENT.equals(payNodeRuleAllow)) {
            return "\u53d1\u7968\u6302\u8d26";
        }
        return "\u9519\u8bef\u7684\u53ef\u9009\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9";
    }

    public static String transUpdateApplyType(Integer updateApplyType) {
        if (ContractConstant.UpdateApplyType.CHANGE_CONTRACT.equals(updateApplyType)) {
            return "\u53d8\u66f4\u5408\u540c";
        }
        if (ContractConstant.UpdateApplyType.END_CONTRACT.equals(updateApplyType)) {
            return "\u7ec8\u6b62\u5408\u540c";
        }
        if (ContractConstant.UpdateApplyType.MATERIAL_CHANGE_CONTRACT.equals(updateApplyType)) {
            return "\u7269\u8d44\u53d8\u66f4";
        }
        return "\u9519\u8bef\u7684\u53ef\u9009\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9";
    }

    public static String transPurchaseChannel(Integer purchaseChannel) {
        if (ContractConstant.PurchaseChannelType.DOMESTIC.equals(purchaseChannel)) {
            return "\u56fd\u5185";
        }
        if (ContractConstant.PurchaseChannelType.INTERNATIONAL.equals(purchaseChannel)) {
            return "\u56fd\u9645";
        }
        return "\u9519\u8bef\u7684\u8fdb\u8d27\u6e20\u9053";
    }

    public static String transTermOfValidity(Integer validType) {
        if (ContractConstant.TermOfValidityType.MONTHS.equals(validType)) {
            return "\u4e2a\u6708";
        }
        if (ContractConstant.TermOfValidityType.YEARS.equals(validType)) {
            return "\u5e74";
        }
        if (ContractConstant.TermOfValidityType.DAY.equals(validType)) {
            return "\u65e5";
        }
        return "\u9519\u8bef\u7684\u6709\u6548\u671f\u7c7b\u578b";
    }

    public static String transMaterialCategory2(Integer materialCategory) {
        if (materialCategory.equals(ContractConstant.MaterialCategory.PROJECT)) {
            return "\u5de5\u7a0b";
        }
        if (materialCategory.equals(ContractConstant.MaterialCategory.SERVICES)) {
            return "\u670d\u52a1";
        }
        if (materialCategory.equals(ContractConstant.MaterialCategory.EQUIPMENT)) {
            return "\u8bbe\u5907";
        }
        if (materialCategory.equals(ContractConstant.MaterialCategory.ACCESSORIES)) {
            return "\u914d\u4ef6";
        }
        if (materialCategory.equals(ContractConstant.MaterialCategory.METAL_MATERIALS)) {
            return "\u91d1\u5c5e\u6750\u6599";
        }
        if (materialCategory.equals(ContractConstant.MaterialCategory.NON_METALLIC_MATERIAL)) {
            return "\u975e\u91d1\u5c5e\u6750\u6599";
        }
        if (materialCategory.equals(ContractConstant.MaterialCategory.COAL)) {
            return "\u7164\u70ad";
        }
        return "\u9519\u8bef\u7684\u7269\u8d44\u5206\u7c7b";
    }

    public static String transSealType(Integer sealType) {
        if (sealType.equals(ContractConstant.SealType.CONTRACT_SPECIAL)) {
            return " \u5408\u540c\u4e13\u7528\u7ae0";
        }
        if (sealType.equals(ContractConstant.SealType.ENTERPRISE_CACHET)) {
            return "\u4f01\u4e1a\u516c\u7ae0";
        }
        if (sealType.equals(ContractConstant.SealType.PERSONAL_SEAL)) {
            return "\u4eba\u540d\u7ae0";
        }
        if (sealType.equals(ContractConstant.SealType.ACCOUNTING_SPECIAL)) {
            return "\u8d26\u52a1\u4e13\u7528\u7ae0";
        }
        if (sealType.equals(ContractConstant.SealType.COMPANY_NAME_FLAT_SEAL)) {
            return "\u516c\u53f8\u540d\u79f0\u6241\u6761\u7ae0";
        }
        return "\u9519\u8bef\u7684\u5370\u7ae0\u7c7b\u578b";
    }

    public static String transPushErpStatus(Integer pushErpStatus) {
        if (pushErpStatus.equals(ContractConstant.PushErpStatus.IN_SYNC)) {
            return "\u540c\u6b65\u4e2d";
        }
        if (pushErpStatus.equals(ContractConstant.PushErpStatus.WAIT_SYNC)) {
            return "\u5f85\u540c\u6b65";
        }
        if (pushErpStatus.equals(ContractConstant.PushErpStatus.ALREADY_SYNC)) {
            return "\u5df2\u540c\u6b65";
        }
        if (pushErpStatus.equals(ContractConstant.PushErpStatus.FAIL_SYNC)) {
            return "\u540c\u6b65\u5931\u8d25";
        }
        if (ContractConstant.PushErpStatus.NEED_NOT_SYNC.equals(pushErpStatus)) {
            return "\u65e0\u9700\u540c\u6b65";
        }
        return "\u9519\u8bef\u7684\u63a8\u9001ERP\u72b6\u6001";
    }

    public static String transSignOperLogType(Integer signOperLogType) {
        if (signOperLogType.equals(ContractConstant.SignOperLogType.SIGN_INIT)) {
            return " \u53d1\u8d77\u7b7e\u7ae0";
        }
        if (signOperLogType.equals(ContractConstant.SignOperLogType.SIGN_OK)) {
            return "\u7b7e\u7ae0\u5b8c\u6210";
        }
        if (signOperLogType.equals(ContractConstant.SignOperLogType.SIGN_REJECT)) {
            return "\u62d2\u7b7e";
        }
        if (signOperLogType.equals(ContractConstant.SignOperLogType.SIGN_INIT_BACK)) {
            return "\u53d1\u8d77\u65b9\u64a4\u56de";
        }
        if (signOperLogType.equals(ContractConstant.SignOperLogType.SIGN_INVALID)) {
            return "\u4f5c\u5e9f\u7b7e\u7f72";
        }
        if (signOperLogType.equals(ContractConstant.SignOperLogType.SIGN_OVERDUE)) {
            return "\u4fe1\u5c01\u8fc7\u671f";
        }
        return "\u9519\u8bef\u7684\u8bb0\u5f55\u7b7e\u7ae0\u64cd\u4f5c\u7c7b\u578b";
    }

    public static String transPushLegalSealType(Integer sealType) {
        if (sealType.equals(ContractConstant.SealType.CONTRACT_SPECIAL)) {
            return "2000100010868";
        }
        if (sealType.equals(ContractConstant.SealType.ENTERPRISE_CACHET)) {
            return "2000100010867";
        }
        if (sealType.equals(ContractConstant.SealType.PERSONAL_SEAL)) {
            return "2000100010869";
        }
        if (sealType.equals(ContractConstant.SealType.ACCOUNTING_SPECIAL)) {
            return "2000100010871";
        }
        if (sealType.equals(ContractConstant.SealType.COMPANY_NAME_FLAT_SEAL)) {
            return "2000100010870";
        }
        return null;
    }

    public static String transContractTermsValidStatus(Integer validStatus) {
        if (ContractConstant.ContractTermsValidStatus.DRAFT.equals(validStatus)) {
            return "\u8349\u7a3f";
        }
        if (ContractConstant.ContractTermsValidStatus.DISABLE.equals(validStatus)) {
            return "\u505c\u7528";
        }
        if (ContractConstant.ContractTermsValidStatus.PUBLISHED.equals(validStatus)) {
            return "\u5df2\u53d1\u5e03";
        }
        if (ContractConstant.ContractTermsValidStatus.DELETE.equals(validStatus)) {
            return "\u5220\u9664";
        }
        return "\u9519\u8bef\u7684\u6761\u6b3e\u72b6\u6001";
    }

    public static String transContractTemplateValidStatus(Integer validStatus) {
        if (ContractConstant.ContractTemplateValidStatus.DRAFT.equals(validStatus)) {
            return "\u8349\u7a3f";
        }
        if (ContractConstant.ContractTemplateValidStatus.DISABLE.equals(validStatus)) {
            return "\u505c\u7528";
        }
        if (ContractConstant.ContractTemplateValidStatus.PUBLISHED.equals(validStatus)) {
            return "\u5df2\u53d1\u5e03";
        }
        return "\u9519\u8bef\u7684\u6a21\u677f\u72b6\u6001";
    }

    public static String transContractTemplatePurpose(Integer purpose) {
        if (ContractConstant.ContractTemplatePurpose.CONTRACT_REFERENCE.equals(purpose)) {
            return "\u5408\u540c\u5f15\u7528";
        }
        if (ContractConstant.ContractTemplatePurpose.SOURCE_REFERENCE.equals(purpose)) {
            return "\u5bfb\u6e90\u53c2\u8003";
        }
        return "\u9519\u8bef\u7684\u6a21\u677f\u7528\u9014";
    }

    public static Integer transSaleStatusStr(String SaleStatusStr) {
        if ("\u6709\u6548".equals(SaleStatusStr)) {
            return ContractConstant.SaleStatus.VALID;
        }
        if ("\u9650\u91cf".equals(SaleStatusStr)) {
            return ContractConstant.SaleStatus.LIMIT;
        }
        if ("\u65e0\u6548".equals(SaleStatusStr)) {
            return ContractConstant.SaleStatus.INVALID;
        }
        return 1;
    }

    public static String transSaleStatus(Integer SaleStatus2) {
        if (ContractConstant.SaleStatus.VALID.equals(SaleStatus2)) {
            return "\u6709\u6548";
        }
        if (ContractConstant.SaleStatus.LIMIT.equals(SaleStatus2)) {
            return "\u9650\u91cf";
        }
        if (ContractConstant.SaleStatus.INVALID.equals(SaleStatus2)) {
            return "\u65e0\u6548";
        }
        return "\u6709\u6548";
    }

    public static enum SaeTypeEnum {
        ONE(1, "\u5de5\u7a0b"),
        TWO(2, "\u670d\u52a1"),
        THREE(3, "\u7269\u8d44"),
        FOUR(4, "\u7269\u8d44"),
        FIVE(5, "\u7269\u8d44"),
        SIX(6, "\u7269\u8d44");

        private Integer code;
        private String codeDesc;

        private SaeTypeEnum(Integer code, String codeDesc) {
            this.code = code;
            this.codeDesc = codeDesc;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getCodeDesc() {
            return this.codeDesc;
        }

        public static String getCodeDesc(Integer value) {
            for (SaeTypeEnum fscInvoiceStateEnum : SaeTypeEnum.values()) {
                if (!fscInvoiceStateEnum.getCode().equals(value)) continue;
                return fscInvoiceStateEnum.getCodeDesc();
            }
            return null;
        }
    }
}

