/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.utils;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uac.exception.BusinessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ExportExcel {
    private static final Logger log = LoggerFactory.getLogger(ExportExcel.class);

    public static String createExcel(Workbook workbook) {
        String path = System.getProperty("user.dir") + "/temporaryfile/" + UUID.randomUUID().toString() + ".xlsx";
        File file = new File(path);
        File fileParent = file.getParentFile();
        if (!fileParent.exists()) {
            fileParent.mkdirs();
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            try {
                workbook.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new BusinessException("8888", "\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25" + e);
        }
        try {
            workbook.write((OutputStream)fout);
        }
        catch (IOException e) {
            throw new BusinessException("8888", "exl\u5185\u5bb9\u5199\u5165\u5931\u8d25" + e);
        }
        finally {
            try {
                workbook.close();
                fout.close();
            }
            catch (IOException iOException) {}
        }
        return path;
    }

    public static Workbook createWorkbook(String[] field, String[] title, String list) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = null;
        int n = 0;
        try {
            sheet = workbook.createSheet();
            workbook.setSheetName(n, "sheet1");
            workbook.setSelectedTab(0);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u521b\u5efasheet\u5931\u8d25");
        }
        assert (sheet != null);
        CellStyle style = workbook.createCellStyle();
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        Row row0 = sheet.createRow(0);
        for (int i = 0; i < title.length; ++i) {
            Cell cell_1 = row0.createCell(i);
            cell_1.setCellValue(title[i]);
            cell_1.setCellStyle(style);
        }
        List result = JSONObject.parseArray((String)list, JSONObject.class);
        for (JSONObject map : result) {
            int index = sheet.getLastRowNum() + 1;
            Row row = sheet.createRow(index);
            for (int i = 0; i < title.length; ++i) {
                String titleField = field[i];
                Cell cell = row.createCell(i);
                cell.setCellValue(map.getString(titleField));
                cell.setCellStyle(style);
            }
        }
        return workbook;
    }

    /*
     * Could not resolve type clashes
     */
    public static Workbook createWorkbook(List<Map<String, Object>> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            throw new BusinessException("8888", "\u751f\u6210excel\u6587\u4ef6\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        workbook.setSelectedTab(0);
        int n = 0;
        for (Map<String, Object> dataMap : dataList) {
            Sheet sheet;
            List<Object> lockedList;
            List<Object> widths;
            String sheetName = dataMap.get("SHEET_NAME") == null ? "" : (String)dataMap.get("SHEET_NAME");
            String[] titles = dataMap.get("TITLES") == null ? new String[]{} : (String[])dataMap.get("TITLES");
            String[] headerTopDesc = dataMap.get("HEADER_TOP_DESC") == null ? new String[]{} : (String[])dataMap.get("HEADER_TOP_DESC");
            String[] headerFooterDesc = dataMap.get("HEADER_FOOTER_DESC") == null ? new String[]{} : (String[])dataMap.get("HEADER_FOOTER_DESC");
            short descFontColor = dataMap.get("DESC_FONT_COLOR") == null ? IndexedColors.RED.getIndex() : ((Short)dataMap.get("DESC_FONT_COLOR")).shortValue();
            String[] fields = dataMap.get("FIELDS") == null ? new String[]{} : (String[])dataMap.get("FIELDS");
            Object widthsObject = dataMap.get("WIDTHS");
            if (widthsObject == null) {
                widths = new ArrayList();
            } else if (widthsObject instanceof List) {
                List widthsList = (List)widthsObject;
                widths = widthsList.stream().map(item -> {
                    if (item instanceof Integer) {
                        return (Integer)item;
                    }
                    throw new BusinessException("8888", "WIDTHS\u6570\u636e\u7c7b\u578b\u4e0d\u5bf9");
                }).collect(Collectors.toList());
            } else {
                throw new BusinessException("8888", "WIDTHS\u6570\u636e\u7c7b\u578b\u4e0d\u5bf9");
            }
            ArrayList jsonList = dataMap.get("DATA") == null ? new ArrayList() : JSONObject.parseArray((String)((String)dataMap.get("DATA")), JSONObject.class);
            Object lockedListObject = dataMap.get("LOCKED_LIST");
            if (lockedListObject == null) {
                lockedList = new ArrayList();
            } else if (lockedListObject instanceof List) {
                List lockedListObjects = (List)lockedListObject;
                lockedList = lockedListObjects.stream().map(item -> {
                    if (item instanceof Integer) {
                        return (Integer)item;
                    }
                    throw new BusinessException("8888", "LOCKED_LIST\u6570\u636e\u7c7b\u578b\u4e0d\u5bf9");
                }).collect(Collectors.toList());
            } else {
                throw new BusinessException("8888", "LOCKED_LIST\u6570\u636e\u7c7b\u578b\u4e0d\u5bf9");
            }
            Object optionMapObject = dataMap.get("OPTION_MAP");
            HashMap<Integer, String[]> optionMap = new HashMap<Integer, String[]>();
            if (optionMapObject != null) {
                if (optionMapObject instanceof Map) {
                    Map optionMapObjects = (Map)optionMapObject;
                    if (!optionMapObjects.isEmpty()) {
                        for (Map.Entry entry : optionMapObjects.entrySet()) {
                            if (entry.getKey() instanceof Integer && entry.getValue() instanceof String[]) {
                                optionMap.put((Integer)entry.getKey(), (String[])entry.getValue());
                                continue;
                            }
                            throw new BusinessException("8888", "OPTION_MAP\u6570\u636e\u7c7b\u578b\u4e0d\u5bf9");
                        }
                    }
                } else {
                    throw new BusinessException("8888", "OPTION_MAP\u6570\u636e\u7c7b\u578b\u4e0d\u5bf9");
                }
            }
            Object extraLongMapObject = dataMap.get("EXTRA_LONG_MAP");
            HashMap<Integer, Integer> extraLongMap = new HashMap<Integer, Integer>();
            if (optionMapObject != null) {
                if (extraLongMapObject instanceof Map) {
                    Map extraLongMapObjects = (Map)extraLongMapObject;
                    if (!extraLongMapObjects.isEmpty()) {
                        for (String[] entry : extraLongMapObjects.entrySet()) {
                            if (entry.getKey() instanceof Integer && entry.getValue() instanceof Integer) {
                                extraLongMap.put((Integer)entry.getKey(), (Integer)entry.getValue());
                                continue;
                            }
                            throw new BusinessException("8888", "EXTRA_LONG_MAP\u6570\u636e\u7c7b\u578b\u4e0d\u5bf9");
                        }
                    }
                } else {
                    throw new BusinessException("8888", "EXTRA_LONG_MAP\u6570\u636e\u7c7b\u578b\u4e0d\u5bf9");
                }
            }
            if (!StringUtils.hasText((String)sheetName)) {
                throw new BusinessException("8888", "SHEET_NAME\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (titles.length == 0 || fields.length == 0 || fields.length != titles.length) {
                throw new BusinessException("8888", "TITLES\u4e3a\u7a7a\u6216\u8005FIELDS\u4e3a\u7a7a\u6216\u8005\u4e24\u8005\u957f\u5ea6\u4e0d\u7b49\u4e8e");
            }
            if (!CollectionUtils.isEmpty(widths) && widths.size() != titles.length) {
                throw new BusinessException("8888", "\u8bf7\u786e\u8ba4\u662f\u5426\u6bcf\u4e00\u5217\u90fd\u8bbe\u7f6e\u4e86WIDTHS");
            }
            try {
                sheet = workbook.createSheet();
                workbook.setSheetName(n, sheetName);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u521b\u5efasheet\u5931\u8d25\uff1a" + e.getMessage());
            }
            sheet.protectSheet("");
            for (int i = 0; i < widths.size(); ++i) {
                sheet.setColumnWidth(i, (Integer)widths.get(i) * 256);
            }
            StringBuilder completeTopDesc = new StringBuilder();
            for (String topDesc : headerTopDesc) {
                completeTopDesc.append(topDesc).append("\n");
            }
            int titlesIndex = 0;
            if (completeTopDesc.length() > 0) {
                CellStyle style = ExportExcel.getCellStyle((Workbook)workbook);
                Row row = sheet.createRow(titlesIndex);
                row.setHeightInPoints((float)(13.5 * (double)(headerTopDesc.length + 1)));
                Cell cell = row.createCell(0);
                cell.setCellValue(completeTopDesc.toString());
                style.setVerticalAlignment(VerticalAlignment.TOP);
                style.setAlignment(HorizontalAlignment.LEFT);
                style.setWrapText(true);
                cell.setCellStyle(style);
                Font font = workbook.createFont();
                font.setColor(descFontColor);
                style.setFont(font);
                style.setLocked(true);
                int i = titles.length - 1;
                if ("\u5931\u8d25\u539f\u56e0".equals(titles[i]) && "\u5bfc\u5165\u7ed3\u679c".equals(titles[i - 1])) {
                    i -= 2;
                }
                ExportExcel.merge(sheet, titlesIndex, titlesIndex, 0, i);
                ++titlesIndex;
            }
            Row titlesRow = sheet.createRow(titlesIndex);
            for (int i = 0; i < titles.length; ++i) {
                XSSFCell cell_1 = (XSSFCell)titlesRow.createCell(i);
                String title = titles[i];
                if (title.contains("*")) {
                    int asteriskIndex = title.indexOf("*");
                    XSSFRichTextString richText = new XSSFRichTextString(title);
                    Font redFont = workbook.createFont();
                    redFont.setColor(IndexedColors.RED.getIndex());
                    richText.applyFont(asteriskIndex, asteriskIndex + 1, redFont);
                    Font blackFont = workbook.createFont();
                    blackFont.setColor(IndexedColors.BLACK.getIndex());
                    richText.applyFont(asteriskIndex + 2, title.length() - 1, blackFont);
                    cell_1.setCellValue((RichTextString)richText);
                } else {
                    cell_1.setCellValue(title);
                }
                CellStyle style = ExportExcel.getCellStyle((Workbook)workbook);
                style.setLocked(true);
                cell_1.setCellStyle(style);
            }
            for (String[] extraLongEntry : extraLongMap.entrySet()) {
                Integer index = (Integer)extraLongEntry.getKey();
                Integer extraLong = (Integer)extraLongEntry.getValue();
                DataValidationHelper validationHelper = sheet.getDataValidationHelper();
                DataValidationConstraint lengthConstraint = validationHelper.createTextLengthConstraint(0, "0", String.valueOf(extraLong));
                CellRangeAddressList addressList = new CellRangeAddressList(0, 65535, index.intValue(), index.intValue());
                DataValidation dataValidation = validationHelper.createValidation(lengthConstraint, addressList);
                dataValidation.setShowErrorBox(true);
                dataValidation.createErrorBox("\u8f93\u5165\u957f\u5ea6\u8fc7\u957f", "\u8f93\u5165\u7684\u6587\u672c\u957f\u5ea6\u8d85\u8fc7\u4e86\u5141\u8bb8\u7684\u6700\u5927\u957f\u5ea6" + extraLong + "\u4e2a\u5b57\u7b26\uff0c\u8bf7\u7f29\u77ed\u6587\u672c\u957f\u5ea6\u3002");
                sheet.addValidationData(dataValidation);
            }
            StringBuilder completeFooterDesc = new StringBuilder();
            for (String footerDesc : headerFooterDesc) {
                completeFooterDesc.append(footerDesc).append("\n");
            }
            if (completeFooterDesc.length() > 0) {
                CellStyle style = ExportExcel.getCellStyle((Workbook)workbook);
                int index = sheet.getLastRowNum() + 1;
                Row row = sheet.createRow(index);
                row.setHeightInPoints((float)(13.5 * (double)(headerFooterDesc.length + 1)));
                Cell cell = row.createCell(0);
                cell.setCellValue(completeFooterDesc.toString());
                style.setVerticalAlignment(VerticalAlignment.TOP);
                style.setAlignment(HorizontalAlignment.LEFT);
                style.setWrapText(true);
                cell.setCellStyle(style);
                Font font = workbook.createFont();
                font.setColor(descFontColor);
                style.setFont(font);
                style.setLocked(true);
                int i = titles.length - 1;
                if ("\u5931\u8d25\u539f\u56e0".equals(titles[i]) && "\u5bfc\u5165\u7ed3\u679c".equals(titles[i - 1])) {
                    i -= 2;
                }
                ExportExcel.merge(sheet, index, index, 0, i - 1);
            }
            int number = 1;
            CellStyle lockedStyle = ExportExcel.getCellStyle((Workbook)workbook);
            lockedStyle.setLocked(true);
            CellStyle unLockedStyle = ExportExcel.getCellStyle((Workbook)workbook);
            unLockedStyle.setLocked(false);
            for (JSONObject map : jsonList) {
                int index = sheet.getLastRowNum() + 1;
                Row row = sheet.createRow(index);
                for (int i = 0; i < titles.length; ++i) {
                    String titleField = fields[i];
                    Cell cell = row.createCell(i);
                    if ("number".equals(titleField)) {
                        cell.setCellValue((double)number);
                    } else {
                        cell.setCellValue(map.getString(titleField));
                    }
                    String[] options = (String[])optionMap.get(i);
                    if (options != null) {
                        ExportExcel.setDropdownColumn(sheet, options, cell);
                    }
                    if (lockedList.contains(i)) {
                        cell.setCellStyle(lockedStyle);
                        continue;
                    }
                    cell.setCellStyle(unLockedStyle);
                }
                ++number;
            }
            CellStyle rowStyle = workbook.createCellStyle();
            rowStyle.setLocked(false);
            if (jsonList.isEmpty()) {
                int index = sheet.getLastRowNum() + 1;
                int loopRowsCount = 60000;
                for (int i = 0; i < fields.length; ++i) {
                    if (!lockedList.isEmpty() && lockedList.contains(i)) continue;
                    sheet.setDefaultColumnStyle(i, rowStyle);
                }
                if (!optionMap.isEmpty()) {
                    for (Map.Entry<Integer, String[]> integerEntry : optionMap.entrySet()) {
                        String[] options = (String[])integerEntry.getValue();
                        if (null == options || options.length <= 0) continue;
                        ExportExcel.setDropdownRaw(sheet, integerEntry, loopRowsCount, index);
                    }
                }
            }
            ++n;
        }
        return workbook;
    }

    public static void setDropdownColumn(Sheet sheet, String[] options, Cell cell) {
        CellRangeAddressList addressList;
        DataValidationConstraint constraint;
        DataValidationHelper validationHelper = sheet.getDataValidationHelper();
        DataValidation validation = validationHelper.createValidation(constraint = validationHelper.createExplicitListConstraint(options), addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex()));
        if (validation instanceof XSSFDataValidation) {
            validation.setSuppressDropDownArrow(true);
            validation.setShowErrorBox(true);
        } else {
            validation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(validation);
    }

    public static void setDropdownRaw(Sheet sheet, Map.Entry<Integer, String[]> integerEntry, int loopRowsCount, int index) {
        CellRangeAddressList addressList;
        DataValidationConstraint constraint;
        DataValidationHelper validationHelper = sheet.getDataValidationHelper();
        DataValidation validation = validationHelper.createValidation(constraint = validationHelper.createExplicitListConstraint(integerEntry.getValue()), addressList = new CellRangeAddressList(index, index + loopRowsCount, integerEntry.getKey().intValue(), integerEntry.getKey().intValue()));
        if (validation instanceof XSSFDataValidation) {
            validation.setSuppressDropDownArrow(true);
            validation.setShowErrorBox(true);
        } else {
            validation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(validation);
    }

    private static CellStyle getCellStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.LEFT);
        return style;
    }

    public static void merge(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cra = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        sheet.addMergedRegion(cra);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
    }

    public static void merge(Workbook workbook, Integer same, Integer merge) {
        Sheet sheet = workbook.getSheetAt(0);
        if (sheet.getLastRowNum() == 1) {
            return;
        }
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            Row data;
            Row row = sheet.getRow(i);
            String content = row.getCell(same.intValue()).getStringCellValue();
            int index = 0;
            int j = i + 1;
            while (j <= sheet.getLastRowNum() && content.equals((data = sheet.getRow(j)).getCell(same.intValue()).getStringCellValue())) {
                index = j++;
            }
            if (index == 0) continue;
            CellRangeAddress cra = new CellRangeAddress(i, index, merge.intValue(), merge.intValue());
            sheet.addMergedRegion(cra);
            i = index;
        }
    }
}

