/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.contract.ability.ContractDetailForPlanAbilityService;
import com.tydic.contract.ability.bo.CContractInfoErpBO;
import com.tydic.contract.ability.bo.ContractDetailForPlanAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailForPlanAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.ability.bo.PushPlanErpItem;
import com.tydic.contract.busi.ContractItemQueryBusiService;
import com.tydic.contract.busi.bo.ContractItemQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemQueryBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoExtendMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractScopeMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractScope;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQueryAbilityService;
import com.tydic.umc.general.ability.api.UmcMemDetailQueryAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityRspBO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractDetailForPlanAbilityService"})
public class ContractDetailForPlanAbilityServiceImpl
implements ContractDetailForPlanAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractDetailForPlanAbilityServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private ContractInfoExtendMapper contractInfoExtendMapper;
    @Autowired
    private ContractItemQueryBusiService contractItemQueryBusiService;
    @Autowired
    private ContractScopeMapper contractScopeMapper;
    @Autowired
    private UmcEnterpriseOrgQueryAbilityService umcEnterpriseOrgQueryAbilityService;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;

    @PostMapping(value={"qryContractDetailListExternal"})
    public ContractDetailForPlanAbilityRspBO qryContractDetailListExternal(@RequestBody ContractDetailForPlanAbilityReqBO reqBo) {
        ContractDetailForPlanAbilityRspBO rspBo = new ContractDetailForPlanAbilityRspBO();
        ContractInfoPO qryContractInfoPo = new ContractInfoPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryContractInfoPo);
        qryContractInfoPo.setContractIds(reqBo.getAgreementIdList());
        qryContractInfoPo.setContractStatusList(reqBo.getAgreementStatusList());
        Page page = PageHelper.startPage((int)reqBo.getPageNo(), (int)reqBo.getPageSize()).doSelectPage(() -> this.contractInfoExtendMapper.getContractListByCondition(qryContractInfoPo));
        if (CollectionUtils.isEmpty((Collection)page.getResult())) {
            rspBo.setRows(new ArrayList(0));
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List contractInfoPOS = page.getResult();
        ArrayList purchaseType = Lists.newArrayList((Object[])new Integer[]{11, 12, 13, 20, 21});
        ArrayList JsType = Lists.newArrayList((Object[])new Integer[]{12});
        ArrayList<CContractInfoErpBO> cContractInfoErpBOList = new ArrayList<CContractInfoErpBO>(contractInfoPOS.size());
        for (ContractInfoPO contractInfoPO : contractInfoPOS) {
            String buyerErpOrgCode;
            String failInfo = "";
            CContractInfoErpBO contractInfoErpBO = new CContractInfoErpBO();
            contractInfoErpBO.setConsignmentLabel(Integer.valueOf(0));
            if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType())) {
                contractInfoErpBO.setConsignmentLabel(Integer.valueOf(1));
            }
            contractInfoErpBO.setAgreementId(contractInfoPO.getContractId());
            contractInfoErpBO.setAgreementName(contractInfoPO.getContractName());
            if (purchaseType.contains(contractInfoPO.getContractType())) {
                contractInfoErpBO.setAgreementSrc(Byte.valueOf((byte)2));
            } else {
                contractInfoErpBO.setAgreementSrc(Byte.valueOf((byte)1));
            }
            if (JsType.contains(contractInfoPO.getContractType())) {
                contractInfoErpBO.setAgreementType(Byte.valueOf((byte)1));
            } else {
                contractInfoErpBO.setAgreementType(Byte.valueOf((byte)2));
            }
            contractInfoErpBO.setAgreementStatus(Byte.valueOf((byte)contractInfoPO.getContractStatus().intValue()));
            if (!(contractInfoPO.getContractSignDate() != null && contractInfoPO.getValidaType() != null && contractInfoPO.getValidaNum() != null || contractInfoPO.getContractValidTime() != null && contractInfoPO.getContractSignDate() != null)) {
                failInfo = failInfo + "\u5408\u540c\u751f\u6548\u65e5\u671f\u4e3a\u7a7a;";
            } else if (contractInfoPO.getContractValidTime() != null) {
                contractInfoErpBO.setEffDate(contractInfoPO.getContractSignDate());
                if (ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER.equals(contractInfoPO.getContractStatus())) {
                    contractInfoErpBO.setExpDate(contractInfoPO.getContractValidTime());
                } else {
                    contractInfoErpBO.setExpDate(contractInfoPO.getContractValidTime());
                }
            } else {
                Calendar c = Calendar.getInstance();
                c.setTime(contractInfoPO.getContractSignDate());
                contractInfoErpBO.setEffDate(contractInfoPO.getContractSignDate());
                if (ContractConstant.TermOfValidityType.MONTHS.equals(contractInfoPO.getValidaType())) {
                    c.add(2, contractInfoPO.getValidaNum());
                } else if (ContractConstant.TermOfValidityType.YEARS.equals(contractInfoPO.getValidaType())) {
                    c.add(1, contractInfoPO.getValidaNum());
                } else {
                    failInfo = failInfo + "\u5408\u540c\u751f\u6548\u65e5\u671f\u4e3a\u7a7a;";
                }
                contractInfoErpBO.setExpDate(c.getTime());
            }
            if (!StringUtils.isEmpty((Object)contractInfoPO.getBuyerNo()) && !StringUtils.isEmpty((Object)(buyerErpOrgCode = this.getErpOrgCode(contractInfoPO.getBuyerNo())))) {
                contractInfoErpBO.setOuList((List)Lists.newArrayList((Object[])new String[]{buyerErpOrgCode}));
            }
            ContractScope contractScope = new ContractScope();
            contractScope.setRelateId(contractInfoPO.getContractId());
            contractScope.setIsDelete(0);
            List<ContractScope> contractScopes = this.contractScopeMapper.queryAll(contractScope);
            if (!CollectionUtils.isEmpty(contractScopes)) {
                List ouList = contractInfoErpBO.getOuList();
                List collect = contractScopes.stream().map(ContractScope::getExtFiled1).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty((Collection)ouList)) {
                    contractInfoErpBO.getOuList().addAll(collect);
                } else {
                    contractInfoErpBO.setOuList(collect);
                }
            }
            if (contractInfoPO.getAmountLimit() != null) {
                contractInfoErpBO.setAmountLimit(MoneyUtils.haoToYuan(contractInfoPO.getAmountLimit()));
            }
            if (contractInfoPO.getOrderAmount() != null) {
                contractInfoErpBO.setOrderAmount(MoneyUtils.haoToYuan(contractInfoPO.getOrderAmount()));
            }
            contractInfoErpBO.setIsDelete(Byte.valueOf((byte)0));
            if (!StringUtils.isEmpty((Object)contractInfoPO.getTrackNo())) {
                contractInfoErpBO.setPlaAgreementCode(contractInfoPO.getTrackNo());
            } else if (!StringUtils.isEmpty((Object)contractInfoPO.getContractCode())) {
                contractInfoErpBO.setPlaAgreementCode(contractInfoPO.getContractCode());
            } else {
                failInfo = failInfo + "\u5408\u540c\u8ddf\u8e2a\u53f7\u548c\u5408\u540c\u7f16\u53f7\u90fd\u4e3a\u7a7a;";
            }
            contractInfoErpBO.setProducerCode(contractInfoPO.getCreateUserCode());
            contractInfoErpBO.setProducerId(this.getMemErp(contractInfoPO.getCreateUserId()));
            contractInfoErpBO.setProducerName(contractInfoPO.getCreateUserName());
            contractInfoErpBO.setRemark(contractInfoPO.getRemark());
            contractInfoErpBO.setScopeType(Byte.valueOf((byte)0));
            contractInfoErpBO.setSignTime(contractInfoPO.getContractSignDate());
            contractInfoErpBO.setSupplierId(this.getMemErp(contractInfoPO.getCreateDeptId()));
            contractInfoErpBO.setSupplierName(contractInfoPO.getCreateDeptName());
            contractInfoErpBO.setUpdateLoginId(Long.valueOf(1L));
            contractInfoErpBO.setUpdateName(contractInfoPO.getUpdateUserName());
            contractInfoErpBO.setUpdateTime(contractInfoPO.getUpdateTime());
            String erpOrgCode = this.getOrgErpCode(contractInfoPO.getSupplierId());
            if (!StringUtils.isEmpty((Object)erpOrgCode)) {
                contractInfoErpBO.setVendorCode(erpOrgCode);
                contractInfoErpBO.setVendorId(erpOrgCode);
            } else {
                contractInfoErpBO.setVendorCode(contractInfoPO.getSupplierCode());
                contractInfoErpBO.setVendorId(contractInfoPO.getSupplierCode());
            }
            contractInfoErpBO.setVendorName(contractInfoPO.getSupplierName());
            ArrayList<PushPlanErpItem> childEntityList = new ArrayList<PushPlanErpItem>();
            ContractItemQueryBusiReqBO contractItemQueryBusiReqBO = new ContractItemQueryBusiReqBO();
            contractItemQueryBusiReqBO.setContractId(contractInfoPO.getContractId());
            contractItemQueryBusiReqBO.setPageNo(0);
            contractItemQueryBusiReqBO.setPageSize(0);
            ContractItemQueryBusiRspBO contractItemQueryBusiRspBO = this.contractItemQueryBusiService.contractItemQuery(contractItemQueryBusiReqBO);
            if (!"0000".equals(contractItemQueryBusiRspBO.getRespCode())) {
                failInfo = failInfo + "\u5408\u540c\u660e\u7ec6\u5217\u8868\u83b7\u53d6\u5931\u8d25;";
                log.error(failInfo);
            } else {
                for (ContractItemAbilityBO row : contractItemQueryBusiRspBO.getRows()) {
                    PushPlanErpItem sh = new PushPlanErpItem();
                    sh.setAgreementId(contractInfoPO.getContractId());
                    sh.setAgreementSkuId(row.getItemId());
                    sh.setCreateLoginId(contractInfoErpBO.getProducerId());
                    sh.setCreateName(contractInfoErpBO.getProducerName());
                    sh.setCreateTime(contractInfoErpBO.getEffDate());
                    sh.setEffDate(contractInfoErpBO.getEffDate());
                    sh.setExpDate(contractInfoErpBO.getExpDate());
                    sh.setMaterialCode(row.getMaterialCode());
                    sh.setMaterialId(row.getMaterialId() + "");
                    sh.setMaterialName(row.getMaterialName());
                    sh.setRemark(row.getRemark());
                    sh.setIsDelete(Byte.valueOf((byte)0));
                    if (row.getSaleStatus() != null && row.getSaleStatus() == 3) {
                        sh.setExpDate(new Date());
                    }
                    try {
                        sh.setSalePrice(row.getUnitPriceExcludingTax().stripTrailingZeros());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sh.setSkuStatus(row.getSaleStatus());
                    sh.setTaxRate(row.getRate());
                    sh.setUpdateLoginId(Long.valueOf(1L));
                    sh.setUpdateName(contractInfoErpBO.getUpdateName());
                    sh.setUpdateTime(contractInfoErpBO.getUpdateTime());
                    childEntityList.add(sh);
                }
                contractInfoErpBO.setChildEntityList(childEntityList);
            }
            cContractInfoErpBOList.add(contractInfoErpBO);
        }
        rspBo.setRows(cContractInfoErpBOList);
        rspBo.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBo.setTotal(Integer.valueOf(page.getPages()));
        rspBo.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String getErpOrgCode(String orgCode) {
        UmcEnterpriseOrgQueryAbilityReqBO reqBO = new UmcEnterpriseOrgQueryAbilityReqBO();
        reqBO.setOrgCodeWeb(orgCode);
        log.info("\u4f1a\u5458\u673a\u6784\u8be6\u60c5\u67e5\u8be2\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)reqBO));
        UmcEnterpriseOrgDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(reqBO);
        log.info("\u4f1a\u5458\u673a\u6784\u8be6\u60c5\u67e5\u8be2\u51fa\u53c2 {}", (Object)JSON.toJSONString((Object)abilityRspBO));
        if (abilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            return abilityRspBO.getUmcEnterpriseOrgAbilityBO().getErpOrgCode();
        }
        return null;
    }

    private String getOrgErpCode(Long orgId) {
        UmcEnterpriseOrgQueryAbilityReqBO reqBO = new UmcEnterpriseOrgQueryAbilityReqBO();
        reqBO.setOrgIdWeb(orgId);
        log.info("\u4f1a\u5458\u673a\u6784\u8be6\u60c5\u67e5\u8be2\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)reqBO));
        UmcEnterpriseOrgDetailAbilityRspBO abilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(reqBO);
        log.info("\u4f1a\u5458\u673a\u6784\u8be6\u60c5\u67e5\u8be2\u51fa\u53c2 {}", (Object)JSON.toJSONString((Object)abilityRspBO));
        if (abilityRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            return abilityRspBO.getUmcEnterpriseOrgAbilityBO().getErpOrgCode();
        }
        return null;
    }

    private String getMemErp(Long memId) {
        UmcMemDetailQueryAbilityReqBO reqBO = new UmcMemDetailQueryAbilityReqBO();
        reqBO.setMemId(memId);
        log.info("\u4f1a\u5458\u8be6\u60c5\u67e5\u8be2\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)reqBO));
        UmcMemDetailQueryAbilityRspBO abilityRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(reqBO);
        log.info("\u4f1a\u5458\u8be6\u60c5\u67e5\u8be2\u51fa\u53c2 {}", (Object)JSON.toJSONString((Object)abilityRspBO));
        if (abilityRspBO.getUmcMemDetailInfoAbilityRspBO() != null) {
            UmcMemDetailInfoAbilityBO abilityBO = abilityRspBO.getUmcMemDetailInfoAbilityRspBO();
            return abilityBO.getAgentAccount();
        }
        return null;
    }
}

