/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractQryHtAllocationListAbilityService;
import com.tydic.contract.ability.bo.ContractListNewBO;
import com.tydic.contract.ability.bo.ContractQryHtAllocationListAbilityReqBO;
import com.tydic.contract.ability.bo.ContractQryHtAllocationListAbilityRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.DateTimeUtils;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.DycUmcQueryBuyerPermissionService;
import com.tydic.umc.general.ability.api.DycUmcQueryMaterialPermissionService;
import com.tydic.umc.general.ability.api.DycUmcQueryOrgPermissionService;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionBO;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionReqBo;
import com.tydic.umc.general.ability.bo.DycUmcQueryBuyerPermissionRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractQryHtAllocationListAbilityService"})
public class ContractQryHtAllocationListAbilityServiceImpl
implements ContractQryHtAllocationListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryHtAllocationListAbilityServiceImpl.class);
    @Value(value="${DEVELOP_COMPANY_DEPARTMENT}")
    private String developCompanyDepartment;
    @Autowired
    private DycUmcQueryMaterialPermissionService dycUmcQueryMaterialPermissionService;
    @Autowired
    private DycUmcQueryOrgPermissionService dycUmcQueryOrgPermissionService;
    @Autowired
    private DycUmcQueryBuyerPermissionService dycUmcQueryBuyerPermissionService;
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @PostMapping(value={"qryHtAllocationList"})
    public ContractQryHtAllocationListAbilityRspBO qryHtAllocationList(@RequestBody ContractQryHtAllocationListAbilityReqBO reqBO) {
        ContractQryHtAllocationListAbilityRspBO rspBO = new ContractQryHtAllocationListAbilityRspBO();
        if (!StringUtils.isEmpty((Object)reqBO.getUsername()) && StringUtils.isEmpty((Object)reqBO.getOccupation())) {
            reqBO.setOccupation(reqBO.getUsername());
        }
        Integer buyerPermission = null;
        ArrayList<Integer> contractTypes = new ArrayList<Integer>();
        contractTypes.add(ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE);
        contractTypes.add(ContractConstant.ContractType.SPOT_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.ORDER_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.FUNCTION_SPOTS_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_TRADE_ORDER_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_NO_TRADE_ORDER_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT);
        contractTypes.add(ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT);
        buyerPermission = 1;
        ContractInfoPO queryContractPo = new ContractInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)queryContractPo);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getContractTypes())) {
            Boolean checkContractType = false;
            for (Integer contractType : reqBO.getContractTypes()) {
                if (contractTypes.contains(contractType)) continue;
                checkContractType = true;
                break;
            }
            if (checkContractType.booleanValue()) {
                log.error("\u4f20\u5165\u7684\u5408\u540c\u7c7b\u578b\u4e0d\u6ee1\u8db3\u5f53\u524d\u6309\u7167\u7528\u6237\u533a\u5206\u7684\u5408\u540c\u7c7b\u578b");
                queryContractPo.setContractTypes(contractTypes);
            }
        } else {
            queryContractPo.setContractTypes(contractTypes);
        }
        if (buyerPermission != null && buyerPermission == 1) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getOccupation())) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u7528\u6237\u7684Occupation\u7f16\u7801\u4e3a\u7a7a");
                rspBO.setRows(null);
                rspBO.setPageNo(Integer.valueOf(1));
                rspBO.setTotal(Integer.valueOf(0));
                rspBO.setRecordsTotal(Integer.valueOf(0));
                return rspBO;
            }
            DycUmcQueryBuyerPermissionReqBo dycUmcQueryBuyerPermissionReqBo = new DycUmcQueryBuyerPermissionReqBo();
            dycUmcQueryBuyerPermissionReqBo.setErpCode(reqBO.getOccupation());
            DycUmcQueryBuyerPermissionRspBo dycUmcQueryBuyerPermissionRspBo = this.dycUmcQueryBuyerPermissionService.queryBuyerPermission(dycUmcQueryBuyerPermissionReqBo);
            if ("0000".equals(dycUmcQueryBuyerPermissionRspBo.getRespCode())) {
                List buyerPermissionRspBoRows = dycUmcQueryBuyerPermissionRspBo.getRows();
                List<String> orgCodes = buyerPermissionRspBoRows.stream().filter(e -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)e.getOrgCode())).map(DycUmcQueryBuyerPermissionBO::getOrgCode).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(orgCodes)) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u4e70\u53d7\u4eba\u6743\u9650\u6743\u9650\u4e3a\u7a7a");
                    rspBO.setRows(null);
                    rspBO.setPageNo(Integer.valueOf(1));
                    rspBO.setTotal(Integer.valueOf(0));
                    rspBO.setRecordsTotal(Integer.valueOf(0));
                    return rspBO;
                }
                queryContractPo.setBuyerNos(orgCodes);
            } else {
                throw new ZTBusinessException("\u67e5\u8be2\u4e70\u53d7\u4eba\u6743\u9650\u5931\u8d25" + dycUmcQueryBuyerPermissionRspBo.getRespDesc());
            }
        }
        log.info("-----------\u67e5\u8be2\u5408\u540c\u5217\u8868\u5165\u53c2\uff1a" + JSON.toJSONString((Object)queryContractPo));
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.contractInfoMapper.qryHtAllocationList(queryContractPo));
        List<ContractListNewBO> rows = this.transContractResult(page.getResult());
        rows.forEach(contractListNewBO -> {
            this.dealData((ContractListNewBO)contractListNewBO);
            if (contractListNewBO.getTotalTaxAmount() != null) {
                contractListNewBO.setTotalTaxAmount(contractListNewBO.getTotalTaxAmount().setScale(2, 4));
            }
            if (contractListNewBO.getTotalAmountExcludingTax() != null) {
                contractListNewBO.setTotalAmountExcludingTax(contractListNewBO.getTotalAmountExcludingTax().setScale(2, 4));
            }
            if (contractListNewBO.getPurchaseTotalTaxAmount() != null) {
                contractListNewBO.setPurchaseTotalTaxAmount(contractListNewBO.getPurchaseTotalTaxAmount().setScale(2, 4));
            }
            if (contractListNewBO.getAmountLimit() != null) {
                contractListNewBO.setAmountLimit(MoneyUtils.haoToYuan(contractListNewBO.getAmountLimit()));
            }
            if (contractListNewBO.getOrderAmount() != null) {
                contractListNewBO.setOrderAmount(MoneyUtils.haoToYuan(contractListNewBO.getOrderAmount()));
            }
        });
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u5217\u8868\u67e5\u8be2\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        return rspBO;
    }

    private List<ContractListNewBO> transContractResult(List<ContractInfoPO> list) {
        String resultJsonStr = JSON.toJSONString(list);
        List rows = JSONArray.parseArray((String)resultJsonStr).toJavaList(ContractListNewBO.class);
        for (ContractListNewBO contractListNewBO : rows) {
            contractListNewBO.setCreateTime(DateTimeUtils.Date2String(contractListNewBO.getCreateTime()));
            contractListNewBO.setContractApprovalTime(DateTimeUtils.Date2String(contractListNewBO.getContractApprovalTime()));
            if (contractListNewBO.getContractStatus() != null) {
                contractListNewBO.setContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListNewBO.getContractStatus()));
            }
            if (contractListNewBO.getContractEffectiveDate() != null) {
                contractListNewBO.setContractEffectiveDateStr(DateTimeUtils.DateChange(contractListNewBO.getContractEffectiveDate()));
            }
            if (contractListNewBO.getContractEndDateStart() != null) {
                contractListNewBO.setContractEndDateStartStr(DateTimeUtils.DateChange(contractListNewBO.getContractEndDateStart()));
            }
            String createInfoStr = contractListNewBO.getCreateUserName() + "/" + contractListNewBO.getCreateUserCode();
            contractListNewBO.setCreateInfoStr(createInfoStr);
            if (contractListNewBO.getPurchaseContractStatus() != null) {
                contractListNewBO.setPurchaseContractStatusStr(ContractTransFieldUtil.transContractStatus(contractListNewBO.getPurchaseContractStatus()));
            }
            if (contractListNewBO.getContractType() != null) {
                String contractTypeStr = ContractQryHtAllocationListAbilityServiceImpl.transContractTypeHTDesc(contractListNewBO.getContractType());
                contractListNewBO.setContractTypeStr(contractTypeStr);
                contractListNewBO.setContractYgTypeStr(ContractTransFieldUtil.transContractType(contractListNewBO.getContractType()));
            }
            if (!StringUtils.isEmpty((Object)contractListNewBO.getOutContractId())) {
                contractListNewBO.setContractSourceStr("\u667a\u63a7\u5408\u540c");
            } else {
                contractListNewBO.setContractSourceStr("\u6613\u8d2d\u7cfb\u7edf");
            }
            if (contractListNewBO.getPurchaseType() != null) {
                contractListNewBO.setPurchaseTypeStr(ContractTransFieldUtil.transContractPurchaseType(contractListNewBO.getPurchaseType()));
            }
            if (contractListNewBO.getPushErpStatus() != null) {
                contractListNewBO.setPushErpStatusStr(ContractTransFieldUtil.transPushErpStatus(contractListNewBO.getPushErpStatus()));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractListNewBO.getErpSyncStauts())) {
                contractListNewBO.setErpSyncStautsStr(ContractTransFieldUtil.transContractErpSyncStauts(contractListNewBO.getErpSyncStauts()));
            }
            if (contractListNewBO.getPushPlanStatus() != null) {
                if (contractListNewBO.getPushErpStatus() != null) {
                    if (!ContractConstant.PushErpStatus.IN_SYNC.equals(contractListNewBO.getPushErpStatus()) && (ContractConstant.PushErpStatus.FAIL_SYNC.equals(contractListNewBO.getPushPlanStatus()) || ContractConstant.PushErpStatus.IN_SYNC.equals(contractListNewBO.getPushPlanStatus()))) {
                        contractListNewBO.setPushErpStatus(contractListNewBO.getPushPlanStatus());
                        contractListNewBO.setPushErpStatusStr(ContractTransFieldUtil.transPushErpStatus(contractListNewBO.getPushErpStatus()));
                    }
                } else {
                    contractListNewBO.setPushErpStatus(contractListNewBO.getPushPlanStatus());
                    contractListNewBO.setPushErpStatusStr(ContractTransFieldUtil.transPushErpStatus(contractListNewBO.getPushErpStatus()));
                }
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contractListNewBO.getMaterialSource())) {
                contractListNewBO.setMaterialSourceStr(ContractTransFieldUtil.transContractMaterialSource(contractListNewBO.getMaterialSource()));
            }
            if (contractListNewBO.getBusinessType() != null) {
                contractListNewBO.setBusinessTypeStr(ContractTransFieldUtil.transBusinessType(contractListNewBO.getBusinessType()));
            }
            if (contractListNewBO.getSignatureFlag() != null) {
                contractListNewBO.setSignatureFlagStr(contractListNewBO.getSignatureFlag() == 1 ? "\u662f" : "\u5426");
            }
            if (contractListNewBO.getEffectWay() == null) continue;
            contractListNewBO.setEffectWayStr(contractListNewBO.getEffectWay() == 0 ? "\u624b\u52a8\u751f\u6548" : "\u7535\u5b50\u7b7e\u7ae0");
        }
        return rows;
    }

    protected void dealData(ContractListNewBO contractListNewBO) {
        ArrayList<Integer> executionStatus = new ArrayList<Integer>();
        ArrayList<String> executionStatusStr = new ArrayList<String>();
        if (contractListNewBO.getAmountLimit() != null && contractListNewBO.getOrderAmount() != null) {
            if (contractListNewBO.getOrderAmount().compareTo(contractListNewBO.getAmountLimit()) > 0) {
                executionStatus.add(ContractConstant.ExecutionStatus.EXECUTION_STATUS_CHAO);
                executionStatusStr.add("\u534f\u8bae\u6267\u884c\u989d\u5df2\u8d85");
            }
            if (contractListNewBO.getAmountLimit().multiply(new BigDecimal("0.7")).compareTo(contractListNewBO.getOrderAmount()) < 0) {
                executionStatus.add(ContractConstant.ExecutionStatus.EXECUTION_STATUS_DRAFT);
                executionStatusStr.add("\u534f\u8bae\u53ef\u6267\u884c\u4f59\u989d\u4e0d\u8db330%");
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 4);
        Date changeAfter = calendar.getTime();
        if (contractListNewBO.getContractValidTime() != null && new Date().before(contractListNewBO.getContractValidTime()) && changeAfter.after(contractListNewBO.getContractValidTime())) {
            executionStatus.add(ContractConstant.ExecutionStatus.EXECUTION_STATUS_NOT);
            executionStatusStr.add("\u534f\u8bae\u5230\u671f\u4e0d\u8db34\u6708");
        }
        contractListNewBO.setExecutionStatus(executionStatus);
        contractListNewBO.setExecutionStatusStr(executionStatusStr);
        if ((ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractListNewBO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractListNewBO.getContractType())) && !CollectionUtils.isEmpty(executionStatusStr) && ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT.equals(contractListNewBO.getContractStatus())) {
            contractListNewBO.setExecutionStatusStrExport(String.join((CharSequence)",", executionStatusStr));
        }
    }

    public static String transContractTypeHTDesc(Integer contractType) {
        if (contractType.equals(ContractConstant.ContractType.SPOT_CONTRACT) || contractType.equals(ContractConstant.ContractType.PURCHASE_TRADE_ORDER_CONTRACT) || contractType.equals(ContractConstant.ContractType.PURCHASE_NO_TRADE_ORDER_CONTRACT) || contractType.equals(ContractConstant.ContractType.PURCHASE_CONTRACT) || contractType.equals(ContractConstant.ContractType.ORDER_CONTRACT) || contractType.equals(ContractConstant.ContractType.PURCHASE_SPOT_CONTRACT) || contractType.equals(ContractConstant.ContractType.PURCHASE_ORDER_CONTRACT) || contractType.equals(ContractConstant.ContractType.PURCHASE_ORDER_NON_TRADE_CONTRACT) || contractType.equals(ContractConstant.ContractType.FUNCTION_SPOTS_CONTRACT)) {
            return "\u73b0\u8d27\u5408\u540c";
        }
        if (contractType.equals(ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE) || contractType.equals(ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT) || contractType.equals(ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT)) {
            return "\u6846\u67b6\u534f\u8bae(\u5b9a\u4ef7)";
        }
        if (contractType.equals(ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT)) {
            return "\u6846\u67b6\u534f\u8bae\uff08\u5bc4\u552e\uff09";
        }
        return null;
    }
}

