/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.contract.ability.ContractReplenishmentListQryAbilityService;
import com.tydic.contract.ability.bo.ContractReplenishmentListQryReqBo;
import com.tydic.contract.ability.bo.ContractReplenishmentListQryRspBo;
import com.tydic.contract.ability.bo.ContractReplenishmentListQryRspBoMaterialList;
import com.tydic.contract.ability.bo.ContractReplenishmentListQryRspBoMaterialListMatchList;
import com.tydic.contract.dao.CPendingReplenishmentMapper;
import com.tydic.contract.dao.CPendingReplenishmentMatchMapper;
import com.tydic.contract.po.CPendingReplenishmentMatchPO;
import com.tydic.contract.po.CPendingReplenishmentPO;
import com.tydic.uoc.common.ability.api.PebWmsQueryOrderCountAbilityService;
import com.tydic.uoc.common.ability.bo.PebWmsQueryOrderCountAbilityReqBO;
import com.tydic.uoc.common.ability.bo.PebWmsQueryOrderCountAbilityRspBO;
import com.tydic.uoc.common.ability.bo.PebWmsQueryOrderCountItemBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractReplenishmentListQryAbilityService"})
public class ContractReplenishmentListQryAbilityServiceImpl
implements ContractReplenishmentListQryAbilityService {
    @Autowired
    private CPendingReplenishmentMapper cPendingReplenishmentMapper;
    @Autowired
    private CPendingReplenishmentMatchMapper cPendingReplenishmentMatchMapper;
    @Autowired
    private PebWmsQueryOrderCountAbilityService pebWmsQueryOrderCountAbilityService;

    @PostMapping(value={"qryReplenishmentList"})
    public ContractReplenishmentListQryRspBo qryReplenishmentList(@RequestBody ContractReplenishmentListQryReqBo reqBo) {
        ContractReplenishmentListQryRspBo rspBo = new ContractReplenishmentListQryRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        CPendingReplenishmentPO cPendingReplenishmentPO = (CPendingReplenishmentPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), CPendingReplenishmentPO.class);
        cPendingReplenishmentPO.setIsDelete(0);
        Page page = PageHelper.startPage((int)reqBo.getPageNo(), (int)reqBo.getPageSize()).doSelectPage(() -> this.cPendingReplenishmentMapper.queryAllByLimit(cPendingReplenishmentPO));
        List poList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)poList)) {
            rspBo.setRows(new ArrayList());
            rspBo.setTotal(0);
            rspBo.setPageNo(0);
            rspBo.setRecordsTotal(0);
            return rspBo;
        }
        List rows = JSON.parseArray((String)JSONObject.toJSONString((Object)poList), ContractReplenishmentListQryRspBoMaterialList.class);
        List<Long> replenishmentIds = rows.stream().map(ContractReplenishmentListQryRspBoMaterialList::getId).collect(Collectors.toList());
        CPendingReplenishmentMatchPO matchPO = new CPendingReplenishmentMatchPO();
        matchPO.setReplenishmentIdList(replenishmentIds);
        List<CPendingReplenishmentMatchPO> matchPOList = this.cPendingReplenishmentMatchMapper.getList(matchPO);
        List matchList = JSON.parseArray((String)JSONObject.toJSONString(matchPOList), ContractReplenishmentListQryRspBoMaterialListMatchList.class);
        Map<Long, List<ContractReplenishmentListQryRspBoMaterialListMatchList>> matchMap = matchList.stream().collect(Collectors.groupingBy(ContractReplenishmentListQryRspBoMaterialListMatchList::getReplenishmentId));
        ArrayList<PebWmsQueryOrderCountItemBO> itemList = new ArrayList<PebWmsQueryOrderCountItemBO>();
        for (ContractReplenishmentListQryRspBoMaterialList bo : rows) {
            List<ContractReplenishmentListQryRspBoMaterialListMatchList> list = matchMap.get(bo.getId());
            bo.setMatchList(list);
            if (bo.getPurchaseCount() == null) {
                bo.setPurchaseCount(BigDecimal.ONE);
            }
            PebWmsQueryOrderCountItemBO itemBO = new PebWmsQueryOrderCountItemBO();
            itemBO.setOrganizationId(bo.getOrganizationId());
            itemBO.setSkuMaterialId(bo.getMaterialCode());
            itemList.add(itemBO);
        }
        PebWmsQueryOrderCountAbilityReqBO orderCountAbilityReqBO = new PebWmsQueryOrderCountAbilityReqBO();
        orderCountAbilityReqBO.setYcList(itemList);
        PebWmsQueryOrderCountAbilityRspBO orderCountAbilityRspBO = this.pebWmsQueryOrderCountAbilityService.queryOrderCount(orderCountAbilityReqBO);
        if ("0000".equals(orderCountAbilityRspBO.getRespCode())) {
            Map ycMap = orderCountAbilityRspBO.getYcMap();
            Iterator iterator = rows.iterator();
            while (iterator.hasNext()) {
                ContractReplenishmentListQryRspBoMaterialList bo;
                BigDecimal stockPendingNum = (BigDecimal)ycMap.get((bo = (ContractReplenishmentListQryRspBoMaterialList)iterator.next()).getOrganizationId() + bo.getMaterialCode());
                bo.setStockPendingNum(stockPendingNum == null ? BigDecimal.ZERO : stockPendingNum);
                BigDecimal suggestNum = bo.getSafeNum().subtract(bo.getRepertoryNum()).subtract(bo.getStockPendingNum());
                bo.setSuggestNum(suggestNum.compareTo(BigDecimal.ZERO) > 0 ? suggestNum : BigDecimal.ZERO);
            }
        }
        rspBo.setRows(rows);
        rspBo.setTotal(page.getPages());
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRecordsTotal(Integer.parseInt(String.valueOf(page.getTotal())));
        return rspBo;
    }
}

