/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.contract.ability.ContractToBeSettledListQryAbilityService;
import com.tydic.contract.ability.bo.CContractInfoBO;
import com.tydic.contract.ability.bo.ContractToBeSettledListQryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractToBeSettledListQryAbilityRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoMapper;
import com.tydic.contract.po.CContractInfoPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CONTRACT_GROUP/1.0.0/com.tydic.contract.ability.ContractToBeSettledListQryAbilityService"})
public class ContractToBeSettledListQryAbilityServiceImpl
implements ContractToBeSettledListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ContractToBeSettledListQryAbilityServiceImpl.class);
    @Autowired
    private CContractInfoMapper cContractInfoMapper;

    @PostMapping(value={"qryToBeSettledList"})
    public ContractToBeSettledListQryAbilityRspBO qryToBeSettledList(@RequestBody ContractToBeSettledListQryAbilityReqBO reqBO) {
        ContractToBeSettledListQryAbilityRspBO rspBO = new ContractToBeSettledListQryAbilityRspBO();
        if (Objects.isNull(reqBO) || Objects.isNull(reqBO.getQueryType())) {
            throw new ZTBusinessException("\u5165\u53c2\u67e5\u8be2\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        if (Integer.valueOf(3).equals(reqBO.getQueryType()) && CollectionUtil.isEmpty((Collection)reqBO.getQryContractIds())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        CContractInfoPO cContractInfoPO = (CContractInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), CContractInfoPO.class);
        if (Objects.nonNull(reqBO.getBusinessType()) && reqBO.getBusinessType() == 3) {
            cContractInfoPO.setIsJy(1);
        } else {
            cContractInfoPO.setMaterialCategory(reqBO.getBusinessType());
        }
        cContractInfoPO.setBusinessType(null);
        cContractInfoPO.setPayType(ContractConstant.PayType.PHASED_PAYMENT_CODE);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.cContractInfoMapper.getListContractJoinContractExtPage(cContractInfoPO));
        List contractInfoBOListPage = JSON.parseArray((String)JSON.toJSONString((Object)page), CContractInfoBO.class);
        for (CContractInfoBO contractInfoBO : contractInfoBOListPage) {
            BigDecimal bigDecimal = MoneyUtils.haoToYuan(contractInfoBO.getContractAmount() == null ? BigDecimal.ZERO : contractInfoBO.getContractAmount());
            contractInfoBO.setContractAmount(bigDecimal);
            contractInfoBO.setBusinessType(Integer.valueOf(contractInfoBO.getMaterialCategory() == null ? 0 : contractInfoBO.getMaterialCategory()));
            if (Objects.nonNull(contractInfoBO.getIsJy()) && contractInfoBO.getIsJy() == 1) {
                contractInfoBO.setBusinessType(Integer.valueOf(3));
                contractInfoBO.setBusinessTypeStr("\u8d27\u7269");
            } else if (ContractConstant.MaterialCategory.PROJECT.equals(contractInfoBO.getBusinessType())) {
                contractInfoBO.setBusinessTypeStr("\u5de5\u7a0b");
            } else if (ContractConstant.MaterialCategory.SERVICES.equals(contractInfoBO.getBusinessType())) {
                String contractTypeStr = ContractTransFieldUtil.transContractType(contractInfoBO.getContractType());
                if ("\u9519\u8bef\u7684\u5408\u540c\u7c7b\u578b".equals(contractTypeStr)) {
                    contractTypeStr = null;
                }
                contractInfoBO.setBusinessTypeStr("\u670d\u52a1" + (StringUtils.isBlank((String)contractTypeStr) ? "" : "-" + contractTypeStr));
            } else {
                contractInfoBO.setBusinessType(Integer.valueOf(3));
                contractInfoBO.setBusinessTypeStr("\u8d27\u7269");
            }
            if (!Objects.nonNull(contractInfoBO.getContractCategory())) continue;
            String valueByCode = ContractConstant.ContractClassificationEnum.getValueByCode(contractInfoBO.getContractCategory());
            contractInfoBO.setContractTypeStr(valueByCode);
        }
        rspBO.setRows(contractInfoBOListPage);
        rspBO.setPageNo(Integer.valueOf(page.getPageNum()));
        rspBO.setTotal(Integer.valueOf(page.getPages()));
        rspBO.setRecordsTotal(Integer.valueOf(String.valueOf(page.getTotal())));
        return rspBO;
    }
}

