/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractItemRemoveWaitOrderAbilityService;
import com.tydic.contract.ability.bo.ContractItemRemoveWaitOrderAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemRemoveWaitOrderAbilityRspBO;
import com.tydic.contract.busi.ContractAllocationContractItemBusiService;
import com.tydic.contract.busi.bo.ContractAllocationContractItemBusiReqBO;
import com.tydic.contract.busi.bo.ContractAllocationContractItemBusiRspBO;
import com.tydic.contract.dao.CContractAllotRecordMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractAllotRecordPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoItemUpdateVO;
import com.tydic.contract.po.ContractInfoPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractAllocationContractItemBusiServiceImpl
implements ContractAllocationContractItemBusiService {
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private CContractAllotRecordMapper cContractAllotRecordMapper;
    @Autowired
    private ContractItemRemoveWaitOrderAbilityService contractItemRemoveWaitOrderAbilityService;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private ContractInfoMapper contractInfoMapper;

    @Override
    public ContractAllocationContractItemBusiRspBO allocationContractItem(ContractAllocationContractItemBusiReqBO reqBO) {
        ContractAllocationContractItemBusiRspBO rspBO = new ContractAllocationContractItemBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<ContractInfoItemPO> infoItemPOS = this.contractInfoItemMapper.selectByRelateIdAndOccupation(reqBO.getContractIds(), reqBO.getOccupation());
        if (CollectionUtils.isEmpty(infoItemPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5f53\u524d\u5206\u914d\u7684\u5408\u540c\u672a\u67e5\u8be2\u5230\uff0c\u53ef\u80fd\u5df2\u88ab\u5206\u914d\u6216\u8005\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
            return rspBO;
        }
        Set relateIds = infoItemPOS.stream().filter(e -> e.getRelateId() != null).map(ContractInfoItemPO::getRelateId).collect(Collectors.toSet());
        ArrayList<Long> contractIdList = new ArrayList<Long>();
        contractIdList.addAll(relateIds);
        Map<Object, Object> contractIdMap = new HashMap();
        if (!CollectionUtils.isEmpty(contractIdList)) {
            List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(contractIdList);
            contractIdMap = contractInfoPOS.stream().collect(Collectors.toMap(ContractInfoPO::getContractId, ContractInfoPO::getContractCode));
        }
        ContractInfoItemUpdateVO updateVO = new ContractInfoItemUpdateVO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)updateVO);
        updateVO.setAllotUserCode(reqBO.getOccupation());
        Set collect = infoItemPOS.stream().map(ContractInfoItemPO::getRelateId).collect(Collectors.toSet());
        ArrayList<Long> contractIds = new ArrayList<Long>();
        contractIds.addAll(collect);
        updateVO.setContractIds(contractIds);
        int count = this.contractInfoItemMapper.updateAwardEmployeeNumber(updateVO);
        if (infoItemPOS.size() != count) {
            throw new ZTBusinessException("\u4fee\u6539\u6570\u636e\u7ed3\u679c\u4e0e\u5206\u914d\u7684\u6570\u636e\u4e0d\u5339\u914d");
        }
        Date nowDate = new Date();
        ArrayList<CContractAllotRecordPO> insertPOS = new ArrayList<CContractAllotRecordPO>();
        for (ContractInfoItemPO e2 : infoItemPOS) {
            if (!StringUtils.isEmpty((Object)contractIdMap.get(e2.getRelateId()))) {
                e2.setRelateCode((String)contractIdMap.get(e2.getRelateId()));
            }
            CContractAllotRecordPO recordPO = new CContractAllotRecordPO();
            recordPO.setId(this.uccBatchSequence.nextId());
            recordPO.setContractId(e2.getRelateId());
            recordPO.setContractCode(e2.getRelateCode());
            recordPO.setItemId(e2.getItemId());
            recordPO.setAllotUserId(reqBO.getUserId());
            recordPO.setAllotUserCode(reqBO.getOccupation());
            recordPO.setAllotUserName(reqBO.getName());
            recordPO.setAssignedUserId(reqBO.getAssignedUserId());
            recordPO.setAssignedUserCode(reqBO.getAssignedUserCode());
            recordPO.setAssignedUserName(reqBO.getAssignedUserName());
            recordPO.setCreateTime(nowDate);
            insertPOS.add(recordPO);
        }
        this.cContractAllotRecordMapper.insertBatch(insertPOS);
        List itemIds = infoItemPOS.stream().map(ContractInfoItemPO::getItemId).collect(Collectors.toList());
        ContractItemRemoveWaitOrderAbilityReqBO contractItemRemoveWaitOrderAbilityReqBO = new ContractItemRemoveWaitOrderAbilityReqBO();
        contractItemRemoveWaitOrderAbilityReqBO.setItemIds(itemIds);
        contractItemRemoveWaitOrderAbilityReqBO.setUserId(reqBO.getUserId());
        ContractItemRemoveWaitOrderAbilityRspBO abilityRspBO = this.contractItemRemoveWaitOrderAbilityService.removeWaitOrder(contractItemRemoveWaitOrderAbilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new ZTBusinessException(abilityRspBO.getRespDesc());
        }
        return rspBO;
    }
}

