/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.ContractItemRemoveWaitOrderAbilityService;
import com.tydic.contract.ability.bo.ContractItemRemoveWaitOrderAbilityReqBO;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityBo;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityReqBo;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityRspBo;
import com.tydic.contract.busi.ContractPlanOrderBusiService;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CRelBuySaleContractMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.dao.ContractOrderMapper;
import com.tydic.contract.po.CRelBuySaleContractPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.po.ContractOrderPo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractPlanOrderBusiServiceImpl
implements ContractPlanOrderBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractPlanOrderBusiServiceImpl.class);
    @Autowired
    private ContractOrderMapper contractOrderMapper;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private CRelBuySaleContractMapper cRelBuySaleContractMapper;
    @Autowired
    private ContractItemRemoveWaitOrderAbilityService contractItemRemoveWaitOrderAbilityService;

    @Override
    public ContractPlanOrderAbilityRspBo dealContractOrder(ContractPlanOrderAbilityReqBo reqBo) {
        List<ContractInfoItemPO> contractInfoItemPOS1;
        List<ContractInfoItemPO> contractInfoItemPOS;
        ContractPlanOrderAbilityRspBo rspBo = new ContractPlanOrderAbilityRspBo();
        String msg = this.checkReq(reqBo);
        if (!StringUtils.isEmpty((Object)msg)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(msg);
            return rspBo;
        }
        List<Long> qryItemIds = reqBo.getPlanOrderReqBo().stream().map(a -> a.getItemId()).collect(Collectors.toList());
        List<ContractInfoItemPO> qryContractInfoItemPOS = this.contractInfoItemMapper.selectContractTypeByItemIds(qryItemIds);
        if (CollectionUtils.isEmpty(qryContractInfoItemPOS)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u660e\u7ec6\u4e0d\u5b58\u5728");
            return rspBo;
        }
        HashSet<Long> maxItemIds = new HashSet<Long>();
        HashMap<Long, Integer> itemIdContractTypeMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> itemIdBusinessTypeMap = new HashMap<Long, Integer>();
        for (ContractInfoItemPO contractInfoItemPO : qryContractInfoItemPOS) {
            itemIdContractTypeMap.put(contractInfoItemPO.getItemId(), contractInfoItemPO.getContractType());
            itemIdBusinessTypeMap.put(contractInfoItemPO.getItemId(), contractInfoItemPO.getBusinessType());
        }
        if (!CollectionUtils.isEmpty(qryContractInfoItemPOS)) {
            Boolean isCheckValidTime = true;
            for (ContractPlanOrderAbilityBo abilityBo : reqBo.getPlanOrderReqBo()) {
                if (abilityBo.getNum().compareTo(BigDecimal.ZERO) >= 1) continue;
                isCheckValidTime = false;
                break;
            }
            Date date = new Date();
            HashSet<String> failContractCode = new HashSet<String>();
            for (ContractInfoItemPO qryContractInfoItemPO : qryContractInfoItemPOS) {
                if ((ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(qryContractInfoItemPO.getContractType()) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(qryContractInfoItemPO.getContractType()) || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(qryContractInfoItemPO.getContractType()) || ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT.equals(qryContractInfoItemPO.getContractType()) || ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(qryContractInfoItemPO.getContractType()) && ContractConstant.BusinessType.SELF_PURCHASE.equals(qryContractInfoItemPO.getBusinessType())) && ContractConstant.SaleStatus.VALID.equals(qryContractInfoItemPO.getSaleStatus())) {
                    maxItemIds.add(qryContractInfoItemPO.getItemId());
                }
                if (!ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(qryContractInfoItemPO.getContractType()) && !ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(qryContractInfoItemPO.getContractType()) || qryContractInfoItemPO.getContractValidTime() == null || !qryContractInfoItemPO.getContractValidTime().before(date)) continue;
                failContractCode.add(qryContractInfoItemPO.getContractCode());
            }
            if (isCheckValidTime.booleanValue() && !CollectionUtils.isEmpty(failContractCode)) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u6709\u5408\u540c\u4e0d\u5728\u6709\u6548\u671f\u5185\uff0c\u5408\u540c\u7f16\u53f7\uff1a" + ((Object)failContractCode).toString());
                return rspBo;
            }
            Map<Integer, List<ContractInfoItemPO>> map = qryContractInfoItemPOS.stream().filter(e -> e.getContractType() != null).collect(Collectors.groupingBy(ContractInfoItemPO::getContractType));
        }
        Map<Object, Object> havOrderMap = new HashMap();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Map<Long, BigDecimal> planOrderMap = reqBo.getPlanOrderReqBo().stream().collect(Collectors.toMap(a -> a.getItemId(), a -> a.getNum(), (first, second) -> first));
        List<Long> planOrderItemIds = reqBo.getPlanOrderReqBo().stream().map(a -> a.getItemId()).collect(Collectors.toList());
        List<ContractOrderPo> contractOrderPos = this.contractOrderMapper.selectListByItemIds(planOrderItemIds);
        if (CollectionUtils.isEmpty(contractOrderPos)) {
            for (Long l : planOrderItemIds) {
                havOrderMap.put(l, BigDecimal.ZERO);
            }
        } else {
            havOrderMap = contractOrderPos.stream().collect(Collectors.toMap(a -> a.getItemId(), a -> a.getDoOrderNum(), (first, second) -> first));
            for (Long l : planOrderItemIds) {
                if (!havOrderMap.containsKey(l)) {
                    havOrderMap.put(l, BigDecimal.ZERO);
                    continue;
                }
                arrayList.add(l);
            }
        }
        if (CollectionUtils.isEmpty(contractInfoItemPOS = this.contractInfoItemMapper.selectListByItemIds(planOrderItemIds))) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u9500\u552e\u5408\u540c\u660e\u7ec6\u4e0d\u5b58\u5728");
            return rspBo;
        }
        for (ContractInfoItemPO contractInfoItemPO : contractInfoItemPOS) {
            if (contractInfoItemPO.getAmount() != null) continue;
            contractInfoItemPO.setAmount(BigDecimal.ZERO);
        }
        Map<Long, BigDecimal> map = contractInfoItemPOS.stream().filter(a -> a.getSaleAmount() != null).collect(Collectors.toMap(a -> a.getItemId(), a -> a.getSaleAmount(), (first, second) -> first));
        Map<Long, BigDecimal> preOrderMap = contractInfoItemPOS.stream().collect(Collectors.toMap(a -> a.getItemId(), a -> a.getAmount(), (first, second) -> first));
        Map<Long, Long> itemContractIdMap = contractInfoItemPOS.stream().collect(Collectors.toMap(a -> a.getItemId(), a -> a.getRelateId(), (first, second) -> first));
        Map<Long, List<ContractInfoItemPO>> itemContractMap = contractInfoItemPOS.stream().collect(Collectors.groupingBy(a -> a.getRelateId()));
        for (Long itemId : planOrderItemIds) {
            if (preOrderMap.containsKey(itemId)) continue;
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u9500\u552e\u5408\u540c\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u660e\u7ec6id\uff1a" + itemId);
            return rspBo;
        }
        List<Long> contractIds = contractInfoItemPOS.stream().map(a -> a.getRelateId()).distinct().collect(Collectors.toList());
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(contractIds);
        if (CollectionUtils.isEmpty(contractInfoPOS)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u9500\u552e\u5408\u540c\u4e0d\u5b58\u5728");
            return rspBo;
        }
        Map<Long, ContractInfoPO> contractInfoMap = contractInfoPOS.stream().collect(Collectors.toMap(a -> a.getContractId(), a -> a, (first, second) -> first));
        for (Long contractId : contractIds) {
            if (!contractInfoMap.containsKey(contractId)) {
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u9500\u552e\u5408\u540c\u4e0d\u5b58\u5728,\u5bf9\u5e94\u4e0b\u5355\u660e\u7ec6ID\uff1a" + itemContractMap.get(contractId).stream().map(a -> a.getItemId()).collect(Collectors.toList()));
                return rspBo;
            }
            if (((ContractPlanOrderAbilityBo)reqBo.getPlanOrderReqBo().get(0)).getNum().compareTo(BigDecimal.ZERO) <= 0 || ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT.equals(contractInfoMap.get(contractId).getContractStatus())) continue;
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u9500\u552e\u5408\u540c\u4e0d\u662f\u5df2\u751f\u6548\u72b6\u6001,\u5bf9\u5e94\u4e0b\u5355\u660e\u7ec6ID\uff1a" + itemContractMap.get(contractId).stream().map(a -> a.getItemId()).collect(Collectors.toList()));
            return rspBo;
        }
        Map<Long, Integer> contractTypeMap = qryContractInfoItemPOS.stream().collect(Collectors.toMap(ContractInfoItemPO::getItemId, ContractInfoItemPO::getContractType));
        Map<Long, Integer> businessTypeMap = qryContractInfoItemPOS.stream().filter(po -> ObjectUtil.isNotEmpty((Object)po.getBusinessType())).collect(Collectors.toMap(ContractInfoItemPO::getItemId, ContractInfoItemPO::getBusinessType));
        for (Map.Entry<Long, BigDecimal> each : map.entrySet()) {
            if (maxItemIds.contains(each.getKey())) continue;
            Integer n = contractTypeMap.get(each.getKey());
            Integer businessType = businessTypeMap.get(each.getKey());
            BigDecimal havOrder = (BigDecimal)havOrderMap.get(each.getKey());
            BigDecimal planOrder = planOrderMap.get(each.getKey());
            if (planOrder.compareTo(BigDecimal.ZERO) < 1) continue;
            BigDecimal preOrder = null;
            preOrder = ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(n) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(n) || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(n) || ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT.equals(n) || ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(n) && ContractConstant.BusinessType.SELF_PURCHASE.equals(businessType) ? (BigDecimal)each.getValue() : preOrderMap.get(each.getKey());
            if (null == preOrder || preOrder.subtract(havOrder).compareTo(planOrder) >= 0) continue;
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u53ef\u4e0b\u5355\u6570\u91cf\u4e0d\u8db3\uff0c\u660e\u7ec6id\uff1a" + each.getKey());
            return rspBo;
        }
        ArrayList<ContractOrderPo> insertPos = new ArrayList<ContractOrderPo>();
        for (Map.Entry entry : planOrderMap.entrySet()) {
            ContractOrderPo contractOrderPo = new ContractOrderPo();
            contractOrderPo.setItemId((Long)entry.getKey());
            BigDecimal updateNum = ((BigDecimal)havOrderMap.get(entry.getKey())).add((BigDecimal)entry.getValue());
            if (updateNum.compareTo(BigDecimal.ZERO) < 0) {
                Iterator<Long> contractType = (Integer)itemIdContractTypeMap.get(entry.getKey());
                Integer businessType = (Integer)itemIdBusinessTypeMap.get(entry.getKey());
                if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractType) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractType) || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(contractType) || ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT.equals(contractType) || ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(contractType) && ContractConstant.BusinessType.SELF_PURCHASE.equals(businessType)) {
                    updateNum = BigDecimal.ZERO;
                } else {
                    throw new ZTBusinessException("\u9000\u5355\u6570\u91cf\u5927\u4e8e\u5df2\u4e0b\u5355\u6570\u91cf\uff0c\u660e\u7ec6id\uff1a" + entry.getKey());
                }
            }
            contractOrderPo.setDoOrderNum(updateNum);
            if (arrayList.contains(entry.getKey())) {
                this.contractOrderMapper.updateByItem(contractOrderPo);
                continue;
            }
            contractOrderPo.setId(Sequence.getInstance().nextId());
            contractOrderPo.setRelateId(contractInfoMap.get(itemContractIdMap.get(entry.getKey())).getContractId());
            contractOrderPo.setRelateCode(contractInfoMap.get(itemContractIdMap.get(entry.getKey())).getContractCode());
            insertPos.add(contractOrderPo);
        }
        if (!CollectionUtils.isEmpty(insertPos)) {
            this.contractOrderMapper.insertBatch(insertPos);
        }
        if (!CollectionUtils.isEmpty(contractInfoItemPOS1 = this.contractInfoItemMapper.selectByContractIds(contractIds))) {
            List<Long> buyContractIds;
            List<CRelBuySaleContractPO> cRelBuySaleContractPOS;
            for (ContractInfoItemPO contractInfoItemPO : contractInfoItemPOS1) {
                if (contractInfoItemPO.getAmount() != null) continue;
                contractInfoItemPO.setAmount(BigDecimal.ZERO);
            }
            List<Long> list = contractInfoItemPOS1.stream().map(a -> a.getItemId()).collect(Collectors.toList());
            List<ContractOrderPo> contractOrderPoList = this.contractOrderMapper.selectListByItemIds(list);
            Map<Object, Object> allHavOrderMap = new HashMap();
            if (CollectionUtils.isEmpty(contractOrderPoList)) {
                for (Long itemId : list) {
                    allHavOrderMap.put(itemId, BigDecimal.ZERO);
                }
            } else {
                allHavOrderMap = contractOrderPoList.stream().collect(Collectors.toMap(a -> a.getItemId(), a -> a.getDoOrderNum(), (first, second) -> first));
                for (Long itemId : list) {
                    if (allHavOrderMap.containsKey(itemId)) continue;
                    allHavOrderMap.put(itemId, BigDecimal.ZERO);
                }
            }
            Map<Long, List<ContractInfoItemPO>> contractItemMap = contractInfoItemPOS1.stream().collect(Collectors.groupingBy(a -> a.getRelateId()));
            ArrayList<Long> expContractIds = new ArrayList<Long>();
            ArrayList<Long> rollBackContractIds = new ArrayList<Long>();
            for (Map.Entry<Long, List<ContractInfoItemPO>> each : contractItemMap.entrySet()) {
                HashMap<Long, BigDecimal> itemAmount = new HashMap<Long, BigDecimal>();
                HashSet<Long> maxContractIds = new HashSet<Long>();
                for (ContractInfoItemPO contractInfoItemPO : each.getValue()) {
                    Integer contractType = (Integer)itemIdContractTypeMap.get(contractInfoItemPO.getItemId());
                    Integer businessType = (Integer)itemIdBusinessTypeMap.get(contractInfoItemPO.getItemId());
                    if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractType) || ContractConstant.ContractType.PURCHASE_LONG_TERM_PRICING_CONTRACT.equals(contractType) || ContractConstant.ContractType.FRAME_AGR_SELF_EXPLOITATION_CONTRACT.equals(contractType) || ContractConstant.ContractType.FUNCTION_FRAMEWORK_AGREEMENT_CONTRACT.equals(contractType) || ContractConstant.ContractType.LONG_TERM_CONTRACT_TYPE.equals(contractType) && ContractConstant.BusinessType.SELF_PURCHASE.equals(businessType)) {
                        if (ContractConstant.SaleStatus.LIMIT.equals(contractInfoItemPO.getSaleStatus())) {
                            itemAmount.put(contractInfoItemPO.getItemId(), contractInfoItemPO.getSaleAmount());
                        } else {
                            itemAmount.put(contractInfoItemPO.getItemId(), contractInfoItemPO.getAmount());
                        }
                        if (!ContractConstant.SaleStatus.VALID.equals(contractInfoItemPO.getSaleStatus())) continue;
                        maxContractIds.add(contractInfoItemPO.getRelateId());
                        continue;
                    }
                    itemAmount.put(contractInfoItemPO.getItemId(), contractInfoItemPO.getAmount());
                }
                Boolean expFlag = true;
                for (Map.Entry itemEach : itemAmount.entrySet()) {
                    if (((BigDecimal)itemEach.getValue()).subtract((BigDecimal)allHavOrderMap.get(itemEach.getKey())).compareTo(BigDecimal.ZERO) <= 0) continue;
                    expFlag = false;
                    break;
                }
                if (maxContractIds.contains(each.getKey())) {
                    expFlag = false;
                }
                if (expFlag.booleanValue()) {
                    expContractIds.add(each.getKey());
                    continue;
                }
                if (((ContractPlanOrderAbilityBo)reqBo.getPlanOrderReqBo().get(0)).getNum().compareTo(BigDecimal.ZERO) >= 0) continue;
                rollBackContractIds.add(each.getKey());
            }
            rollBackContractIds.removeAll(expContractIds);
            if (!CollectionUtils.isEmpty(rollBackContractIds)) {
                this.contractInfoMapper.batchUpdateContractStatusRollBack(rollBackContractIds, ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                cRelBuySaleContractPOS = this.cRelBuySaleContractMapper.getListBySaleIds(rollBackContractIds);
                if (!CollectionUtils.isEmpty(cRelBuySaleContractPOS)) {
                    buyContractIds = cRelBuySaleContractPOS.stream().map(a -> a.getBuyContractId()).distinct().collect(Collectors.toList());
                    this.contractInfoMapper.batchUpdateContractStatusRollBack(buyContractIds, ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT);
                }
            }
            if (!CollectionUtils.isEmpty(expContractIds)) {
                this.contractInfoMapper.batchUpdateContractStatus(expContractIds, ContractConstant.ContractStatus.CONTRACT_STATUS_EXECUTED);
                cRelBuySaleContractPOS = this.cRelBuySaleContractMapper.getListBySaleIds(expContractIds);
                if (!CollectionUtils.isEmpty(cRelBuySaleContractPOS)) {
                    buyContractIds = cRelBuySaleContractPOS.stream().map(a -> a.getBuyContractId()).distinct().collect(Collectors.toList());
                    this.contractInfoMapper.batchUpdateContractStatus(buyContractIds, ContractConstant.ContractStatus.CONTRACT_STATUS_EXECUTED);
                }
            }
        }
        List list = reqBo.getPlanOrderReqBo().stream().map(ContractPlanOrderAbilityBo::getItemId).collect(Collectors.toList());
        ContractItemRemoveWaitOrderAbilityReqBO removeWaitOrderAbilityReqBO = new ContractItemRemoveWaitOrderAbilityReqBO();
        removeWaitOrderAbilityReqBO.setUserId(reqBo.getUserId());
        removeWaitOrderAbilityReqBO.setItemIds(list);
        this.contractItemRemoveWaitOrderAbilityService.removeWaitOrder(removeWaitOrderAbilityReqBO);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String checkReq(ContractPlanOrderAbilityReqBo reqBo) {
        String msg = "";
        if (CollectionUtils.isEmpty((Collection)reqBo.getPlanOrderReqBo())) {
            msg = "\u4e0b\u5355\u5165\u53c2\u4fe1\u606f\u4e3a\u7a7a";
        }
        for (ContractPlanOrderAbilityBo contractPlanOrderAbilityBo : reqBo.getPlanOrderReqBo()) {
            if (contractPlanOrderAbilityBo.getItemId() == null) {
                msg = "\u4e0b\u5355\u5165\u53c2\u4fe1\u606f\u4e2d\u660e\u7ec6id\u4e3a\u7a7a";
            }
            if (contractPlanOrderAbilityBo.getNum() != null) continue;
            msg = "\u4e0b\u5355\u5165\u53c2\u4fe1\u606f\u4e2d\u4e0b\u5355\u6570\u91cf\u4e3a\u7a7a";
        }
        return msg;
    }
}

