/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.contract.ability.bo.ContractItemAbilityBO;
import com.tydic.contract.atom.InterFaceContractErpSyncService;
import com.tydic.contract.atom.bo.ErpSyncLineData;
import com.tydic.contract.atom.bo.InterFaceContractErpSyncReqBo;
import com.tydic.contract.atom.bo.InterFaceContractErpSyncReqDataBo;
import com.tydic.contract.atom.bo.InterFaceContractErpSyncRspBo;
import com.tydic.contract.atom.bo.InterFaceContractErpSyncRspDataBo;
import com.tydic.contract.busi.ContractItemQueryBusiService;
import com.tydic.contract.busi.ContractPushErpBusiService;
import com.tydic.contract.busi.bo.ContractItemQueryBusiReqBO;
import com.tydic.contract.busi.bo.ContractItemQueryBusiRspBO;
import com.tydic.contract.busi.bo.ContractPushErpBusiReqBO;
import com.tydic.contract.busi.bo.ContractPushErpBusiRspBO;
import com.tydic.contract.constant.ContractConstant;
import com.tydic.contract.dao.CContractInfoExtMapper;
import com.tydic.contract.dao.CContractInfoHistoryLogMapper;
import com.tydic.contract.dao.CContractInfoItemHistoryLogMapper;
import com.tydic.contract.dao.CContractInfoPushErpLogMapper;
import com.tydic.contract.dao.ContractInfoItemMapper;
import com.tydic.contract.dao.ContractInfoMapper;
import com.tydic.contract.po.CContractInfoExtPO;
import com.tydic.contract.po.CContractInfoHistoryLogPO;
import com.tydic.contract.po.CContractInfoItemHistoryLogPO;
import com.tydic.contract.po.CContractInfoPushErpPO;
import com.tydic.contract.po.ContractInfoItemPO;
import com.tydic.contract.po.ContractInfoPO;
import com.tydic.contract.utils.ContractTransFieldUtil;
import com.tydic.contract.utils.MoneyUtils;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.api.UmcMemDetailQueryAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgQryDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcMemDetailQueryAbilityRspBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ContractPushErpBusiServiceImpl
implements ContractPushErpBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractPushErpBusiServiceImpl.class);
    @Autowired
    private ContractInfoMapper contractInfoMapper;
    @Autowired
    private CContractInfoPushErpLogMapper cContractInfoPushErpLogMapper;
    @Autowired
    private InterFaceContractErpSyncService interFaceContractErpSyncService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService dycUmcEnterpriseOrgQryDetailService;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;
    @Autowired
    private ContractItemQueryBusiService contractItemQueryBusiService;
    @Autowired
    private ContractInfoItemMapper contractInfoItemMapper;
    @Resource
    private CContractInfoItemHistoryLogMapper cContractInfoItemHistoryLogMapper;
    @Resource
    private CContractInfoHistoryLogMapper cContractInfoHistoryLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private CContractInfoExtMapper cContractInfoExtMapper;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;

    @Override
    public ContractPushErpBusiRspBO dealPushErp(ContractPushErpBusiReqBO reqBO) {
        CContractInfoPushErpPO cContractInfoPushErpPO;
        ContractPushErpBusiRspBO busiRspBO = new ContractPushErpBusiRspBO();
        if (CollectionUtils.isEmpty(reqBO.getContractIds())) {
            busiRspBO.setRespCode("8888");
            busiRspBO.setRespDesc("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a");
            return busiRspBO;
        }
        List<ContractInfoPO> contractInfoPOS = this.contractInfoMapper.getListByContractIds(reqBO.getContractIds());
        ArrayList<InterFaceContractErpSyncReqDataBo> interFaceContractErpSyncReqDataBos = new ArrayList<InterFaceContractErpSyncReqDataBo>();
        ArrayList<CContractInfoPushErpPO> contractInfoPushErpPOS = new ArrayList<CContractInfoPushErpPO>();
        HashMap<Long, Object> failDealPushInfo = new HashMap<Long, Object>();
        HashMap<String, String> headerIdAndContractCode = new HashMap<String, String>();
        HashMap success = new HashMap();
        HashMap<Long, String> needNot = new HashMap<Long, String>();
        HashMap fail = new HashMap();
        ArrayList<Long> pushErpContractIds = new ArrayList<Long>();
        HashMap<Long, String> pushErpInParameterMap = new HashMap<Long, String>();
        String pushErpReturnInfo = "";
        Date nowDate = new Date();
        for (ContractInfoPO contractInfoPO : contractInfoPOS) {
            boolean checkPushErpYc;
            Object failInfo = "";
            if (!ContractConstant.ContractStatus.CONTRACT_STATUS_EFFECT.equals(contractInfoPO.getContractStatus()) && !ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER.equals(contractInfoPO.getContractStatus())) {
                failInfo = (String)failInfo + "\u5408\u540c\u7684\u72b6\u6001\u4e0d\u4e3a\u5df2\u751f\u6548\u6216\u8005\u5df2\u5931\u6548;";
            }
            if (checkPushErpYc = this.checkPushErpYc(contractInfoPO)) {
                needNot.put(contractInfoPO.getContractId(), "\u5f53\u524d\u6846\u67b6\u534f\u8bae\u5bc4\u552e\u5408\u540c\u65e0\u9700\u63a8\u9001erp");
                continue;
            }
            if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType()) && Objects.nonNull(contractInfoPO.getContractVersion()) && contractInfoPO.getContractVersion() > 1) {
                log.error("++++++++++\u8fdb\u5165\u5bc4\u552e\u5408\u540c\u6821\u9a8c+++++++++++");
                boolean flag = Boolean.FALSE;
                CContractInfoHistoryLogPO record = new CContractInfoHistoryLogPO();
                record.setContractId(contractInfoPO.getContractId());
                record.setContractVersion(contractInfoPO.getContractVersion() - 1);
                List<CContractInfoHistoryLogPO> oldContractInfo = this.cContractInfoHistoryLogMapper.selectByPO(record);
                if (!CollectionUtils.isEmpty(oldContractInfo)) {
                    flag = this.checkPushErpYn(contractInfoPO, oldContractInfo.get(0));
                }
                if (!flag) {
                    needNot.put(contractInfoPO.getContractId(), "\u5f53\u524d\u5408\u540c\u53d8\u66f4\u9879\u6570\u636e\u65e0\u9700\u63a8\u9001erp");
                    continue;
                }
            }
            InterFaceContractErpSyncReqDataBo interFaceContractErpSyncReqDataBo = new InterFaceContractErpSyncReqDataBo();
            interFaceContractErpSyncReqDataBo.setHEADER_UUID(contractInfoPO.getContractId().toString());
            if (StringUtils.isEmpty((Object)contractInfoPO.getBuyerNo())) {
                failInfo = failInfo + "\u4e70\u53d7\u4eba\u7f16\u53f7\u4e3a\u7a7a;";
            } else {
                UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
                umcEnterpriseOrgQryDetailAbilityReqBO.setOrgCode(contractInfoPO.getBuyerNo());
                UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.dycUmcEnterpriseOrgQryDetailService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
                if (!"0000".equals(umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode())) {
                    failInfo = (String)failInfo + "\u4e70\u53d7\u4eba\u673a\u6784\u83b7\u53d6\u8be6\u60c5\u5931\u8d25;";
                } else {
                    interFaceContractErpSyncReqDataBo.setORG_ID(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode());
                }
            }
            String materialSource = contractInfoPO.getMaterialSource();
            log.info("\u7269\u8d44\u6765\u6e90" + materialSource);
            if (contractInfoPO.getSupplierId() == null) {
                failInfo = (String)failInfo + "\u4f9b\u5e94\u5546\u4e3a\u7a7a;";
            } else {
                UmcEnterpriseOrgQryDetailAbilityReqBO umcEnterpriseOrgQryDetailAbilityReqBO = new UmcEnterpriseOrgQryDetailAbilityReqBO();
                umcEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(contractInfoPO.getSupplierId());
                UmcEnterpriseOrgQryDetailAbilityRspBO umcEnterpriseOrgQryDetailAbilityRspBO = this.dycUmcEnterpriseOrgQryDetailService.qryEnterpriseOrgDetail(umcEnterpriseOrgQryDetailAbilityReqBO);
                if (!"0000".equals(umcEnterpriseOrgQryDetailAbilityRspBO.getRespCode())) {
                    failInfo = (String)failInfo + "\u4f9b\u5e94\u5546\u673a\u6784\u83b7\u53d6\u8be6\u60c5\u5931\u8d25;";
                } else {
                    interFaceContractErpSyncReqDataBo.setVENDOR_CODE(umcEnterpriseOrgQryDetailAbilityRspBO.getUmcEnterpriseOrgDetailBO().getErpOrgCode());
                }
            }
            interFaceContractErpSyncReqDataBo.setVENDOR_NAME(contractInfoPO.getSupplierName());
            if (StringUtils.isEmpty((Object)interFaceContractErpSyncReqDataBo.getVENDOR_CODE())) {
                failInfo = (String)failInfo + "\u4f9b\u5e94\u5546ERP\u7f16\u53f7\u4e3a\u7a7a;";
            }
            if (StringUtils.isEmpty((Object)interFaceContractErpSyncReqDataBo.getVENDOR_NAME())) {
                failInfo = (String)failInfo + "\u4f9b\u5e94\u5546\u540d\u79f0\u4e3a\u7a7a;";
            }
            if (contractInfoPO.getCreateUserId() == null) {
                failInfo = (String)failInfo + "\u5408\u540c\u521b\u5efa\u4ebaid\u4e3a\u7a7a;";
            } else {
                UmcMemDetailQueryAbilityReqBO umcMemDetailQueryAbilityReqBO = new UmcMemDetailQueryAbilityReqBO();
                umcMemDetailQueryAbilityReqBO.setUserIdWeb(contractInfoPO.getCreateUserId());
                UmcMemDetailQueryAbilityRspBO umcMemDetailQueryAbilityRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(umcMemDetailQueryAbilityReqBO);
                UmcMemDetailInfoAbilityBO memDetailInfoBO = umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO();
                if (memDetailInfoBO == null) {
                    failInfo = (String)failInfo + "\u91c7\u8d2d\u5458\u7684ERP\u7528\u6237\u540d\u4e3a\u7a7a;";
                } else {
                    if (StringUtils.isEmpty((Object)memDetailInfoBO.getMemName2())) {
                        failInfo = (String)failInfo + "\u91c7\u8d2d\u5458\u7684ERP\u7528\u6237\u540d\u4e3a\u7a7a;";
                    } else {
                        interFaceContractErpSyncReqDataBo.setAGENT_NAME(memDetailInfoBO.getMemName2());
                    }
                    if (StringUtils.isEmpty((Object)memDetailInfoBO.getAgentAccount())) {
                        failInfo = (String)failInfo + "ERP\u7528\u6237\u540d\u4e3a\u7a7a;";
                    } else {
                        interFaceContractErpSyncReqDataBo.setUSER_NAME(memDetailInfoBO.getAgentAccount());
                    }
                    if (memDetailInfoBO.getAgentId() == null) {
                        failInfo = (String)failInfo + "\u91c7\u8d2d\u5458\u7684\u4eba\u5458ID\u4e3a\u7a7a;";
                    } else {
                        interFaceContractErpSyncReqDataBo.setAGENT_ID(memDetailInfoBO.getAgentId().toString());
                    }
                }
            }
            if (StringUtils.isEmpty((Object)interFaceContractErpSyncReqDataBo.getVENDOR_CODE())) {
                failInfo = (String)failInfo + "\u4f9b\u5e94\u5546ERP\u7f16\u53f7\u4e3a\u7a7a;";
            }
            if (StringUtils.isEmpty((Object)contractInfoPO.getCurrency())) {
                if (!"6".equals(contractInfoPO.getMaterialSource())) {
                    failInfo = (String)failInfo + "\u5e01\u79cd\u4e3a\u7a7a;";
                }
            } else {
                interFaceContractErpSyncReqDataBo.setCURRENCY_CODE(contractInfoPO.getCurrency());
            }
            if (contractInfoPO.getSupplierAddressAliasId() != null && !StringUtils.isEmpty((Object)contractInfoPO.getSupplierAddressAliasId())) {
                interFaceContractErpSyncReqDataBo.setB2BSITE_ID(contractInfoPO.getSupplierAddressAliasId());
                interFaceContractErpSyncReqDataBo.setVENDOR_SITE_NAME(contractInfoPO.getSupplierAddressAlias());
            } else {
                failInfo = (String)failInfo + "\u4f9b\u5e94\u5546ERP\u7f16\u53f7\u4e3a\u7a7a;";
            }
            interFaceContractErpSyncReqDataBo.setDOC_TYPE("BLANKET");
            if (!StringUtils.isEmpty((Object)contractInfoPO.getTrackNo())) {
                interFaceContractErpSyncReqDataBo.setDOC_NUM(contractInfoPO.getTrackNo());
            } else if (!StringUtils.isEmpty((Object)contractInfoPO.getContractCode())) {
                interFaceContractErpSyncReqDataBo.setDOC_NUM(contractInfoPO.getContractCode());
            } else {
                failInfo = (String)failInfo + "\u5408\u540c\u8ddf\u8e2a\u53f7\u548c\u5408\u540c\u7f16\u53f7\u90fd\u4e3a\u7a7a;";
            }
            interFaceContractErpSyncReqDataBo.setAUTO_APPROVE("Y");
            if (!(contractInfoPO.getContractSignDate() != null && contractInfoPO.getValidaType() != null && contractInfoPO.getValidaNum() != null || contractInfoPO.getContractValidTime() != null && contractInfoPO.getContractSignDate() != null)) {
                failInfo = (String)failInfo + "\u5408\u540c\u751f\u6548\u65e5\u671f\u4e3a\u7a7a;";
            } else if (contractInfoPO.getContractValidTime() != null) {
                interFaceContractErpSyncReqDataBo.setSTART_DATE(DateUtils.dateToStr((Date)contractInfoPO.getContractSignDate()));
                if (ContractConstant.ContractStatus.CONTRACT_STATUS_FAILUSER.equals(contractInfoPO.getContractStatus())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
                    interFaceContractErpSyncReqDataBo.setEND_DATE(sdf.format(contractInfoPO.getContractValidTime()));
                } else {
                    interFaceContractErpSyncReqDataBo.setEND_DATE(DateUtils.dateToStr((Date)contractInfoPO.getContractValidTime()));
                }
            } else {
                Calendar c = Calendar.getInstance();
                c.setTime(contractInfoPO.getContractSignDate());
                interFaceContractErpSyncReqDataBo.setSTART_DATE(DateUtils.dateToStr((Date)contractInfoPO.getContractSignDate()));
                if (ContractConstant.TermOfValidityType.MONTHS.equals(contractInfoPO.getValidaType())) {
                    c.add(2, contractInfoPO.getValidaNum());
                } else if (ContractConstant.TermOfValidityType.YEARS.equals(contractInfoPO.getValidaType())) {
                    c.add(1, contractInfoPO.getValidaNum());
                } else {
                    failInfo = (String)failInfo + "\u5408\u540c\u660e\u7ec6\u5217\u8868\u83b7\u53d6\u5931\u8d25;";
                }
                interFaceContractErpSyncReqDataBo.setEND_DATE(DateUtils.dateToStr((Date)c.getTime()));
            }
            if (contractInfoPO.getAmountLimit() != null) {
                interFaceContractErpSyncReqDataBo.setAMOUNT_LIMIT(MoneyUtils.haoToYuan(contractInfoPO.getAmountLimit()).toString());
            }
            if (contractInfoPO.getDiscussAmount() != null) {
                interFaceContractErpSyncReqDataBo.setAMOUNT_AGREED(MoneyUtils.haoToYuan(contractInfoPO.getDiscussAmount()).toString());
            }
            if (contractInfoPO.getMinAmount() != null) {
                interFaceContractErpSyncReqDataBo.setMIN_RELEASE_AMT(MoneyUtils.haoToYuan(contractInfoPO.getMinAmount()).toString());
            }
            if (contractInfoPO.getPurchaseType() != null) {
                interFaceContractErpSyncReqDataBo.setATTRIBUTE15(ContractTransFieldUtil.transContractPurchaseType(contractInfoPO.getPurchaseType()));
            } else {
                failInfo = (String)failInfo + "\u91c7\u8d2d\u65b9\u5f0f\u4e3a\u7a7a;";
            }
            interFaceContractErpSyncReqDataBo.setCOMMENTS(contractInfoPO.getContractName());
            if (!"6".equals(contractInfoPO.getMaterialSource()) && !"CNY".equals(contractInfoPO.getCurrency())) {
                interFaceContractErpSyncReqDataBo.setRATE(contractInfoPO.getExchangeRate());
                interFaceContractErpSyncReqDataBo.setRATE_DATE(contractInfoPO.getConversionDate() != null ? DateUtils.dateToStr((Date)contractInfoPO.getConversionDate()) : null);
                interFaceContractErpSyncReqDataBo.setRATE_TYPE(contractInfoPO.getConversionType());
            }
            if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType())) {
                interFaceContractErpSyncReqDataBo.setATTRIBUTE13("Y");
            } else {
                interFaceContractErpSyncReqDataBo.setATTRIBUTE13("N");
            }
            if (contractInfoPO.getPushErpExist() != null && contractInfoPO.getPushErpExist() == 1) {
                interFaceContractErpSyncReqDataBo.setDATA_TYPE_ID("1");
            } else {
                interFaceContractErpSyncReqDataBo.setDATA_TYPE_ID("0");
            }
            if ("6".equals(materialSource)) {
                interFaceContractErpSyncReqDataBo.setDATA_TYPE_ID("1");
                interFaceContractErpSyncReqDataBo.setPO_HEADER_ID(contractInfoPO.getPoHeaderId());
            }
            ArrayList<ErpSyncLineData> lineData = new ArrayList<ErpSyncLineData>();
            interFaceContractErpSyncReqDataBo.setLINE_DATA(lineData);
            ContractItemQueryBusiReqBO contractItemQueryBusiReqBO = new ContractItemQueryBusiReqBO();
            contractItemQueryBusiReqBO.setContractId(contractInfoPO.getContractId());
            contractItemQueryBusiReqBO.setPageNo(0);
            contractItemQueryBusiReqBO.setPageSize(0);
            ContractItemQueryBusiRspBO contractItemQueryBusiRspBO = this.contractItemQueryBusiService.contractItemQuery(contractItemQueryBusiReqBO);
            if (!"0000".equals(contractItemQueryBusiRspBO.getRespCode())) {
                failInfo = (String)failInfo + "\u5408\u540c\u660e\u7ec6\u5217\u8868\u83b7\u53d6\u5931\u8d25;";
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                HashMap<String, String> failItemKey = new HashMap<String, String>();
                if (!CollectionUtils.isEmpty((Collection)contractItemQueryBusiRspBO.getRows())) {
                    String needTimeStr = "";
                    try {
                        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                        needTimeStr = sdf2.format(new Date());
                    }
                    catch (Exception e) {
                        needTimeStr = "2022-11-11";
                    }
                    Boolean checkThrough = true;
                    if (((ContractItemAbilityBO)contractItemQueryBusiRspBO.getRows().get(0)).getRate() != null) {
                        interFaceContractErpSyncReqDataBo.setATTRIBUTE1(((ContractItemAbilityBO)contractItemQueryBusiRspBO.getRows().get(0)).getRate().toString());
                    }
                    for (Object row : contractItemQueryBusiRspBO.getRows()) {
                        if (!ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType()) && StringUtils.isEmpty((Object)row.getErpOrgCode()) && !"6".equals(contractInfoPO.getMaterialSource())) {
                            failItemKey.put("erpOrgCode", "\u5408\u540c\u660e\u7ec6\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a");
                        }
                        if (StringUtils.isEmpty((Object)row.getMaterialCode())) {
                            failItemKey.put("materialCode", "\u5408\u540c\u660e\u7ec6\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                        }
                        if (StringUtils.isEmpty((Object)row.getUnitName())) {
                            failItemKey.put("unitName", "\u5408\u540c\u660e\u7ec6\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a");
                        }
                        if (StringUtils.isEmpty((Object)row.getNeedArriveTime())) {
                            // empty if block
                        }
                        if (row.getAmount() == null && !"6".equals(contractInfoPO.getMaterialSource())) {
                            failItemKey.put("amount", "\u5408\u540c\u660e\u7ec6\u6570\u91cf\u4e3a\u7a7a");
                        }
                        if (row.getUnitPriceExcludingTax() == null) {
                            failItemKey.put("priceExcludingTax", "\u5408\u540c\u660e\u7ec6\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                        }
                        if (row.getFactoryPrice() != null || "6".equals(contractInfoPO.getMaterialSource())) continue;
                        failItemKey.put("factoryPrice", "\u5408\u540c\u660e\u7ec6\u5230/\u51fa\u5382\u4ef7\u4e3a\u7a7a");
                    }
                    if (failItemKey.size() >= 1) {
                        failInfo = (String)failInfo + "\u660e\u7ec6\u6570\u636e\u4e2d\uff1a" + failItemKey.values();
                    } else {
                        int i = 1;
                        try {
                            Object row;
                            row = contractItemQueryBusiRspBO.getRows().iterator();
                            while (row.hasNext()) {
                                ContractItemAbilityBO contractItemAbilityBO = (ContractItemAbilityBO)row.next();
                                ErpSyncLineData erpSyncLineData = new ErpSyncLineData();
                                if (contractItemAbilityBO.getSaleStatus() != null && contractItemAbilityBO.getSaleStatus() == 3) {
                                    erpSyncLineData.setEXPIRATION_DATE(DateUtils.dateToStr((Date)new Date()));
                                }
                                erpSyncLineData.setLINE_TYPE_ID("1");
                                erpSyncLineData.setITEM_NO(contractItemAbilityBO.getMaterialCode());
                                erpSyncLineData.setUNIT_OF_MEASURE(contractItemAbilityBO.getUnitName());
                                if (contractItemAbilityBO.getNeedArriveTime() != null) {
                                    erpSyncLineData.setNEED_BY_DATE(contractItemAbilityBO.getNeedArriveTime());
                                } else {
                                    erpSyncLineData.setNEED_BY_DATE(needTimeStr);
                                }
                                if (contractItemAbilityBO.getAmount() != null) {
                                    erpSyncLineData.setQUANTITY(contractItemAbilityBO.getAmount().toString());
                                }
                                if (contractItemAbilityBO.getUnitPriceExcludingTax() != null) {
                                    erpSyncLineData.setUNIT_PRICE(contractItemAbilityBO.getUnitPriceExcludingTax().toString());
                                }
                                erpSyncLineData.setUSER_NAME(interFaceContractErpSyncReqDataBo.getUSER_NAME());
                                erpSyncLineData.setLINE_NUM(String.valueOf(i));
                                if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType())) {
                                    erpSyncLineData.setORGANIZATION_ID(StringUtils.isEmpty((Object)contractItemAbilityBO.getErpOrgCode()) ? "176" : contractItemAbilityBO.getErpOrgCode());
                                } else {
                                    erpSyncLineData.setORGANIZATION_ID(contractItemAbilityBO.getErpOrgCode());
                                }
                                erpSyncLineData.setITEM_DESC(contractItemAbilityBO.getMaterialDesc());
                                if (contractItemAbilityBO.getRate() != null) {
                                    erpSyncLineData.setTAXRATE(contractItemAbilityBO.getRate().toString());
                                }
                                erpSyncLineData.setLINE_ATTRIBUTE7("N");
                                if (contractItemAbilityBO.getFactoryPrice() != null) {
                                    erpSyncLineData.setUN_NUMBER(contractItemAbilityBO.getFactoryPrice().toString());
                                }
                                if (contractItemAbilityBO.getPushErpExist() != null && contractItemAbilityBO.getPushErpExist() == 1) {
                                    erpSyncLineData.setLINE_DATA_TYPE_ID("1");
                                } else if (contractInfoPO.getPushErpExist() != null && contractInfoPO.getPushErpExist() == 1) {
                                    erpSyncLineData.setLINE_DATA_TYPE_ID("2");
                                } else {
                                    erpSyncLineData.setLINE_DATA_TYPE_ID("0");
                                }
                                if ("6".equals(materialSource)) {
                                    erpSyncLineData.setLINE_DATA_TYPE_ID("1");
                                    if (contractItemAbilityBO.getPushErpExist() == null || contractItemAbilityBO.getPushErpExist() != 1) {
                                        erpSyncLineData.setLINE_DATA_TYPE_ID("2");
                                    }
                                    erpSyncLineData.setPO_LINE_ID(contractItemAbilityBO.getPoLineId());
                                }
                                erpSyncLineData.setLINE_ATTRIBUTE4(contractItemAbilityBO.getItemId().toString());
                                lineData.add(erpSyncLineData);
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            log.error("\u8f6c\u6362\u5408\u540c\u660e\u7ec6\u5931\u8d25" + e.getMessage());
                            failInfo = (String)failInfo + "\u8f6c\u6362\u5408\u540c\u660e\u7ec6\u5931\u8d25";
                        }
                    }
                }
            }
            if (!StringUtils.isEmpty((Object)failInfo)) {
                failDealPushInfo.put(contractInfoPO.getContractId(), failInfo);
                continue;
            }
            interFaceContractErpSyncReqDataBo.setATTRIBUTE4(contractInfoPO.getContractId().toString());
            headerIdAndContractCode.put(contractInfoPO.getContractId().toString(), contractInfoPO.getContractId().toString());
            interFaceContractErpSyncReqDataBos.add(interFaceContractErpSyncReqDataBo);
            pushErpInParameterMap.put(contractInfoPO.getContractId(), JSONObject.toJSONString((Object)interFaceContractErpSyncReqDataBo));
            pushErpContractIds.add(contractInfoPO.getContractId());
        }
        InterFaceContractErpSyncReqBo interFaceContractErpSyncReqBo = new InterFaceContractErpSyncReqBo();
        if (!CollectionUtils.isEmpty(pushErpContractIds)) {
            try {
                interFaceContractErpSyncReqBo.setHEADER_DATA(interFaceContractErpSyncReqDataBos);
                interFaceContractErpSyncReqBo.setPBATCH_ID(String.valueOf(Sequence.getInstance().nextId()));
                InterFaceContractErpSyncRspBo interFaceContractErpSyncRspBo = this.interFaceContractErpSyncService.erpSync(interFaceContractErpSyncReqBo);
                BeanUtils.copyProperties((Object)((Object)interFaceContractErpSyncRspBo), (Object)((Object)busiRspBO));
                pushErpReturnInfo = interFaceContractErpSyncRspBo.getPushErpReturnInfo();
                if ("0000".equals(interFaceContractErpSyncRspBo.getRespCode())) {
                    if ("S".equals(interFaceContractErpSyncRspBo.getERP_STATUS())) {
                        for (Long pushErpContractId : pushErpContractIds) {
                            success.put(pushErpContractId.toString(), interFaceContractErpSyncRspBo.getERP_MSG());
                        }
                    } else {
                        for (InterFaceContractErpSyncRspDataBo interFaceContractErpSyncRspDataBo : interFaceContractErpSyncRspBo.getDATA()) {
                            if (!headerIdAndContractCode.containsKey(interFaceContractErpSyncRspDataBo.getHEADER_UUID())) continue;
                            if ("S".equals(interFaceContractErpSyncRspDataBo.getRETURN_STATUS())) {
                                success.put(headerIdAndContractCode.get(interFaceContractErpSyncRspDataBo.getHEADER_UUID()), interFaceContractErpSyncRspDataBo.getRETURN_MSG());
                                continue;
                            }
                            if ("E".equals(interFaceContractErpSyncRspDataBo.getRETURN_STATUS())) {
                                fail.put(headerIdAndContractCode.get(interFaceContractErpSyncRspDataBo.getHEADER_UUID()), interFaceContractErpSyncRspDataBo.getRETURN_MSG());
                                continue;
                            }
                            fail.put(headerIdAndContractCode.get(interFaceContractErpSyncRspDataBo.getHEADER_UUID()), "\u5904\u7406\u7ed3\u679c\u8fd4\u56de\u72b6\u6001\u4e0d\u5bf9");
                        }
                    }
                } else {
                    for (Long pushErpContractId : pushErpContractIds) {
                        fail.put(pushErpContractId.toString(), "\u672a\u77e5\u5f02\u5e38" + interFaceContractErpSyncRspBo.getRespDesc());
                    }
                }
            }
            catch (Exception e) {
                log.error("\u63a8\u9001erp\u672a\u77e5\u5f02\u5e38" + e.getMessage());
                for (Long pushErpContractId : pushErpContractIds) {
                    fail.put(pushErpContractId.toString(), "\u63a8\u9001\u672a\u77e5\u5f02\u5e38");
                }
            }
        }
        ArrayList<Long> pushErpOkContractIds = new ArrayList<Long>();
        ArrayList<Long> pushErpFailContractIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(failDealPushInfo)) {
            for (Map.Entry each : failDealPushInfo.entrySet()) {
                cContractInfoPushErpPO = new CContractInfoPushErpPO();
                cContractInfoPushErpPO.setContractId((Long)each.getKey());
                cContractInfoPushErpPO.setId(this.uccBatchSequence.nextId());
                cContractInfoPushErpPO.setPushInfo("\u6570\u636e\u5904\u7406\u5931\u8d25\uff1a" + (String)each.getValue());
                cContractInfoPushErpPO.setPushTime(nowDate);
                cContractInfoPushErpPO.setPushErpStatus(ContractConstant.PushStatus.FAIL);
                contractInfoPushErpPOS.add(cContractInfoPushErpPO);
                pushErpFailContractIds.add((Long)each.getKey());
            }
        }
        if (!CollectionUtils.isEmpty(success)) {
            for (Map.Entry each : success.entrySet()) {
                cContractInfoPushErpPO = new CContractInfoPushErpPO();
                cContractInfoPushErpPO.setContractId(Long.valueOf((String)each.getKey()));
                cContractInfoPushErpPO.setId(this.uccBatchSequence.nextId());
                cContractInfoPushErpPO.setPushInfo("\u6570\u636e\u5168\u90e8\u5904\u7406\u6210\u529f");
                cContractInfoPushErpPO.setPushReturnInfo((String)each.getValue());
                cContractInfoPushErpPO.setPushTime(nowDate);
                cContractInfoPushErpPO.setPushErpStatus(ContractConstant.PushStatus.SUCCESS);
                contractInfoPushErpPOS.add(cContractInfoPushErpPO);
                pushErpOkContractIds.add(Long.valueOf((String)each.getKey()));
            }
        }
        if (!CollectionUtils.isEmpty(fail)) {
            for (Map.Entry each : fail.entrySet()) {
                cContractInfoPushErpPO = new CContractInfoPushErpPO();
                cContractInfoPushErpPO.setContractId(Long.valueOf((String)each.getKey()));
                cContractInfoPushErpPO.setId(this.uccBatchSequence.nextId());
                cContractInfoPushErpPO.setPushInfo("\u6570\u636e\u5168\u90e8\u5904\u7406\u6210\u529f");
                cContractInfoPushErpPO.setPushReturnInfo((String)each.getValue());
                cContractInfoPushErpPO.setPushTime(nowDate);
                cContractInfoPushErpPO.setPushErpStatus(ContractConstant.PushStatus.FAIL);
                contractInfoPushErpPOS.add(cContractInfoPushErpPO);
                pushErpFailContractIds.add(Long.valueOf((String)each.getKey()));
            }
        }
        if (!CollectionUtils.isEmpty(needNot)) {
            needNot.forEach((k, v) -> {
                CContractInfoPushErpPO cContractInfoPushErpPO = new CContractInfoPushErpPO();
                cContractInfoPushErpPO.setContractId((Long)k);
                cContractInfoPushErpPO.setId(this.uccBatchSequence.nextId());
                cContractInfoPushErpPO.setPushInfo("\u5904\u7406\u5b8c\u6210");
                cContractInfoPushErpPO.setPushReturnInfo((String)v);
                cContractInfoPushErpPO.setPushTime(nowDate);
                contractInfoPushErpPOS.add(cContractInfoPushErpPO);
            });
        }
        if (!CollectionUtils.isEmpty(pushErpOkContractIds)) {
            this.contractInfoMapper.updatePushErpSyncStatusByCodes(pushErpOkContractIds, ContractConstant.PushErpStatus.ALREADY_SYNC, 1);
            this.contractInfoItemMapper.updatePushErpFlagByCodes(pushErpOkContractIds, 1);
        }
        if (!CollectionUtils.isEmpty(pushErpFailContractIds)) {
            this.contractInfoMapper.updatePushErpSyncStatusByCodes(pushErpFailContractIds, ContractConstant.PushErpStatus.FAIL_SYNC, null);
        }
        if (!CollectionUtils.isEmpty(contractInfoPushErpPOS)) {
            for (CContractInfoPushErpPO contractInfoPushErpPO : contractInfoPushErpPOS) {
                contractInfoPushErpPO.setPushErpInParameterInfo(JSONObject.toJSONString((Object)interFaceContractErpSyncReqBo));
                contractInfoPushErpPO.setPushErpReturnInfo(pushErpReturnInfo);
            }
        }
        busiRspBO.setContractInfoPushErpPOS(contractInfoPushErpPOS);
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private boolean checkPushErpYn(ContractInfoPO ContractPo2, CContractInfoHistoryLogPO contractInfoChangePO) {
        boolean flag = Boolean.FALSE;
        if (Objects.nonNull(ContractPo2.getCreateUserId()) && !ContractPo2.getCreateUserId().equals(contractInfoChangePO.getCreateUserId()) || Objects.nonNull(ContractPo2.getDiscussAmount()) && !ContractPo2.getDiscussAmount().equals(contractInfoChangePO.getDiscussAmount()) || Objects.nonNull(ContractPo2.getAmountLimit()) && !ContractPo2.getAmountLimit().equals(contractInfoChangePO.getAmountLimit()) || Objects.nonNull(ContractPo2.getPurchaseType()) && !ContractPo2.getPurchaseType().equals(contractInfoChangePO.getPurchaseType()) || !StringUtils.isEmpty((Object)ContractPo2.getContractName()) && !ContractPo2.getContractName().equals(contractInfoChangePO.getContractName()) || Objects.nonNull(ContractPo2.getValidaNum()) && !ContractPo2.getValidaNum().equals(contractInfoChangePO.getValidaNum()) || Objects.nonNull(ContractPo2.getValidaType()) && !ContractPo2.getValidaType().equals(contractInfoChangePO.getValidaType()) || Objects.nonNull(ContractPo2.getMinAmount()) && !ContractPo2.getMinAmount().equals(contractInfoChangePO.getMinAmount()) || Objects.nonNull(ContractPo2.getContractEndDate()) && !ContractPo2.getContractEndDate().equals(contractInfoChangePO.getContractEndDate())) {
            flag = Boolean.TRUE;
            log.error("==============\u5408\u540c\u4e3b\u4f53\u4fe1\u606f\u5b58\u5728\u5dee\u5f02================");
        }
        if (!flag) {
            List<ContractInfoItemPO> newItemPOs = this.contractInfoItemMapper.getItemsByRelId(contractInfoChangePO.getContractId());
            if (CollectionUtils.isEmpty(newItemPOs)) {
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u5408\u540c\u660e\u7ec6\u4fe1\u606f");
            }
            CContractInfoItemHistoryLogPO contractInfoItemHistoryPO = new CContractInfoItemHistoryLogPO();
            contractInfoItemHistoryPO.setUpdateApplyId(contractInfoChangePO.getUpdateApplyId());
            List<CContractInfoItemHistoryLogPO> oldItemPOs = this.cContractInfoItemHistoryLogMapper.getList(contractInfoItemHistoryPO);
            if (CollectionUtils.isEmpty(oldItemPOs)) {
                throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u53d8\u66f4\u524d\u5408\u540c\u660e\u7ec6\u4fe1\u606f");
            }
            if (newItemPOs.size() > oldItemPOs.size()) {
                flag = Boolean.TRUE;
                log.error("==============\u5408\u540c\u4e3b\u4f53\u660e\u7ec6\u6570\u91cf\u4e0d\u4e00\u81f4================");
            }
            if (!flag) {
                Map newItemMap = newItemPOs.stream().collect(Collectors.toMap(ContractInfoItemPO::getItemId, Function.identity(), (k1, k2) -> k1));
                if (CollectionUtils.isEmpty(newItemMap)) {
                    throw new ZTBusinessException("\u5408\u540c\u660e\u7ec6\u4fe1\u606f\u8f6c\u6362\u5f02\u5e38");
                }
                for (CContractInfoItemHistoryLogPO item : oldItemPOs) {
                    if (Objects.isNull(newItemMap.get(item.getItemId()))) {
                        flag = Boolean.TRUE;
                        log.error("==============\u5408\u540c\u4e3b\u4f53\u660e\u7ec6\u6ca1\u6709\u627e\u5230===============");
                        break;
                    }
                    ContractInfoItemPO newItem = (ContractInfoItemPO)newItemMap.get(item.getItemId());
                    if (!(Objects.nonNull(newItem.getAmount()) && !newItem.getAmount().equals(item.getAmount()) || Objects.nonNull(newItem.getRate()) && !newItem.getRate().equals(item.getRate())) && (!Objects.nonNull(newItem.getTaxUnitPrice()) || newItem.getTaxUnitPrice().equals(item.getTaxUnitPrice()))) continue;
                    flag = Boolean.TRUE;
                    log.error("==============\u5408\u540c\u4e3b\u4f53\u660e\u7ec6\u5b58\u5728\u5dee\u5f02================");
                    break;
                }
            }
            if (!flag) {
                ContractInfoPO contractInfoPO = new ContractInfoPO();
                contractInfoPO.setContractId(ContractPo2.getContractId());
                contractInfoPO.setPushErpStatus(ContractConstant.PushErpStatus.NEED_NOT_SYNC);
                this.contractInfoMapper.updateContract(contractInfoPO);
            }
        }
        return flag;
    }

    private boolean checkPushErpYc(ContractInfoPO contractInfoPO) {
        boolean flag = Boolean.FALSE;
        if (ContractConstant.ContractType.PURCHASE_LONG_TERM_CONS_SALE_CONTRACT.equals(contractInfoPO.getContractType())) {
            CContractInfoExtPO searchPO = new CContractInfoExtPO();
            ArrayList<Long> contractIds = new ArrayList<Long>();
            contractIds.add(contractInfoPO.getContractId());
            searchPO.setRelateIds(contractIds);
            List<CContractInfoExtPO> list = this.cContractInfoExtMapper.getList(searchPO);
            if (!CollectionUtils.isEmpty(list) && ContractConstant.ContractPushWmsStatus.YES.equals(list.get(0).getIsPushWms())) {
                UmcEnterpriseOrgQryDetailAbilityReqBO buyerBo = new UmcEnterpriseOrgQryDetailAbilityReqBO();
                if (!StringUtils.isEmpty((Object)contractInfoPO.getBuyerNo())) {
                    Integer isPushWms;
                    buyerBo.setOrgCode(contractInfoPO.getBuyerNo());
                    UmcEnterpriseOrgQryDetailAbilityRspBO buyerRspBO = this.umcEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(buyerBo);
                    if ("0000".equals(buyerRspBO.getRespCode()) && buyerRspBO.getUmcEnterpriseOrgDetailBO() != null && (isPushWms = buyerRspBO.getUmcEnterpriseOrgDetailBO().getIsPushWms()) != null && ContractConstant.ContractPushWmsStatus.YES.equals(isPushWms)) {
                        flag = Boolean.TRUE;
                    }
                }
            }
        }
        if (flag) {
            ContractInfoPO updatePO = new ContractInfoPO();
            updatePO.setContractId(contractInfoPO.getContractId());
            updatePO.setPushErpStatus(ContractConstant.PushErpStatus.NEED_NOT_SYNC);
            this.contractInfoMapper.updateContract(updatePO);
        }
        return flag;
    }
}

