/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.contract.busi.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.tydic.contract.busi.ContractQryPriceHistoryBusiService;
import com.tydic.contract.busi.bo.ContractPriceHistoryInfoBO;
import com.tydic.contract.busi.bo.ContractQryPriceHistoryBusiReqBO;
import com.tydic.contract.busi.bo.ContractQryPriceHistoryBusiRspBO;
import com.tydic.contract.dao.ContractPriceHistoryMapper;
import com.tydic.contract.po.ContractPriceHistoryPO;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractQryPriceHistoryBusiServiceImpl
implements ContractQryPriceHistoryBusiService {
    private static final Logger log = LoggerFactory.getLogger(ContractQryPriceHistoryBusiServiceImpl.class);
    @Autowired
    private ContractPriceHistoryMapper contractPriceHistoryMapper;

    @Override
    public ContractQryPriceHistoryBusiRspBO query(ContractQryPriceHistoryBusiReqBO contractQryPriceHistoryBusiReqBO) {
        ContractQryPriceHistoryBusiRspBO contractQryPriceHistoryBusiRspBO = new ContractQryPriceHistoryBusiRspBO();
        ContractPriceHistoryPO contractPriceHistoryPO = new ContractPriceHistoryPO();
        BeanUtils.copyProperties((Object)((Object)contractQryPriceHistoryBusiReqBO), (Object)contractPriceHistoryPO);
        Page page = PageHelper.startPage((int)contractQryPriceHistoryBusiReqBO.getPageNo(), (int)contractQryPriceHistoryBusiReqBO.getPageSize()).doSelectPage(() -> this.contractPriceHistoryMapper.query(contractPriceHistoryPO));
        List contractPriceHistoryPOS = page.getResult();
        List<ContractPriceHistoryPO> contractPriceHistoryPOS1 = this.contractPriceHistoryMapper.query(contractPriceHistoryPO);
        log.debug("\u5386\u53f2\u6210\u4ea4\u4ef7\u5206\u9875\u7ed3\u679c\uff1a" + page.toString());
        contractQryPriceHistoryBusiRspBO.setPageNo(contractQryPriceHistoryBusiReqBO.getPageNo());
        contractQryPriceHistoryBusiRspBO.setTotal(page.getPages());
        contractQryPriceHistoryBusiRspBO.setRecordsTotal(Integer.parseInt(String.valueOf(page.getTotal())));
        if (contractPriceHistoryPOS1 != null && contractPriceHistoryPOS1.size() > 0) {
            BigDecimal total = new BigDecimal(0);
            int account = 0;
            BigDecimal maxTaxUnitPrice = ((ContractPriceHistoryPO)contractPriceHistoryPOS.get(0)).getTaxUnitPrice();
            BigDecimal minTaxUnitPrice = ((ContractPriceHistoryPO)contractPriceHistoryPOS.get(0)).getTaxUnitPrice();
            for (ContractPriceHistoryPO poTemp2 : contractPriceHistoryPOS1) {
                account += poTemp2.getAmount().intValue();
                total = total.add(poTemp2.getTaxUnitPrice().multiply(new BigDecimal(poTemp2.getAmount())));
                maxTaxUnitPrice = poTemp2.getTaxUnitPrice().max(maxTaxUnitPrice);
                minTaxUnitPrice = poTemp2.getTaxUnitPrice().min(minTaxUnitPrice);
            }
            contractQryPriceHistoryBusiRspBO.setMaxTaxUnitPrice(maxTaxUnitPrice);
            contractQryPriceHistoryBusiRspBO.setMinTaxUnitPrice(minTaxUnitPrice);
            contractQryPriceHistoryBusiRspBO.setAvgTaxUnitPrice(total.divide(new BigDecimal(account), 6, 5));
        }
        if (contractPriceHistoryPOS == null || contractPriceHistoryPOS.size() < 1) {
            contractQryPriceHistoryBusiRspBO.setRespCode("0000");
            contractQryPriceHistoryBusiRspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return contractQryPriceHistoryBusiRspBO;
        }
        List contractPriceHistoryInfoBOS = contractPriceHistoryPOS.stream().map(poTemp -> {
            ContractPriceHistoryInfoBO contractPriceHistoryInfoBO = new ContractPriceHistoryInfoBO();
            BeanUtils.copyProperties((Object)poTemp, (Object)contractPriceHistoryInfoBO);
            return contractPriceHistoryInfoBO;
        }).collect(Collectors.toList());
        contractQryPriceHistoryBusiRspBO.setRows(contractPriceHistoryInfoBOS);
        contractQryPriceHistoryBusiRspBO.setRespCode("0000");
        contractQryPriceHistoryBusiRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f\uff01");
        return contractQryPriceHistoryBusiRspBO;
    }
}

